/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.ISVNChangelistHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc2.SvnGetChangelistPaths;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnSetChangelist;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SVNChangelistClient
extends SVNBasicClient {
    public SVNChangelistClient(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
    }

    public SVNChangelistClient(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public SVNChangelistClient(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
    }

    public void getChangeLists(File file, Collection collection, SVNDepth sVNDepth, ISVNChangelistHandler iSVNChangelistHandler) {
        this.doGetChangeLists(file, collection, sVNDepth, iSVNChangelistHandler);
    }

    public void getChangeListPaths(Collection collection, Collection collection2, SVNDepth sVNDepth, ISVNChangelistHandler iSVNChangelistHandler) {
        this.doGetChangeListPaths(collection, collection2, sVNDepth, iSVNChangelistHandler);
    }

    public void addToChangelist(File[] fileArray, SVNDepth sVNDepth, String string, String[] stringArray) {
        this.doAddToChangelist(fileArray, sVNDepth, string, stringArray);
    }

    public void removeFromChangelist(File[] fileArray, SVNDepth sVNDepth, String[] stringArray) {
        this.doRemoveFromChangelist(fileArray, sVNDepth, stringArray);
    }

    public void doAddToChangelist(File[] fileArray, SVNDepth sVNDepth, String string, String[] stringArray) {
        SvnSetChangelist svnSetChangelist = this.getOperationsFactory().createSetChangelist();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            svnSetChangelist.addTarget(SvnTarget.fromFile(fileArray[i2]));
        }
        svnSetChangelist.setDepth(sVNDepth);
        svnSetChangelist.setChangelistName(string);
        if (stringArray != null) {
            svnSetChangelist.setApplicalbeChangelists(Arrays.asList(stringArray));
        }
        svnSetChangelist.run();
    }

    public void doRemoveFromChangelist(File[] fileArray, SVNDepth sVNDepth, String[] stringArray) {
        SvnSetChangelist svnSetChangelist = this.getOperationsFactory().createSetChangelist();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            svnSetChangelist.addTarget(SvnTarget.fromFile(fileArray[i2]));
        }
        svnSetChangelist.setDepth(sVNDepth);
        if (stringArray != null) {
            svnSetChangelist.setApplicalbeChangelists(Arrays.asList(stringArray));
        }
        svnSetChangelist.setRemove(true);
        svnSetChangelist.run();
    }

    public void doGetChangeListPaths(Collection collection, Collection collection2, SVNDepth sVNDepth, ISVNChangelistHandler iSVNChangelistHandler) {
        SvnGetChangelistPaths svnGetChangelistPaths = this.getOperationsFactory().createGetChangelistPaths();
        for (Object e2 : collection2) {
            svnGetChangelistPaths.addTarget(SvnTarget.fromFile((File)e2));
        }
        svnGetChangelistPaths.setReceiver(SvnCodec.changelistReceiver(iSVNChangelistHandler));
        svnGetChangelistPaths.setDepth(sVNDepth);
        if (collection != null) {
            svnGetChangelistPaths.setApplicalbeChangelists(collection);
        }
        svnGetChangelistPaths.run();
    }

    public void doGetChangeLists(File file, Collection collection, SVNDepth sVNDepth, ISVNChangelistHandler iSVNChangelistHandler) {
        SvnGetChangelistPaths svnGetChangelistPaths = this.getOperationsFactory().createGetChangelistPaths();
        svnGetChangelistPaths.addTarget(SvnTarget.fromFile(file));
        svnGetChangelistPaths.setReceiver(SvnCodec.changelistReceiver(iSVNChangelistHandler));
        svnGetChangelistPaths.setDepth(sVNDepth);
        if (collection != null) {
            svnGetChangelistPaths.setApplicalbeChangelists(collection);
        }
        svnGetChangelistPaths.run();
    }
}

