/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate;
import org.tmatesoft.svn.core.wc.DefaultSVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNPathListHandler;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc2.SvnGetInfo;
import org.tmatesoft.svn.core.wc2.SvnInfo;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNBasicClient {
    private static final String SVNKIT_WC_17_PROPERTY = "svnkit.wc.17";
    private static final String SVNKIT_WC_17_DEFAULT = "true";
    private static final String SVNKIT_WC_17_EXPECTED = "true";
    private SvnOperationFactory operationFactory;
    private boolean ignoreExternals;
    private boolean leaveConflictsUnresolved;
    private ISVNPathListHandler pathListHandler;
    private ISVNDebugLog debugLog;

    protected SVNBasicClient(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        if (iSVNAuthenticationManager == null) {
            iSVNAuthenticationManager = SVNWCUtil.createDefaultAuthenticationManager();
        }
        if (iSVNOptions == null) {
            iSVNOptions = SVNWCUtil.createDefaultOptions(true);
        }
        this.operationFactory = new SvnOperationFactory();
        this.setOptions(iSVNOptions);
        this.operationFactory.setAuthenticationManager(iSVNAuthenticationManager);
        this.operationFactory.setRepositoryPool(new DefaultSVNRepositoryPool(iSVNAuthenticationManager, iSVNOptions));
        this.operationFactory.setAutoDisposeRepositoryPool(true);
        this.initDefaults();
    }

    protected SVNBasicClient(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        boolean bl2 = false;
        if (iSVNRepositoryPool == null) {
            iSVNRepositoryPool = new DefaultSVNRepositoryPool(SVNWCUtil.createDefaultAuthenticationManager(), iSVNOptions);
            bl2 = true;
        }
        if (iSVNOptions == null) {
            iSVNOptions = SVNWCUtil.createDefaultOptions(true);
        }
        this.operationFactory = new SvnOperationFactory();
        this.setOptions(iSVNOptions);
        this.operationFactory.setRepositoryPool(iSVNRepositoryPool);
        this.operationFactory.setAutoDisposeRepositoryPool(bl2);
        this.initDefaults();
    }

    protected SVNBasicClient(SvnOperationFactory svnOperationFactory) {
        this.operationFactory = svnOperationFactory;
        this.setOptions(svnOperationFactory.getOptions());
        this.initDefaults();
    }

    protected void initDefaults() {
        this.setPathListHandler(null);
        this.setDebugLog(null);
        this.setEventPathPrefix(null);
        this.setEventHandler(null);
    }

    public static boolean isWC17Supported() {
        return "true".equalsIgnoreCase(System.getProperty(SVNKIT_WC_17_PROPERTY, "true"));
    }

    protected static SVNBasicDelegate dontWC17Support() {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.CLIENT);
        return null;
    }

    public ISVNOptions getOptions() {
        return this.getOperationsFactory().getOptions();
    }

    public void setOptions(ISVNOptions iSVNOptions) {
        if (iSVNOptions == null) {
            iSVNOptions = SVNWCUtil.createDefaultOptions(true);
        }
        this.getOperationsFactory().setOptions(iSVNOptions);
    }

    public void setIgnoreExternals(boolean bl2) {
        this.ignoreExternals = bl2;
    }

    public boolean isIgnoreExternals() {
        return this.ignoreExternals;
    }

    public void setLeaveConflictsUnresolved(boolean bl2) {
        this.leaveConflictsUnresolved = bl2;
    }

    public boolean isLeaveConflictsUnresolved() {
        return this.leaveConflictsUnresolved;
    }

    public void setEventHandler(ISVNEventHandler iSVNEventHandler) {
        this.getOperationsFactory().setEventHandler(iSVNEventHandler);
    }

    public void setPathListHandler(ISVNPathListHandler iSVNPathListHandler) {
        this.pathListHandler = iSVNPathListHandler;
    }

    public ISVNPathListHandler getPathListHandler() {
        return this.pathListHandler;
    }

    public void setDebugLog(ISVNDebugLog iSVNDebugLog) {
        if (iSVNDebugLog == null) {
            iSVNDebugLog = SVNDebugLog.getDefaultLog();
        }
        this.debugLog = iSVNDebugLog;
    }

    public ISVNDebugLog getDebugLog() {
        return this.debugLog;
    }

    public SVNURL getReposRoot(File file, SVNURL sVNURL, SVNRevision sVNRevision, SVNAdminArea sVNAdminArea, SVNWCAccess sVNWCAccess) {
        SVNBasicDelegate sVNBasicDelegate = new SVNBasicDelegate(this.getOperationsFactory().getAuthenticationManager(), this.getOperationsFactory().getOptions());
        return sVNBasicDelegate.getReposRoot(file, sVNURL, sVNRevision, sVNAdminArea, sVNWCAccess);
    }

    public SVNURL getReposRoot(File file, SVNURL sVNURL, SVNRevision sVNRevision) {
        SvnGetInfo svnGetInfo = this.getOperationsFactory().createGetInfo();
        if (file != null) {
            svnGetInfo.setSingleTarget(SvnTarget.fromFile(file, sVNRevision));
        } else {
            svnGetInfo.setSingleTarget(SvnTarget.fromURL(sVNURL, sVNRevision));
        }
        svnGetInfo.setDepth(SVNDepth.EMPTY);
        SvnInfo svnInfo = (SvnInfo)svnGetInfo.run();
        return svnInfo != null ? svnInfo.getRepositoryRootUrl() : null;
    }

    public void setEventPathPrefix(String string) {
    }

    public SvnOperationFactory getOperationsFactory() {
        return this.operationFactory;
    }
}

