/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.ISVNConnectionListener;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.DefaultSVNRepositoryPool$DaemonThreadFactory;
import org.tmatesoft.svn.core.wc.DefaultSVNRepositoryPool$TimeoutTask;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNRepositoryPool
implements ISVNConnectionListener,
ISVNSession,
ISVNRepositoryPool {
    public static final int RUNTIME_POOL = 1;
    public static final int INSTANCE_POOL = 2;
    public static final int NO_POOL = 4;
    private static final long DEFAULT_IDLE_TIMEOUT = 60000L;
    private static volatile ScheduledExecutorService ourTimer;
    private static volatile int ourInstanceCount;
    private ISVNAuthenticationManager myAuthManager;
    private ISVNTunnelProvider myTunnelProvider;
    private ISVNDebugLog myDebugLog;
    private ISVNCanceller myCanceller;
    private Map myPool;
    private long myTimeout;
    private Map myInactiveRepositories = new HashMap();
    private ScheduledExecutorService myTimer;
    private boolean myIsKeepConnection;
    private ScheduledFuture myScheduledTimeoutTask;
    private File mySpoolLocation;

    public DefaultSVNRepositoryPool(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNTunnelProvider iSVNTunnelProvider) {
        this(iSVNAuthenticationManager, iSVNTunnelProvider, 60000L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultSVNRepositoryPool(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNTunnelProvider iSVNTunnelProvider, long l2, boolean bl2) {
        this.myAuthManager = iSVNAuthenticationManager;
        this.myTunnelProvider = iSVNTunnelProvider;
        this.myDebugLog = SVNDebugLog.getDefaultLog();
        this.myTimeout = l2 > 0L ? l2 : 60000L;
        this.myIsKeepConnection = bl2;
        this.myTimeout = l2;
        Class<DefaultSVNRepositoryPool> clazz = DefaultSVNRepositoryPool.class;
        synchronized (DefaultSVNRepositoryPool.class) {
            if (ourTimer == null) {
                ourTimer = this.createExecutor();
            }
            if (this.myIsKeepConnection) {
                this.myTimer = ourTimer;
                try {
                    this.myScheduledTimeoutTask = this.myTimer.scheduleWithFixedDelay(new DefaultSVNRepositoryPool$TimeoutTask(this, null), 10L, 10L, TimeUnit.SECONDS);
                }
                catch (IllegalStateException illegalStateException) {
                    SVNDebugLog.getDefaultLog().logError(SVNLogType.DEFAULT, illegalStateException);
                    this.myTimer = ourTimer = this.createExecutor();
                    this.myScheduledTimeoutTask = this.myTimer.scheduleWithFixedDelay(new DefaultSVNRepositoryPool$TimeoutTask(this, null), 10L, 10L, TimeUnit.SECONDS);
                }
            }
            ++ourInstanceCount;
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    private ScheduledExecutorService createExecutor() {
        return Executors.newSingleThreadScheduledExecutor(new DefaultSVNRepositoryPool$DaemonThreadFactory());
    }

    public DefaultSVNRepositoryPool(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNTunnelProvider iSVNTunnelProvider, boolean bl2, int n2) {
        this(iSVNAuthenticationManager, iSVNTunnelProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SVNRepository createRepository(SVNURL sVNURL, boolean bl2) {
        Object object = DefaultSVNRepositoryPool.class;
        synchronized (DefaultSVNRepositoryPool.class) {
            if (this.myIsKeepConnection && this.myTimer == null && ourTimer != null) {
                this.myTimer = ourTimer;
                this.myScheduledTimeoutTask = this.myTimer.scheduleWithFixedDelay(new DefaultSVNRepositoryPool$TimeoutTask(this, null), 10L, 10L, TimeUnit.SECONDS);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            object = null;
            Map map = this.getPool();
            if (!bl2 || map == null) {
                object = SVNRepositoryFactory.create(sVNURL, this);
                ((SVNRepository)object).setAuthenticationManager(this.myAuthManager);
                ((SVNRepository)object).setTunnelProvider(this.myTunnelProvider);
                ((SVNRepository)object).setDebugLog(this.myDebugLog);
                ((SVNRepository)object).setCanceller(this.myCanceller);
                this.setOptionalSpoolLocation((SVNRepository)object, this.myTunnelProvider);
                return object;
            }
            object = (SVNRepository)map.get(sVNURL.getProtocol());
            if (object != null) {
                ((SVNRepository)object).setLocation(sVNURL, false);
            } else {
                object = SVNRepositoryFactory.create(sVNURL, this);
                if (this.myIsKeepConnection) {
                    ((SVNRepository)object).addConnectionListener(this);
                }
                map.put(sVNURL.getProtocol(), object);
            }
            ((SVNRepository)object).setAuthenticationManager(this.myAuthManager);
            ((SVNRepository)object).setTunnelProvider(this.myTunnelProvider);
            ((SVNRepository)object).setDebugLog(this.myDebugLog);
            ((SVNRepository)object).setCanceller(this.myCanceller);
            this.setOptionalSpoolLocation((SVNRepository)object, this.myTunnelProvider);
            return object;
        }
    }

    public void setSpoolLocation(File file) {
        this.mySpoolLocation = file;
    }

    public File getSpoolLocation() {
        return this.mySpoolLocation;
    }

    private void setOptionalSpoolLocation(SVNRepository sVNRepository, ISVNTunnelProvider iSVNTunnelProvider) {
        File file;
        if (!(sVNRepository instanceof DAVRepository)) {
            return;
        }
        File file2 = this.getSpoolLocation();
        if (iSVNTunnelProvider instanceof DefaultSVNOptions) {
            File file3 = ((DefaultSVNOptions)iSVNTunnelProvider).getHttpSpoolDirectory();
            file = file2 != null ? file2 : file3;
        } else {
            file = file2;
        }
        if (file != null) {
            ((DAVRepository)sVNRepository).setSpoolLocation(file);
        }
    }

    @Override
    public void setAuthenticationManager(ISVNAuthenticationManager iSVNAuthenticationManager) {
        this.myAuthManager = iSVNAuthenticationManager;
        Map map = this.getPool();
        for (String string : map.keySet()) {
            SVNRepository sVNRepository = (SVNRepository)map.get(string);
            sVNRepository.setAuthenticationManager(this.myAuthManager);
        }
    }

    @Override
    public boolean keepConnection(SVNRepository sVNRepository) {
        return this.myIsKeepConnection;
    }

    @Override
    public synchronized void shutdownConnections(boolean bl2) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map map = this.myInactiveRepositories;
        synchronized (map) {
            this.myTimer = null;
        }
        this.shutdownInactiveRepositories(Long.MAX_VALUE);
        map = this.getPool();
        for (String string : map.keySet()) {
            SVNRepository sVNRepository = (SVNRepository)map.get(string);
            sVNRepository.closeSession();
        }
        this.myPool = null;
        Class<DefaultSVNRepositoryPool> clazz = DefaultSVNRepositoryPool.class;
        synchronized (DefaultSVNRepositoryPool.class) {
            if (this.myScheduledTimeoutTask != null) {
                this.myScheduledTimeoutTask.cancel(false);
                this.myScheduledTimeoutTask = null;
            }
            if (--ourInstanceCount <= 0) {
                ourInstanceCount = 0;
                DefaultSVNRepositoryPool.shutdownTimer();
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownTimer() {
        Class<DefaultSVNRepositoryPool> clazz = DefaultSVNRepositoryPool.class;
        synchronized (DefaultSVNRepositoryPool.class) {
            if (ourTimer != null) {
                try {
                    ourTimer.shutdownNow();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                ourTimer = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void saveCommitMessage(SVNRepository sVNRepository, long l2, String string) {
    }

    @Override
    public String getCommitMessage(SVNRepository sVNRepository, long l2) {
        return null;
    }

    @Override
    public boolean hasCommitMessage(SVNRepository sVNRepository, long l2) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(SVNRepository sVNRepository) {
        Map map = this.myInactiveRepositories;
        synchronized (map) {
            this.myInactiveRepositories.put(sVNRepository, System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionOpened(SVNRepository sVNRepository) {
        Map map = this.myInactiveRepositories;
        synchronized (map) {
            this.myInactiveRepositories.remove(sVNRepository);
        }
    }

    @Override
    public void setCanceller(ISVNCanceller iSVNCanceller) {
        this.myCanceller = iSVNCanceller;
        Map map = this.getPool();
        for (String string : map.keySet()) {
            SVNRepository sVNRepository = (SVNRepository)map.get(string);
            sVNRepository.setCanceller(iSVNCanceller);
        }
    }

    @Override
    public void setDebugLog(ISVNDebugLog iSVNDebugLog) {
        this.myDebugLog = iSVNDebugLog == null ? SVNDebugLog.getDefaultLog() : iSVNDebugLog;
        Map map = this.getPool();
        for (String string : map.keySet()) {
            SVNRepository sVNRepository = (SVNRepository)map.get(string);
            sVNRepository.setDebugLog(this.myDebugLog);
        }
    }

    private long getTimeout() {
        return this.myTimeout;
    }

    private Map getPool() {
        if (this.myPool == null) {
            this.myPool = new HashMap();
        }
        return this.myPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownInactiveRepositories(long l2) {
        Map map = this.myInactiveRepositories;
        synchronized (map) {
            Iterator iterator = this.myInactiveRepositories.keySet().iterator();
            while (iterator.hasNext()) {
                SVNRepository sVNRepository = (SVNRepository)iterator.next();
                long l3 = (Long)this.myInactiveRepositories.get(sVNRepository);
                if (l2 - l3 < this.getTimeout()) continue;
                iterator.remove();
                sVNRepository.closeSession();
            }
        }
    }

    static /* synthetic */ void access$200(DefaultSVNRepositoryPool defaultSVNRepositoryPool, long l2) {
        defaultSVNRepositoryPool.shutdownInactiveRepositories(l2);
    }
}

