/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import de.regnis.q.sequence.line.diff.QDiffGenerator;
import de.regnis.q.sequence.line.diff.QDiffManager;
import de.regnis.q.sequence.line.diff.QDiffUniGenerator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.DefaultSVNDiffGenerator$1;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNDiffGenerator
implements ISVNDiffGenerator {
    protected static final String PROPERTIES_SEPARATOR = "___________________________________________________________________";
    protected static final String HEADER_SEPARATOR = "===================================================================";
    protected static final String WC_REVISION_LABEL = "(working copy)";
    protected static final InputStream EMPTY_FILE_IS = SVNFileUtil.DUMMY_IN;
    private boolean myIsForcedBinaryDiff;
    private String myAnchorPath1 = "";
    private String myAnchorPath2 = "";
    private ISVNOptions myOptions;
    private String myEncoding;
    private byte[] myEOL;
    private boolean myIsDiffDeleted;
    private boolean myIsDiffAdded;
    private boolean myIsDiffCopied;
    private File myBasePath;
    private boolean myIsDiffUnversioned;
    private SVNDiffOptions myDiffOptions;
    private Collection myRawDiffOptions;
    private String myDiffCommand;
    private boolean myIsUseAbsolutePaths;

    public DefaultSVNDiffGenerator() {
        this.setDiffDeleted(true);
        this.setDiffAdded(true);
    }

    @Override
    public void init(String string, String string2) {
        this.myAnchorPath1 = string.replace(File.separatorChar, '/');
        this.myAnchorPath2 = string2.replace(File.separatorChar, '/');
    }

    public void setDiffOptions(SVNDiffOptions sVNDiffOptions) {
        this.myDiffOptions = sVNDiffOptions;
    }

    public void setRawDiffOptions(Collection collection) {
        this.myRawDiffOptions = collection;
    }

    public void setOptions(ISVNOptions iSVNOptions) {
        this.myOptions = iSVNOptions;
    }

    public void setExternalDiffCommand(String string) {
        this.myDiffCommand = string;
    }

    @Override
    public void setBasePath(File file) {
        this.myBasePath = file;
    }

    public void setFallbackToAbsolutePath(boolean bl2) {
        this.myIsUseAbsolutePaths = bl2;
    }

    @Override
    public void setDiffDeleted(boolean bl2) {
        this.myIsDiffDeleted = bl2;
    }

    @Override
    public boolean isDiffDeleted() {
        return this.myIsDiffDeleted;
    }

    @Override
    public void setDiffAdded(boolean bl2) {
        this.myIsDiffAdded = bl2;
    }

    @Override
    public boolean isDiffAdded() {
        return this.myIsDiffAdded;
    }

    @Override
    public void setDiffCopied(boolean bl2) {
        this.myIsDiffCopied = bl2;
    }

    @Override
    public boolean isDiffCopied() {
        return this.myIsDiffCopied;
    }

    public SVNDiffOptions getDiffOptions() {
        if (this.myDiffOptions == null) {
            this.myDiffOptions = new SVNDiffOptions();
        }
        return this.myDiffOptions;
    }

    protected String getDisplayPath(String string) {
        if (this.myBasePath == null) {
            return string;
        }
        if (string == null) {
            string = "";
        }
        if (SVNPathUtil.isURL(string)) {
            return string;
        }
        String string2 = this.myBasePath.getAbsolutePath().replace(File.separatorChar, '/');
        if ((string = new File(string).getAbsolutePath().replace(File.separatorChar, '/')).equals(string2)) {
            return ".";
        }
        String string3 = SVNPathUtil.getPathAsChild(string2, string);
        if (string3 == null) {
            if (this.myIsUseAbsolutePaths) {
                return string;
            }
            this.createBadRelativePathError(string);
        }
        if (string3.startsWith("./")) {
            string3 = string3.substring("./".length());
        }
        return string3;
    }

    @Override
    public void setForcedBinaryDiff(boolean bl2) {
        this.myIsForcedBinaryDiff = bl2;
    }

    @Override
    public boolean isForcedBinaryDiff() {
        return this.myIsForcedBinaryDiff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void displayPropDiff(String string, SVNProperties sVNProperties, SVNProperties sVNProperties2, OutputStream outputStream) {
        SVNPropertyValue sVNPropertyValue;
        Object object3;
        sVNProperties = sVNProperties != null ? sVNProperties : new SVNProperties();
        sVNProperties2 = sVNProperties2 != null ? sVNProperties2 : new SVNProperties();
        Object object2 = sVNProperties2.nameSet().iterator();
        while (object2.hasNext()) {
            String string2 = (String)object2.next();
            object3 = sVNProperties.getSVNPropertyValue(string2);
            sVNPropertyValue = sVNProperties2.getSVNPropertyValue(string2);
            if ((object3 == null || !((SVNPropertyValue)object3).equals(sVNPropertyValue)) && (object3 != null || sVNPropertyValue != null)) continue;
            object2.remove();
        }
        if (sVNProperties2.isEmpty()) {
            return;
        }
        string = this.getDisplayPath(string);
        object2 = new ByteArrayOutputStream();
        sVNProperties2 = new SVNProperties(sVNProperties2);
        try {
            ((OutputStream)object2).write(this.getEOL());
            ((OutputStream)object2).write(("Property changes on: " + (this.useLocalFileSeparatorChar() ? string.replace('/', File.separatorChar) : string)).getBytes(this.getEncoding()));
            ((OutputStream)object2).write(this.getEOL());
            ((OutputStream)object2).write(PROPERTIES_SEPARATOR.getBytes(this.getEncoding()));
            ((OutputStream)object2).write(this.getEOL());
            for (Object object3 : sVNProperties2.nameSet()) {
                sVNPropertyValue = sVNProperties != null ? sVNProperties.getSVNPropertyValue((String)object3) : null;
                SVNPropertyValue sVNPropertyValue2 = sVNProperties2.getSVNPropertyValue((String)object3);
                String string3 = null;
                string3 = sVNPropertyValue == null ? "Added: " : (sVNPropertyValue2 == null ? "Deleted: " : "Modified: ");
                ((OutputStream)object2).write((string3 + (String)object3).getBytes(this.getEncoding()));
                ((OutputStream)object2).write(this.getEOL());
                if ("svn:mergeinfo".equals(object3)) {
                    this.displayMergeInfoDiff((ByteArrayOutputStream)object2, sVNPropertyValue == null ? null : sVNPropertyValue.getString(), sVNPropertyValue2 == null ? null : sVNPropertyValue2.getString());
                    continue;
                }
                if (sVNPropertyValue != null) {
                    ((OutputStream)object2).write("   - ".getBytes(this.getEncoding()));
                    ((OutputStream)object2).write(this.getPropertyAsBytes(sVNPropertyValue, this.getEncoding()));
                    ((OutputStream)object2).write(this.getEOL());
                }
                if (sVNPropertyValue2 == null) continue;
                ((OutputStream)object2).write("   + ".getBytes(this.getEncoding()));
                ((OutputStream)object2).write(this.getPropertyAsBytes(sVNPropertyValue2, this.getEncoding()));
                ((OutputStream)object2).write(this.getEOL());
            }
            ((OutputStream)object2).write(this.getEOL());
        }
        catch (IOException iOException) {
            object3 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error((SVNErrorMessage)object3, iOException, SVNLogType.DEFAULT);
        }
        finally {
            try {
                ((ByteArrayOutputStream)object2).close();
                ((ByteArrayOutputStream)object2).writeTo(outputStream);
            }
            catch (IOException iOException) {}
        }
    }

    private byte[] getPropertyAsBytes(SVNPropertyValue sVNPropertyValue, String string) {
        if (sVNPropertyValue == null) {
            return null;
        }
        if (sVNPropertyValue.isString()) {
            try {
                return sVNPropertyValue.getString().getBytes(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return sVNPropertyValue.getString().getBytes();
            }
        }
        return sVNPropertyValue.getBytes();
    }

    protected File getBasePath() {
        return this.myBasePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void displayFileDiff(String string, File file, File file2, String string2, String string3, String string4, String string5, OutputStream outputStream) {
        Object object;
        Object object2;
        int n2;
        string = this.getDisplayPath(string);
        for (n2 = 0; n2 < this.myAnchorPath1.length() && n2 < this.myAnchorPath2.length() && this.myAnchorPath1.charAt(n2) == this.myAnchorPath2.charAt(n2); ++n2) {
        }
        if (n2 < this.myAnchorPath1.length() || n2 < this.myAnchorPath2.length()) {
            if (n2 == this.myAnchorPath1.length()) {
                n2 = this.myAnchorPath1.length() - 1;
            }
            while (n2 > 0 && this.myAnchorPath1.charAt(n2) != '/') {
                --n2;
            }
        }
        String string6 = this.myAnchorPath1.substring(n2);
        String string7 = this.myAnchorPath2.substring(n2);
        string6 = string6.length() == 0 ? string : (string6.charAt(0) == '/' ? string + "\t(..." + string6 + ")" : string + "\t(.../" + string6 + ")");
        string7 = string7.length() == 0 ? string : (string7.charAt(0) == '/' ? string + "\t(..." + string7 + ")" : string + "\t(.../" + string7 + ")");
        String string8 = this.getLabel(string6, string2);
        String string9 = this.getLabel(string7, string3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (this.displayHeader(byteArrayOutputStream, string, file2 == null)) {
                byteArrayOutputStream.close();
                byteArrayOutputStream.writeTo(outputStream);
                return;
            }
            if (this.isHeaderForced(file, file2)) {
                byteArrayOutputStream.writeTo(outputStream);
                byteArrayOutputStream.reset();
            }
        }
        catch (IOException iOException) {
            try {
                byteArrayOutputStream.close();
                byteArrayOutputStream.writeTo(outputStream);
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            object2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error((SVNErrorMessage)object2, iOException, SVNLogType.DEFAULT);
        }
        if (!this.isForcedBinaryDiff() && (SVNProperty.isBinaryMimeType(string4) || SVNProperty.isBinaryMimeType(string5))) {
            try {
                this.displayBinary(byteArrayOutputStream, string4, string5);
            }
            catch (IOException iOException) {
                object2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                SVNErrorManager.error((SVNErrorMessage)object2, iOException, SVNLogType.DEFAULT);
            }
            finally {
                try {
                    byteArrayOutputStream.close();
                    byteArrayOutputStream.writeTo(outputStream);
                }
                catch (IOException iOException) {}
            }
            return;
        }
        if (file == file2 && file == null) {
            try {
                byteArrayOutputStream.close();
                byteArrayOutputStream.writeTo(outputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        String string10 = this.getExternalDiffCommand();
        if (string10 != null) {
            try {
                byteArrayOutputStream.close();
                byteArrayOutputStream.writeTo(outputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            object2 = new LinkedList();
            File file3 = new File(string10);
            object2.add(file3.getAbsolutePath().replace(File.separatorChar, '/'));
            if (this.myRawDiffOptions != null) {
                object2.addAll(this.myRawDiffOptions);
            } else {
                Collection collection = this.getDiffOptions().toOptionsCollection();
                object2.addAll(collection);
                object2.add("-u");
            }
            if (string8 != null) {
                object2.add("-L");
                object2.add(string8);
            }
            if (string9 != null) {
                object2.add("-L");
                object2.add(string9);
            }
            boolean bl2 = false;
            boolean bl3 = false;
            if (file == null) {
                file = SVNFileUtil.createTempFile("svn.", ".tmp");
                bl2 = true;
            }
            if (file2 == null) {
                file2 = SVNFileUtil.createTempFile("svn.", ".tmp");
                bl3 = true;
            }
            String string11 = new File("").getAbsolutePath().replace(File.separatorChar, '/');
            String string12 = file.getAbsolutePath().replace(File.separatorChar, '/');
            String string13 = file2.getAbsolutePath().replace(File.separatorChar, '/');
            if (string12.startsWith(string11)) {
                String string14 = string12 = (string12 = string12.substring(string11.length())).startsWith("/") ? string12.substring(1) : string12;
            }
            if (string13.startsWith(string11)) {
                string13 = (string13 = string13.substring(string11.length())).startsWith("/") ? string13.substring(1) : string13;
            }
            object2.add(string12);
            object2.add(string13);
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.getEncoding());
                SVNFileUtil.execCommand(object2.toArray(new String[object2.size()]), true, new DefaultSVNDiffGenerator$1(this, string10, outputStreamWriter));
                ((Writer)outputStreamWriter).flush();
            }
            catch (IOException iOException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage());
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.DEFAULT);
            }
            finally {
                try {
                    if (bl2) {
                        SVNFileUtil.deleteFile(file);
                    }
                    if (bl3) {
                        SVNFileUtil.deleteFile(file2);
                    }
                }
                catch (SVNException sVNException) {}
            }
            return;
        }
        try {
            this.displayHeaderFields(byteArrayOutputStream, string8, string9);
        }
        catch (IOException iOException) {
            try {
                byteArrayOutputStream.close();
                byteArrayOutputStream.writeTo(outputStream);
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            object = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error((SVNErrorMessage)object, iOException, SVNLogType.DEFAULT);
        }
        try {
            byteArrayOutputStream.close();
            object2 = byteArrayOutputStream.toString(this.getEncoding());
        }
        catch (IOException iOException) {
            object2 = "";
        }
        object = null;
        RandomAccessFile randomAccessFile = null;
        try {
            object = file == null ? null : SVNFileUtil.openRAFileForReading(file);
            randomAccessFile = file2 == null ? null : SVNFileUtil.openRAFileForReading(file2);
            QDiffUniGenerator.setup();
            SVNHashMap sVNHashMap = new SVNHashMap();
            sVNHashMap.put("ignore-eol-style", this.getDiffOptions().isIgnoreEOLStyle());
            if (this.getDiffOptions().isIgnoreAllWhitespace()) {
                sVNHashMap.put("ignore-space", "all-space");
            } else if (this.getDiffOptions().isIgnoreAmountOfWhitespace()) {
                sVNHashMap.put("ignore-space", "space-change");
            }
            QDiffUniGenerator qDiffUniGenerator = new QDiffUniGenerator(sVNHashMap, (String)object2);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.getEncoding());
            QDiffManager.generateTextDiff((RandomAccessFile)object, randomAccessFile, this.getEncoding(), (Writer)outputStreamWriter, (QDiffGenerator)qDiffUniGenerator);
            ((Writer)outputStreamWriter).flush();
        }
        catch (IOException iOException) {
            try {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getMessage());
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.DEFAULT);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile((RandomAccessFile)object);
                SVNFileUtil.closeFile(randomAccessFile);
                throw throwable;
            }
            SVNFileUtil.closeFile((RandomAccessFile)object);
            SVNFileUtil.closeFile(randomAccessFile);
        }
        SVNFileUtil.closeFile((RandomAccessFile)object);
        SVNFileUtil.closeFile(randomAccessFile);
    }

    @Override
    public void setEncoding(String string) {
        this.myEncoding = string;
    }

    @Override
    public String getEncoding() {
        if (this.hasEncoding()) {
            return this.myEncoding;
        }
        return this.getOptions().getNativeCharset();
    }

    public boolean hasEncoding() {
        return this.myEncoding != null;
    }

    public boolean hasEOL() {
        return this.myEOL != null;
    }

    public String getGlobalEncoding() {
        if (this.getOptions() instanceof DefaultSVNOptions) {
            DefaultSVNOptions defaultSVNOptions = (DefaultSVNOptions)this.getOptions();
            return defaultSVNOptions.getGlobalCharset();
        }
        return null;
    }

    @Override
    public void setEOL(byte[] byArray) {
        this.myEOL = byArray;
    }

    @Override
    public byte[] getEOL() {
        if (this.myEOL == null) {
            this.myEOL = this.getOptions().getNativeEOL();
        }
        return this.myEOL;
    }

    @Override
    public File createTempDirectory() {
        return SVNFileUtil.createTempDirectory("diff");
    }

    @Override
    public boolean isDiffUnversioned() {
        return this.myIsDiffUnversioned;
    }

    @Override
    public void setDiffUnversioned(boolean bl2) {
        this.myIsDiffUnversioned = bl2;
    }

    @Override
    public void displayDeletedDirectory(String string, String string2, String string3) {
    }

    @Override
    public void displayAddedDirectory(String string, String string2, String string3) {
    }

    protected String getExternalDiffCommand() {
        if (this.myDiffCommand != null) {
            return this.myDiffCommand;
        }
        if (this.myOptions instanceof DefaultSVNOptions) {
            return ((DefaultSVNOptions)this.myOptions).getDiffCommand();
        }
        return null;
    }

    protected ISVNOptions getOptions() {
        if (this.myOptions == null) {
            this.myOptions = new DefaultSVNOptions();
        }
        return this.myOptions;
    }

    protected void displayBinary(OutputStream outputStream, String string, String string2) {
        outputStream.write("Cannot display: file marked as a binary type.".getBytes(this.getEncoding()));
        outputStream.write(this.getEOL());
        if (SVNProperty.isBinaryMimeType(string) && !SVNProperty.isBinaryMimeType(string2)) {
            outputStream.write("svn:mime-type = ".getBytes(this.getEncoding()));
            outputStream.write(string.getBytes(this.getEncoding()));
            outputStream.write(this.getEOL());
        } else if (!SVNProperty.isBinaryMimeType(string) && SVNProperty.isBinaryMimeType(string2)) {
            outputStream.write("svn:mime-type = ".getBytes(this.getEncoding()));
            outputStream.write(string2.getBytes(this.getEncoding()));
            outputStream.write(this.getEOL());
        } else if (SVNProperty.isBinaryMimeType(string) && SVNProperty.isBinaryMimeType(string2)) {
            if (string.equals(string2)) {
                outputStream.write("svn:mime-type = ".getBytes(this.getEncoding()));
                outputStream.write(string2.getBytes(this.getEncoding()));
                outputStream.write(this.getEOL());
            } else {
                outputStream.write("svn:mime-type = (".getBytes(this.getEncoding()));
                outputStream.write(string.getBytes(this.getEncoding()));
                outputStream.write(", ".getBytes(this.getEncoding()));
                outputStream.write(string2.getBytes(this.getEncoding()));
                outputStream.write(")".getBytes(this.getEncoding()));
                outputStream.write(this.getEOL());
            }
        }
    }

    protected boolean displayHeader(OutputStream outputStream, String string, boolean bl2) {
        if (bl2 && !this.isDiffDeleted()) {
            outputStream.write("Index: ".getBytes(this.getEncoding()));
            outputStream.write(string.getBytes(this.getEncoding()));
            outputStream.write(" (deleted)".getBytes(this.getEncoding()));
            outputStream.write(this.getEOL());
            outputStream.write(HEADER_SEPARATOR.getBytes(this.getEncoding()));
            outputStream.write(this.getEOL());
            return true;
        }
        outputStream.write("Index: ".getBytes(this.getEncoding()));
        outputStream.write(string.getBytes(this.getEncoding()));
        outputStream.write(this.getEOL());
        outputStream.write(HEADER_SEPARATOR.getBytes(this.getEncoding()));
        outputStream.write(this.getEOL());
        return false;
    }

    protected void displayHeaderFields(OutputStream outputStream, String string, String string2) {
        outputStream.write("--- ".getBytes(this.getEncoding()));
        outputStream.write(string.getBytes(this.getEncoding()));
        outputStream.write(this.getEOL());
        outputStream.write("+++ ".getBytes(this.getEncoding()));
        outputStream.write(string2.getBytes(this.getEncoding()));
        outputStream.write(this.getEOL());
    }

    protected boolean isHeaderForced(File file, File file2) {
        return file == null && file2 != null;
    }

    protected boolean useLocalFileSeparatorChar() {
        return true;
    }

    protected String getLabel(String string, String string2) {
        string2 = string2 == null ? WC_REVISION_LABEL : string2;
        return string + "\t" + string2;
    }

    private void displayMergeInfoDiff(ByteArrayOutputStream byteArrayOutputStream, String string, String string2) {
        SVNMergeRangeList sVNMergeRangeList;
        Map map = null;
        Map map2 = null;
        if (string != null) {
            map = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(string), null);
        }
        if (string2 != null) {
            map2 = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(string2), null);
        }
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = new TreeMap();
        SVNMergeInfoUtil.diffMergeInfo(treeMap, treeMap2, map, map2, true);
        for (String string3 : treeMap.keySet()) {
            sVNMergeRangeList = (SVNMergeRangeList)treeMap.get(string3);
            byteArrayOutputStream.write(("   Reverse-merged " + string3 + ":r").getBytes(this.getEncoding()));
            byteArrayOutputStream.write(sVNMergeRangeList.toString().getBytes(this.getEncoding()));
            byteArrayOutputStream.write(this.getEOL());
        }
        for (String string3 : treeMap2.keySet()) {
            sVNMergeRangeList = (SVNMergeRangeList)treeMap2.get(string3);
            byteArrayOutputStream.write(("   Merged " + string3 + ":r").getBytes(this.getEncoding()));
            byteArrayOutputStream.write(sVNMergeRangeList.toString().getBytes(this.getEncoding()));
            byteArrayOutputStream.write(this.getEOL());
        }
    }

    private void createBadRelativePathError(String string) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_RELATIVE_PATH, "Path ''{0}'' must be an immediate child of the directory ''{1}''", string, this.myBasePath);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
    }
}

