/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.replicator;

import java.util.Iterator;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.replicator.ISVNReplicationHandler;
import org.tmatesoft.svn.core.replicator.SVNReplicationEditor;
import org.tmatesoft.svn.core.replicator.SVNRepositoryReplicator$1;
import org.tmatesoft.svn.core.replicator.SVNRepositoryReplicator$2;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNRepositoryReplicator
implements ISVNEventHandler {
    private ISVNReplicationHandler myHandler;

    private SVNRepositoryReplicator() {
    }

    public static SVNRepositoryReplicator newInstance() {
        return new SVNRepositoryReplicator();
    }

    public long replicateRepository(SVNRepository sVNRepository, SVNRepository sVNRepository2, boolean bl2) {
        long l2 = bl2 ? sVNRepository2.getLatestRevision() + 1L : 1L;
        return this.replicateRepository(sVNRepository, sVNRepository2, l2, -1L);
    }

    public long replicateRepository(SVNRepository sVNRepository, SVNRepository sVNRepository2, long l2, long l3) {
        SVNErrorMessage sVNErrorMessage;
        l2 = l2 <= 0L ? 1L : l2;
        long l4 = sVNRepository2.getLatestRevision();
        if (l4 != l2 - 1L) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "The target repository''s latest revision must be ''{0}''", (Object)(l2 - 1L));
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (!sVNRepository.getRepositoryRoot(true).equals(sVNRepository.getLocation())) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Source repository location must be at repository root ({0}), not at {1}", sVNRepository.getRepositoryRoot(true), sVNRepository.getLocation());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (!sVNRepository2.getRepositoryRoot(true).equals(sVNRepository2.getLocation())) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Target repository location must be at repository root ({0}), not at {1}", sVNRepository2.getRepositoryRoot(true), sVNRepository2.getLocation());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        long l5 = sVNRepository.getLatestRevision();
        l3 = l3 > 0L && l3 <= l5 ? l3 : l5;
        SVNLogEntry[] sVNLogEntryArray = new SVNLogEntry[1];
        long l6 = l3 - l2 + 1L;
        if (l4 == 0L) {
            SVNProperties sVNProperties = sVNRepository.getRevisionProperties(0L, null);
            this.updateRevisionProperties(sVNRepository2, 0L, sVNProperties);
        }
        for (long i2 = l2; i2 <= l3; ++i2) {
            Object object;
            Object object2;
            SVNProperties sVNProperties = sVNRepository.getRevisionProperties(i2, null);
            String string = sVNProperties.getStringValue("svn:log");
            sVNLogEntryArray[0] = null;
            this.checkCancelled();
            sVNRepository.log(new String[]{""}, i2, i2, true, false, 1L, new SVNRepositoryReplicator$1(this, sVNLogEntryArray));
            this.checkCancelled();
            if (sVNLogEntryArray[0] == null || sVNLogEntryArray[0].getChangedPaths() == null) {
                object2 = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Revision ''{0}'' does not contain information on changed paths; probably access is denied", (Object)i2);
                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.FSFS);
            } else if (sVNLogEntryArray[0].getDate() == null) {
                object2 = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Revision ''{0}'' does not contain commit date; probably access is denied", (Object)i2);
                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.FSFS);
            }
            this.fireReplicatingEvent(sVNLogEntryArray[0]);
            string = string == null ? "" : string;
            object2 = SVNCancellableEditor.newInstance(sVNRepository2.getCommitEditor(string, null), this, sVNRepository.getDebugLog());
            SVNReplicationEditor sVNReplicationEditor = null;
            try {
                sVNReplicationEditor = new SVNReplicationEditor(sVNRepository, (ISVNEditor)object2, sVNLogEntryArray[0]);
                long l7 = i2 - 1L;
                sVNRepository.update(i2, null, true, new SVNRepositoryReplicator$2(this, l7), SVNCancellableEditor.newInstance(sVNReplicationEditor, this, sVNRepository.getDebugLog()));
            }
            catch (SVNException sVNException) {
                try {
                    sVNReplicationEditor.abortEdit();
                }
                catch (SVNException sVNException2) {
                    // empty catch block
                }
                throw sVNException;
            }
            catch (Throwable throwable) {
                try {
                    sVNReplicationEditor.abortEdit();
                }
                catch (SVNException sVNException) {
                    // empty catch block
                }
                object = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, throwable.getMessage());
                SVNErrorManager.error((SVNErrorMessage)object, throwable, SVNLogType.FSFS);
            }
            SVNCommitInfo sVNCommitInfo = sVNReplicationEditor.getCommitInfo();
            try {
                this.updateRevisionProperties(sVNRepository2, i2, sVNProperties);
                object = sVNProperties.getStringValue("svn:author");
                SVNDate sVNDate = SVNDate.parseDate(sVNProperties.getStringValue("svn:date"));
                sVNCommitInfo = new SVNCommitInfo(i2, (String)object, sVNDate);
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
            this.fireReplicatedEvent(sVNCommitInfo);
        }
        return l6;
    }

    private void updateRevisionProperties(SVNRepository sVNRepository, long l2, SVNProperties sVNProperties) {
        if (!sVNProperties.containsName("svn:author")) {
            sVNProperties.put("svn:author", (byte[])null);
        }
        if (!sVNProperties.containsName("svn:date")) {
            sVNProperties.put("svn:date", (byte[])null);
        }
        if (!sVNProperties.containsName("svn:log")) {
            sVNProperties.put("svn:log", (byte[])null);
        }
        Iterator iterator = sVNProperties.nameSet().iterator();
        while (iterator.hasNext()) {
            this.checkCancelled();
            String string = (String)iterator.next();
            SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string);
            sVNRepository.setRevisionPropertyValue(l2, string, sVNPropertyValue);
        }
    }

    public void setReplicationHandler(ISVNReplicationHandler iSVNReplicationHandler) {
        this.myHandler = iSVNReplicationHandler;
    }

    protected void fireReplicatingEvent(SVNLogEntry sVNLogEntry) {
        if (this.myHandler != null) {
            this.myHandler.revisionReplicating(this, sVNLogEntry);
        }
    }

    protected void fireReplicatedEvent(SVNCommitInfo sVNCommitInfo) {
        if (this.myHandler != null) {
            this.myHandler.revisionReplicated(this, sVNCommitInfo);
        }
    }

    @Override
    public void handleEvent(SVNEvent sVNEvent, double d2) {
    }

    @Override
    public void checkCancelled() {
        if (this.myHandler != null) {
            this.myHandler.checkCancelled();
        }
    }
}

