/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.replicator;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.replicator.SVNReplicationEditor$EntryBaton;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNReplicationEditor
implements ISVNEditor {
    private static final int ACCEPT = 0;
    private static final int IGNORE = 1;
    private static final int DECIDE = 2;
    private ISVNEditor myCommitEditor;
    private Map myCopiedPaths;
    private Map myChangedPaths;
    private Set myDeletedPaths;
    private SVNRepository myRepos;
    private Map myPathsToFileBatons;
    private Stack myDirsStack;
    private long myPreviousRevision;
    private long myTargetRevision;
    private SVNCommitInfo myCommitInfo;
    private SVNRepository mySourceRepository;

    public SVNReplicationEditor(SVNRepository sVNRepository, ISVNEditor iSVNEditor, SVNLogEntry sVNLogEntry) {
        this.myRepos = sVNRepository;
        this.myCommitEditor = iSVNEditor;
        this.myPathsToFileBatons = new SVNHashMap();
        this.myDirsStack = new Stack();
        this.myCopiedPaths = new SVNHashMap();
        this.myChangedPaths = sVNLogEntry.getChangedPaths();
        this.myDeletedPaths = new SVNHashSet();
        for (String string : this.myChangedPaths.keySet()) {
            SVNLogEntryPath sVNLogEntryPath = (SVNLogEntryPath)this.myChangedPaths.get(string);
            if (sVNLogEntryPath.getType() != 'R' && sVNLogEntryPath.getType() != 'A' || sVNLogEntryPath.getCopyPath() == null || sVNLogEntryPath.getCopyRevision() < 0L) continue;
            this.myCopiedPaths.put(string, sVNLogEntryPath);
        }
    }

    @Override
    public void targetRevision(long l2) {
        this.myPreviousRevision = l2 - 1L;
        this.myTargetRevision = l2;
    }

    @Override
    public void openRoot(long l2) {
        this.myCommitEditor.openRoot(this.myPreviousRevision);
        SVNReplicationEditor$EntryBaton sVNReplicationEditor$EntryBaton = new SVNReplicationEditor$EntryBaton("/");
        SVNReplicationEditor$EntryBaton.access$002(sVNReplicationEditor$EntryBaton, 0);
        this.myDirsStack.push(sVNReplicationEditor$EntryBaton);
    }

    @Override
    public void deleteEntry(String string, long l2) {
        String string2 = this.getSourceRepository().getRepositoryPath(string);
        SVNLogEntryPath sVNLogEntryPath = (SVNLogEntryPath)this.myChangedPaths.get(string2);
        if (sVNLogEntryPath != null && (sVNLogEntryPath.getType() == 'D' || sVNLogEntryPath.getType() == 'R')) {
            if (sVNLogEntryPath.getType() == 'D') {
                this.myChangedPaths.remove(string2);
            }
        } else {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Expected that path ''{0}'' is deleted in revision {1}", string2, this.myPreviousRevision);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
        if (!this.myDeletedPaths.contains(string)) {
            this.myCommitEditor.deleteEntry(string, this.myPreviousRevision);
            this.myDeletedPaths.add(string);
        }
    }

    @Override
    public void absentDir(String string) {
    }

    @Override
    public void absentFile(String string) {
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        String string3 = this.getSourceRepository().getRepositoryPath(string);
        SVNReplicationEditor$EntryBaton sVNReplicationEditor$EntryBaton = new SVNReplicationEditor$EntryBaton(string3);
        this.myDirsStack.push(sVNReplicationEditor$EntryBaton);
        SVNLogEntryPath sVNLogEntryPath = (SVNLogEntryPath)this.myChangedPaths.get(string3);
        if (sVNLogEntryPath != null && (sVNLogEntryPath.getType() == 'A' || sVNLogEntryPath.getType() == 'R') && sVNLogEntryPath.getCopyPath() != null && sVNLogEntryPath.getCopyRevision() >= 0L) {
            SVNReplicationEditor$EntryBaton.access$002(sVNReplicationEditor$EntryBaton, 2);
            SVNProperties sVNProperties = new SVNProperties();
            this.getSourceRepository().getDir(sVNLogEntryPath.getCopyPath(), sVNLogEntryPath.getCopyRevision(), sVNProperties, (ISVNDirEntryHandler)null);
            SVNReplicationEditor$EntryBaton.access$102(sVNReplicationEditor$EntryBaton, sVNProperties);
            if (sVNLogEntryPath.getType() == 'R') {
                if (!this.myDeletedPaths.contains(string)) {
                    this.myCommitEditor.deleteEntry(string, this.myPreviousRevision);
                    this.myDeletedPaths.add(string);
                }
                this.myChangedPaths.remove(string3);
            }
            this.myCommitEditor.addDir(string, sVNLogEntryPath.getCopyPath(), sVNLogEntryPath.getCopyRevision());
        } else if (sVNLogEntryPath != null && (sVNLogEntryPath.getType() == 'A' || sVNLogEntryPath.getType() == 'R')) {
            SVNReplicationEditor$EntryBaton.access$002(sVNReplicationEditor$EntryBaton, 0);
            this.myCommitEditor.addDir(string, null, -1L);
        } else if (sVNLogEntryPath != null && sVNLogEntryPath.getType() == 'M') {
            SVNReplicationEditor$EntryBaton.access$002(sVNReplicationEditor$EntryBaton, 0);
            this.myCommitEditor.openDir(string, this.myPreviousRevision);
        } else if (sVNLogEntryPath == null) {
            SVNReplicationEditor$EntryBaton.access$002(sVNReplicationEditor$EntryBaton, 1);
            this.myCommitEditor.openDir(string, this.myPreviousRevision);
        } else {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Unknown bug in addDir()");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
    }

    @Override
    public void openDir(String string, long l2) {
        SVNReplicationEditor$EntryBaton sVNReplicationEditor$EntryBaton = new SVNReplicationEditor$EntryBaton(this.getSourceRepository().getRepositoryPath(string));
        SVNReplicationEditor$EntryBaton.access$002(sVNReplicationEditor$EntryBaton, 0);
        this.myDirsStack.push(sVNReplicationEditor$EntryBaton);
        this.myCommitEditor.openDir(string, this.myPreviousRevision);
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        if (!SVNProperty.isRegularProperty(string)) {
            return;
        }
        SVNReplicationEditor$EntryBaton sVNReplicationEditor$EntryBaton = (SVNReplicationEditor$EntryBaton)this.myDirsStack.peek();
        if (SVNReplicationEditor$EntryBaton.access$000(sVNReplicationEditor$EntryBaton) == 0) {
            this.myCommitEditor.changeDirProperty(string, sVNPropertyValue);
        } else if (SVNReplicationEditor$EntryBaton.access$000(sVNReplicationEditor$EntryBaton) == 2) {
            SVNPropertyValue sVNPropertyValue2 = SVNReplicationEditor$EntryBaton.access$100(sVNReplicationEditor$EntryBaton).getSVNPropertyValue(string);
            if (sVNPropertyValue2 != null && sVNPropertyValue2.equals(sVNPropertyValue)) {
                SVNReplicationEditor$EntryBaton.access$002(sVNReplicationEditor$EntryBaton, 1);
                return;
            }
            SVNReplicationEditor$EntryBaton.access$002(sVNReplicationEditor$EntryBaton, 0);
            this.myCommitEditor.changeDirProperty(string, sVNPropertyValue);
        }
    }

    @Override
    public void closeDir() {
        if (this.myDirsStack.size() > 1 && !this.myCopiedPaths.isEmpty()) {
            SVNReplicationEditor$EntryBaton sVNReplicationEditor$EntryBaton = (SVNReplicationEditor$EntryBaton)this.myDirsStack.peek();
            this.completeDeletion(SVNReplicationEditor$EntryBaton.access$200(sVNReplicationEditor$EntryBaton));
        }
        this.myDirsStack.pop();
        this.myCommitEditor.closeDir();
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        String string3 = this.getSourceRepository().getRepositoryPath(string);
        SVNReplicationEditor$EntryBaton sVNReplicationEditor$EntryBaton = new SVNReplicationEditor$EntryBaton(string3);
        this.myPathsToFileBatons.put(string, sVNReplicationEditor$EntryBaton);
        SVNLogEntryPath sVNLogEntryPath = (SVNLogEntryPath)this.myChangedPaths.get(string3);
        if (sVNLogEntryPath != null && (sVNLogEntryPath.getType() == 'A' || sVNLogEntryPath.getType() == 'R') && sVNLogEntryPath.getCopyPath() != null && sVNLogEntryPath.getCopyRevision() >= 0L) {
            SVNReplicationEditor$EntryBaton.access$002(sVNReplicationEditor$EntryBaton, 2);
            SVNReplicationEditor$EntryBaton.access$302(sVNReplicationEditor$EntryBaton, 0);
            SVNProperties sVNProperties = new SVNProperties();
            if (this.areFileContentsEqual(string3, this.myTargetRevision, sVNLogEntryPath.getCopyPath(), sVNLogEntryPath.getCopyRevision(), sVNProperties)) {
                SVNReplicationEditor$EntryBaton.access$302(sVNReplicationEditor$EntryBaton, 1);
            }
            SVNReplicationEditor$EntryBaton.access$102(sVNReplicationEditor$EntryBaton, sVNProperties);
            if (sVNLogEntryPath.getType() == 'R') {
                if (!this.myDeletedPaths.contains(string)) {
                    this.myCommitEditor.deleteEntry(string, this.myPreviousRevision);
                    this.myDeletedPaths.add(string);
                }
                this.myChangedPaths.remove(string3);
            }
            this.myCommitEditor.addFile(string, sVNLogEntryPath.getCopyPath(), sVNLogEntryPath.getCopyRevision());
        } else if (sVNLogEntryPath != null && (sVNLogEntryPath.getType() == 'A' || sVNLogEntryPath.getType() == 'R')) {
            SVNReplicationEditor$EntryBaton.access$002(sVNReplicationEditor$EntryBaton, 0);
            SVNReplicationEditor$EntryBaton.access$302(sVNReplicationEditor$EntryBaton, 0);
            if (sVNLogEntryPath.getType() == 'R') {
                if (!this.myDeletedPaths.contains(string)) {
                    this.myCommitEditor.deleteEntry(string, this.myPreviousRevision);
                    this.myDeletedPaths.add(string);
                }
                this.myChangedPaths.remove(string3);
            }
            this.myCommitEditor.addFile(string, null, -1L);
        } else if (sVNLogEntryPath != null && sVNLogEntryPath.getType() == 'M') {
            Serializable serializable;
            SVNReplicationEditor$EntryBaton.access$002(sVNReplicationEditor$EntryBaton, 2);
            SVNReplicationEditor$EntryBaton.access$302(sVNReplicationEditor$EntryBaton, 0);
            SVNLogEntryPath sVNLogEntryPath2 = this.getFileCopyOrigin(string3);
            if (sVNLogEntryPath2 == null) {
                serializable = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Unknown error, can't get the copy origin of a file");
                SVNErrorManager.error(serializable, SVNLogType.FSFS);
            }
            serializable = new SVNProperties();
            if (this.areFileContentsEqual(string3, this.myTargetRevision, sVNLogEntryPath2.getCopyPath(), sVNLogEntryPath2.getCopyRevision(), (SVNProperties)serializable)) {
                SVNReplicationEditor$EntryBaton.access$302(sVNReplicationEditor$EntryBaton, 1);
            }
            SVNReplicationEditor$EntryBaton.access$102(sVNReplicationEditor$EntryBaton, (SVNProperties)serializable);
            this.myCommitEditor.openFile(string, this.myPreviousRevision);
        } else if (sVNLogEntryPath == null) {
            SVNReplicationEditor$EntryBaton.access$002(sVNReplicationEditor$EntryBaton, 1);
            SVNReplicationEditor$EntryBaton.access$302(sVNReplicationEditor$EntryBaton, 1);
        } else {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Unknown bug in addFile()");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
        }
    }

    @Override
    public void openFile(String string, long l2) {
        SVNReplicationEditor$EntryBaton sVNReplicationEditor$EntryBaton = new SVNReplicationEditor$EntryBaton(this.getSourceRepository().getRepositoryPath(string));
        SVNReplicationEditor$EntryBaton.access$002(sVNReplicationEditor$EntryBaton, 0);
        SVNReplicationEditor$EntryBaton.access$302(sVNReplicationEditor$EntryBaton, 0);
        this.myPathsToFileBatons.put(string, sVNReplicationEditor$EntryBaton);
        this.myCommitEditor.openFile(string, this.myPreviousRevision);
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        SVNReplicationEditor$EntryBaton sVNReplicationEditor$EntryBaton = (SVNReplicationEditor$EntryBaton)this.myPathsToFileBatons.get(string);
        if (SVNReplicationEditor$EntryBaton.access$300(sVNReplicationEditor$EntryBaton) == 0) {
            this.myCommitEditor.applyTextDelta(string, string2);
        }
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        SVNReplicationEditor$EntryBaton sVNReplicationEditor$EntryBaton = (SVNReplicationEditor$EntryBaton)this.myPathsToFileBatons.get(string);
        if (SVNReplicationEditor$EntryBaton.access$300(sVNReplicationEditor$EntryBaton) == 0) {
            return this.myCommitEditor.textDeltaChunk(string, sVNDiffWindow);
        }
        return SVNFileUtil.DUMMY_OUT;
    }

    @Override
    public void textDeltaEnd(String string) {
        SVNReplicationEditor$EntryBaton sVNReplicationEditor$EntryBaton = (SVNReplicationEditor$EntryBaton)this.myPathsToFileBatons.get(string);
        if (SVNReplicationEditor$EntryBaton.access$300(sVNReplicationEditor$EntryBaton) == 0) {
            this.myCommitEditor.textDeltaEnd(string);
        }
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        if (!SVNProperty.isRegularProperty(string2)) {
            return;
        }
        SVNReplicationEditor$EntryBaton sVNReplicationEditor$EntryBaton = (SVNReplicationEditor$EntryBaton)this.myPathsToFileBatons.get(string);
        if (SVNReplicationEditor$EntryBaton.access$000(sVNReplicationEditor$EntryBaton) == 0) {
            this.myCommitEditor.changeFileProperty(string, string2, sVNPropertyValue);
        } else if (SVNReplicationEditor$EntryBaton.access$000(sVNReplicationEditor$EntryBaton) == 2) {
            SVNPropertyValue sVNPropertyValue2 = SVNReplicationEditor$EntryBaton.access$100(sVNReplicationEditor$EntryBaton).getSVNPropertyValue(string2);
            if (sVNPropertyValue2 != null && sVNPropertyValue2.equals(sVNPropertyValue)) {
                SVNReplicationEditor$EntryBaton.access$002(sVNReplicationEditor$EntryBaton, 1);
                return;
            }
            SVNReplicationEditor$EntryBaton.access$002(sVNReplicationEditor$EntryBaton, 0);
            this.myCommitEditor.changeFileProperty(string, string2, sVNPropertyValue);
        }
    }

    @Override
    public void closeFile(String string, String string2) {
        SVNReplicationEditor$EntryBaton sVNReplicationEditor$EntryBaton = (SVNReplicationEditor$EntryBaton)this.myPathsToFileBatons.get(string);
        if (SVNReplicationEditor$EntryBaton.access$300(sVNReplicationEditor$EntryBaton) != 1 || SVNReplicationEditor$EntryBaton.access$300(sVNReplicationEditor$EntryBaton) != 1) {
            this.myCommitEditor.closeFile(string, string2);
        }
    }

    @Override
    public SVNCommitInfo closeEdit() {
        this.myCommitInfo = this.myCommitEditor.closeEdit();
        if (this.mySourceRepository != null) {
            this.mySourceRepository.closeSession();
            this.mySourceRepository = null;
        }
        return this.myCommitInfo;
    }

    @Override
    public void abortEdit() {
        if (this.mySourceRepository != null) {
            this.mySourceRepository.closeSession();
            this.mySourceRepository = null;
        }
        this.myCommitEditor.abortEdit();
    }

    public SVNCommitInfo getCommitInfo() {
        return this.myCommitInfo;
    }

    private SVNRepository getSourceRepository() {
        if (this.mySourceRepository == null) {
            this.mySourceRepository = SVNRepositoryFactory.create(this.myRepos.getLocation());
            this.mySourceRepository.setAuthenticationManager(this.myRepos.getAuthenticationManager());
            this.mySourceRepository.setDebugLog(this.myRepos.getDebugLog());
            this.mySourceRepository.setTunnelProvider(this.myRepos.getTunnelProvider());
            this.mySourceRepository.setCanceller(this.myRepos.getCanceller());
        }
        return this.mySourceRepository;
    }

    private void completeDeletion(String string) {
        String string2;
        String string32;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string32 : this.myChangedPaths.keySet()) {
            SVNLogEntryPath sVNLogEntryPath;
            if (!string32.startsWith(string + "/") || (sVNLogEntryPath = (SVNLogEntryPath)this.myChangedPaths.get(string32)).getType() != 'D') continue;
            string2 = string32.substring(string.length() + 1);
            arrayList.add(string2);
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(stringArray, SVNPathUtil.PATH_COMPARATOR);
        string32 = "";
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            string2 = stringArray[i2];
            while (!"".equals(string32) && string2.indexOf(string32) == -1) {
                this.myCommitEditor.closeDir();
                string32 = SVNPathUtil.removeTail(string32);
            }
            String string4 = null;
            string4 = !"".equals(string32) ? string2.substring(string32.length() + 1) : string2;
            String[] stringArray2 = string4.split("/");
            int n2 = 0;
            for (n2 = 0; n2 < stringArray2.length - 1; ++n2) {
                string32 = SVNPathUtil.append(string32, stringArray2[n2]);
                this.myCommitEditor.openDir(SVNPathUtil.append(string, string32), this.myPreviousRevision);
            }
            String string5 = SVNPathUtil.append(string32, stringArray2[n2]);
            String string6 = SVNPathUtil.append(string, string5);
            if (!this.myDeletedPaths.contains(string6)) {
                this.myCommitEditor.deleteEntry(string6, this.myPreviousRevision);
                this.myDeletedPaths.add(string6);
            }
            this.myChangedPaths.remove(string6);
        }
        while (!"".equals(string32)) {
            this.myCommitEditor.closeDir();
            string32 = SVNPathUtil.removeTail(string32);
        }
    }

    private SVNLogEntryPath getFileCopyOrigin(String string) {
        String string2;
        int n2;
        String[] stringArray = this.myCopiedPaths.keySet().toArray(new String[this.myCopiedPaths.size()]);
        Arrays.sort(stringArray, 0, stringArray.length, SVNPathUtil.PATH_COMPARATOR);
        SVNLogEntryPath sVNLogEntryPath = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            string2 = stringArray[n2];
            if (!string.startsWith(string2 + "/")) continue;
            if (string.equals(string2)) {
                return (SVNLogEntryPath)this.myCopiedPaths.get(string2);
            }
            arrayList.add(string2);
        }
        for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
            string2 = (String)arrayList.get(n2);
            if (this.getSourceRepository().checkPath(string2, this.myTargetRevision) != SVNNodeKind.DIR) continue;
            SVNLogEntryPath sVNLogEntryPath2 = (SVNLogEntryPath)this.myCopiedPaths.get(string2);
            String string3 = string.substring(string2.length() + 1);
            string3 = SVNPathUtil.append(sVNLogEntryPath2.getCopyPath(), string3);
            return new SVNLogEntryPath(string, ' ', string3, sVNLogEntryPath2.getCopyRevision());
        }
        return sVNLogEntryPath;
    }

    private boolean areFileContentsEqual(String string, long l2, String string2, long l3, SVNProperties sVNProperties) {
        SVNProperties sVNProperties2 = new SVNProperties();
        sVNProperties = sVNProperties == null ? new SVNProperties() : sVNProperties;
        SVNRepository sVNRepository = this.getSourceRepository();
        sVNRepository.getFile(string, l2, sVNProperties2, null);
        sVNRepository.getFile(string2, l3, sVNProperties, null);
        String string3 = sVNProperties2.getStringValue("svn:entry:checksum");
        String string4 = sVNProperties.getStringValue("svn:entry:checksum");
        return string3 != null && string3.equals(string4);
    }
}

