/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io.diff;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNDiffWindowApplyBaton {
    InputStream mySourceStream;
    OutputStream myTargetStream;
    long mySourceViewOffset;
    int mySourceViewLength;
    int myTargetViewSize;
    byte[] mySourceBuffer;
    byte[] myTargetBuffer;
    MessageDigest myDigest;

    public static SVNDiffWindowApplyBaton create(File file, File file2, MessageDigest messageDigest) {
        SVNDiffWindowApplyBaton sVNDiffWindowApplyBaton = new SVNDiffWindowApplyBaton();
        sVNDiffWindowApplyBaton.mySourceStream = file.exists() ? SVNFileUtil.openFileForReading(file) : SVNFileUtil.DUMMY_IN;
        sVNDiffWindowApplyBaton.myTargetStream = SVNFileUtil.openFileForWriting(file2, true);
        sVNDiffWindowApplyBaton.mySourceBuffer = new byte[0];
        sVNDiffWindowApplyBaton.mySourceViewLength = 0;
        sVNDiffWindowApplyBaton.mySourceViewOffset = 0L;
        sVNDiffWindowApplyBaton.myDigest = messageDigest;
        return sVNDiffWindowApplyBaton;
    }

    public static SVNDiffWindowApplyBaton create(InputStream inputStream, OutputStream outputStream, MessageDigest messageDigest) {
        SVNDiffWindowApplyBaton sVNDiffWindowApplyBaton = new SVNDiffWindowApplyBaton();
        sVNDiffWindowApplyBaton.mySourceStream = inputStream;
        sVNDiffWindowApplyBaton.myTargetStream = outputStream;
        sVNDiffWindowApplyBaton.mySourceBuffer = new byte[0];
        sVNDiffWindowApplyBaton.mySourceViewLength = 0;
        sVNDiffWindowApplyBaton.mySourceViewOffset = 0L;
        sVNDiffWindowApplyBaton.myDigest = messageDigest;
        return sVNDiffWindowApplyBaton;
    }

    private SVNDiffWindowApplyBaton() {
    }

    public String close() {
        SVNFileUtil.closeFile(this.mySourceStream);
        this.mySourceStream = null;
        SVNFileUtil.closeFile(this.myTargetStream);
        this.myTargetStream = null;
        if (this.myDigest != null) {
            MessageDigest messageDigest = this.myDigest;
            this.myDigest = null;
            return SVNFileUtil.toHexDigest(messageDigest);
        }
        return null;
    }
}

