/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io.diff;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.zip.DeflaterOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCompression;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.diff.SVNDiffInstruction;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow$1;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow$InstructionsIterator;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindowApplyBaton;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDiffWindow {
    @Deprecated
    public static final byte[] SVN_HEADER = SVNDeltaCompression.None.getHeader();
    @Deprecated
    public static final byte[] SVN1_HEADER = SVNDeltaCompression.Zlib.getHeader();
    public static final byte[] SVN2_HEADER = SVNDeltaCompression.LZ4.getHeader();
    public static final SVNDiffWindow EMPTY = new SVNDiffWindow(0L, 0, 0, 0, 0);
    private static final LZ4Compressor LZ4_COMPRESSOR = LZ4Factory.fastestInstance().fastCompressor();
    private final long mySourceViewOffset;
    private final int mySourceViewLength;
    private final int myTargetViewLength;
    private final int myNewDataLength;
    private int myInstructionsLength;
    private SVNDiffInstruction myTemplateInstruction = new SVNDiffInstruction(0, 0, 0);
    private SVNDiffInstruction myTemplateNextInstruction = new SVNDiffInstruction(0, 0, 0);
    private byte[] myData;
    private int myDataOffset;
    private int myInstructionsCount;

    public SVNDiffWindow(long l2, int n2, int n3, int n4, int n5) {
        this.mySourceViewOffset = l2;
        this.mySourceViewLength = n2;
        this.myTargetViewLength = n3;
        this.myInstructionsLength = n4;
        this.myNewDataLength = n5;
    }

    public int getInstructionsLength() {
        return this.myInstructionsLength;
    }

    public long getSourceViewOffset() {
        return this.mySourceViewOffset;
    }

    public int getSourceViewLength() {
        return this.mySourceViewLength;
    }

    public int getTargetViewLength() {
        return this.myTargetViewLength;
    }

    public int getNewDataLength() {
        return this.myNewDataLength;
    }

    public Iterator instructions() {
        return this.instructions(false);
    }

    public Iterator instructions(boolean bl2) {
        return new SVNDiffWindow$InstructionsIterator(this, bl2);
    }

    public void apply(SVNDiffWindowApplyBaton sVNDiffWindowApplyBaton) {
        int n2;
        if (sVNDiffWindowApplyBaton.myTargetBuffer == null || sVNDiffWindowApplyBaton.myTargetViewSize < this.getTargetViewLength()) {
            sVNDiffWindowApplyBaton.myTargetBuffer = new byte[this.getTargetViewLength()];
        }
        sVNDiffWindowApplyBaton.myTargetViewSize = this.getTargetViewLength();
        int n3 = 0;
        if (this.getSourceViewOffset() != sVNDiffWindowApplyBaton.mySourceViewOffset || this.getSourceViewLength() > sVNDiffWindowApplyBaton.mySourceViewLength) {
            byte[] byArray = sVNDiffWindowApplyBaton.mySourceBuffer;
            sVNDiffWindowApplyBaton.mySourceBuffer = new byte[this.getSourceViewLength()];
            if (sVNDiffWindowApplyBaton.mySourceViewOffset + (long)sVNDiffWindowApplyBaton.mySourceViewLength > this.getSourceViewOffset()) {
                n2 = (int)(this.getSourceViewOffset() - sVNDiffWindowApplyBaton.mySourceViewOffset);
                System.arraycopy(byArray, n2, sVNDiffWindowApplyBaton.mySourceBuffer, 0, sVNDiffWindowApplyBaton.mySourceViewLength - n2);
                n3 = sVNDiffWindowApplyBaton.mySourceViewLength - n2;
            }
        }
        if (n3 < this.getSourceViewLength()) {
            try {
                int n4 = (int)(this.getSourceViewOffset() - (sVNDiffWindowApplyBaton.mySourceViewOffset + (long)sVNDiffWindowApplyBaton.mySourceViewLength));
                if (n4 > 0) {
                    sVNDiffWindowApplyBaton.mySourceStream.skip(n4);
                }
                SVNFileUtil.readIntoBuffer(sVNDiffWindowApplyBaton.mySourceStream, sVNDiffWindowApplyBaton.mySourceBuffer, n3, sVNDiffWindowApplyBaton.mySourceBuffer.length - n3);
            }
            catch (IOException iOException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.DEFAULT);
            }
        }
        sVNDiffWindowApplyBaton.mySourceViewLength = this.getSourceViewLength();
        sVNDiffWindowApplyBaton.mySourceViewOffset = this.getSourceViewOffset();
        int n5 = 0;
        n2 = this.myInstructionsLength;
        try {
            Iterator iterator = this.instructions(true);
            while (iterator.hasNext()) {
                SVNDiffInstruction sVNDiffInstruction = (SVNDiffInstruction)iterator.next();
                int n6 = sVNDiffInstruction.length < this.getTargetViewLength() - n5 ? sVNDiffInstruction.length : this.getTargetViewLength() - n5;
                switch (sVNDiffInstruction.type) {
                    case 2: {
                        System.arraycopy(this.myData, this.myDataOffset + n2, sVNDiffWindowApplyBaton.myTargetBuffer, n5, n6);
                        n2 += n6;
                        break;
                    }
                    case 1: {
                        int n7 = sVNDiffInstruction.offset;
                        int n8 = sVNDiffInstruction.offset + n6;
                        int n9 = n5;
                        for (int i2 = n7; i2 < n8; ++i2) {
                            sVNDiffWindowApplyBaton.myTargetBuffer[n9] = sVNDiffWindowApplyBaton.myTargetBuffer[i2];
                            ++n9;
                        }
                        break;
                    }
                    case 0: {
                        System.arraycopy(sVNDiffWindowApplyBaton.mySourceBuffer, sVNDiffInstruction.offset, sVNDiffWindowApplyBaton.myTargetBuffer, n5, n6);
                        break;
                    }
                }
                if ((n5 += sVNDiffInstruction.length) < this.getTargetViewLength()) continue;
                break;
            }
            if (sVNDiffWindowApplyBaton.myDigest != null) {
                sVNDiffWindowApplyBaton.myDigest.update(sVNDiffWindowApplyBaton.myTargetBuffer, 0, this.getTargetViewLength());
            }
            sVNDiffWindowApplyBaton.myTargetStream.write(sVNDiffWindowApplyBaton.myTargetBuffer, 0, this.getTargetViewLength());
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.DEFAULT);
        }
    }

    public int apply(byte[] byArray, byte[] byArray2) {
        int n2 = this.myInstructionsLength;
        int n3 = 0;
        Iterator iterator = this.instructions(true);
        while (iterator.hasNext()) {
            SVNDiffInstruction sVNDiffInstruction = (SVNDiffInstruction)iterator.next();
            int n4 = sVNDiffInstruction.length < this.getTargetViewLength() - n3 ? sVNDiffInstruction.length : this.getTargetViewLength() - n3;
            switch (sVNDiffInstruction.type) {
                case 2: {
                    System.arraycopy(this.myData, this.myDataOffset + n2, byArray2, n3, n4);
                    n2 += n4;
                    break;
                }
                case 1: {
                    int n5 = sVNDiffInstruction.offset;
                    int n6 = sVNDiffInstruction.offset + n4;
                    int n7 = n3;
                    for (int i2 = n5; i2 < n6; ++i2) {
                        byArray2[n7] = byArray2[i2];
                        ++n7;
                    }
                    break;
                }
                case 0: {
                    System.arraycopy(byArray, sVNDiffInstruction.offset, byArray2, n3, n4);
                    break;
                }
            }
            if ((n3 += sVNDiffInstruction.length) < this.getTargetViewLength()) continue;
            break;
        }
        return this.getTargetViewLength();
    }

    public void setData(ByteBuffer byteBuffer) {
        this.myData = byteBuffer.array();
        this.myDataOffset = byteBuffer.position() + byteBuffer.arrayOffset();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getSourceViewOffset());
        stringBuffer.append(":");
        stringBuffer.append(this.getSourceViewLength());
        stringBuffer.append(":");
        stringBuffer.append(this.getTargetViewLength());
        stringBuffer.append(":");
        stringBuffer.append(this.getInstructionsLength());
        stringBuffer.append(":");
        stringBuffer.append(this.getNewDataLength());
        stringBuffer.append(":");
        stringBuffer.append(this.getDataLength());
        stringBuffer.append(":");
        stringBuffer.append(this.myDataOffset);
        return stringBuffer.toString();
    }

    public boolean hasInstructions() {
        return this.myInstructionsLength > 0;
    }

    public void writeTo(OutputStream outputStream, boolean bl2) {
        this.writeTo(outputStream, bl2, SVNDeltaCompression.None);
    }

    @Deprecated
    public void writeTo(OutputStream outputStream, boolean bl2, boolean bl3) {
        this.writeTo(outputStream, bl2, SVNDeltaCompression.fromLegacyCompress(bl3));
    }

    public void writeTo(OutputStream outputStream, boolean bl2, SVNDeltaCompression sVNDeltaCompression) {
        if (bl2) {
            outputStream.write(sVNDeltaCompression.getHeader());
        }
        if (!this.hasInstructions()) {
            return;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(100);
        SVNDiffInstruction.writeLong(byteBuffer, this.mySourceViewOffset);
        SVNDiffInstruction.writeInt(byteBuffer, this.mySourceViewLength);
        SVNDiffInstruction.writeInt(byteBuffer, this.myTargetViewLength);
        ByteBuffer byteBuffer2 = null;
        ByteBuffer byteBuffer3 = null;
        int n2 = 0;
        int n3 = 0;
        if (sVNDeltaCompression != SVNDeltaCompression.None) {
            byteBuffer2 = SVNDiffWindow.inflate(this.myData, this.myDataOffset, this.myInstructionsLength, sVNDeltaCompression);
            n2 = byteBuffer2.remaining();
            byteBuffer3 = SVNDiffWindow.inflate(this.myData, this.myDataOffset + this.myInstructionsLength, this.myNewDataLength, sVNDeltaCompression);
            n3 = byteBuffer3.remaining();
            SVNDiffInstruction.writeInt(byteBuffer, n2);
            SVNDiffInstruction.writeInt(byteBuffer, n3);
        } else {
            SVNDiffInstruction.writeInt(byteBuffer, this.myInstructionsLength);
            SVNDiffInstruction.writeInt(byteBuffer, this.myNewDataLength);
        }
        outputStream.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.position());
        if (sVNDeltaCompression != SVNDeltaCompression.None) {
            outputStream.write(byteBuffer2.array(), byteBuffer2.arrayOffset(), byteBuffer2.remaining());
            outputStream.write(byteBuffer3.array(), byteBuffer3.arrayOffset(), byteBuffer3.remaining());
        } else {
            outputStream.write(this.myData, this.myDataOffset, this.myInstructionsLength);
            if (this.myNewDataLength > 0) {
                outputStream.write(this.myData, this.myDataOffset + this.myInstructionsLength, this.myNewDataLength);
            }
        }
    }

    public int getDataLength() {
        return this.myNewDataLength + this.myInstructionsLength;
    }

    public boolean hasCopyFromSourceInstructions() {
        Iterator iterator = this.instructions(true);
        while (iterator.hasNext()) {
            SVNDiffInstruction sVNDiffInstruction = (SVNDiffInstruction)iterator.next();
            if (sVNDiffInstruction.type != 0) continue;
            return true;
        }
        return false;
    }

    public SVNDiffWindow clone(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.position() + byteBuffer.arrayOffset();
        int n3 = byteBuffer.position();
        byteBuffer.put(this.myData, this.myDataOffset, this.myInstructionsLength + this.myNewDataLength);
        byteBuffer.position(n3);
        SVNDiffWindow sVNDiffWindow = new SVNDiffWindow(this.getSourceViewOffset(), this.getSourceViewLength(), this.getTargetViewLength(), this.getInstructionsLength(), this.getNewDataLength());
        sVNDiffWindow.setData(byteBuffer);
        sVNDiffWindow.myDataOffset = n2;
        return sVNDiffWindow;
    }

    private static ByteBuffer inflate(byte[] byArray, int n2, int n3, SVNDeltaCompression sVNDeltaCompression) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3 * 2 + 2);
        SVNDiffInstruction.writeInt(byteBuffer, n3);
        if (n3 < 512) {
            byteBuffer.put(byArray, n2, n3);
        } else {
            if (sVNDeltaCompression == SVNDeltaCompression.LZ4) {
                LZ4_COMPRESSOR.compress(ByteBuffer.wrap(byArray, n2, n3), byteBuffer);
            } else if (sVNDeltaCompression == SVNDeltaCompression.Zlib) {
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(new SVNDiffWindow$1(byteBuffer));
                deflaterOutputStream.write(byArray, n2, n3);
                deflaterOutputStream.finish();
            }
            if (byteBuffer.position() >= n3) {
                byteBuffer.clear();
                SVNDiffInstruction.writeInt(byteBuffer, n3);
                byteBuffer.put(byArray, n2, n3);
            }
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    public SVNDiffInstruction[] loadDiffInstructions(SVNDiffInstruction[] sVNDiffInstructionArray) {
        int n2 = 0;
        Iterator iterator = this.instructions();
        while (iterator.hasNext()) {
            if (n2 >= sVNDiffInstructionArray.length) {
                SVNDiffInstruction[] sVNDiffInstructionArray2 = new SVNDiffInstruction[n2 * 3 / 2];
                System.arraycopy(sVNDiffInstructionArray, 0, sVNDiffInstructionArray2, 0, n2);
                sVNDiffInstructionArray = sVNDiffInstructionArray2;
            }
            sVNDiffInstructionArray[n2] = (SVNDiffInstruction)iterator.next();
            ++n2;
        }
        this.myInstructionsCount = n2;
        return sVNDiffInstructionArray;
    }

    public int getInstructionsCount() {
        return this.myInstructionsCount;
    }

    public void writeNewData(ByteBuffer byteBuffer, int n2, int n3) {
        byteBuffer.put(this.myData, n2 += this.myDataOffset + this.myInstructionsLength, n3);
    }

    static /* synthetic */ SVNDiffInstruction access$000(SVNDiffWindow sVNDiffWindow) {
        return sVNDiffWindow.myTemplateNextInstruction;
    }

    static /* synthetic */ byte[] access$100(SVNDiffWindow sVNDiffWindow) {
        return sVNDiffWindow.myData;
    }

    static /* synthetic */ int access$200(SVNDiffWindow sVNDiffWindow) {
        return sVNDiffWindow.myInstructionsLength;
    }

    static /* synthetic */ SVNDiffInstruction access$300(SVNDiffWindow sVNDiffWindow) {
        return sVNDiffWindow.myTemplateInstruction;
    }

    static /* synthetic */ int access$400(SVNDiffWindow sVNDiffWindow) {
        return sVNDiffWindow.myDataOffset;
    }
}

