/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io.diff;

import java.nio.ByteBuffer;

public class SVNDiffInstruction {
    public static final int COPY_FROM_SOURCE = 0;
    public static final int COPY_FROM_TARGET = 1;
    public static final int COPY_FROM_NEW_DATA = 2;
    public int type;
    public int length;
    public int offset;

    public SVNDiffInstruction(int n2, int n3, int n4) {
        this.type = n2;
        this.length = n3;
        this.offset = n4;
    }

    public SVNDiffInstruction() {
        this(0, 0, 0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 0: {
                stringBuffer.append("S->");
                break;
            }
            case 1: {
                stringBuffer.append("T->");
                break;
            }
            case 2: {
                stringBuffer.append("D->");
            }
        }
        if (this.type == 0 || this.type == 1) {
            stringBuffer.append(this.offset);
        } else {
            stringBuffer.append(this.offset);
        }
        stringBuffer.append(":");
        stringBuffer.append(this.length);
        return stringBuffer.toString();
    }

    public void writeTo(ByteBuffer byteBuffer) {
        byte by = (byte)(this.type << 6);
        if (this.length <= 63 && this.length > 0) {
            by = (byte)(by | this.length & 0x3F);
            byteBuffer.put((byte)(by & 0xFF));
        } else {
            byteBuffer.put((byte)(by & 0xFF));
            SVNDiffInstruction.writeInt(byteBuffer, this.length);
        }
        if (this.type == 0 || this.type == 1) {
            SVNDiffInstruction.writeInt(byteBuffer, this.offset);
        }
    }

    public static void writeInt(ByteBuffer byteBuffer, int n2) {
        if (n2 == 0) {
            byteBuffer.put((byte)0);
            return;
        }
        int n3 = 1;
        long l2 = n2 >> 7;
        while (l2 > 0L) {
            l2 >>= 7;
            ++n3;
        }
        while (--n3 >= 0) {
            byte by = (byte)((n3 > 0 ? 1 : 0) << 7);
            int n4 = (byte)(n2 >> 7 * n3 & 0x7F) | by;
            byteBuffer.put((byte)n4);
        }
    }

    public static void writeLong(ByteBuffer byteBuffer, long l2) {
        if (l2 == 0L) {
            byteBuffer.put((byte)0);
            return;
        }
        int n2 = 1;
        long l3 = l2 >> 7;
        while (l3 > 0L) {
            l3 >>= 7;
            ++n2;
        }
        while (--n2 >= 0) {
            byte by = (byte)((n2 > 0 ? 1 : 0) << 7);
            int n3 = (byte)(l2 >> 7 * n2 & 0x7FL) | by;
            byteBuffer.put((byte)n3);
        }
    }
}

