/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io.diff;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindowApplyBaton;

public class SVNDeltaProcessor {
    private SVNDiffWindowApplyBaton myApplyBaton;

    public void applyTextDelta(InputStream inputStream, OutputStream outputStream, boolean bl2) {
        this.reset();
        MessageDigest messageDigest = null;
        try {
            messageDigest = bl2 ? MessageDigest.getInstance("MD5") : null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        inputStream = inputStream == null ? SVNFileUtil.DUMMY_IN : inputStream;
        this.myApplyBaton = SVNDiffWindowApplyBaton.create(inputStream, outputStream, messageDigest);
    }

    public void applyTextDelta(File file, File file2, boolean bl2) {
        if (!file2.exists()) {
            SVNFileUtil.createEmptyFile(file2);
        }
        InputStream inputStream = file != null && file.exists() ? SVNFileUtil.openFileForReading(file) : SVNFileUtil.DUMMY_IN;
        this.applyTextDelta(inputStream, SVNFileUtil.openFileForWriting(file2), bl2);
    }

    public void applyTextDelta(InputStream inputStream, File file, boolean bl2) {
        if (!file.exists()) {
            SVNFileUtil.createEmptyFile(file);
        }
        this.applyTextDelta(inputStream, SVNFileUtil.openFileForWriting(file), bl2);
    }

    public OutputStream textDeltaChunk(SVNDiffWindow sVNDiffWindow) {
        sVNDiffWindow.apply(this.myApplyBaton);
        return SVNFileUtil.DUMMY_OUT;
    }

    private void reset() {
        if (this.myApplyBaton != null) {
            this.myApplyBaton.close();
            this.myApplyBaton = null;
        }
    }

    public String textDeltaEnd() {
        try {
            String string = this.myApplyBaton.close();
            return string;
        }
        finally {
            this.reset();
        }
    }
}

