/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io.diff;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaAlgorithm;
import org.tmatesoft.svn.core.internal.delta.SVNXDeltaAlgorithm;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDeltaGenerator {
    private SVNDeltaAlgorithm myXDelta = new SVNXDeltaAlgorithm();
    private byte[] mySourceBuffer;
    private byte[] myTargetBuffer;
    private int myMaximumBufferSize;

    public SVNDeltaGenerator() {
        this(102400);
    }

    public SVNDeltaGenerator(int n2) {
        this.myMaximumBufferSize = n2;
        int n3 = Math.min(8192, this.myMaximumBufferSize);
        this.mySourceBuffer = new byte[n3];
        this.myTargetBuffer = new byte[n3];
    }

    public String sendDelta(String string, InputStream inputStream, ISVNDeltaConsumer iSVNDeltaConsumer, boolean bl2) {
        return this.sendDelta(string, SVNFileUtil.DUMMY_IN, 0L, inputStream, iSVNDeltaConsumer, bl2);
    }

    public String sendDelta(String string, InputStream inputStream, long l2, InputStream inputStream2, ISVNDeltaConsumer iSVNDeltaConsumer, boolean bl2) {
        MessageDigest messageDigest = null;
        if (bl2) {
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", (Object)noSuchAlgorithmException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, noSuchAlgorithmException, SVNLogType.DEFAULT);
                return null;
            }
        }
        boolean bl3 = false;
        while (true) {
            int n2;
            int n3;
            try {
                n3 = this.readToBuffer(inputStream2, this.myTargetBuffer);
            }
            catch (IOExceptionWrapper iOExceptionWrapper) {
                throw iOExceptionWrapper.getOriginalException();
            }
            catch (IOException iOException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.DEFAULT);
                return null;
            }
            if (n3 <= 0) {
                if (bl3 || iSVNDeltaConsumer == null) break;
                iSVNDeltaConsumer.textDeltaChunk(string, SVNDiffWindow.EMPTY);
                break;
            }
            try {
                n2 = this.readToBuffer(inputStream, this.mySourceBuffer);
            }
            catch (IOExceptionWrapper iOExceptionWrapper) {
                throw iOExceptionWrapper.getOriginalException();
            }
            catch (IOException iOException) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage());
                SVNErrorManager.error(sVNErrorMessage, iOException, SVNLogType.DEFAULT);
                return null;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (messageDigest != null) {
                messageDigest.update(this.myTargetBuffer, 0, n3);
            }
            this.sendDelta(string, l2, this.mySourceBuffer, n2, this.myTargetBuffer, n3, iSVNDeltaConsumer);
            bl3 = true;
            l2 += (long)n2;
        }
        if (iSVNDeltaConsumer != null) {
            iSVNDeltaConsumer.textDeltaEnd(string);
        }
        return SVNFileUtil.toHexDigest(messageDigest);
    }

    public void sendDelta(String string, byte[] byArray, int n2, ISVNDeltaConsumer iSVNDeltaConsumer) {
        this.sendDelta(string, null, 0, 0L, byArray, n2, iSVNDeltaConsumer);
    }

    public void sendDelta(String string, byte[] byArray, int n2, long l2, byte[] byArray2, int n3, ISVNDeltaConsumer iSVNDeltaConsumer) {
        if (n3 == 0 || byArray2 == null) {
            if (iSVNDeltaConsumer != null) {
                iSVNDeltaConsumer.textDeltaChunk(string, SVNDiffWindow.EMPTY);
            }
            return;
        }
        if (byArray == null) {
            byArray = new byte[]{};
            n2 = 0;
        } else if (n2 < 0) {
            n2 = 0;
        }
        this.sendDelta(string, l2, byArray == null ? new byte[]{} : byArray, n2, byArray2, n3, iSVNDeltaConsumer);
    }

    private void sendDelta(String string, long l2, byte[] byArray, int n2, byte[] byArray2, int n3, ISVNDeltaConsumer iSVNDeltaConsumer) {
        SVNDeltaAlgorithm sVNDeltaAlgorithm = this.myXDelta;
        sVNDeltaAlgorithm.computeDelta(byArray, n2, byArray2, n3);
        if (iSVNDeltaConsumer == null) {
            sVNDeltaAlgorithm.reset();
            return;
        }
        int n4 = sVNDeltaAlgorithm.getInstructionsLength();
        int n5 = sVNDeltaAlgorithm.getNewDataLength();
        SVNDiffWindow sVNDiffWindow = new SVNDiffWindow(l2, n2, n3, n4, n5);
        sVNDiffWindow.setData(sVNDeltaAlgorithm.getData());
        OutputStream outputStream = iSVNDeltaConsumer.textDeltaChunk(string, sVNDiffWindow);
        SVNFileUtil.closeFile(outputStream);
        sVNDeltaAlgorithm.reset();
    }

    private int readToBuffer(InputStream inputStream, byte[] byArray) {
        int n2 = SVNFileUtil.readIntoBuffer(inputStream, byArray, 0, byArray.length);
        if (n2 <= 0) {
            return n2;
        }
        if (n2 == byArray.length && n2 < this.myMaximumBufferSize) {
            byte[] byArray2 = new byte[this.myMaximumBufferSize];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            if (byArray == this.myTargetBuffer) {
                this.myTargetBuffer = byArray2;
            } else {
                this.mySourceBuffer = byArray2;
            }
            byArray = byArray2;
            int n3 = SVNFileUtil.readIntoBuffer(inputStream, byArray, n2, byArray.length - n2);
            if (n3 <= 0) {
                return n2;
            }
            n2 += n3;
        }
        return n2;
    }
}

