/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb$Mode;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentationCacheUtil;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNUUIDGenerator;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SVNRepositoryFactory {
    private static final Map myFactoriesMap = new SVNHashMap();
    private static final String REPOSITORY_TEMPLATE_PATH = "/org/tmatesoft/svn/core/io/repository/template.jar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerRepositoryFactory(String string, SVNRepositoryFactory sVNRepositoryFactory) {
        if (string != null && sVNRepositoryFactory != null) {
            Map map = myFactoriesMap;
            synchronized (map) {
                myFactoriesMap.put(string, sVNRepositoryFactory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean hasRepositoryFactory(String string) {
        if (string != null) {
            Map map = myFactoriesMap;
            synchronized (map) {
                return myFactoriesMap.get(string) != null;
            }
        }
        return false;
    }

    public static SVNRepository create(SVNURL sVNURL) {
        return SVNRepositoryFactory.create(sVNURL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNRepository create(SVNURL sVNURL, ISVNSession iSVNSession) {
        String string = sVNURL.toString();
        Object object = myFactoriesMap;
        synchronized (object) {
            for (String string2 : myFactoriesMap.keySet()) {
                if (!Pattern.matches(string2, string)) continue;
                return ((SVNRepositoryFactory)myFactoriesMap.get(string2)).createRepositoryImpl(sVNURL, iSVNSession);
            }
        }
        if ("file".equalsIgnoreCase(sVNURL.getProtocol())) {
            object = SVNErrorMessage.create(SVNErrorCode.RA_LOCAL_REPOS_OPEN_FAILED, "Unable to open repository ''{0}''", new Object[]{sVNURL});
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        }
        object = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Unable to create SVNRepository object for ''{0}''", (Object)sVNURL);
        SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        return null;
    }

    public static SVNURL createLocalRepository(File file, boolean bl2, boolean bl3) {
        return SVNRepositoryFactory.createLocalRepository(file, null, bl2, bl3);
    }

    public static SVNURL createLocalRepository(File file, String string, boolean bl2, boolean bl3) {
        return SVNRepositoryFactory.createLocalRepository(file, string, bl2, bl3, false);
    }

    public static SVNURL createLocalRepository(File file, String string, boolean bl2, boolean bl3, boolean bl4) {
        return SVNRepositoryFactory.createLocalRepository(file, string, bl2, bl3, bl4, false);
    }

    public static SVNURL createLocalRepository(File file, String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return SVNRepositoryFactory.createLocalRepository(file, string, bl2, bl3, bl4, bl5, false);
    }

    public static SVNURL createLocalRepository(File file, String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        return SVNRepositoryFactory.createLocalRepository(file, string, bl2, bl3, bl4, bl5, bl6, false, false);
    }

    public static SVNURL createLocalRepository(File file, String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        return SVNRepositoryFactory.createLocalRepository(file, string, bl2, bl3, bl4, bl5, bl6, bl7, bl8, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNURL createLocalRepository(File file, String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        OutputStream outputStream;
        OutputStream outputStream2;
        OutputStream outputStream3;
        OutputStream outputStream4;
        OutputStream outputStream5;
        OutputStream outputStream6;
        Serializable serializable;
        block66: {
            Object object;
            Object object2;
            SVNFileType sVNFileType = SVNFileType.getType(file);
            if (sVNFileType != SVNFileType.NONE) {
                if (sVNFileType == SVNFileType.DIRECTORY) {
                    object2 = SVNFileListUtil.listFiles(file);
                    if (object2 != null && ((File[])object2).length != 0) {
                        if (!bl3) {
                            object = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "''{0}'' already exists; use ''force'' to overwrite existing files", (Object)file);
                            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
                        } else {
                            SVNFileUtil.deleteAll(file, true);
                        }
                    }
                } else if (!bl3) {
                    object2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "''{0}'' already exists; use ''force'' to overwrite existing files", (Object)file);
                    SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.FSFS);
                } else {
                    SVNFileUtil.deleteAll(file, true);
                }
            }
            if ((object2 = FSFS.findRepositoryRoot(file)) != null) {
                object = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "''{0}'' is a subdirectory of an existing repository rooted at ''{1}''", file, object2);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
            }
            if (!file.mkdirs() && !file.exists()) {
                object = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can not create directory ''{0}''", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.FSFS);
            }
            if ((object = SVNRepositoryFactory.class.getResourceAsStream(REPOSITORY_TEMPLATE_PATH)) == null) {
                serializable = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "No repository template found; should be part of SVNKit library jar");
                SVNErrorManager.error(serializable, SVNLogType.FSFS);
            }
            serializable = SVNFileUtil.createUniqueFile(file, ".template", ".jar", true);
            outputStream6 = null;
            outputStream5 = null;
            outputStream4 = null;
            outputStream3 = null;
            outputStream2 = null;
            outputStream = null;
            try {
                Object object3;
                File file2;
                File file3;
                Serializable serializable2;
                Object object4;
                Serializable serializable3;
                Object object5;
                Object object6;
                Object object7;
                SVNErrorMessage sVNErrorMessage;
                Object object8;
                SVNRepositoryFactory.copyToFile((InputStream)object, (File)serializable);
                SVNRepositoryFactory.extract((File)serializable, file);
                SVNFileUtil.deleteFile((File)serializable);
                if (!SVNFileUtil.isWindows) {
                    SVNRepositoryFactory.translateFiles(file);
                    SVNRepositoryFactory.translateFiles(new File(file, "conf"));
                    SVNRepositoryFactory.translateFiles(new File(file, "hooks"));
                    SVNRepositoryFactory.translateFiles(new File(file, "locks"));
                }
                if (bl2) {
                    File file4;
                    if (SVNFileUtil.isWindows) {
                        file4 = new File(file, "hooks/pre-revprop-change.bat");
                        object8 = SVNFileUtil.openFileForWriting(file4);
                        try {
                            ((OutputStream)object8).write("@echo off".getBytes());
                        }
                        catch (IOException iOException) {
                            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create pre-rev-prop-change hook file at ''{0}'': {1}", file4, iOException.getLocalizedMessage());
                            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                        }
                        finally {
                            SVNFileUtil.closeFile((OutputStream)object8);
                        }
                    } else {
                        file4 = new File(file, "hooks/pre-revprop-change");
                        object8 = null;
                        try {
                            object8 = SVNFileUtil.openFileForWriting(file4);
                            ((OutputStream)object8).write("#!/bin/sh\nexit 0".getBytes("US-ASCII"));
                        }
                        catch (IOException iOException) {
                            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create pre-rev-prop-change hook file at ''{0}'': {1}", file4, iOException.getLocalizedMessage());
                            SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                        }
                        finally {
                            SVNFileUtil.closeFile((OutputStream)object8);
                        }
                        SVNFileUtil.setExecutable(file4, true);
                    }
                }
                int n2 = 8;
                if (bl9) {
                    n2 = 7;
                }
                if (!bl8) {
                    n2 = 4;
                }
                if (bl7) {
                    n2 = 4;
                }
                if (bl4) {
                    object8 = new File(file, "format");
                    try {
                        outputStream5 = SVNFileUtil.openFileForWriting((File)object8);
                        object7 = String.valueOf(3);
                        object7 = (String)object7 + '\n';
                        outputStream5.write(((String)object7).getBytes("US-ASCII"));
                    }
                    catch (IOException iOException) {
                        sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Error writing repository format to ''{0}''", object8);
                        sVNErrorMessage.setChildErrorMessage(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage()));
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                    }
                }
                if (bl6) {
                    n2 = 3;
                }
                if (bl4 || bl5) {
                    if (bl4) {
                        n2 = 1;
                    } else if (bl5) {
                        n2 = 2;
                    }
                    object8 = new File(file, "db/format");
                    try {
                        outputStream4 = SVNFileUtil.openFileForWriting((File)object8);
                        object7 = String.valueOf(n2);
                        object7 = (String)object7 + '\n';
                        outputStream4.write(((String)object7).getBytes("US-ASCII"));
                    }
                    catch (IOException iOException) {
                        sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Error writing fs format to ''{0}''", object8);
                        sVNErrorMessage.setChildErrorMessage(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage()));
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                    }
                    object7 = new File(file, "dav");
                    ((File)object7).mkdir();
                } else {
                    object8 = new File(file, "db/txn-current-lock");
                    SVNFileUtil.createEmptyFile((File)object8);
                }
                object8 = new File(file, "db/uuid");
                if (string == null || string.length() != 36) {
                    string = SVNUUIDGenerator.generateUUIDString();
                }
                if (n2 >= 7) {
                    while (((String)(object7 = SVNUUIDGenerator.generateUUIDString())).equals(string)) {
                    }
                    string = string + '\n' + (String)object7 + '\n';
                } else {
                    string = string + '\n';
                }
                try {
                    outputStream6 = SVNFileUtil.openFileForWriting((File)object8);
                    outputStream6.write(string.getBytes("US-ASCII"));
                }
                catch (IOException iOException) {
                    sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Error writing repository UUID to ''{0}''", object8);
                    sVNErrorMessage.setChildErrorMessage(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage()));
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.FSFS);
                }
                long l2 = 0L;
                if (n2 >= 3) {
                    l2 = FSFS.getDefaultMaxFilesPerDirectory();
                    object6 = new File(file, "db/format");
                    try {
                        outputStream4 = SVNFileUtil.openFileForWriting((File)object6);
                        object5 = String.valueOf(n2) + "\n";
                        if (l2 > 0L) {
                            serializable3 = new File(file, "db/revs/0");
                            object4 = SVNFileUtil.createUniqueFile(new File(file, "db/revs"), "0", "tmp", true);
                            SVNFileUtil.rename((File)serializable3, (File)object4);
                            serializable2 = new File(file, "db/revs/0");
                            ((File)serializable2).mkdirs();
                            file3 = new File((File)serializable2, "0");
                            SVNFileUtil.rename((File)object4, file3);
                            file2 = new File(file, "db/revprops/0");
                            object4 = SVNFileUtil.createUniqueFile(new File(file, "db/revprops"), "0", "tmp", true);
                            SVNFileUtil.rename(file2, (File)object4);
                            object3 = new File(file, "db/revprops/0");
                            ((File)object3).mkdirs();
                            File file5 = new File((File)object3, "0");
                            SVNFileUtil.rename((File)object4, file5);
                            object5 = (String)object5 + "layout sharded " + String.valueOf(l2) + "\n";
                        } else {
                            object5 = (String)object5 + "layout linear\n";
                        }
                        outputStream4.write(((String)object5).getBytes("US-ASCII"));
                    }
                    catch (IOException iOException) {
                        serializable3 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Error writing fs format to ''{0}''", object6);
                        ((SVNErrorMessage)serializable3).setChildErrorMessage(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage()));
                        SVNErrorManager.error((SVNErrorMessage)serializable3, SVNLogType.FSFS);
                    }
                }
                object6 = n2 >= 3 ? "0\n" : "0 1 1\n";
                object5 = new File(file, "db/current");
                outputStream = SVNFileUtil.openFileForWriting((File)object5);
                try {
                    outputStream.write(((String)object6).getBytes("US-ASCII"));
                }
                catch (IOException iOException) {
                    object4 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can not write to ''{0}'' file: {1}", ((File)object5).getName(), iOException.getLocalizedMessage());
                    SVNErrorManager.error((SVNErrorMessage)object4, iOException, SVNLogType.FSFS);
                }
                if (n2 >= 4) {
                    serializable3 = new File(file, "db/min-unpacked-rev");
                    SVNFileUtil.createEmptyFile((File)serializable3);
                    outputStream2 = SVNFileUtil.openFileForWriting((File)serializable3);
                    try {
                        outputStream2.write("0\n".getBytes("US-ASCII"));
                    }
                    catch (IOException iOException) {
                        serializable2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can not write to ''{0}'' file: {1}", ((File)serializable3).getName(), iOException.getLocalizedMessage());
                        SVNErrorManager.error((SVNErrorMessage)serializable2, iOException, SVNLogType.FSFS);
                    }
                }
                if (n2 >= 3) {
                    serializable3 = new File(file, "db/txn-current");
                    SVNFileUtil.createEmptyFile((File)serializable3);
                    outputStream3 = SVNFileUtil.openFileForWriting((File)serializable3);
                    try {
                        outputStream3.write("0\n".getBytes("US-ASCII"));
                    }
                    catch (IOException iOException) {
                        serializable2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can not write to ''{0}'' file: {1}", ((File)serializable3).getName(), iOException.getLocalizedMessage());
                        SVNErrorManager.error((SVNErrorMessage)serializable2, iOException, SVNLogType.FSFS);
                    }
                }
                if (n2 >= 3) {
                    serializable3 = new File(file, "db/txn-protorevs");
                    ((File)serializable3).mkdirs();
                }
                serializable3 = new File(file, l2 > 0L ? "db/revprops/0/0" : "db/revprops/0");
                object4 = SVNDate.formatDate(new Date(System.currentTimeMillis()), true);
                serializable2 = new SVNHashMap();
                serializable2.put("svn:date", object4);
                SVNWCProperties.setProperties(SVNProperties.wrap((Map)((Object)serializable2)), (File)serializable3, null, "END");
                SVNRepositoryFactory.setSGID(new File(file, "db"));
                if (n2 >= 4) {
                    file3 = new File(file, "db/rep-cache.db");
                    FSRepresentationCacheUtil.create(n2, file3);
                }
                if (n2 < 6) break block66;
                file3 = new File(file, "db/min-unpacked-rev");
                SVNFileUtil.writeToFile(file3, "0\n", "US-ASCII");
                file2 = new File(file, "db/revprops/revprops.db");
                object3 = SVNSqlJetDb.open(file2, SVNSqlJetDb$Mode.RWCreate);
                try {
                    ((SVNSqlJetDb)object3).execStatement(SVNWCDbStatements.REVPROP_CREATE_SCHEMA);
                }
                finally {
                    ((SVNSqlJetDb)object3).close();
                }
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(outputStream6);
                SVNFileUtil.closeFile(outputStream5);
                SVNFileUtil.closeFile(outputStream4);
                SVNFileUtil.closeFile(outputStream3);
                SVNFileUtil.closeFile(outputStream2);
                SVNFileUtil.closeFile(outputStream);
                SVNFileUtil.deleteFile((File)serializable);
                throw throwable;
            }
        }
        SVNFileUtil.closeFile(outputStream6);
        SVNFileUtil.closeFile(outputStream5);
        SVNFileUtil.closeFile(outputStream4);
        SVNFileUtil.closeFile(outputStream3);
        SVNFileUtil.closeFile(outputStream2);
        SVNFileUtil.closeFile(outputStream);
        SVNFileUtil.deleteFile((File)serializable);
        return SVNURL.fromFile(file);
    }

    protected abstract SVNRepository createRepositoryImpl(SVNURL var1, ISVNSession var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyToFile(InputStream inputStream, File file) {
        OutputStream outputStream = null;
        byte[] byArray = new byte[16384];
        try {
            int n2;
            outputStream = SVNFileUtil.openFileForWriting(file);
            while ((n2 = inputStream.read(byArray)) >= 0) {
                if (n2 == 0) continue;
                outputStream.write(byArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can not copy repository template file to ''{0}''", (Object)file);
            sVNErrorMessage.setChildErrorMessage(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage()));
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        finally {
            SVNFileUtil.closeFile(outputStream);
            SVNFileUtil.closeFile(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void extract(File file, File file2) {
        JarInputStream jarInputStream = null;
        InputStream inputStream = SVNFileUtil.openFileForReading(file, SVNLogType.NETWORK);
        byte[] byArray = new byte[16384];
        JarFile jarFile = null;
        try {
            JarEntry jarEntry;
            jarFile = new JarFile(file);
            jarInputStream = new JarInputStream(inputStream);
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                block19: {
                    OutputStream outputStream;
                    BufferedInputStream bufferedInputStream;
                    String string = jarEntry.getName();
                    File file3 = new File(file2, string);
                    if (jarEntry.isDirectory()) {
                        file3.mkdirs();
                    } else {
                        int n2;
                        bufferedInputStream = null;
                        outputStream = null;
                        bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
                        outputStream = SVNFileUtil.openFileForWriting(file3);
                        while ((n2 = ((InputStream)bufferedInputStream).read(byArray)) >= 0) {
                            if (n2 == 0) continue;
                            outputStream.write(byArray, 0, n2);
                        }
                        SVNFileUtil.closeFile(outputStream);
                        SVNFileUtil.closeFile(bufferedInputStream);
                    }
                    break block19;
                    catch (Throwable throwable) {
                        SVNFileUtil.closeFile(outputStream);
                        SVNFileUtil.closeFile(bufferedInputStream);
                        throw throwable;
                    }
                }
                jarInputStream.closeEntry();
            }
        }
        catch (IOException iOException) {
            try {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can not extract repository files from ''{0}'' to ''{1}''", file, file2);
                sVNErrorMessage.setChildErrorMessage(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException.getLocalizedMessage()));
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(jarInputStream);
                SVNFileUtil.closeFile(inputStream);
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            SVNFileUtil.closeFile(jarInputStream);
            SVNFileUtil.closeFile(inputStream);
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException3) {}
            }
        }
        SVNFileUtil.closeFile(jarInputStream);
        SVNFileUtil.closeFile(inputStream);
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void translateFiles(File file) {
        File[] fileArray = SVNFileListUtil.listFiles(file);
        byte[] byArray = new byte[]{10};
        for (int i2 = 0; fileArray != null && i2 < fileArray.length; ++i2) {
            File file2 = fileArray[i2];
            File file3 = null;
            if (!file2.isFile()) continue;
            try {
                file3 = SVNFileUtil.createUniqueFile(file, ".repos", ".tmp", true);
                SVNTranslator.translate(file2, file3, null, byArray, null, false, true);
                SVNFileUtil.deleteFile(file2);
                SVNFileUtil.rename(file3, file2);
            }
            catch (Throwable throwable) {
                SVNFileUtil.deleteFile(file3);
                throw throwable;
            }
            SVNFileUtil.deleteFile(file3);
        }
    }

    private static void setSGID(File file) {
        SVNFileUtil.setSGID(file);
        File[] fileArray = file.listFiles();
        for (int i2 = 0; fileArray != null && i2 < fileArray.length; ++i2) {
            File file2 = fileArray[i2];
            if (!file2.isDirectory()) continue;
            SVNRepositoryFactory.setSGID(file2);
        }
    }

    static {
        FSRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        DAVRepositoryFactory.setup();
    }
}

