/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNConnectionListener;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNFileCheckoutTarget;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.ISVNInheritedPropertiesHandler;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.ISVNLocationSegmentHandler;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.ISVNReplayHandler;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNFileCheckoutEditor;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNRepository$1;
import org.tmatesoft.svn.core.io.SVNRepository$10;
import org.tmatesoft.svn.core.io.SVNRepository$2;
import org.tmatesoft.svn.core.io.SVNRepository$3;
import org.tmatesoft.svn.core.io.SVNRepository$4;
import org.tmatesoft.svn.core.io.SVNRepository$5;
import org.tmatesoft.svn.core.io.SVNRepository$6;
import org.tmatesoft.svn.core.io.SVNRepository$7;
import org.tmatesoft.svn.core.io.SVNRepository$8;
import org.tmatesoft.svn.core.io.SVNRepository$9;
import org.tmatesoft.svn.core.io.SVNRepository$DeletedRevisionLogHandler;
import org.tmatesoft.svn.core.io.SVNRepository$FileRevisionsLogHandler;
import org.tmatesoft.svn.core.io.SVNRepository$LocationSegmentsLogHandler;
import org.tmatesoft.svn.core.io.SVNRepository$LocationsLogHandler;
import org.tmatesoft.svn.core.io.SVNRepository$Revision;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SVNRepository {
    public static final long INVALID_REVISION = -1L;
    protected String myRepositoryUUID;
    protected SVNURL myRepositoryRoot;
    protected SVNURL myLocation;
    protected Set myOriginalLocations;
    private int myLockCount;
    private Thread myLocker;
    private ISVNAuthenticationManager myAuthManager;
    private ISVNSession myOptions;
    private ISVNTunnelProvider myTunnelProvider;
    private ISVNDebugLog myDebugLog;
    private ISVNCanceller myCanceller;
    private ISVNEventHandler myEventHandler;
    private Collection myConnectionListeners;

    protected SVNRepository(SVNURL sVNURL, ISVNSession iSVNSession) {
        this.myLocation = sVNURL;
        this.myOptions = iSVNSession;
        this.myConnectionListeners = new SVNHashSet();
        this.myOriginalLocations = new HashSet();
    }

    public SVNURL getLocation() {
        return this.myLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocation(SVNURL sVNURL, boolean bl2) {
        this.lock();
        try {
            if (sVNURL == null) {
                return;
            }
            if (!sVNURL.getProtocol().equals(this.myLocation.getProtocol()) && !this.myOriginalLocations.contains(sVNURL)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "SVNRepository URL could not be changed from ''{0}'' to ''{1}''; create new SVNRepository instance instead", this.myLocation, sVNURL);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
            }
            this.setLocationInternal(sVNURL, bl2);
        }
        finally {
            this.unlock();
        }
    }

    protected void setLocationInternal(SVNURL sVNURL, boolean bl2) {
        if (bl2) {
            this.closeSession();
            this.myRepositoryRoot = null;
            this.myRepositoryUUID = null;
        } else if (this.myRepositoryRoot == null) {
            if (!sVNURL.toString().startsWith(this.myLocation.toString() + "/") && !sVNURL.equals(this.getLocation())) {
                this.closeSession();
                this.myRepositoryRoot = null;
                this.myRepositoryUUID = null;
            }
        } else if (!sVNURL.toString().startsWith(this.myRepositoryRoot.toString() + "/") && !this.myRepositoryRoot.equals(sVNURL)) {
            this.closeSession();
            this.myRepositoryRoot = null;
            this.myRepositoryUUID = null;
        }
        this.myLocation = sVNURL;
    }

    public String getRepositoryUUID() {
        try {
            return this.getRepositoryUUID(false);
        }
        catch (SVNException sVNException) {
            return this.myRepositoryUUID;
        }
    }

    public String getRepositoryUUID(boolean bl2) {
        if (bl2 && this.myRepositoryUUID == null) {
            this.testConnection();
        }
        return this.myRepositoryUUID;
    }

    public SVNURL getRepositoryRoot() {
        try {
            return this.getRepositoryRoot(false);
        }
        catch (SVNException sVNException) {
            return null;
        }
    }

    public SVNURL getRepositoryRoot(boolean bl2) {
        if (bl2 && this.myRepositoryRoot == null) {
            this.testConnection();
        }
        return this.myRepositoryRoot;
    }

    public void setAuthenticationManager(ISVNAuthenticationManager iSVNAuthenticationManager) {
        this.myAuthManager = iSVNAuthenticationManager;
    }

    public ISVNAuthenticationManager getAuthenticationManager() {
        return this.myAuthManager;
    }

    public void setTunnelProvider(ISVNTunnelProvider iSVNTunnelProvider) {
        this.myTunnelProvider = iSVNTunnelProvider;
    }

    public ISVNTunnelProvider getTunnelProvider() {
        return this.myTunnelProvider;
    }

    public void setCanceller(ISVNCanceller iSVNCanceller) {
        this.myCanceller = iSVNCanceller;
    }

    public ISVNCanceller getCanceller() {
        return this.myCanceller == null ? ISVNCanceller.NULL : this.myCanceller;
    }

    public void setEventHandler(ISVNEventHandler iSVNEventHandler) {
        this.myEventHandler = iSVNEventHandler;
    }

    public ISVNEventHandler getEventHandler() {
        return this.myEventHandler;
    }

    protected void setRepositoryCredentials(String string, SVNURL sVNURL) {
        if (string != null && sVNURL != null) {
            this.myRepositoryUUID = string;
            this.myRepositoryRoot = sVNURL;
        }
    }

    public abstract void testConnection();

    public abstract long getLatestRevision();

    public abstract long getDatedRevision(Date var1);

    public abstract SVNProperties getRevisionProperties(long var1, SVNProperties var3);

    public abstract void setRevisionPropertyValue(long var1, String var3, SVNPropertyValue var4);

    public abstract SVNPropertyValue getRevisionPropertyValue(long var1, String var3);

    public abstract SVNNodeKind checkPath(String var1, long var2);

    public abstract long getFile(String var1, long var2, SVNProperties var4, OutputStream var5);

    public abstract long getDir(String var1, long var2, SVNProperties var4, ISVNDirEntryHandler var5);

    public abstract long getDir(String var1, long var2, SVNProperties var4, int var5, ISVNDirEntryHandler var6);

    public int getFileRevisions(String string, long l2, long l3, ISVNFileRevisionHandler iSVNFileRevisionHandler) {
        return this.getFileRevisions(string, l2, l3, false, iSVNFileRevisionHandler);
    }

    public int getFileRevisions(String string, long l2, long l3, boolean bl2, ISVNFileRevisionHandler iSVNFileRevisionHandler) {
        if (bl2) {
            this.assertServerIsMergeInfoCapable(null);
        }
        try {
            return this.getFileRevisionsImpl(string, l2, l3, bl2, iSVNFileRevisionHandler);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                return this.getFileRevisionsFromLog(string, l2, l3, iSVNFileRevisionHandler);
            }
            throw sVNException;
        }
    }

    public void assertServerIsMergeInfoCapable(String string) {
        boolean bl2 = this.hasCapability(SVNCapability.MERGE_INFO);
        if (!bl2) {
            Object object;
            if (string == null) {
                object = this.getLocation();
                string = ((SVNURL)object).toString();
            }
            object = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Retrieval of mergeinfo unsupported by ''{0}''", (Object)string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        }
    }

    public long log(String[] stringArray, long l2, long l3, boolean bl2, boolean bl3, ISVNLogEntryHandler iSVNLogEntryHandler) {
        return this.log(stringArray, l2, l3, bl2, bl3, 0L, iSVNLogEntryHandler);
    }

    public long log(String[] stringArray, long l2, long l3, boolean bl2, boolean bl3, long l4, ISVNLogEntryHandler iSVNLogEntryHandler) {
        return this.log(stringArray, l2, l3, bl2, bl3, l4, false, null, iSVNLogEntryHandler);
    }

    public long log(String[] stringArray, long l2, long l3, boolean bl2, boolean bl3, long l4, boolean bl4, String[] stringArray2, ISVNLogEntryHandler iSVNLogEntryHandler) {
        if (bl4) {
            this.assertServerIsMergeInfoCapable(null);
        }
        return this.logImpl(stringArray, l2, l3, bl2, bl3, l4, bl4, stringArray2, iSVNLogEntryHandler);
    }

    public int getLocations(String string, long l2, long[] lArray, ISVNLocationEntryHandler iSVNLocationEntryHandler) {
        try {
            return this.getLocationsImpl(string, l2, lArray, iSVNLocationEntryHandler);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                return this.getLocationsFromLog(string, l2, lArray, iSVNLocationEntryHandler);
            }
            throw sVNException;
        }
    }

    public long getLocationSegments(String string, long l2, long l3, long l4, ISVNLocationSegmentHandler iSVNLocationSegmentHandler) {
        try {
            return this.getLocationSegmentsImpl(string, l2, l3, l4, iSVNLocationSegmentHandler);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                return this.getLocationSegmentsFromLog(string, l2, l3, l4, iSVNLocationSegmentHandler);
            }
            throw sVNException;
        }
    }

    public List getLocationSegments(String string, long l2, long l3, long l4) {
        LinkedList linkedList = new LinkedList();
        this.getLocationSegments(string, l2, l3, l4, new SVNRepository$1(this, linkedList));
        Collections.sort(linkedList, new SVNRepository$2(this));
        return linkedList;
    }

    public Collection getFileRevisions(String string, Collection collection, long l2, long l3) {
        Collection collection2 = collection != null ? collection : new LinkedList();
        SVNRepository$3 sVNRepository$3 = new SVNRepository$3(this, collection2);
        this.getFileRevisions(string, l2, l3, sVNRepository$3);
        return collection2;
    }

    public Collection getDir(String string, long l2, SVNProperties sVNProperties, Collection collection) {
        return this.getDir(string, l2, sVNProperties, -1, collection);
    }

    public Collection getDir(String string, long l2, SVNProperties sVNProperties, int n2, Collection collection) {
        Collection collection2 = collection != null ? collection : new LinkedList();
        SVNRepository$4 sVNRepository$4 = new SVNRepository$4(this, collection2);
        this.getDir(string, l2, sVNProperties, n2, sVNRepository$4);
        return collection2;
    }

    public abstract SVNDirEntry getDir(String var1, long var2, boolean var4, Collection var5);

    public Collection log(String[] stringArray, Collection collection, long l2, long l3, boolean bl2, boolean bl3) {
        Collection collection2 = collection != null ? collection : new LinkedList();
        this.log(stringArray, l2, l3, bl2, bl3, new SVNRepository$5(this, collection2));
        return collection2;
    }

    public Collection getLocations(String string, Collection collection, long l2, long[] lArray) {
        Collection collection2 = collection != null ? collection : new LinkedList();
        this.getLocations(string, l2, lArray, new SVNRepository$6(this, collection2));
        return collection2;
    }

    public Map getLocations(String string, Map map, long l2, long[] lArray) {
        Map map2 = map != null ? map : new SVNHashMap();
        this.getLocations(string, l2, lArray, new SVNRepository$7(this, map2));
        return map2;
    }

    public void diff(SVNURL sVNURL, long l2, long l3, String string, boolean bl2, boolean bl3, boolean bl4, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        this.diff(sVNURL, l2, l3, string, bl2, SVNDepth.fromRecurse(bl3), bl4, iSVNReporterBaton, iSVNEditor);
    }

    public abstract void diff(SVNURL var1, long var2, long var4, String var6, boolean var7, SVNDepth var8, boolean var9, ISVNReporterBaton var10, ISVNEditor var11);

    public void diff(SVNURL sVNURL, long l2, long l3, String string, boolean bl2, boolean bl3, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        this.diff(sVNURL, l2, l3, string, bl2, SVNDepth.fromRecurse(bl3), true, iSVNReporterBaton, iSVNEditor);
    }

    public void diff(SVNURL sVNURL, long l2, String string, boolean bl2, boolean bl3, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        this.diff(sVNURL, l2, l2, string, bl2, SVNDepth.fromRecurse(bl3), true, iSVNReporterBaton, iSVNEditor);
    }

    public void update(SVNURL sVNURL, long l2, String string, boolean bl2, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        this.update(sVNURL, l2, string, SVNDepth.fromRecurse(bl2), iSVNReporterBaton, iSVNEditor);
    }

    public abstract void update(SVNURL var1, long var2, String var4, SVNDepth var5, ISVNReporterBaton var6, ISVNEditor var7);

    public void update(long l2, String string, boolean bl2, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        this.update(l2, string, SVNDepth.fromRecurse(bl2), false, iSVNReporterBaton, iSVNEditor);
    }

    public abstract void update(long var1, String var3, SVNDepth var4, boolean var5, ISVNReporterBaton var6, ISVNEditor var7);

    public void status(long l2, String string, boolean bl2, ISVNReporterBaton iSVNReporterBaton, ISVNEditor iSVNEditor) {
        this.status(l2, string, SVNDepth.fromRecurse(bl2), iSVNReporterBaton, iSVNEditor);
    }

    public abstract void status(long var1, String var3, SVNDepth var4, ISVNReporterBaton var5, ISVNEditor var6);

    public void checkout(long l2, String string, boolean bl2, ISVNEditor iSVNEditor) {
        this.checkout(l2, string, SVNDepth.fromRecurse(bl2), iSVNEditor);
    }

    public void checkout(long l2, String string, SVNDepth sVNDepth, ISVNEditor iSVNEditor) {
        Object object;
        long l3 = l2 >= 0L ? l2 : this.getLatestRevision();
        SVNNodeKind sVNNodeKind = this.checkPath("", l2);
        if (sVNNodeKind == SVNNodeKind.FILE) {
            object = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' refers to a file, not a directory", (Object)this.getLocation());
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        } else if (sVNNodeKind == SVNNodeKind.NONE) {
            object = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' doesn''t exist", (Object)this.getLocation());
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        }
        object = sVNDepth;
        this.update(l2, string, sVNDepth, false, (ISVNReporterBaton)new SVNRepository$8(this, l3, (SVNDepth)object), iSVNEditor);
    }

    public void checkoutFiles(long l2, String[] stringArray, ISVNFileCheckoutTarget iSVNFileCheckoutTarget) {
        long l3 = l2 >= 0L ? l2 : this.getLatestRevision();
        SVNRepository$9 sVNRepository$9 = new SVNRepository$9(this, stringArray, l3);
        this.update(l3, null, SVNDepth.INFINITY, false, (ISVNReporterBaton)sVNRepository$9, (ISVNEditor)new SVNFileCheckoutEditor(iSVNFileCheckoutTarget));
    }

    public abstract void replay(long var1, long var3, boolean var5, ISVNEditor var6);

    public void replayRange(long l2, long l3, long l4, boolean bl2, ISVNReplayHandler iSVNReplayHandler) {
        try {
            this.replayRangeImpl(l2, l3, l4, bl2, iSVNReplayHandler);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                for (long i2 = l2; i2 <= l3; ++i2) {
                    SVNProperties sVNProperties = this.getRevisionProperties(i2, null);
                    ISVNEditor iSVNEditor = iSVNReplayHandler.handleStartRevision(i2, sVNProperties);
                    this.replay(l4, i2, bl2, iSVNEditor);
                    iSVNReplayHandler.handleEndRevision(i2, sVNProperties, iSVNEditor);
                }
            }
            throw sVNException;
        }
    }

    public ISVNEditor getCommitEditor(String string, ISVNWorkspaceMediator iSVNWorkspaceMediator) {
        return this.getCommitEditor(string, null, false, iSVNWorkspaceMediator);
    }

    public abstract SVNDirEntry info(String var1, long var2);

    public abstract ISVNEditor getCommitEditor(String var1, Map var2, boolean var3, ISVNWorkspaceMediator var4);

    public ISVNEditor getCommitEditor(String string, Map map, boolean bl2, SVNProperties sVNProperties, ISVNWorkspaceMediator iSVNWorkspaceMediator) {
        SVNProperties sVNProperties2 = sVNProperties = sVNProperties == null ? new SVNProperties() : new SVNProperties(sVNProperties);
        if (string != null) {
            sVNProperties.put("svn:log", string);
        }
        return this.getCommitEditorInternal(map, bl2, sVNProperties, iSVNWorkspaceMediator);
    }

    protected abstract ISVNEditor getCommitEditorInternal(Map var1, boolean var2, SVNProperties var3, ISVNWorkspaceMediator var4);

    public abstract SVNLock getLock(String var1);

    public abstract SVNLock[] getLocks(String var1);

    public Map getMergeInfo(String[] stringArray, long l2, SVNMergeInfoInheritance sVNMergeInfoInheritance, boolean bl2) {
        if (stringArray == null) {
            return null;
        }
        this.assertServerIsMergeInfoCapable(this.getRepositoryRoot(true).toString());
        return this.getMergeInfoImpl(stringArray, l2, sVNMergeInfoInheritance, bl2);
    }

    public abstract void lock(Map var1, String var2, boolean var3, ISVNLockHandler var4);

    public abstract void unlock(Map var1, boolean var2, ISVNLockHandler var3);

    public abstract void closeSession();

    public abstract boolean hasCapability(SVNCapability var1);

    public ISVNSession getOptions() {
        if (this.myOptions == null) {
            this.myOptions = ISVNSession.DEFAULT;
        }
        return this.myOptions;
    }

    public void addConnectionListener(ISVNConnectionListener iSVNConnectionListener) {
        this.myConnectionListeners.add(iSVNConnectionListener);
    }

    public void removeConnectionListener(ISVNConnectionListener iSVNConnectionListener) {
        this.myConnectionListeners.remove(iSVNConnectionListener);
    }

    public long getDeletedRevision(String string, long l2, long l3) {
        SVNErrorMessage sVNErrorMessage;
        String string2 = this.getRepositoryPath(string);
        if ("/".equals(string2)) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "root path could not be deleted");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if (SVNRepository.isInvalidRevision(l2)) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Invalid peg revision {0}", (Object)String.valueOf(l2));
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if (SVNRepository.isInvalidRevision(l3)) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Invalid end revision {0}", (Object)String.valueOf(l3));
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        if (l3 <= l2) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Peg revision must precede end revision");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.DEFAULT);
        }
        try {
            string = this.getLocationRelativePath(string);
            return this.getDeletedRevisionImpl(string, l2, l3);
        }
        catch (SVNException sVNException) {
            SVNErrorCode sVNErrorCode = sVNException.getErrorMessage().getErrorCode();
            if (sVNErrorCode == SVNErrorCode.UNSUPPORTED_FEATURE || sVNErrorCode == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                return this.getDeletedRevisionFromLog(string, l2, l3);
            }
            throw sVNException;
        }
    }

    public Map getInheritedProperties(String string, long l2, String string2) {
        TreeMap treeMap = new TreeMap(SVNPathUtil.PATH_COMPARATOR);
        this.getInheritedProperties(string, l2, string2, new SVNRepository$10(this, treeMap));
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInheritedProperties(String string, long l2, String string2, ISVNInheritedPropertiesHandler iSVNInheritedPropertiesHandler) {
        if (SVNRepository.isInvalidRevision(l2)) {
            l2 = this.getLatestRevision();
        }
        if (this.hasCapability(SVNCapability.INHERITED_PROPS)) {
            this.getInheritedPropertiesImpl(string, l2, string2, iSVNInheritedPropertiesHandler);
            return;
        }
        SVNURL sVNURL = this.getLocation();
        String string3 = this.getRepositoryPath("");
        try {
            while (!"/".equals(string3)) {
                if ("".equals(string3 = SVNPathUtil.removeTail(string3))) {
                    string3 = "/";
                }
                this.setLocation(this.getLocation().removePathTail(), false);
                SVNProperties sVNProperties = new SVNProperties();
                try {
                    this.getDir("", l2, sVNProperties, 0, (ISVNDirEntryHandler)null);
                }
                catch (SVNAuthenticationException sVNAuthenticationException) {
                    continue;
                }
                SVNProperties sVNProperties2 = new SVNProperties();
                if (string2 != null && sVNProperties.containsName(string2)) {
                    sVNProperties2.put(string2, sVNProperties.getSVNPropertyValue(string2));
                } else if (string2 == null) {
                    for (String string4 : sVNProperties.nameSet()) {
                        if (!SVNProperty.isRegularProperty(string4)) continue;
                        sVNProperties2.put(string4, sVNProperties.getSVNPropertyValue(string4));
                    }
                }
                if (iSVNInheritedPropertiesHandler == null || sVNProperties2.isEmpty()) continue;
                iSVNInheritedPropertiesHandler.handleInheritedProperites(string3, sVNProperties2);
            }
        }
        finally {
            this.setLocation(sVNURL, false);
        }
    }

    protected abstract void getInheritedPropertiesImpl(String var1, long var2, String var4, ISVNInheritedPropertiesHandler var5);

    protected abstract long getDeletedRevisionImpl(String var1, long var2, long var4);

    protected abstract long getLocationSegmentsImpl(String var1, long var2, long var4, long var6, ISVNLocationSegmentHandler var8);

    protected abstract int getLocationsImpl(String var1, long var2, long[] var4, ISVNLocationEntryHandler var5);

    protected abstract long logImpl(String[] var1, long var2, long var4, boolean var6, boolean var7, long var8, boolean var10, String[] var11, ISVNLogEntryHandler var12);

    protected abstract int getFileRevisionsImpl(String var1, long var2, long var4, boolean var6, ISVNFileRevisionHandler var7);

    protected abstract Map getMergeInfoImpl(String[] var1, long var2, SVNMergeInfoInheritance var4, boolean var5);

    protected abstract void replayRangeImpl(long var1, long var3, long var5, boolean var7, ISVNReplayHandler var8);

    protected void fireConnectionOpened() {
        for (ISVNConnectionListener iSVNConnectionListener : this.myConnectionListeners) {
            iSVNConnectionListener.connectionOpened(this);
        }
    }

    protected void fireConnectionClosed() {
        for (ISVNConnectionListener iSVNConnectionListener : this.myConnectionListeners) {
            iSVNConnectionListener.connectionClosed(this);
        }
    }

    protected synchronized void lock() {
        this.lock(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void lock(boolean bl2) {
        try {
            SVNRepository sVNRepository = this;
            synchronized (sVNRepository) {
                if (Thread.currentThread() == this.myLocker) {
                    if (!bl2) {
                        this.getDebugLog().logFine(SVNLogType.DEFAULT, new Exception());
                        throw new Error("SVNRepository methods are not reenterable");
                    }
                    ++this.myLockCount;
                    return;
                }
                while (this.myLocker != null) {
                    this.wait();
                }
                this.myLocker = Thread.currentThread();
                ++this.myLockCount;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new Error("Interrupted attempt to aquire write lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void unlock() {
        SVNRepository sVNRepository = this;
        synchronized (sVNRepository) {
            if (--this.myLockCount <= 0) {
                this.myLockCount = 0;
                this.myLocker = null;
                this.notify();
            }
        }
    }

    protected static boolean isInvalidRevision(long l2) {
        return l2 < 0L;
    }

    protected static boolean isValidRevision(long l2) {
        return l2 >= 0L;
    }

    protected static Long getRevisionObject(long l2) {
        return SVNRepository.isValidRevision(l2) ? Long.valueOf(l2) : null;
    }

    protected static void assertValidRevision(long l2) {
        if (!SVNRepository.isValidRevision(l2)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Invalid revision number ''{0}''", (Object)l2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
    }

    public String getRepositoryPath(String string) {
        if (string == null) {
            return "/";
        }
        if (string.length() > 0 && string.charAt(0) == '/') {
            return string;
        }
        String string2 = SVNPathUtil.append(this.getLocation().getPath(), string);
        String string3 = string2.substring(this.getRepositoryRoot(true).getPath().length());
        if ("".equals(string3)) {
            return "/";
        }
        if (!string3.startsWith("/")) {
            string3 = "/" + string3;
        }
        return string3;
    }

    protected String getLocationRelativePath(String string) {
        if (string == null) {
            string = "/";
        }
        if (string.length() > 0 && string.charAt(0) == '/') {
            String string2 = this.getLocation().getPath();
            if (!(string2 = string2.substring(this.getRepositoryRoot(true).getPath().length())).startsWith("/")) {
                string2 = "/" + string2;
            }
            if ((string.startsWith(string2 + "/") || string.equals(string2)) && (string = string.substring(string2.length())).startsWith("/")) {
                string = string.substring(1);
            }
            return string;
        }
        return string;
    }

    public String getFullPath(String string) {
        if (string == null) {
            return this.getFullPath("/");
        }
        String string2 = string.length() > 0 && string.charAt(0) == '/' ? SVNPathUtil.append(this.getRepositoryRoot(true).getPath(), string) : SVNPathUtil.append(this.getLocation().getPath(), string);
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        return string2;
    }

    public void setDebugLog(ISVNDebugLog iSVNDebugLog) {
        this.myDebugLog = iSVNDebugLog;
    }

    public ISVNDebugLog getDebugLog() {
        if (this.myDebugLog == null) {
            return SVNDebugLog.getDefaultLog();
        }
        return this.myDebugLog;
    }

    private long getDeletedRevisionFromLog(String string, long l2, long l3) {
        SVNRepository$DeletedRevisionLogHandler sVNRepository$DeletedRevisionLogHandler = new SVNRepository$DeletedRevisionLogHandler(string);
        this.log(null, l2, l3, true, true, 0L, false, null, sVNRepository$DeletedRevisionLogHandler);
        return sVNRepository$DeletedRevisionLogHandler.getDeletedRevision();
    }

    private long getLocationSegmentsFromLog(String string, long l2, long l3, long l4, ISVNLocationSegmentHandler iSVNLocationSegmentHandler) {
        Object object;
        String string2 = this.getRepositoryPath(string);
        long l5 = -1L;
        if (SVNRepository.isInvalidRevision(l2)) {
            l2 = l5 = this.getLatestRevision();
        }
        if (SVNRepository.isInvalidRevision(l3)) {
            l3 = SVNRepository.isValidRevision(l5) ? l5 : this.getLatestRevision();
        }
        if (SVNRepository.isInvalidRevision(l4)) {
            l4 = 0L;
        }
        SVNErrorManager.assertionFailure(l2 >= l3, null, SVNLogType.NETWORK);
        SVNErrorManager.assertionFailure(l3 >= l4, null, SVNLogType.NETWORK);
        SVNNodeKind sVNNodeKind = this.checkPath(string, l2);
        if (sVNNodeKind == SVNNodeKind.NONE) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' doesn''t exist in revision {1}", string2, l2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        }
        object = new SVNRepository$LocationSegmentsLogHandler(sVNNodeKind, string2, l3, iSVNLocationSegmentHandler);
        this.log(new String[]{string}, l2, l4, true, false, 0L, false, new String[0], (ISVNLogEntryHandler)object);
        if (!((SVNRepository$LocationSegmentsLogHandler)object).myIsDone) {
            ((SVNRepository$LocationSegmentsLogHandler)object).maybeCropAndSendSegment(((SVNRepository$LocationSegmentsLogHandler)object).myLastPath, l3, l4, ((SVNRepository$LocationSegmentsLogHandler)object).myRangeEnd, iSVNLocationSegmentHandler);
        }
        return ((SVNRepository$LocationSegmentsLogHandler)object).myCount;
    }

    private int getLocationsFromLog(String string, long l2, long[] lArray, ISVNLocationEntryHandler iSVNLocationEntryHandler) {
        String string2 = this.getRepositoryPath(string);
        SVNNodeKind sVNNodeKind = this.checkPath(string, l2);
        if (sVNNodeKind == SVNNodeKind.NONE) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' doesn''t exist in revision {1}", string2, l2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        if (lArray == null || lArray.length == 0) {
            return 0;
        }
        Arrays.sort(lArray);
        long l3 = lArray[0];
        long l4 = lArray[lArray.length - 1];
        long l5 = l2;
        l5 = l3 > l5 ? l3 : l5;
        l5 = l4 > l5 ? l4 : l5;
        long l6 = l2;
        l6 = l3 < l6 ? l3 : l6;
        l6 = l4 < l6 ? l4 : l6;
        SVNRepository$LocationsLogHandler sVNRepository$LocationsLogHandler = new SVNRepository$LocationsLogHandler(lArray, sVNNodeKind, string2, l2, iSVNLocationEntryHandler);
        this.log(new String[]{string}, l5, l6, true, false, 0L, false, null, sVNRepository$LocationsLogHandler);
        if (sVNRepository$LocationsLogHandler.myPegPath == null) {
            sVNRepository$LocationsLogHandler.myPegPath = sVNRepository$LocationsLogHandler.myLastPath;
        }
        if (sVNRepository$LocationsLogHandler.myLastPath != null) {
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                long l7 = lArray[i2];
                Long l8 = l7;
                if (iSVNLocationEntryHandler == null || sVNRepository$LocationsLogHandler.myProcessedRevisions.contains(l8)) continue;
                iSVNLocationEntryHandler.handleLocationEntry(new SVNLocationEntry(l7, sVNRepository$LocationsLogHandler.myLastPath));
                sVNRepository$LocationsLogHandler.myProcessedRevisions.add(l8);
            }
        }
        if (sVNRepository$LocationsLogHandler.myPegPath == null) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Unable to find repository location for ''{0}'' in revision {1}", string2, l2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        if (!string2.equals(sVNRepository$LocationsLogHandler.myPegPath)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "''{0}'' in revision {1} is an unrelated object", string2, l5);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.NETWORK);
        }
        return sVNRepository$LocationsLogHandler.myProcessedRevisions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFileRevisionsFromLog(String string, long l2, long l3, ISVNFileRevisionHandler iSVNFileRevisionHandler) {
        Object object;
        SVNURL sVNURL = this.getRepositoryRoot(true);
        SVNURL sVNURL2 = this.getLocation();
        String string2 = this.getRepositoryPath(string);
        SVNNodeKind sVNNodeKind = this.checkPath("", l3);
        if (sVNNodeKind == SVNNodeKind.DIR) {
            object = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "''{0}'' is not a file", (Object)string2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.NETWORK);
        }
        object = new SVNRepository$FileRevisionsLogHandler(string2);
        this.log(new String[]{""}, l3, l2, true, false, 0L, false, null, (ISVNLogEntryHandler)object);
        LinkedList linkedList = ((SVNRepository$FileRevisionsLogHandler)object).getRevisions();
        this.setLocation(sVNURL, false);
        File file = null;
        SVNProperties sVNProperties = null;
        SVNDeltaGenerator sVNDeltaGenerator = new SVNDeltaGenerator();
        int n2 = 0;
        for (SVNRepository$Revision sVNRepository$Revision : linkedList) {
            File file2 = SVNFileUtil.createTempFile("tmp", ".tmp");
            SVNProperties sVNProperties2 = new SVNProperties();
            OutputStream outputStream = null;
            try {
                outputStream = SVNFileUtil.openFileForWriting(file2);
                this.getFile(sVNRepository$Revision.myPath, sVNRepository$Revision.myRevision, sVNProperties2, outputStream);
            }
            finally {
                SVNFileUtil.closeFile(outputStream);
            }
            SVNProperties sVNProperties3 = FSRepositoryUtil.getPropsDiffs(sVNProperties, sVNProperties2);
            SVNFileRevision sVNFileRevision = new SVNFileRevision(sVNRepository$Revision.myPath, sVNRepository$Revision.myRevision, sVNRepository$Revision.myProperties, sVNProperties3, false);
            iSVNFileRevisionHandler.openRevision(sVNFileRevision);
            InputStream inputStream = null;
            InputStream inputStream2 = null;
            try {
                inputStream = file != null ? SVNFileUtil.openFileForReading(file, SVNLogType.NETWORK) : SVNFileUtil.DUMMY_IN;
                inputStream2 = SVNFileUtil.openFileForReading(file2, SVNLogType.NETWORK);
                sVNDeltaGenerator.sendDelta(sVNRepository$Revision.myPath, inputStream, 0L, inputStream2, iSVNFileRevisionHandler, false);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(inputStream);
                SVNFileUtil.closeFile(inputStream2);
                throw throwable;
            }
            SVNFileUtil.closeFile(inputStream);
            SVNFileUtil.closeFile(inputStream2);
            iSVNFileRevisionHandler.closeRevision(sVNRepository$Revision.myPath);
            if (file != null) {
                SVNFileUtil.deleteFile(file);
            }
            file = file2;
            sVNProperties = sVNProperties2;
            ++n2;
        }
        this.setLocation(sVNURL2, false);
        return n2;
    }

    private static String getPreviousLogPath(char[] cArray, long[] lArray, Map map, String string, SVNNodeKind sVNNodeKind, long l2) {
        Serializable serializable;
        if (cArray != null && cArray.length > 0) {
            cArray[0] = 77;
        }
        if (lArray != null && lArray.length > 0) {
            lArray[0] = -1L;
        }
        String string2 = null;
        if (map != null) {
            serializable = (SVNLogEntryPath)map.get(string);
            if (serializable != null) {
                if (((SVNLogEntryPath)serializable).getType() != 'A' && ((SVNLogEntryPath)serializable).getType() != 'R') {
                    string2 = string;
                } else {
                    if (((SVNLogEntryPath)serializable).getCopyPath() != null) {
                        string2 = ((SVNLogEntryPath)serializable).getCopyPath();
                    }
                    if (cArray != null && cArray.length > 0) {
                        cArray[0] = ((SVNLogEntryPath)serializable).getType();
                    }
                    if (lArray != null && lArray.length > 0) {
                        lArray[0] = ((SVNLogEntryPath)serializable).getCopyRevision();
                    }
                    return string2;
                }
            }
            if (!map.isEmpty()) {
                String[] stringArray = map.keySet().toArray(new String[map.size()]);
                Arrays.sort(stringArray, SVNPathUtil.PATH_COMPARATOR);
                for (int i2 = stringArray.length; i2 > 0; --i2) {
                    String string3 = stringArray[i2 - 1];
                    if (!string.startsWith(string3) || string.length() <= string3.length() || string.charAt(string3.length()) != '/' || ((SVNLogEntryPath)(serializable = (SVNLogEntryPath)map.get(string3))).getCopyPath() == null) continue;
                    if (cArray != null && cArray.length > 0) {
                        cArray[0] = ((SVNLogEntryPath)serializable).getType();
                    }
                    if (lArray != null && lArray.length > 0) {
                        lArray[0] = ((SVNLogEntryPath)serializable).getCopyRevision();
                    }
                    string2 = SVNPathUtil.append(((SVNLogEntryPath)serializable).getCopyPath(), string.substring(string3.length() + 1));
                    break;
                }
            }
        }
        if (string2 == null) {
            if (sVNNodeKind == SVNNodeKind.DIR) {
                string2 = string;
            } else {
                serializable = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "Missing changed-path information for ''{0}'' in revision {1}", string, l2);
                SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.NETWORK);
            }
        }
        return string2;
    }

    static /* synthetic */ String access$100(char[] cArray, long[] lArray, Map map, String string, SVNNodeKind sVNNodeKind, long l2) {
        return SVNRepository.getPreviousLogPath(cArray, lArray, map, string, sVNNodeKind, l2);
    }
}

