/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.remote;

import java.io.File;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.SvnUnlock;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnRemoteUnlock
extends SvnRemoteOperationRunner
implements ISVNLockHandler {
    public boolean isApplicable(SvnUnlock svnUnlock, SvnWcGeneration svnWcGeneration) {
        return svnUnlock.hasRemoteTargets();
    }

    @Override
    protected SVNLock run() {
        Object object2;
        int n2 = 0;
        SVNURL[] sVNURLArray = new SVNURL[((SvnUnlock)this.getOperation()).getTargets().size()];
        for (Object object2 : ((SvnUnlock)this.getOperation()).getTargets()) {
            sVNURLArray[n2++] = ((SvnTarget)object2).getURL();
        }
        SVNHashSet sVNHashSet = new SVNHashSet();
        object2 = SVNURLUtil.condenceURLs(sVNURLArray, sVNHashSet, false);
        if (sVNHashSet.isEmpty()) {
            sVNHashSet.add("");
        }
        Map map = new SVNHashMap();
        Object object3 = sVNHashSet.iterator();
        while (object3.hasNext()) {
            String string = (String)object3.next();
            string = SVNEncodingUtil.uriDecode(string);
            map.put(string, null);
        }
        this.checkCancelled();
        object3 = this.getRepositoryAccess().createRepository((SVNURL)object2, null, true);
        if (!((SvnUnlock)this.getOperation()).isBreakLock()) {
            map = this.fetchLockTokens((SVNRepository)object3, map);
        }
        ((SVNRepository)object3).unlock(map, ((SvnUnlock)this.getOperation()).isBreakLock(), this);
        return (SVNLock)((SvnUnlock)this.getOperation()).first();
    }

    private Map fetchLockTokens(SVNRepository sVNRepository, Map map) {
        SVNHashMap sVNHashMap = new SVNHashMap();
        for (String string : map.keySet()) {
            SVNLock sVNLock = sVNRepository.getLock(string);
            if (sVNLock == null || sVNLock.getID() == null) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_MISSING_LOCK_TOKEN, "''{0}'' is not locked", (Object)string);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                continue;
            }
            sVNHashMap.put(string, sVNLock.getID());
        }
        return sVNHashMap;
    }

    @Override
    public void handleLock(String string, SVNLock sVNLock, SVNErrorMessage sVNErrorMessage) {
    }

    @Override
    public void handleUnlock(String string, SVNLock sVNLock, SVNErrorMessage sVNErrorMessage) {
        if (sVNErrorMessage != null) {
            this.handleEvent(SVNEventFactory.createLockEvent(new File(string), SVNEventAction.UNLOCK_FAILED, null, sVNErrorMessage), -1.0);
        } else {
            this.handleEvent(SVNEventFactory.createLockEvent(new File(string), SVNEventAction.UNLOCKED, null, null), -1.0);
        }
    }
}

