/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.remote;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExportEditor;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess$RepositoryInfo;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.remote.SvnRemoteExport$1;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnExport;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnRemoteExport
extends SvnRemoteOperationRunner {
    public boolean isApplicable(SvnExport svnExport, SvnWcGeneration svnWcGeneration) {
        return !svnExport.getSource().isLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Long run() {
        SvnTarget svnTarget = ((SvnExport)this.getOperation()).getSource();
        Structure structure = this.getRepositoryAccess().createRepositoryFor(svnTarget, ((SvnExport)this.getOperation()).getRevision(), svnTarget.getResolvedPegRevision(), svnTarget.getFile());
        long l2 = structure.lng(SvnRepositoryAccess$RepositoryInfo.revision);
        SVNRepository sVNRepository = (SVNRepository)structure.get(SvnRepositoryAccess$RepositoryInfo.repository);
        structure.release();
        File file = ((SvnExport)this.getOperation()).getFirstTarget().getFile();
        SVNDepth sVNDepth = ((SvnExport)this.getOperation()).getDepth();
        boolean bl2 = ((SvnExport)this.getOperation()).isForce();
        boolean bl3 = ((SvnExport)this.getOperation()).isExpandKeywords();
        String string = ((SvnExport)this.getOperation()).getEolStyle();
        boolean bl4 = ((SvnExport)this.getOperation()).isIgnoreExternals();
        ISVNOptions iSVNOptions = ((SvnExport)this.getOperation()).getOptions();
        SVNNodeKind sVNNodeKind = sVNRepository.checkPath("", l2);
        if (sVNNodeKind == SVNNodeKind.DIR) {
            SVNExportEditor sVNExportEditor = new SVNExportEditor(this, sVNRepository.getLocation().toString(), file, bl2, string, bl3, sVNRepository.getRepositoryRoot(true).toString(), iSVNOptions);
            sVNRepository.update(l2, null, sVNDepth, false, (ISVNReporterBaton)new SvnRemoteExport$1(this, l2), SVNCancellableEditor.newInstance(sVNExportEditor, this, null));
            SVNFileType sVNFileType = SVNFileType.getType(file);
            if (sVNFileType == SVNFileType.NONE) {
                sVNExportEditor.openRoot(l2);
            }
            if (!bl4 && sVNDepth == SVNDepth.INFINITY) {
                Map map = sVNExportEditor.getCollectedExternals();
                this.handleExternals(map, sVNRepository.getLocation(), file, sVNRepository.getRepositoryRoot(true));
            }
        } else if (sVNNodeKind == SVNNodeKind.FILE) {
            Serializable serializable;
            String string2;
            String string3 = sVNRepository.getLocation().toString();
            String string4 = string2 = bl3 ? sVNRepository.getRepositoryRoot(true).toString() : null;
            if (file.isDirectory()) {
                file = new File(file, SVNEncodingUtil.uriDecode(SVNPathUtil.tail(string3)));
            }
            if (file.exists()) {
                if (!bl2) {
                    serializable = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Path ''{0}'' already exists", (Object)file);
                    SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
                }
            } else {
                file.getParentFile().mkdirs();
            }
            serializable = new SVNProperties();
            OutputStream outputStream = null;
            File file2 = SVNFileUtil.createUniqueFile(file.getParentFile(), ".export", ".tmp", false);
            try {
                outputStream = SVNFileUtil.openFileForWriting(file2);
                try {
                    sVNRepository.getFile("", l2, (SVNProperties)serializable, new SVNCancellableOutputStream(outputStream, this));
                }
                finally {
                    SVNFileUtil.closeFile(outputStream);
                }
                if (bl2 && file.exists()) {
                    SVNFileUtil.deleteAll(file, this);
                }
                if (!bl3) {
                    ((SVNProperties)serializable).put("svn:mime-type", "application/octet-stream");
                }
                String string5 = ((SVNProperties)serializable).getStringValue("svn:mime-type");
                boolean bl5 = SVNProperty.isBinaryMimeType(string5);
                String string6 = SVNTranslator.getCharset(((SVNProperties)serializable).getStringValue("svnkit:charset"), string5, string3, iSVNOptions);
                Map map = SVNTranslator.computeKeywords(((SVNProperties)serializable).getStringValue("svn:keywords"), string3, string2, ((SVNProperties)serializable).getStringValue("svn:entry:last-author"), ((SVNProperties)serializable).getStringValue("svn:entry:committed-date"), ((SVNProperties)serializable).getStringValue("svn:entry:committed-rev"), iSVNOptions);
                byte[] byArray = null;
                if ("native".equals(((SVNProperties)serializable).getStringValue("svn:eol-style"))) {
                    byArray = SVNTranslator.getEOL(string != null ? string : ((SVNProperties)serializable).getStringValue("svn:eol-style"), iSVNOptions);
                } else if (((SVNProperties)serializable).containsName("svn:eol-style")) {
                    byArray = SVNTranslator.getEOL(((SVNProperties)serializable).getStringValue("svn:eol-style"), iSVNOptions);
                }
                if (bl5) {
                    string6 = null;
                    byArray = null;
                    map = null;
                }
                SVNTranslator.translate(file2, file, string6, byArray, map, ((SVNProperties)serializable).getStringValue("svn:special") != null, true);
            }
            finally {
                SVNFileUtil.deleteFile(file2);
            }
            if (((SVNProperties)serializable).getStringValue("svn:executable") != null) {
                SVNFileUtil.setExecutable(file, true);
            }
            this.handleEvent(SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, null, -1L, SVNEventAction.UPDATE_ADD, null, null, null));
        } else {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' doesn''t exist", (Object)sVNRepository.getLocation());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        this.handleEvent(SVNEventFactory.createSVNEvent(file, SVNNodeKind.NONE, null, l2, SVNEventAction.UPDATE_COMPLETED, null, null, null));
        return l2;
    }

    private void handleExternals(Map map, SVNURL sVNURL, File file, SVNURL sVNURL2) {
        for (String string : map.keySet()) {
            File file2 = new File(file, string);
            String string2 = (String)map.get(string);
            SVNExternal[] sVNExternalArray = SVNExternal.parseExternals(file2, string2);
            SVNURL sVNURL3 = sVNURL.appendPath(string, false);
            for (int i2 = 0; i2 < sVNExternalArray.length; ++i2) {
                File file3 = new File(file2, sVNExternalArray[i2].getPath());
                File file4 = SVNFileUtil.getParentFile(file3);
                if (file4 != null) {
                    SVNFileUtil.ensureDirectoryExists(file4);
                }
                sVNExternalArray[i2].resolveURL(sVNURL2, sVNURL3);
                SVNURL sVNURL4 = sVNExternalArray[i2].getResolvedURL();
                SvnExport svnExport = ((SvnExport)this.getOperation()).getOperationFactory().createExport();
                svnExport.setSource(SvnTarget.fromURL(sVNURL4, sVNExternalArray[i2].getPegRevision()));
                svnExport.setSingleTarget(SvnTarget.fromFile(file3));
                svnExport.setDepth(SVNDepth.INFINITY);
                svnExport.setExpandKeywords(((SvnExport)this.getOperation()).isExpandKeywords());
                svnExport.setEolStyle(((SvnExport)this.getOperation()).getEolStyle());
                svnExport.setRevision(sVNExternalArray[i2].getRevision());
                svnExport.setForce(true);
                svnExport.setIgnoreExternals(false);
                svnExport.setSleepForTimestamp(false);
                try {
                    svnExport.run();
                    continue;
                }
                catch (SVNCancelException sVNCancelException) {
                    throw sVNCancelException;
                }
                catch (SVNException sVNException) {
                    this.handleEvent(SVNEventFactory.createSVNEvent(file3, SVNNodeKind.NONE, null, -1L, SVNEventAction.FAILED_EXTERNAL, SVNEventAction.UPDATE_EXTERNAL_REMOVED, sVNException.getErrorMessage(), null));
                }
            }
        }
    }
}

