/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.patch;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$NodeMovedAway;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$SVNWCNodeReposInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$Moved;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbInfo;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgAdd;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemove;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgWcToWcCopy;
import org.tmatesoft.svn.core.internal.wc2.patch.ISvnPatchContext;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPatchTarget;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnStatus;

public class SvnWcPatchContext
implements ISvnPatchContext {
    private final SVNWCContext context;

    public SvnWcPatchContext(SVNWCContext sVNWCContext) {
        this.context = sVNWCContext;
    }

    @Override
    public void resolvePatchTargetStatus(SvnPatchTarget svnPatchTarget, File file, boolean bl2, List list) {
        Object object;
        SvnStatus svnStatus;
        try {
            svnStatus = SVNStatusEditor17.internalStatus(this.context, svnPatchTarget.getAbsPath(), true);
            if (svnStatus.getNodeStatus() == SVNStatusType.STATUS_IGNORED || svnStatus.getNodeStatus() == SVNStatusType.STATUS_UNVERSIONED || svnStatus.getNodeStatus() == SVNStatusType.MISSING || svnStatus.getNodeStatus() == SVNStatusType.OBSTRUCTED || svnStatus.isConflicted()) {
                svnPatchTarget.setSkipped(true);
                svnPatchTarget.setObstructed(true);
                return;
            }
            if (svnStatus.getNodeStatus() == SVNStatusType.STATUS_DELETED) {
                svnPatchTarget.setLocallyDeleted(true);
            }
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw sVNException;
            }
            svnPatchTarget.setLocallyDeleted(true);
            svnPatchTarget.setDbKind(SVNNodeKind.NONE);
            svnStatus = null;
        }
        if (svnStatus != null && svnStatus.getKind() != SVNNodeKind.UNKNOWN) {
            svnPatchTarget.setDbKind(svnStatus.getKind());
        } else {
            svnPatchTarget.setDbKind(SVNNodeKind.NONE);
        }
        SVNFileType sVNFileType = SVNFileType.getType(svnPatchTarget.getAbsPath());
        svnPatchTarget.setSymlink(sVNFileType == SVNFileType.SYMLINK);
        svnPatchTarget.setKindOnDisk(SVNFileType.getNodeKind(sVNFileType));
        if (svnPatchTarget.isLocallyDeleted()) {
            object = null;
            if (bl2 && !SvnPatchTarget.targetIsAdded(list, svnPatchTarget.getAbsPath())) {
                object = this.context.nodeWasMovedAway(svnPatchTarget.getAbsPath());
            }
            if (object != null && ((SVNWCContext$NodeMovedAway)object).movedToAbsPath != null) {
                svnPatchTarget.setAbsPath(((SVNWCContext$NodeMovedAway)object).movedToAbsPath);
                svnPatchTarget.setRelPath(SVNFileUtil.skipAncestor(file, ((SVNWCContext$NodeMovedAway)object).movedToAbsPath));
                assert (svnPatchTarget.getRelPath() != null && svnPatchTarget.getRelPath().getPath().length() > 0);
                svnPatchTarget.setLocallyDeleted(false);
                sVNFileType = SVNFileType.getType(svnPatchTarget.getAbsPath());
                svnPatchTarget.setSymlink(sVNFileType == SVNFileType.SYMLINK);
                svnPatchTarget.setKindOnDisk(SVNFileType.getNodeKind(sVNFileType));
            } else if (svnPatchTarget.getKindOnDisk() != SVNNodeKind.NONE) {
                svnPatchTarget.setSkipped(true);
                return;
            }
        }
        if (SVNFileUtil.symlinksSupported() && svnPatchTarget.getKindOnDisk() == SVNNodeKind.FILE && !svnPatchTarget.isSymlink() && !svnPatchTarget.isLocallyDeleted() && svnStatus != null && svnStatus.getPropertiesStatus() != SVNStatusType.STATUS_NONE && (object = this.context.getProperty(svnPatchTarget.getAbsPath(), "svn:special")) != null) {
            svnPatchTarget.setSymlink(true);
        }
    }

    @Override
    public File createTempFile(File file) {
        return SVNFileUtil.createUniqueFile(this.context.getDb().getWCRootTempDir(file), "", "", true);
    }

    @Override
    public SVNProperties getActualProps(File file) {
        return this.context.getActualProps(file);
    }

    @Override
    public boolean isTextModified(File file, boolean bl2) {
        return this.context.isTextModified(file, bl2);
    }

    @Override
    public SVNNodeKind readKind(File file, boolean bl2, boolean bl3) {
        return this.context.readKind(file, bl2, bl3);
    }

    @Override
    public Map computeKeywords(File file, SVNPropertyValue sVNPropertyValue) {
        ISVNWCDb$WCDbInfo iSVNWCDb$WCDbInfo = this.context.getNodeChangedInfo(file);
        long l2 = iSVNWCDb$WCDbInfo.changedRev;
        SVNDate sVNDate = iSVNWCDb$WCDbInfo.changedDate;
        String string = iSVNWCDb$WCDbInfo.changedAuthor;
        SVNURL sVNURL = this.context.getNodeUrl(file);
        SVNWCContext$SVNWCNodeReposInfo sVNWCContext$SVNWCNodeReposInfo = this.context.getNodeReposInfo(file);
        SVNURL sVNURL2 = sVNWCContext$SVNWCNodeReposInfo.reposRootUrl;
        return SVNTranslator.computeKeywords(SVNPropertyValue.getPropertyAsString(sVNPropertyValue), sVNURL == null ? null : sVNURL.toString(), sVNURL2 == null ? null : sVNURL2.toString(), string, sVNDate.format(), String.valueOf(l2), null);
    }

    @Override
    public ISVNEventHandler getEventHandler() {
        return this.context.getEventHandler();
    }

    @Override
    public void setProperty(File file, String string, SVNPropertyValue sVNPropertyValue) {
        SvnNgPropertiesManager.setProperty(this.context, file, string, sVNPropertyValue, SVNDepth.EMPTY, true, null, null);
    }

    @Override
    public void delete(File file) {
        SvnNgRemove.delete(this.context, file, null, false, false, null);
    }

    @Override
    public void add(File file) {
        SvnNgAdd svnNgAdd = new SvnNgAdd();
        svnNgAdd.setWcContext(this.context);
        svnNgAdd.addFromDisk(file, null, false);
    }

    @Override
    public void move(File file, File file2) {
        SvnNgWcToWcCopy svnNgWcToWcCopy = new SvnNgWcToWcCopy();
        svnNgWcToWcCopy.setWcContext(this.context);
        svnNgWcToWcCopy.move(this.context, file, file2, true);
        SVNFileUtil.deleteFile(file);
    }

    @Override
    public boolean isExecutable(File file) {
        return SVNFileUtil.isExecutable(file);
    }

    @Override
    public void setExecutable(File file, boolean bl2) {
        SVNFileUtil.setExecutable(file, bl2);
    }

    @Override
    public void translate(File file, File file2, String string, byte[] byArray, Map map, boolean bl2, boolean bl3) {
        SVNTranslator.translate(file, file2, string, byArray, map, bl2, bl3);
    }

    @Override
    public void copySymlink(File file, File file2) {
        SVNFileUtil.deleteFile(file2);
        SVNFileUtil.copySymlink(file, file2);
    }

    @Override
    public void writeSymlinkContent(File file, String string) {
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - "\n".length());
        }
        if (string.endsWith("\r")) {
            string = string.substring(0, string.length() - "\r".length());
        }
        if (SVNFileType.getType(file) != SVNFileType.NONE) {
            SVNFileUtil.deleteFile(file);
        }
        SVNFileUtil.createSymlink(file, string);
    }

    @Override
    public String readSymlinkContent(File file) {
        return "link " + SVNFileUtil.getSymlinkName(file);
    }

    @Override
    public SVNFileType getKindOnDisk(File file) {
        return SVNFileType.getType(file);
    }

    @Override
    public File wasNodeMovedHere(File file) {
        try {
            ISVNWCDb$Moved iSVNWCDb$Moved = this.context.getDb().scanMoved(file);
            File file2 = iSVNWCDb$Moved.movedFromAbsPath;
            File file3 = iSVNWCDb$Moved.movedFromDeleteAbsPath;
            return file2;
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_UNEXPECTED_STATUS) {
                throw sVNException;
            }
            return null;
        }
    }
}

