/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.patch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$SVNEolStyle;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnDiffHunk;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnHunkInfo;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnTargetContent$IRealLineCallback;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnTargetContent$ISeekCallback;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnTargetContent$ITellCallback;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnTargetContent$IWriteCallback;

public class SvnTargetContent {
    boolean existed;
    int currentLine;
    private SVNWCContext$SVNEolStyle eolStyle;
    private String eolStr;
    private List lines;
    private List hunkInfos = new ArrayList();
    private boolean eof;
    private Map keywords;
    private Object readBaton;
    private Object writeBaton;
    private SvnTargetContent$ISeekCallback seekCallback;
    private SvnTargetContent$ITellCallback tellCallback;
    private SvnTargetContent$IRealLineCallback readLineCallback;
    private SvnTargetContent$IWriteCallback writeCallback;

    public SvnTargetContent() {
        this.lines = new ArrayList();
        this.keywords = new HashMap();
        this.eolStyle = SVNWCContext$SVNEolStyle.Unknown;
    }

    public String readLine() {
        int n2 = this.getLines().size() + 1;
        if (this.isEof() || this.getReadLineCallback() == null) {
            return "";
        }
        assert (this.getCurrentLine() <= n2);
        if (this.getCurrentLine() == n2) {
            long l2 = this.getTellCallback().tell(this.getReadBaton());
            this.getLines().add(l2);
        }
        String[] stringArray = new String[]{null};
        boolean[] blArray = new boolean[]{false};
        String string = this.getReadLineCallback().readLine(this.getReadBaton(), stringArray, blArray);
        this.setEof(blArray[0]);
        if (this.getEolStyle() == SVNWCContext$SVNEolStyle.None) {
            this.setEolStr(stringArray[0]);
        }
        if ((string = string != null ? SVNTranslator.translateString(string, null, this.getKeywords(), false, false) : "") != null && string.length() > 0 || stringArray != null) {
            this.setCurrentLine(this.getCurrentLine() + 1);
        }
        assert (this.getCurrentLine() > 0);
        return string;
    }

    protected void seekToLine(int n2) {
        assert (n2 > 0);
        if (n2 == this.getCurrentLine()) {
            return;
        }
        int n3 = this.getCurrentLine();
        boolean bl2 = this.isEof();
        if (n2 <= this.getLines().size()) {
            long l2 = (Long)this.getLines().get(n2 - 1);
            this.getSeekCallback().seek(this.getReadBaton(), l2);
            this.setCurrentLine(n2);
        } else {
            while (!this.isEof() && this.getCurrentLine() < n2) {
                this.readLine();
            }
        }
        if (bl2 && n3 > this.getCurrentLine()) {
            this.setEof(false);
        }
    }

    protected int scanForMatch(SvnDiffHunk svnDiffHunk, boolean bl2, int n2, int n3, boolean bl3, boolean bl4, ISVNCanceller iSVNCanceller) {
        int n4 = 0;
        while (!(this.getCurrentLine() >= n2 && n2 != 0 || this.isEof())) {
            boolean bl5;
            if (iSVNCanceller != null) {
                iSVNCanceller.checkCancelled();
            }
            if (bl5 = this.matchHunk(svnDiffHunk, n3, bl3, bl4)) {
                boolean bl6 = false;
                List list = this.getHunkInfos();
                for (SvnHunkInfo svnHunkInfo : list) {
                    int n5 = bl4 ? svnHunkInfo.getHunk().getDirectedModifiedLength() : svnHunkInfo.getHunk().getDirectedOriginalLength();
                    bl6 = !svnHunkInfo.isRejected() && this.getCurrentLine() >= svnHunkInfo.getMatchedLine() && this.getCurrentLine() < svnHunkInfo.getMatchedLine() + n5;
                    if (!bl6) continue;
                    break;
                }
                if (!bl6) {
                    n4 = this.getCurrentLine();
                    if (bl2) break;
                }
            }
            if (this.isEof()) continue;
            this.seekToLine(this.getCurrentLine() + 1);
        }
        return n4;
    }

    private boolean matchHunk(SvnDiffHunk svnDiffHunk, int n2, boolean bl2, boolean bl3) {
        String string;
        boolean[] blArray;
        int n3;
        boolean bl4 = false;
        if (this.isEof()) {
            return bl4;
        }
        int n4 = this.getCurrentLine();
        int n5 = 0;
        boolean bl5 = false;
        int n6 = svnDiffHunk.getLeadingContext();
        int n7 = svnDiffHunk.getTrailingContext();
        int n8 = svnDiffHunk.getFuzzPenalty();
        if (n8 > n2) {
            return bl4;
        }
        n2 -= n8;
        if (bl3) {
            svnDiffHunk.resetModifiedText();
            n3 = svnDiffHunk.getDirectedModifiedLength();
        } else {
            svnDiffHunk.resetOriginalText();
            n3 = svnDiffHunk.getDirectedOriginalLength();
        }
        do {
            blArray = new boolean[1];
            string = bl3 ? svnDiffHunk.readLineModifiedText(null, blArray) : svnDiffHunk.readLineOriginalText(null, blArray);
            String string2 = SVNTranslator.translateString(string, null, this.getKeywords(), false, false);
            String string3 = this.readLine();
            ++n5;
            if (blArray[0] && string.length() == 0 || this.isEof() && string3.length() == 0) break;
            if (n5 <= n2 && n6 > n2 || n5 > n3 - n2 && n7 > n2) {
                bl5 = true;
                continue;
            }
            if (bl2) {
                String string4 = string2;
                String string5 = string3;
                string4 = SVNFormatUtil.collapseSpaces(string4);
                string5 = SVNFormatUtil.collapseSpaces(string5);
                bl5 = string4.equals(string5);
                continue;
            }
            bl5 = string2.equals(string3);
        } while (bl5);
        boolean bl6 = bl5 && blArray[0] && string.length() == 0;
        this.seekToLine(n4);
        return bl6;
    }

    protected boolean matchExistingTarget(SvnDiffHunk svnDiffHunk) {
        boolean bl2;
        svnDiffHunk.resetModifiedText();
        boolean[] blArray = new boolean[]{false};
        int n2 = this.getCurrentLine();
        do {
            String string = this.readLine();
            String string2 = svnDiffHunk.readLineModifiedText(null, blArray);
            String string3 = SVNTranslator.translateString(string, null, this.getKeywords(), false, false);
            String string4 = SVNTranslator.translateString(string2, null, this.getKeywords(), false, false);
            bl2 = string3.equals(string4);
            if (this.isEof() == blArray[0]) continue;
            return false;
        } while (bl2 && !this.isEof() && !blArray[0]);
        boolean bl3 = bl2 && this.isEof() == blArray[0];
        this.seekToLine(n2);
        return bl3;
    }

    public boolean isExisted() {
        return this.existed;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public SVNWCContext$SVNEolStyle getEolStyle() {
        return this.eolStyle;
    }

    public String getEolStr() {
        return this.eolStr;
    }

    public List getLines() {
        return this.lines;
    }

    public List getHunkInfos() {
        return this.hunkInfos;
    }

    public boolean isEof() {
        return this.eof;
    }

    public Map getKeywords() {
        return this.keywords;
    }

    public Object getReadBaton() {
        return this.readBaton;
    }

    public SvnTargetContent$ISeekCallback getSeekCallback() {
        return this.seekCallback;
    }

    public SvnTargetContent$ITellCallback getTellCallback() {
        return this.tellCallback;
    }

    public SvnTargetContent$IRealLineCallback getReadLineCallback() {
        return this.readLineCallback;
    }

    public SvnTargetContent$IWriteCallback getWriteCallback() {
        return this.writeCallback;
    }

    public void setExisted(boolean bl2) {
        this.existed = bl2;
    }

    public void setCurrentLine(int n2) {
        this.currentLine = n2;
    }

    public void setEolStyle(SVNWCContext$SVNEolStyle sVNWCContext$SVNEolStyle) {
        this.eolStyle = sVNWCContext$SVNEolStyle;
    }

    public void setEolStr(String string) {
        this.eolStr = string;
    }

    public void setLines(List list) {
        this.lines = list;
    }

    public void addHunkInfo(SvnHunkInfo svnHunkInfo) {
        this.hunkInfos.add(svnHunkInfo);
    }

    public void setEof(boolean bl2) {
        this.eof = bl2;
    }

    public void setKeywords(Map map) {
        this.keywords = map;
    }

    public void setReadLineCallback(SvnTargetContent$IRealLineCallback svnTargetContent$IRealLineCallback) {
        this.readLineCallback = svnTargetContent$IRealLineCallback;
    }

    public void setTellCallback(SvnTargetContent$ITellCallback svnTargetContent$ITellCallback) {
        this.tellCallback = svnTargetContent$ITellCallback;
    }

    public void setSeekCallback(SvnTargetContent$ISeekCallback svnTargetContent$ISeekCallback) {
        this.seekCallback = svnTargetContent$ISeekCallback;
    }

    public void setWriteCallback(SvnTargetContent$IWriteCallback svnTargetContent$IWriteCallback) {
        this.writeCallback = svnTargetContent$IWriteCallback;
    }

    public void setReadBaton(Object object) {
        this.readBaton = object;
    }

    public void setWriteBaton(Object object) {
        this.writeBaton = object;
    }

    public Object getWriteBaton() {
        return this.writeBaton;
    }
}

