/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.patch;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchFileStream;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallback$OperationKind;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnDiffHunk;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnDiffHunk$Range;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPatch$BinaryPatch;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPatch$IParserFunction;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPatch$LineType;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPatch$ParserState;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPatch$Transition;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPatchFile;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPropertiesPatch;

public class SvnPatch {
    public static final File DEV_NULL = new File("/dev/null");
    private static final SvnPatch$Transition[] TRANSITIONS = new SvnPatch$Transition[]{new SvnPatch$Transition("--- ", SvnPatch$ParserState.START, SvnPatch$IParserFunction.DIFF_MINUS), new SvnPatch$Transition("+++ ", SvnPatch$ParserState.MINUS_SEEN, SvnPatch$IParserFunction.DIFF_PLUS), new SvnPatch$Transition("diff --git", SvnPatch$ParserState.START, SvnPatch$IParserFunction.GIT_START), new SvnPatch$Transition("--- a/", SvnPatch$ParserState.GIT_DIFF_SEEN, SvnPatch$IParserFunction.GIT_MINUS), new SvnPatch$Transition("--- a/", SvnPatch$ParserState.GIT_MODE_SEEN, SvnPatch$IParserFunction.GIT_MINUS), new SvnPatch$Transition("--- a/", SvnPatch$ParserState.GIT_TREE_SEEN, SvnPatch$IParserFunction.GIT_MINUS), new SvnPatch$Transition("--- /dev/null", SvnPatch$ParserState.GIT_MODE_SEEN, SvnPatch$IParserFunction.GIT_MINUS), new SvnPatch$Transition("--- /dev/null", SvnPatch$ParserState.GIT_TREE_SEEN, SvnPatch$IParserFunction.GIT_MINUS), new SvnPatch$Transition("+++ b/", SvnPatch$ParserState.GIT_MINUS_SEEN, SvnPatch$IParserFunction.GIT_PLUS), new SvnPatch$Transition("+++ /dev/null", SvnPatch$ParserState.GIT_MINUS_SEEN, SvnPatch$IParserFunction.GIT_PLUS), new SvnPatch$Transition("old mode ", SvnPatch$ParserState.GIT_DIFF_SEEN, SvnPatch$IParserFunction.GIT_OLD_MODE), new SvnPatch$Transition("new mode ", SvnPatch$ParserState.OLD_MODE_SEEN, SvnPatch$IParserFunction.GIT_NEW_MODE), new SvnPatch$Transition("rename from ", SvnPatch$ParserState.GIT_DIFF_SEEN, SvnPatch$IParserFunction.GIT_MOVE_FROM), new SvnPatch$Transition("rename from ", SvnPatch$ParserState.GIT_MODE_SEEN, SvnPatch$IParserFunction.GIT_MOVE_FROM), new SvnPatch$Transition("rename to ", SvnPatch$ParserState.MOVE_FROM_SEEN, SvnPatch$IParserFunction.GIT_MOVE_TO), new SvnPatch$Transition("copy from ", SvnPatch$ParserState.GIT_DIFF_SEEN, SvnPatch$IParserFunction.GIT_COPY_FROM), new SvnPatch$Transition("copy from ", SvnPatch$ParserState.GIT_MODE_SEEN, SvnPatch$IParserFunction.GIT_COPY_FROM), new SvnPatch$Transition("copy to ", SvnPatch$ParserState.COPY_FROM_SEEN, SvnPatch$IParserFunction.GIT_COPY_TO), new SvnPatch$Transition("new file ", SvnPatch$ParserState.GIT_DIFF_SEEN, SvnPatch$IParserFunction.GIT_NEW_FILE), new SvnPatch$Transition("deleted file ", SvnPatch$ParserState.GIT_DIFF_SEEN, SvnPatch$IParserFunction.GIT_DELETED_FILE), new SvnPatch$Transition("index ", SvnPatch$ParserState.GIT_DIFF_SEEN, SvnPatch$IParserFunction.GIT_INDEX), new SvnPatch$Transition("index ", SvnPatch$ParserState.GIT_TREE_SEEN, SvnPatch$IParserFunction.GIT_INDEX), new SvnPatch$Transition("index ", SvnPatch$ParserState.GIT_MODE_SEEN, SvnPatch$IParserFunction.GIT_INDEX), new SvnPatch$Transition("GIT binary patch", SvnPatch$ParserState.GIT_DIFF_SEEN, SvnPatch$IParserFunction.BINARY_PATCH_START), new SvnPatch$Transition("GIT binary patch", SvnPatch$ParserState.GIT_TREE_SEEN, SvnPatch$IParserFunction.BINARY_PATCH_START), new SvnPatch$Transition("GIT binary patch", SvnPatch$ParserState.GIT_MODE_SEEN, SvnPatch$IParserFunction.BINARY_PATCH_START)};
    private List hunks;
    private Map propPatches;
    private SvnDiffCallback$OperationKind operation;
    private boolean reverse;
    private boolean gitPatchFormat;
    Map mergeInfo;
    private Map reverseMergeInfo;
    private File oldFileName;
    private File newFileName;
    private File path;
    private SVNPatchFileStream patchFileStream;
    private SvnPatch$BinaryPatch binaryPatch;
    private Boolean newExecutableBit;
    private Boolean oldExecutableBit;
    private Boolean newSymlinkBit;
    private Boolean oldSymlinkBit;
    private SVNNodeKind nodeKind;

    public static SvnPatch parseNextPatch(SvnPatchFile svnPatchFile, boolean bl2, boolean bl3) {
        Comparable<StringBuffer> comparable;
        boolean bl4;
        if (svnPatchFile.getPatchFileStream().isEOF()) {
            return null;
        }
        SvnPatch$ParserState svnPatch$ParserState = SvnPatch$ParserState.START;
        boolean bl5 = false;
        SvnPatch svnPatch = new SvnPatch();
        svnPatch.setNodeKind(SVNNodeKind.UNKNOWN);
        svnPatch.setOperation(SvnDiffCallback$OperationKind.Unchanged);
        long l2 = svnPatchFile.getNextPatchOffset();
        svnPatchFile.getPatchFileStream().setSeekPosition(l2);
        do {
            boolean bl6 = false;
            long l3 = l2;
            comparable = new StringBuffer();
            bl4 = svnPatchFile.getPatchFileStream().readLine((StringBuffer)comparable);
            String string = comparable.toString();
            if (!bl4) {
                l2 = svnPatchFile.getPatchFileStream().getSeekPosition();
            }
            for (int i2 = 0; i2 < TRANSITIONS.length; ++i2) {
                SvnPatch$Transition svnPatch$Transition = TRANSITIONS[i2];
                if (!svnPatch$Transition.matches(string, svnPatch$ParserState)) continue;
                svnPatch$ParserState = SvnPatch$Transition.access$000(svnPatch$Transition).parse(string, svnPatch, svnPatch$ParserState);
                bl6 = true;
                break;
            }
            if (svnPatch$ParserState == SvnPatch$ParserState.UNIDIFF_FOUND || svnPatch$ParserState == SvnPatch$ParserState.GIT_HEADER_FOUND || svnPatch$ParserState == SvnPatch$ParserState.BINARY_PATCH_FOUND) break;
            if ((svnPatch$ParserState == SvnPatch$ParserState.GIT_TREE_SEEN || svnPatch$ParserState == SvnPatch$ParserState.GIT_MODE_SEEN) && bl5 && !bl6) {
                svnPatchFile.getPatchFileStream().setSeekPosition(l3);
                break;
            }
            if (svnPatch$ParserState == SvnPatch$ParserState.GIT_TREE_SEEN || svnPatch$ParserState == SvnPatch$ParserState.GIT_MODE_SEEN) {
                bl5 = true;
                continue;
            }
            if (bl6 || svnPatch$ParserState == SvnPatch$ParserState.START || svnPatch$ParserState == SvnPatch$ParserState.GIT_DIFF_SEEN) continue;
            svnPatchFile.getPatchFileStream().setSeekPosition(l3);
            svnPatch$ParserState = SvnPatch$ParserState.START;
        } while (!bl4);
        svnPatch.setReverse(bl2);
        if (bl2) {
            File file = svnPatch.getOldFileName();
            svnPatch.setOldFileName(svnPatch.getNewFileName());
            svnPatch.setNewFileName(file);
            switch (svnPatch.getOperation()) {
                case Added: {
                    svnPatch.setOperation(SvnDiffCallback$OperationKind.Deleted);
                    break;
                }
                case Deleted: {
                    svnPatch.setOperation(SvnDiffCallback$OperationKind.Added);
                    break;
                }
                case Modified: {
                    break;
                }
                case Copied: 
                case Moved: {
                    break;
                }
            }
            comparable = svnPatch.getOldExecutableBit();
            svnPatch.setOldExecutableBit(svnPatch.getNewExecutableBit());
            svnPatch.setNewExecutableBit((Boolean)comparable);
            comparable = svnPatch.getOldSymlinkBit();
            svnPatch.setOldSymlinkBit(svnPatch.getNewSymlinkBit());
            svnPatch.setNewSymlinkBit((Boolean)comparable);
        }
        if (svnPatch.getOldFileName() == null || svnPatch.getNewFileName() == null) {
            svnPatch = null;
        } else {
            if (svnPatch$ParserState == SvnPatch$ParserState.BINARY_PATCH_FOUND) {
                svnPatch.parseBinaryPatch(svnPatch, svnPatchFile.getPatchFileStream(), bl2);
            }
            svnPatch.parseHunks(svnPatchFile.getPatchFileStream(), bl3);
        }
        svnPatchFile.setNextPatchOffset(0L);
        svnPatchFile.setNextPatchOffset(svnPatchFile.getPatchFileStream().getSeekPosition());
        if (svnPatch != null) {
            Collections.sort(svnPatch.hunks);
        }
        return svnPatch;
    }

    private void parseHunks(SVNPatchFileStream sVNPatchFileStream, boolean bl2) {
        SvnDiffHunk svnDiffHunk;
        String string = null;
        this.hunks = new ArrayList();
        this.propPatches = new HashMap();
        do {
            SvnDiffCallback$OperationKind[] svnDiffCallback$OperationKindArray;
            String[] stringArray;
            boolean[] blArray;
            if ((svnDiffHunk = this.parseNextHunk(blArray = new boolean[1], stringArray = new String[1], svnDiffCallback$OperationKindArray = new SvnDiffCallback$OperationKind[1], sVNPatchFileStream, bl2)) != null && blArray[0]) {
                if (stringArray[0] == null) {
                    stringArray[0] = string;
                } else {
                    string = stringArray[0];
                }
                if ("svn:mergeinfo".equals(stringArray[0])) continue;
                this.addPropertyHunk(stringArray[0], svnDiffHunk, svnDiffCallback$OperationKindArray[0]);
                continue;
            }
            if (svnDiffHunk == null) continue;
            this.hunks.add(svnDiffHunk);
            string = null;
        } while (svnDiffHunk != null);
    }

    private void parseBinaryPatch(SvnPatch svnPatch, SVNPatchFileStream sVNPatchFileStream, boolean bl2) {
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        SvnPatch$BinaryPatch svnPatch$BinaryPatch = new SvnPatch$BinaryPatch();
        svnPatch$BinaryPatch.setPatchFileStream(sVNPatchFileStream);
        long l2 = -1L;
        long l3 = sVNPatchFileStream.getSeekPosition();
        while (!bl3) {
            l2 = l3;
            StringBuffer stringBuffer = new StringBuffer();
            bl3 = sVNPatchFileStream.readLine(stringBuffer);
            String string = stringBuffer.toString();
            l3 = sVNPatchFileStream.getSeekPosition();
            if (bl4) {
                char c2;
                char c3 = c2 = string.length() == 0 ? (char)'\u0000' : string.charAt(0);
                if ((c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') && string.length() <= 66 && !string.contains(":") && !string.contains(" ")) {
                    if (bl5) {
                        svnPatch$BinaryPatch.setSrcEnd(l3);
                        continue;
                    }
                    svnPatch$BinaryPatch.setDstEnd(l3);
                    continue;
                }
                if (this.containsNonSpaceCharacter(string) && (!bl5 || svnPatch$BinaryPatch.getSrcStart() >= l2)) break;
                if (bl5) {
                    svnPatch.setBinaryPatch(svnPatch$BinaryPatch);
                    break;
                }
                bl4 = false;
                bl5 = true;
                continue;
            }
            if (!string.startsWith("literal ")) break;
            try {
                long l4 = Long.parseLong(string.substring("literal ".length()));
                if (bl5) {
                    svnPatch$BinaryPatch.setSrcStart(l3);
                    svnPatch$BinaryPatch.setSrcFileSize(l4);
                } else {
                    svnPatch$BinaryPatch.setDstStart(l3);
                    svnPatch$BinaryPatch.setDstFileSize(l4);
                }
                bl4 = true;
            }
            catch (NumberFormatException numberFormatException) {
                break;
            }
        }
        if (!bl3) {
            sVNPatchFileStream.setSeekPosition(l2);
        } else if (bl5 && (svnPatch$BinaryPatch.getSrcEnd() > svnPatch$BinaryPatch.getSrcStart() || svnPatch$BinaryPatch.getSrcFileSize() == 0L)) {
            svnPatch.setBinaryPatch(svnPatch$BinaryPatch);
        }
        if (bl2 && svnPatch.getBinaryPatch() != null) {
            long l5 = svnPatch$BinaryPatch.getSrcStart();
            long l6 = svnPatch$BinaryPatch.getSrcEnd();
            long l7 = svnPatch$BinaryPatch.getSrcFileSize();
            svnPatch$BinaryPatch.setSrcStart(svnPatch$BinaryPatch.getDstStart());
            svnPatch$BinaryPatch.setSrcEnd(svnPatch$BinaryPatch.getDstEnd());
            svnPatch$BinaryPatch.setSrcFileSize(svnPatch$BinaryPatch.getDstFileSize());
            svnPatch$BinaryPatch.setDstStart(l5);
            svnPatch$BinaryPatch.setDstEnd(l6);
            svnPatch$BinaryPatch.setDstFileSize(l7);
        }
    }

    private boolean containsNonSpaceCharacter(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (Character.isSpaceChar(c2)) continue;
            return true;
        }
        return false;
    }

    public SvnDiffHunk parseNextHunk(boolean[] blArray, String[] stringArray, SvnDiffCallback$OperationKind[] svnDiffCallback$OperationKindArray, SVNPatchFileStream sVNPatchFileStream, boolean bl2) {
        long l2;
        String string;
        boolean bl3;
        String string2 = "--- ";
        String string3 = "@@";
        String string4 = "##";
        boolean bl4 = false;
        boolean bl5 = false;
        svnDiffCallback$OperationKindArray[0] = SvnDiffCallback$OperationKind.Unchanged;
        stringArray[0] = null;
        blArray[0] = false;
        if (sVNPatchFileStream.isEOF()) {
            return null;
        }
        boolean bl6 = false;
        boolean bl7 = false;
        int n2 = 0;
        int n3 = 0;
        boolean bl8 = false;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        int n4 = 0;
        int n5 = 0;
        SvnDiffHunk svnDiffHunk = new SvnDiffHunk();
        long l7 = sVNPatchFileStream.getSeekPosition();
        SvnPatch$LineType svnPatch$LineType = SvnPatch$LineType.NOISE_LINE;
        do {
            boolean bl9;
            l2 = l7;
            StringBuffer stringBuffer = new StringBuffer();
            bl3 = sVNPatchFileStream.readLine(stringBuffer);
            string = stringBuffer.toString();
            l7 = sVNPatchFileStream.getSeekPosition();
            if (string.startsWith("\\")) {
                String string5;
                if (!bl6) continue;
                sVNPatchFileStream.setSeekPosition(l2 - 2L);
                StringBuffer stringBuffer2 = new StringBuffer();
                String string6 = stringBuffer2.toString();
                StringBuffer stringBuffer3 = new StringBuffer();
                bl3 = sVNPatchFileStream.readLineWithEol(stringBuffer, stringBuffer3);
                String string7 = string5 = stringBuffer3.length() == 0 ? null : stringBuffer3.toString();
                long l8 = string5 == null ? l2 : (string5.charAt(0) == '\r' && string5.charAt(1) == '\n' ? l2 - 2L : (string5.charAt(0) == '\n' || string5.charAt(0) == '\r' ? l2 - 1L : l2));
                if (svnPatch$LineType == SvnPatch$LineType.ORIGINAL_LINE && l3 == 0L) {
                    l3 = l8;
                } else if (svnPatch$LineType == SvnPatch$LineType.MODIFIED_LINE && l4 == 0L) {
                    l4 = l8;
                } else if (svnPatch$LineType == SvnPatch$LineType.CONTEXT_LINE) {
                    if (l3 == 0L) {
                        l3 = l8;
                    }
                    if (l4 == 0L) {
                        l4 = l8;
                    }
                }
                sVNPatchFileStream.setSeekPosition(l7);
                if (svnPatch$LineType != SvnPatch$LineType.MODIFIED_LINE) {
                    bl4 = true;
                }
                if (svnPatch$LineType == SvnPatch$LineType.ORIGINAL_LINE) continue;
                bl5 = true;
                continue;
            }
            if (bl6 && blArray[0] && stringArray[0] != null && stringArray[0].equals("svn:mergeinfo") && (bl9 = this.parseMergeInfo(string, svnDiffHunk))) continue;
            if (bl6) {
                char c2;
                int n6 = 43;
                int n7 = 45;
                if (!bl7) {
                    l5 = l2;
                }
                char c3 = c2 = string.length() == 0 ? (char)'\u0000' : string.charAt(0);
                if (n4 > 0 && n5 > 0 && (c2 == ' ' || !bl3 && string.length() == 0 || bl2 && c2 != '-' && c2 != '+')) {
                    bl7 = true;
                    --n4;
                    --n5;
                    if (bl8) {
                        ++n3;
                    } else {
                        ++n2;
                    }
                    svnPatch$LineType = SvnPatch$LineType.CONTEXT_LINE;
                    continue;
                }
                if (c2 == '-' && (n4 > 0 || string.charAt(1) != '-')) {
                    bl7 = true;
                    bl8 = true;
                    if (n3 > 0) {
                        n3 = 0;
                    }
                    if (n4 > 0) {
                        --n4;
                    } else {
                        svnDiffHunk.setOriginalLength(svnDiffHunk.getOriginalLength() + 1);
                        svnDiffHunk.setOriginalFuzz(svnDiffHunk.getOriginalFuzz() + 1);
                    }
                    svnPatch$LineType = SvnPatch$LineType.ORIGINAL_LINE;
                    continue;
                }
                if (c2 == '+' && (n5 > 0 || string.charAt(1) != '+')) {
                    bl7 = true;
                    bl8 = true;
                    if (n3 > 0) {
                        n3 = 0;
                    }
                    if (n5 > 0) {
                        --n5;
                    } else {
                        svnDiffHunk.setModifiedLength(svnDiffHunk.getModifiedLength() + 1);
                        svnDiffHunk.setModifiedFuzz(svnDiffHunk.getModifiedFuzz() + 1);
                    }
                    svnPatch$LineType = SvnPatch$LineType.MODIFIED_LINE;
                    continue;
                }
                l6 = bl3 ? l7 : l2;
                if (l3 == 0L) {
                    l3 = l6;
                }
                if (l4 != 0L) break;
                l4 = l6;
                break;
            }
            if (string.startsWith("@@")) {
                bl6 = this.parseHunkHeader(string, svnDiffHunk, "@@");
                if (!bl6) continue;
                n4 = svnDiffHunk.getOriginalLength();
                n5 = svnDiffHunk.getModifiedLength();
                blArray[0] = false;
                continue;
            }
            if (string.startsWith("##")) {
                bl6 = this.parseHunkHeader(string, svnDiffHunk, "##");
                if (!bl6) continue;
                n4 = svnDiffHunk.getOriginalLength();
                n5 = svnDiffHunk.getModifiedLength();
                blArray[0] = true;
                continue;
            }
            if (string.startsWith("Added: ")) {
                stringArray[0] = this.parsePropName(string, "Added: ");
                if (stringArray[0] == null) continue;
                svnDiffCallback$OperationKindArray[0] = SvnDiffCallback$OperationKind.Added;
                continue;
            }
            if (string.startsWith("Deleted: ")) {
                stringArray[0] = this.parsePropName(string, "Deleted: ");
                if (stringArray[0] == null) continue;
                svnDiffCallback$OperationKindArray[0] = SvnDiffCallback$OperationKind.Deleted;
                continue;
            }
            if (string.startsWith("Modified: ")) {
                stringArray[0] = this.parsePropName(string, "Modified: ");
                if (stringArray[0] == null) continue;
                svnDiffCallback$OperationKindArray[0] = SvnDiffCallback$OperationKind.Modified;
                continue;
            }
            if (string.startsWith("--- ") || string.startsWith("diff --git ")) break;
        } while (!bl3 || string.length() > 0);
        if (!bl3) {
            sVNPatchFileStream.setSeekPosition(l2);
        }
        if (bl7 && l5 < l6) {
            if (n4 != 0) {
                svnDiffHunk.setOriginalLength(svnDiffHunk.getOriginalLength() - n4);
                svnDiffHunk.setOriginalFuzz(svnDiffHunk.getOriginalFuzz() + n4);
            }
            if (n5 != 0) {
                svnDiffHunk.setModifiedLength(svnDiffHunk.getModifiedLength() - n5);
                svnDiffHunk.setModifiedFuzz(svnDiffHunk.getModifiedFuzz() + n5);
            }
            svnDiffHunk.setPatch(this);
            svnDiffHunk.setPatchFileStream(sVNPatchFileStream);
            svnDiffHunk.setLeadingContext(n2);
            svnDiffHunk.setTrailingContext(n3);
            svnDiffHunk.setDiffTextRange(new SvnDiffHunk$Range(l5, l6, l5));
            svnDiffHunk.setOriginalTextRange(new SvnDiffHunk$Range(l5, l3, l5));
            svnDiffHunk.setModifiedTextRange(new SvnDiffHunk$Range(l5, l4, l5));
            svnDiffHunk.setOriginalNoFinalEol(bl4);
            svnDiffHunk.setModifiedNoFinalEol(bl5);
            return svnDiffHunk;
        }
        svnDiffHunk = null;
        return svnDiffHunk;
    }

    private boolean parseMergeInfo(String string, SvnDiffHunk svnDiffHunk) {
        int n2 = string.indexOf(47);
        int n3 = string.indexOf(58);
        boolean bl2 = false;
        if (n2 >= 0 && n3 >= 0 && string.charAt(n3 + 1) == 'r' && n2 < n3) {
            Map map;
            int n4;
            StringBuilder stringBuilder = new StringBuilder();
            for (n4 = n2; n4 <= n3; ++n4) {
                stringBuilder.append(string.charAt(n4));
            }
            ++n4;
            while (n4 < string.length() && !SVNFormatUtil.isSpace(string.charAt(n4))) {
                stringBuilder.append(string.charAt(n4));
                ++n4;
            }
            try {
                map = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(stringBuilder.toString()), null);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.MERGE_INFO_PARSE_ERROR) {
                    map = null;
                }
                throw sVNException;
            }
            if (map != null) {
                if (svnDiffHunk.getOriginalLength() > 0) {
                    if (this.isReverse()) {
                        if (this.getMergeInfo() == null) {
                            this.setMergeInfo(map);
                        } else {
                            SVNMergeInfoUtil.mergeMergeInfos(this.getMergeInfo(), map);
                        }
                    } else if (this.getReverseMergeInfo() == null) {
                        this.setReverseMergeInfo(map);
                    } else {
                        SVNMergeInfoUtil.mergeMergeInfos(this.getReverseMergeInfo(), map);
                    }
                    svnDiffHunk.decreaseOriginalLength();
                } else if (svnDiffHunk.getModifiedLength() > 0) {
                    if (this.isReverse()) {
                        if (this.getReverseMergeInfo() == null) {
                            this.setReverseMergeInfo(map);
                        } else {
                            SVNMergeInfoUtil.mergeMergeInfos(this.getReverseMergeInfo(), map);
                        }
                    } else if (this.getMergeInfo() == null) {
                        this.setMergeInfo(map);
                    } else {
                        SVNMergeInfoUtil.mergeMergeInfos(this.getMergeInfo(), map);
                    }
                    svnDiffHunk.decreaseModifiedLength();
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    private String parsePropName(String string, String string2) {
        String string3 = string.substring(string2.length());
        if (string3.length() == 0) {
            return null;
        }
        if (!SVNPropertiesManager.isValidPropertyName(string3)) {
            return SVNPropertiesManager.isValidPropertyName(string3 = string3.trim()) ? string3 : null;
        }
        return string3;
    }

    private boolean parseHunkHeader(String string, SvnDiffHunk svnDiffHunk, String string2) {
        int n2 = string2.length();
        if (string.charAt(n2) != ' ') {
            return false;
        }
        if (string.charAt(++n2) != '-') {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = ++n2;
        while (n2 < string.length() && string.charAt(n2) != ' ') {
            ++n2;
        }
        if (n2 == string.length() || string.charAt(n2) != ' ') {
            return false;
        }
        stringBuilder.append(string.substring(n3, n2));
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (!this.parseRange(nArray, nArray2, stringBuilder)) {
            svnDiffHunk.setOriginalStart(nArray[0]);
            svnDiffHunk.setOriginalLength(nArray2[0]);
            return false;
        }
        svnDiffHunk.setOriginalStart(nArray[0]);
        svnDiffHunk.setOriginalLength(nArray2[0]);
        stringBuilder = new StringBuilder();
        if (string.charAt(++n2) != '+') {
            return false;
        }
        n3 = ++n2;
        while (n2 < string.length() && string.charAt(n2) != ' ') {
            ++n2;
        }
        if (n2 == string.length() || string.charAt(n2) != ' ') {
            return false;
        }
        stringBuilder.append(string.substring(n3, n2));
        if (!string.substring(++n2).startsWith(string2)) {
            return false;
        }
        if (!this.parseRange(nArray, nArray2, stringBuilder)) {
            svnDiffHunk.setModifiedStart(nArray[0]);
            svnDiffHunk.setModifiedLength(nArray2[0]);
            return false;
        }
        svnDiffHunk.setModifiedStart(nArray[0]);
        svnDiffHunk.setModifiedLength(nArray2[0]);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseRange(int[] nArray, int[] nArray2, StringBuilder stringBuilder) {
        if (stringBuilder.length() == 0) {
            return false;
        }
        int n2 = stringBuilder.indexOf(",");
        if (n2 >= 0) {
            if (stringBuilder.length() <= 1) return false;
            if (!this.parseOffset(nArray2, stringBuilder.substring(n2 + ",".length()))) {
                return false;
            }
            stringBuilder.setLength(n2);
            return this.parseOffset(nArray, stringBuilder.toString());
        } else {
            nArray2[0] = 1;
        }
        return this.parseOffset(nArray, stringBuilder.toString());
    }

    private boolean parseOffset(int[] nArray, String string) {
        String string2 = string;
        try {
            nArray[0] = Integer.parseInt(string2);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void addPropertyHunk(String string, SvnDiffHunk svnDiffHunk, SvnDiffCallback$OperationKind svnDiffCallback$OperationKind) {
        SvnPropertiesPatch svnPropertiesPatch = (SvnPropertiesPatch)this.propPatches.get(string);
        if (svnPropertiesPatch == null) {
            svnPropertiesPatch = new SvnPropertiesPatch(string, new ArrayList(), svnDiffCallback$OperationKind);
            this.propPatches.put(string, svnPropertiesPatch);
        }
        svnPropertiesPatch.addHunk(svnDiffHunk);
    }

    public File getOldFileName() {
        return this.oldFileName;
    }

    public File getNewFileName() {
        return this.newFileName;
    }

    public List getHunks() {
        return this.hunks;
    }

    public Map getPropPatches() {
        return this.propPatches;
    }

    public SvnDiffCallback$OperationKind getOperation() {
        return this.operation;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public boolean isGitPatchFormat() {
        return this.gitPatchFormat;
    }

    public void setGitPatchFormat(boolean bl2) {
        this.gitPatchFormat = bl2;
    }

    public Map getMergeInfo() {
        return this.mergeInfo;
    }

    public Map getReverseMergeInfo() {
        return this.reverseMergeInfo;
    }

    public void setMergeInfo(Map map) {
        this.mergeInfo = map;
    }

    public void setReverseMergeInfo(Map map) {
        this.reverseMergeInfo = map;
    }

    public void setReverse(boolean bl2) {
        this.reverse = bl2;
    }

    public void setOldFileName(File file) {
        this.oldFileName = file;
    }

    public void setNewFileName(File file) {
        this.newFileName = file;
    }

    public void setOperation(SvnDiffCallback$OperationKind svnDiffCallback$OperationKind) {
        this.operation = svnDiffCallback$OperationKind;
    }

    private static File grabFileName(String string) {
        if ("/dev/null".equals(string)) {
            return DEV_NULL;
        }
        return SVNFileUtil.createFilePath(SVNPathUtil.canonicalizePath(string));
    }

    public void setBinaryPatch(SvnPatch$BinaryPatch svnPatch$BinaryPatch) {
        this.binaryPatch = svnPatch$BinaryPatch;
    }

    public SvnPatch$BinaryPatch getBinaryPatch() {
        return this.binaryPatch;
    }

    public Boolean getNewExecutableBit() {
        return this.newExecutableBit;
    }

    public void setNewExecutableBit(Boolean bl2) {
        this.newExecutableBit = bl2;
    }

    public Boolean getOldExecutableBit() {
        return this.oldExecutableBit;
    }

    public void setOldExecutableBit(Boolean bl2) {
        this.oldExecutableBit = bl2;
    }

    public Boolean getNewSymlinkBit() {
        return this.newSymlinkBit;
    }

    public void setNewSymlinkBit(Boolean bl2) {
        this.newSymlinkBit = bl2;
    }

    public Boolean getOldSymlinkBit() {
        return this.oldSymlinkBit;
    }

    public void setOldSymlinkBit(Boolean bl2) {
        this.oldSymlinkBit = bl2;
    }

    public SVNNodeKind getNodeKind() {
        return this.nodeKind;
    }

    public void setNodeKind(SVNNodeKind sVNNodeKind) {
        this.nodeKind = sVNNodeKind;
    }

    private Boolean[] parseGitModeBits(String string) {
        Boolean bl2;
        Boolean bl3;
        int n2 = Integer.parseInt(string, 8);
        switch (n2 & 0x1FF) {
            case 420: {
                bl3 = Boolean.FALSE;
                break;
            }
            case 493: {
                bl3 = Boolean.TRUE;
                break;
            }
            default: {
                bl3 = null;
            }
        }
        switch (n2 & 0xF000) {
            case 40960: {
                bl2 = Boolean.TRUE;
                break;
            }
            case 16384: 
            case 32768: {
                bl2 = Boolean.FALSE;
                break;
            }
            default: {
                bl2 = null;
            }
        }
        return new Boolean[]{bl3, bl2};
    }

    protected static int readFully(InputStream inputStream, byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = 0;
        while ((n4 = inputStream.read(byArray, n2, n3)) >= 0) {
            n5 += n4;
            n2 += n4;
            if ((n3 -= n4) != 0) continue;
            break;
        }
        if (n5 == 0) {
            return -1;
        }
        return n5;
    }

    static /* synthetic */ File access$100(String string) {
        return SvnPatch.grabFileName(string);
    }

    static /* synthetic */ Boolean[] access$200(SvnPatch svnPatch, String string) {
        return svnPatch.parseGitModeBits(string);
    }
}

