/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.patch;

import java.io.IOException;
import java.io.InputStream;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchFileStream;

class SvnPatch$Base85DataStream
extends InputStream {
    private final SVNPatchFileStream patchFileStream;
    private long start;
    private final long end;
    private boolean done;
    private byte[] buffer;
    private int bufSize;
    private int bufPos;
    private byte[] singleByteBuffer;

    public SvnPatch$Base85DataStream(SVNPatchFileStream sVNPatchFileStream, long l2, long l3) {
        this.patchFileStream = sVNPatchFileStream;
        this.start = l2;
        this.end = l3;
        this.done = false;
        this.buffer = new byte[52];
        this.bufSize = 0;
        this.bufPos = 0;
        this.singleByteBuffer = new byte[1];
    }

    @Override
    public int read() {
        int n2 = this.read(this.singleByteBuffer, 0, 1);
        if (n2 < 0) {
            return n2;
        }
        return this.singleByteBuffer[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        try {
            int n4 = n3;
            int n5 = n2;
            if (this.done) {
                return -1;
            }
            while (n4 != 0 && (this.bufSize > this.bufPos || this.start < this.end)) {
                int n6 = this.bufSize - this.bufPos;
                if (n6 != 0) {
                    int n7 = n4 < n6 ? n4 : n6;
                    System.arraycopy(this.buffer, this.bufPos, byArray, n5, n7);
                    n5 += n7;
                    this.bufPos += n7;
                    if ((n4 -= n7) == 0) {
                        return n3;
                    }
                }
                if (this.start >= this.end) break;
                this.patchFileStream.setSeekPosition(this.start);
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl2 = this.patchFileStream.readLine(stringBuffer);
                String string = stringBuffer.toString();
                this.start = bl2 ? this.end : this.patchFileStream.getSeekPosition();
                if (string.length() > 0 && string.charAt(0) >= 'A' && string.charAt(0) <= 'Z') {
                    this.bufSize = string.charAt(0) - 65 + 1;
                } else if (string.length() > 0 && string.charAt(0) >= 'a' && string.charAt(0) <= 'z') {
                    this.bufSize = string.charAt(0) - 97 + 26 + 1;
                } else {
                    throw new IOException("Unexpected data in base85 section");
                }
                if (this.bufSize < 52) {
                    this.start = this.end;
                }
                SvnPatch$Base85DataStream.base85DecodeLine(this.buffer, this.bufSize, string.substring(1));
                this.bufPos = 0;
            }
            this.done = true;
            return n3 -= n4;
        }
        catch (SVNException sVNException) {
            throw new IOException(sVNException);
        }
    }

    private static void base85DecodeLine(byte[] byArray, int n2, String string) {
        int n3 = (n2 + 3) / 4 * 5;
        if (string.length() != n3) {
            throw new IOException("Unexpected base85 line length");
        }
        int n4 = 0;
        int n5 = string.length();
        int n6 = 0;
        while (n5 != 0) {
            int n7;
            int n8;
            long l2 = 0L;
            for (n8 = 0; n8 < 5; ++n8) {
                n7 = SvnPatch$Base85DataStream.base85Value(string.charAt(n4 + n8));
                l2 *= 85L;
                l2 += (long)n7;
            }
            n8 = 0;
            n7 = 24;
            while (n8 < 4) {
                if (n8 < n2) {
                    byArray[n6 + n8] = (byte)(l2 >> n7 & 0xFFL);
                }
                ++n8;
                n7 -= 8;
            }
            n4 += 5;
            n5 -= 5;
            n6 += 4;
            n2 -= 4;
        }
    }

    private static int base85Value(char c2) {
        int n2 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!#$%&()*+-;<=>?@^_`{|}~".indexOf(String.valueOf(c2));
        if (n2 < 0) {
            throw new IOException("Invalid base85 value");
        }
        return n2;
    }
}

