/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.patch;

import java.io.IOException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchFileStream;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnDiffHunk$Range;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPatch;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnDiffHunk
implements Comparable {
    private SvnPatch patch;
    private SVNPatchFileStream patchFileStream;
    private SvnDiffHunk$Range diffTextRange;
    private SvnDiffHunk$Range originalTextRange;
    private SvnDiffHunk$Range modifiedTextRange;
    private int originalStart;
    private int originalLength;
    private int modifiedStart;
    private int modifiedLength;
    private int leadingContext;
    private int trailingContext;
    private boolean originalNoFinalEol;
    private boolean modifiedNoFinalEol;
    private int originalFuzz;
    private int modifiedFuzz;

    public void resetDiffText() {
        SvnDiffHunk$Range.access$002(this.diffTextRange, SvnDiffHunk$Range.access$100(this.diffTextRange));
    }

    public void resetOriginalText() {
        if (this.patch.isReverse()) {
            SvnDiffHunk$Range.access$002(this.modifiedTextRange, SvnDiffHunk$Range.access$100(this.modifiedTextRange));
        } else {
            SvnDiffHunk$Range.access$002(this.originalTextRange, SvnDiffHunk$Range.access$100(this.originalTextRange));
        }
    }

    public void resetModifiedText() {
        if (this.patch.isReverse()) {
            SvnDiffHunk$Range.access$002(this.originalTextRange, SvnDiffHunk$Range.access$100(this.originalTextRange));
        } else {
            SvnDiffHunk$Range.access$002(this.modifiedTextRange, SvnDiffHunk$Range.access$100(this.modifiedTextRange));
        }
    }

    public int getDirectedOriginalStart() {
        return this.patch.isReverse() ? this.modifiedStart : this.originalStart;
    }

    public int getDirectedOriginalLength() {
        return this.patch.isReverse() ? this.modifiedLength : this.originalLength;
    }

    public int getDirectedModifiedStart() {
        return this.patch.isReverse() ? this.originalStart : this.modifiedStart;
    }

    public int getDirectedModifiedLength() {
        return this.patch.isReverse() ? this.originalLength : this.modifiedLength;
    }

    public int getLeadingContext() {
        return this.leadingContext;
    }

    public int getTrailingContext() {
        return this.trailingContext;
    }

    public void setOriginalStart(int n2) {
        this.originalStart = n2;
    }

    public void setOriginalLength(int n2) {
        this.originalLength = n2;
    }

    public void setModifiedStart(int n2) {
        this.modifiedStart = n2;
    }

    public void setModifiedLength(int n2) {
        this.modifiedLength = n2;
    }

    public void setDiffTextRange(SvnDiffHunk$Range svnDiffHunk$Range) {
        this.diffTextRange = svnDiffHunk$Range;
    }

    public void setOriginalTextRange(SvnDiffHunk$Range svnDiffHunk$Range) {
        this.originalTextRange = svnDiffHunk$Range;
    }

    public void setModifiedTextRange(SvnDiffHunk$Range svnDiffHunk$Range) {
        this.modifiedTextRange = svnDiffHunk$Range;
    }

    private int getOriginalStart() {
        return this.originalStart;
    }

    public int getOriginalLength() {
        return this.originalLength;
    }

    private int getModifiedStart() {
        return this.modifiedStart;
    }

    public int getModifiedLength() {
        return this.modifiedLength;
    }

    public void setLeadingContext(int n2) {
        this.leadingContext = n2;
    }

    public void setTrailingContext(int n2) {
        this.trailingContext = n2;
    }

    public void setPatch(SvnPatch svnPatch) {
        this.patch = svnPatch;
    }

    public String readLineDiffText(String[] stringArray, boolean[] blArray) {
        if (SvnDiffHunk$Range.access$000(this.diffTextRange) >= SvnDiffHunk$Range.access$200(this.diffTextRange)) {
            blArray[0] = true;
            if (stringArray != null) {
                stringArray[0] = null;
            }
            return "";
        }
        long l2 = this.patchFileStream.getSeekPosition();
        this.patchFileStream.setSeekPosition(SvnDiffHunk$Range.access$000(this.diffTextRange));
        long l3 = SvnDiffHunk$Range.access$200(this.diffTextRange) - SvnDiffHunk$Range.access$000(this.diffTextRange);
        String string = this.readLine(this.patchFileStream, stringArray, blArray);
        SvnDiffHunk$Range.access$002(this.diffTextRange, 0L);
        SvnDiffHunk$Range.access$002(this.diffTextRange, this.patchFileStream.getSeekPosition());
        this.patchFileStream.setSeekPosition(l2);
        if (this.patch.isReverse()) {
            if (string.startsWith("+")) {
                string = "-" + string.substring("+".length());
            } else if (string.startsWith("-")) {
                string = "+" + string.substring("-".length());
            }
        }
        return string;
    }

    public String readLineOriginalText(String[] stringArray, boolean[] blArray) {
        return this.readLineOriginalOrModified(this.patch.isReverse() ? this.modifiedTextRange : this.originalTextRange, stringArray, blArray, this.patch.isReverse() ? (char)'-' : '+', this.patch.isReverse() ? this.modifiedNoFinalEol : this.originalNoFinalEol);
    }

    public String readLineModifiedText(String[] stringArray, boolean[] blArray) {
        return this.readLineOriginalOrModified(this.patch.isReverse() ? this.originalTextRange : this.modifiedTextRange, stringArray, blArray, this.patch.isReverse() ? (char)'+' : '-', this.patch.isReverse() ? this.originalNoFinalEol : this.modifiedNoFinalEol);
    }

    private String readLineOriginalOrModified(SvnDiffHunk$Range svnDiffHunk$Range, String[] stringArray, boolean[] blArray, char c2, boolean bl2) {
        String[] stringArray2 = new String[1];
        if (stringArray == null) {
            stringArray = stringArray2;
        }
        try {
            String string;
            String string2;
            boolean bl3;
            if (SvnDiffHunk$Range.access$000(svnDiffHunk$Range) >= SvnDiffHunk$Range.access$200(svnDiffHunk$Range)) {
                blArray[0] = true;
                if (stringArray != null) {
                    stringArray[0] = null;
                }
                return "";
            }
            long l2 = this.patchFileStream.getSeekPosition();
            this.patchFileStream.setSeekPosition(SvnDiffHunk$Range.access$000(svnDiffHunk$Range));
            do {
                long l3 = SvnDiffHunk$Range.access$200(svnDiffHunk$Range) - SvnDiffHunk$Range.access$000(svnDiffHunk$Range);
                string2 = null;
                if (l3 < 0L && stringArray != null) {
                    string2 = stringArray[0];
                }
                string = this.readLine(this.patchFileStream, stringArray, blArray);
                byte[] byArray = string.getBytes("UTF-8");
                if (l3 >= 0L && (long)byArray.length >= l3) {
                    string = new String(byArray, 0, (int)l3);
                    if (stringArray != null && stringArray[0] != null && !string.endsWith("\r") && !string.endsWith("\n")) {
                        stringArray[0] = null;
                    }
                    if (blArray != null) {
                        blArray[0] = l3 == 0L;
                    }
                } else if (l3 < 0L && stringArray != null) {
                    stringArray[0] = string2;
                }
                SvnDiffHunk$Range.access$002(svnDiffHunk$Range, this.patchFileStream.getSeekPosition());
                boolean bl4 = bl3 = string.length() > 0 && (string.charAt(0) == c2 || string.charAt(0) == '\\');
            } while (bl3 && !blArray[0]);
            if (bl3) {
                string2 = "";
                stringArray[0] = null;
            } else {
                string2 = string.startsWith("+") || string.startsWith("-") || string.startsWith(" ") ? string.substring(1) : string;
            }
            if (!bl3 && blArray[0] && stringArray[0] == null && string.length() > 0) {
                if (!bl2 && stringArray != stringArray2) {
                    this.patchFileStream.setSeekPosition(0L);
                    string = this.readLine(this.patchFileStream, stringArray, blArray);
                    assert (stringArray[0] != null);
                    string2 = string;
                }
                blArray[0] = false;
            }
            this.patchFileStream.setSeekPosition(l2);
            return string2;
        }
        catch (IOException iOException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            return null;
        }
    }

    private String readLine(SVNPatchFileStream sVNPatchFileStream, String[] stringArray, boolean[] blArray) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (blArray != null) {
            blArray[0] = sVNPatchFileStream.readLineWithEol(stringBuffer, stringBuffer2);
        }
        if (stringArray != null) {
            stringArray[0] = stringBuffer2.length() == 0 ? null : stringBuffer2.toString();
        }
        return stringBuffer.toString();
    }

    public int compareTo(SvnDiffHunk svnDiffHunk) {
        if (this.getOriginalStart() < svnDiffHunk.getOriginalStart()) {
            return -1;
        }
        if (this.getOriginalStart() > svnDiffHunk.getOriginalStart()) {
            return 1;
        }
        return 0;
    }

    public void setPatchFileStream(SVNPatchFileStream sVNPatchFileStream) {
        this.patchFileStream = sVNPatchFileStream;
    }

    public void decreaseOriginalLength() {
        --this.originalLength;
    }

    public void decreaseModifiedLength() {
        --this.modifiedLength;
    }

    public void setOriginalNoFinalEol(boolean bl2) {
        this.originalNoFinalEol = bl2;
    }

    public void setModifiedNoFinalEol(boolean bl2) {
        this.modifiedNoFinalEol = bl2;
    }

    public int getFuzzPenalty() {
        return this.patch.isReverse() ? this.originalFuzz : this.modifiedFuzz;
    }

    public int getOriginalFuzz() {
        return this.originalFuzz;
    }

    public void setOriginalFuzz(int n2) {
        this.originalFuzz = n2;
    }

    public int getModifiedFuzz() {
        return this.modifiedFuzz;
    }

    public void setModifiedFuzz(int n2) {
        this.modifiedFuzz = n2;
    }
}

