/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.old;

import java.util.Collection;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc16.SVNCopyClient16;
import org.tmatesoft.svn.core.internal.wc16.SVNMoveClient16;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.internal.wc2.old.SvnOldRunner;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc2.SvnCopy;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnOldCopy
extends SvnOldRunner {
    @Override
    protected Void run() {
        if (((SvnCopy)this.getOperation()).isDisjoint()) {
            return this.disjointCopy();
        }
        if (((SvnCopy)this.getOperation()).isVirtual()) {
            return this.virtualCopy();
        }
        return this.copy();
    }

    private Void disjointCopy() {
        assert (!((SvnCopy)this.getOperation()).isMove());
        SVNCopyClient16 sVNCopyClient16 = new SVNCopyClient16(((SvnCopy)this.getOperation()).getRepositoryPool(), ((SvnCopy)this.getOperation()).getOptions());
        sVNCopyClient16.setEventHandler(((SvnCopy)this.getOperation()).getEventHandler());
        sVNCopyClient16.setCommitHandler(null);
        sVNCopyClient16.setExternalsHandler(ISVNExternalsHandler.DEFAULT);
        sVNCopyClient16.setOptions(((SvnCopy)this.getOperation()).getOptions());
        Collection collection = ((SvnCopy)this.getOperation()).getTargets();
        for (SvnTarget svnTarget : collection) {
            if (svnTarget.isURL()) {
                this.throwCannotPerformOnUrl(svnTarget, "disjoint", "copy");
            }
            sVNCopyClient16.doCopy(svnTarget.getFile());
        }
        return null;
    }

    private Void virtualCopy() {
        SVNCopySource[] sVNCopySourceArray;
        SVNMoveClient16 sVNMoveClient16 = new SVNMoveClient16(((SvnCopy)this.getOperation()).getRepositoryPool(), ((SvnCopy)this.getOperation()).getOptions());
        sVNMoveClient16.setEventHandler(((SvnCopy)this.getOperation()).getEventHandler());
        sVNMoveClient16.setOptions(((SvnCopy)this.getOperation()).getOptions());
        SvnTarget svnTarget = ((SvnCopy)this.getOperation()).getFirstTarget();
        if (svnTarget.isURL()) {
            this.throwCannotPerformOnUrl(svnTarget, "virtual", ((SvnCopy)this.getOperation()).isMove() ? "move" : "copy");
        }
        for (SVNCopySource sVNCopySource : sVNCopySourceArray = this.getCopySources()) {
            sVNMoveClient16.doVirtualCopy(sVNCopySource.getFile(), svnTarget.getFile(), ((SvnCopy)this.getOperation()).isMove());
        }
        return null;
    }

    private Void copy() {
        SVNCopyClient16 sVNCopyClient16 = new SVNCopyClient16(((SvnCopy)this.getOperation()).getRepositoryPool(), ((SvnCopy)this.getOperation()).getOptions());
        sVNCopyClient16.setEventHandler(((SvnCopy)this.getOperation()).getEventHandler());
        sVNCopyClient16.setCommitHandler(null);
        sVNCopyClient16.setExternalsHandler(ISVNExternalsHandler.DEFAULT);
        sVNCopyClient16.setOptions(((SvnCopy)this.getOperation()).getOptions());
        SvnTarget svnTarget = ((SvnCopy)this.getOperation()).getFirstTarget();
        SVNCopySource[] sVNCopySourceArray = this.getCopySources();
        if (svnTarget.isURL()) {
            sVNCopyClient16.doCopy(sVNCopySourceArray, svnTarget.getURL(), ((SvnCopy)this.getOperation()).isMove(), ((SvnCopy)this.getOperation()).isMakeParents(), ((SvnCopy)this.getOperation()).isFailWhenDstExists(), null, null);
        } else {
            sVNCopyClient16.doCopy(sVNCopySourceArray, svnTarget.getFile(), ((SvnCopy)this.getOperation()).isMove(), ((SvnCopy)this.getOperation()).isMakeParents(), ((SvnCopy)this.getOperation()).isFailWhenDstExists());
        }
        return null;
    }

    private SVNCopySource[] getCopySources() {
        SVNCopySource[] sVNCopySourceArray = new SVNCopySource[((SvnCopy)this.getOperation()).getSources().size()];
        int n2 = 0;
        for (SvnCopySource svnCopySource : ((SvnCopy)this.getOperation()).getSources()) {
            sVNCopySourceArray[n2] = SvnCodec.copySource(svnCopySource);
            ++n2;
        }
        return sVNCopySourceArray;
    }

    private void throwCannotPerformOnUrl(SvnTarget svnTarget, String string, String string2) {
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot perform ''{0}'' {1}: ''{2}'' is URL", string, string2, svnTarget);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
    }
}

