/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternalsUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$NodePresence;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$SVNWCSchedule;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$ScheduleInternalInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo$BaseInfoField;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbInfo$InfoField;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbRepositoryInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbRepositoryInfo$RepositoryInfoField;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb$DirParsedInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbDir;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$AdditionInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$ExternalNodeInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeOriginInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts$TextConflictInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbCopy;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbPristines;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemove;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgWcToWcCopy$1;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgWcToWcCopy$CopyToTmpDir;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgWcToWcCopy$SvnCopyPair;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnCopy;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnGetStatus;
import org.tmatesoft.svn.core.wc2.SvnOperation;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnScheduleForAddition;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgWcToWcCopy
extends SvnNgOperationRunner {
    public boolean isApplicable(SvnCopy svnCopy, SvnWcGeneration svnWcGeneration) {
        return this.areAllSourcesLocal(svnCopy) && svnCopy.getFirstTarget().isLocal();
    }

    private boolean areAllSourcesLocal(SvnCopy svnCopy) {
        for (SvnCopySource svnCopySource : svnCopy.getSources()) {
            if (svnCopySource.getSource().isFile() && (svnCopy.isMove() || this.isLocalRevision(svnCopySource.getRevision()) && this.isLocalRevision(svnCopySource.getSource().getResolvedPegRevision()))) continue;
            return false;
        }
        return true;
    }

    private boolean isLocalRevision(SVNRevision sVNRevision) {
        return sVNRevision == SVNRevision.WORKING || sVNRevision == SVNRevision.UNDEFINED;
    }

    @Override
    protected Void run(SVNWCContext sVNWCContext) {
        boolean bl2 = false;
        Collection collection = ((SvnCopy)this.getOperation()).getSources();
        try {
            bl2 = this.tryRun(sVNWCContext, collection, this.getFirstTarget());
            Void void_ = null;
            return void_;
        }
        catch (SVNException sVNException) {
            SVNErrorCode sVNErrorCode = sVNException.getErrorMessage().getErrorCode();
            if (!(((SvnCopy)this.getOperation()).isFailWhenDstExists() || ((SvnCopy)this.getOperation()).getSources().size() != 1 || sVNErrorCode != SVNErrorCode.ENTRY_EXISTS && sVNErrorCode != SVNErrorCode.FS_ALREADY_EXISTS)) {
                SvnCopySource svnCopySource = (SvnCopySource)collection.iterator().next();
                bl2 = this.tryRun(sVNWCContext, collection, new File(this.getFirstTarget(), svnCopySource.getSource().getFile().getName()));
                Void void_ = null;
                return void_;
            }
            throw sVNException;
        }
        finally {
            if (bl2) {
                this.sleepForTimestamp();
            }
        }
    }

    protected boolean tryRun(SVNWCContext sVNWCContext, Collection collection, File file) {
        if (((SvnCopy)this.getOperation()).isDisjoint()) {
            return this.disjointCopy(sVNWCContext, file);
        }
        return this.copy(sVNWCContext, collection, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean disjointCopy(SVNWCContext sVNWCContext, File file) {
        file = new File(file.getAbsolutePath().replace(File.separatorChar, '/'));
        File file2 = file.getParentFile();
        this.checkForDisjointCopyPossibility(sVNWCContext, file, file2);
        sVNWCContext.getDb().close();
        File file3 = sVNWCContext.getDb().getWCRoot(file2);
        File file4 = new File(this.getAdminDirectory(file3), "tmp");
        SVNFileUtil.ensureDirectoryExists(file4);
        File file5 = SVNFileUtil.createUniqueDir(file4, "disjoint-copy", "tmp", true);
        this.moveWcDb(file, file5);
        this.copyPristineFiles(file, file3, true);
        SVNFileUtil.deleteAll(this.getAdminDirectory(file), true);
        sVNWCContext.getDb().forgetDirectoryTemp(file);
        File file6 = null;
        try {
            file6 = sVNWCContext.acquireWriteLock(file3, true, true);
            this.copy(sVNWCContext, file5, file, true);
        }
        finally {
            if (file6 != null) {
                sVNWCContext.releaseWriteLock(file6);
            }
        }
        return true;
    }

    private void checkForDisjointCopyPossibility(SVNWCContext sVNWCContext, File file, File file2) {
        SVNErrorMessage sVNErrorMessage;
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        SVNFileType sVNFileType = SVNFileType.getType(file);
        if (sVNFileType != SVNFileType.DIRECTORY) {
            object4 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "This kind of copy can be run on a root of a disjoint wc directory only");
            SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.WC);
        }
        if (file2 == null) {
            object4 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "{0} seems to be not a disjoint wc since it has no parent", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.WC);
        }
        if (!(sVNWCContext.getDb() instanceof SVNWCDb)) {
            object4 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Unsupported working copy format", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.WC);
        }
        if (this.hasMetadataInParentWc((SVNWCDb)(object4 = (SVNWCDb)sVNWCContext.getDb()), file, file2)) {
            object3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Entry ''{0}'' already exists in parent directory", (Object)file.getName());
            SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
        }
        object3 = sVNWCContext.getDb().getBaseInfo(file, ISVNWCDb$WCDbBaseInfo$BaseInfoField.reposRootUrl, ISVNWCDb$WCDbBaseInfo$BaseInfoField.reposRelPath);
        ISVNWCDb$WCDbBaseInfo iSVNWCDb$WCDbBaseInfo = sVNWCContext.getDb().getBaseInfo(file2, ISVNWCDb$WCDbBaseInfo$BaseInfoField.reposRootUrl, ISVNWCDb$WCDbBaseInfo$BaseInfoField.reposRelPath);
        if (((ISVNWCDb$WCDbBaseInfo)object3).reposRootUrl != null && iSVNWCDb$WCDbBaseInfo.reposRootUrl != null && !((ISVNWCDb$WCDbBaseInfo)object3).reposRootUrl.equals(iSVNWCDb$WCDbBaseInfo.reposRootUrl)) {
            object2 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is not from repository ''{1}''; it is from ''{2}''", file2, ((ISVNWCDb$WCDbBaseInfo)object3).reposRootUrl, ((ISVNWCDb$WCDbBaseInfo)object3).reposRootUrl);
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
        }
        object2 = sVNWCContext.getNodeScheduleInternal(file2, true, true);
        if (((SVNWCContext$ScheduleInternalInfo)object2).schedule == SVNWCContext$SVNWCSchedule.delete) {
            object = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is scheduled for deletion", (Object)file2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = sVNWCContext.getNodeScheduleInternal(file, true, true);
        if (((SVNWCContext$ScheduleInternalInfo)object).schedule == SVNWCContext$SVNWCSchedule.delete) {
            serializable = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy ''{0}'', as it is scheduled for deletion", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        serializable = ((ISVNWCDb$WCDbBaseInfo)object3).reposRelPath;
        File file3 = iSVNWCDb$WCDbBaseInfo.reposRelPath;
        if (serializable == null || file3 == null) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy ''{0}'': cannot resolve its relative path, perhaps it is obstructed", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (SVNPathUtil.isAncestor(((File)serializable).getPath(), file3.getPath())) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot copy path ''{0}'' into its own child ''{1}", file, file2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (((SVNWCContext$ScheduleInternalInfo)object).schedule == SVNWCContext$SVNWCSchedule.add && !((SVNWCContext$ScheduleInternalInfo)object).copied || sVNWCContext.getNodeUrl(file) == null) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Cannot copy or move ''{0}'': it is not in repository yet; try committing first", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
    }

    private void moveWcDb(File file, File file2) {
        File file3 = this.getWCDbFile(file);
        File file4 = this.getWCDbFile(file2);
        SVNFileUtil.ensureDirectoryExists(file4.getParentFile());
        SVNFileUtil.rename(file3, file4);
    }

    private void copyPristineFiles(File file, File file2, boolean bl2) {
        File file3 = this.getPristineDirectory(file);
        File file4 = this.getPristineDirectory(file2);
        File[] fileArray = SVNFileListUtil.listFiles(file3);
        if (fileArray != null) {
            for (File file5 : fileArray) {
                File file6 = new File(file4, file5.getName());
                SVNFileUtil.ensureDirectoryExists(file6);
                File[] fileArray2 = SVNFileListUtil.listFiles(file5);
                if (fileArray2 == null) continue;
                for (File file7 : fileArray2) {
                    File file8 = new File(file6, file7.getName());
                    if (file8.exists()) continue;
                    if (bl2) {
                        SVNFileUtil.rename(file7, file8);
                        continue;
                    }
                    SVNFileUtil.copyFile(file7, file8, false);
                }
            }
        }
        SVNFileUtil.deleteAll(file3, true);
    }

    private File getPristineDirectory(File file) {
        return new File(this.getAdminDirectory(file), "pristine");
    }

    private File getWCDbFile(File file) {
        return new File(this.getAdminDirectory(file), "wc.db");
    }

    private File getAdminDirectory(File file) {
        String string = SVNFileUtil.getAdminDirectoryName();
        return new File(file, string);
    }

    private boolean hasMetadataInParentWc(SVNWCDb sVNWCDb, File file, File file2) {
        SVNWCDbRoot sVNWCDbRoot;
        SVNWCDb$DirParsedInfo sVNWCDb$DirParsedInfo = sVNWCDb.obtainWcRoot(file2);
        SVNWCDbDir sVNWCDbDir = sVNWCDb$DirParsedInfo == null ? null : sVNWCDb$DirParsedInfo.wcDbDir;
        SVNWCDbRoot sVNWCDbRoot2 = sVNWCDbRoot = sVNWCDbDir == null ? null : sVNWCDbDir.getWCRoot();
        if (sVNWCDbRoot == null) {
            return false;
        }
        try {
            sVNWCDb.readInfo(sVNWCDbRoot, new File(SVNPathUtil.getRelativePath(file2.getPath(), file.getPath())), new ISVNWCDb$WCDbInfo$InfoField[0]);
            return true;
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND || sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                return false;
            }
            throw sVNException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copy(SVNWCContext sVNWCContext, Collection collection, File file) {
        Object object;
        Object object2;
        Object object32;
        Object object4;
        boolean bl2 = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (collection.size() > 1) {
            if (((SvnCopy)this.getOperation()).isFailWhenDstExists()) {
                object4 = SVNErrorMessage.create(SVNErrorCode.CLIENT_MULTIPLE_SOURCES_DISALLOWED);
                SVNErrorManager.error(object4, SVNLogType.DEFAULT);
            }
            for (SvnCopySource iterator : collection) {
                object32 = new SvnNgWcToWcCopy$SvnCopyPair();
                ((SvnNgWcToWcCopy$SvnCopyPair)object32).source = iterator.getSource().getFile();
                object2 = ((SvnNgWcToWcCopy$SvnCopyPair)object32).source.getName();
                ((SvnNgWcToWcCopy$SvnCopyPair)object32).dst = new File(file, (String)object2);
                arrayList.add(object32);
            }
        } else if (collection.size() == 1) {
            object4 = new SvnNgWcToWcCopy$SvnCopyPair();
            SvnCopySource svnCopySource = (SvnCopySource)collection.iterator().next();
            ((SvnNgWcToWcCopy$SvnCopyPair)object4).source = new File(SVNPathUtil.validateFilePath(svnCopySource.getSource().getFile().getAbsolutePath()));
            ((SvnNgWcToWcCopy$SvnCopyPair)object4).dst = file;
            arrayList.add(object4);
        }
        for (SvnNgWcToWcCopy$SvnCopyPair svnNgWcToWcCopy$SvnCopyPair : arrayList) {
            object32 = svnNgWcToWcCopy$SvnCopyPair.source;
            object2 = svnNgWcToWcCopy$SvnCopyPair.dst;
            if (((SvnCopy)this.getOperation()).isMove() && ((File)object32).getAbsolutePath().equals(((File)object2).getAbsolutePath())) {
                object = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot move path ''{0}'' into itself", object32);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            if (!SVNWCUtils.isChild((File)object32, (File)object2)) continue;
            object = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot copy path ''{0}'' into its own child ''{1}''", object32, object2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (((SvnCopy)this.getOperation()).isMove()) {
            for (SvnNgWcToWcCopy$SvnCopyPair svnNgWcToWcCopy$SvnCopyPair : arrayList) {
                object32 = svnNgWcToWcCopy$SvnCopyPair.source;
                try {
                    object2 = SvnWcDbExternals.readExternal(sVNWCContext, (File)object32, (File)object32, StructureFields$ExternalNodeInfo.kind, StructureFields$ExternalNodeInfo.definingAbsPath);
                    if (!((Structure)object2).hasValue(StructureFields$ExternalNodeInfo.kind) || ((Structure)object2).get(StructureFields$ExternalNodeInfo.kind) == SVNNodeKind.NONE) continue;
                    object = SVNErrorMessage.create(SVNErrorCode.WC_CANNOT_MOVE_FILE_EXTERNAL, "Cannot move the external at ''{0}''; please edit the svn:externals property on ''{1}''.", object32, (int)((Integer)((Structure)object2).get(StructureFields$ExternalNodeInfo.definingAbsPath)));
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) continue;
                    throw sVNException;
                }
            }
        }
        this.verifyPaths(arrayList, ((SvnCopy)this.getOperation()).isMakeParents(), ((SvnCopy)this.getOperation()).isMove());
        if (((SvnCopy)this.getOperation()).isMove()) {
            bl2 = this.move(arrayList);
        } else {
            object4 = null;
            if (arrayList.size() >= 1) {
                object4 = ((SvnNgWcToWcCopy$SvnCopyPair)arrayList.iterator().next()).dst;
            }
            if (arrayList.size() > 1 && object4 != null) {
                object4 = SVNFileUtil.getParentFile((File)object4);
            }
            object4 = ((File)object4).getAbsoluteFile();
            object4 = sVNWCContext.acquireWriteLock((File)object4, false, true);
            try {
                for (Object object32 : arrayList) {
                    object2 = null;
                    this.checkCancelled();
                    if (((SvnCopy)this.getOperation()).isPinExternals()) {
                        object = this.getWcContext().getNodeOrigin(((SvnNgWcToWcCopy$SvnCopyPair)object32).source, false, StructureFields$NodeOriginInfo.reposRootUrl);
                        SVNURL sVNURL = (SVNURL)((Structure)object).get(StructureFields$NodeOriginInfo.reposRootUrl);
                        object2 = this.resolvePinnedExternals(((SvnCopy)this.getOperation()).getExternalsToPin(), (SvnNgWcToWcCopy$SvnCopyPair)object32, null, sVNURL);
                    }
                    object = SVNFileUtil.createFilePath(((SvnNgWcToWcCopy$SvnCopyPair)object32).dstParent, ((SvnNgWcToWcCopy$SvnCopyPair)object32).baseName);
                    boolean bl3 = bl2 || this.copy(sVNWCContext, ((SvnNgWcToWcCopy$SvnCopyPair)object32).source, (File)object, ((SvnCopy)this.getOperation()).isMetadataOnly() || ((SvnCopy)this.getOperation()).isVirtual()) ? true : (bl2 = false);
                    if (object2 == null) continue;
                    for (Map.Entry entry : object2.entrySet()) {
                        String string = (String)entry.getKey();
                        SVNPropertyValue sVNPropertyValue = (SVNPropertyValue)entry.getValue();
                        File file2 = SVNFileUtil.createFilePath(((SvnNgWcToWcCopy$SvnCopyPair)object32).dst, string);
                        SvnNgPropertiesManager.setProperty(this.getWcContext(), file2, "svn:externals", sVNPropertyValue, SVNDepth.EMPTY, true, null, null);
                    }
                }
            }
            finally {
                sVNWCContext.releaseWriteLock((File)object4);
            }
        }
        return false;
    }

    private Map resolvePinnedExternals(Map map, SvnNgWcToWcCopy$SvnCopyPair svnNgWcToWcCopy$SvnCopyPair, SVNRepository sVNRepository, SVNURL sVNURL) {
        return SVNExternalsUtil.resolvePinnedExternals(this.getWcContext(), this.getRepositoryAccess(), map, SvnTarget.fromFile(svnNgWcToWcCopy$SvnCopyPair.source), SvnTarget.fromFile(svnNgWcToWcCopy$SvnCopyPair.dst), -1L, sVNRepository, sVNURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean move(Collection collection) {
        for (SvnNgWcToWcCopy$SvnCopyPair svnNgWcToWcCopy$SvnCopyPair : collection) {
            HashSet<File> hashSet = new HashSet<File>();
            HashSet<File> hashSet2 = new HashSet<File>();
            this.checkCancelled();
            File file = new File(SVNPathUtil.validateFilePath(SVNFileUtil.getParentFile(svnNgWcToWcCopy$SvnCopyPair.source).getAbsolutePath()));
            if (file.equals(svnNgWcToWcCopy$SvnCopyPair.dstParent) || SVNWCUtils.isChild(file, svnNgWcToWcCopy$SvnCopyPair.dstParent)) {
                hashSet.add(file);
            } else if (SVNWCUtils.isChild(svnNgWcToWcCopy$SvnCopyPair.dstParent, file)) {
                hashSet.add(svnNgWcToWcCopy$SvnCopyPair.dstParent);
            } else {
                hashSet.add(file);
                hashSet.add(svnNgWcToWcCopy$SvnCopyPair.dstParent);
            }
            try {
                for (File file2 : hashSet) {
                    hashSet2.add(this.getWcContext().acquireWriteLock(file2, false, true));
                }
                this.move(this.getWcContext(), svnNgWcToWcCopy$SvnCopyPair.source, SVNFileUtil.createFilePath(svnNgWcToWcCopy$SvnCopyPair.dstParent, svnNgWcToWcCopy$SvnCopyPair.baseName), ((SvnCopy)this.getOperation()).isMetadataOnly() || ((SvnCopy)this.getOperation()).isVirtual());
            }
            finally {
                for (File file2 : hashSet2) {
                    this.getWcContext().releaseWriteLock(file2);
                }
            }
        }
        return false;
    }

    private void verifyPaths(Collection collection, boolean bl2, boolean bl3) {
        for (SvnNgWcToWcCopy$SvnCopyPair svnNgWcToWcCopy$SvnCopyPair : collection) {
            Object object;
            Object object2;
            Object object3;
            SVNNodeKind sVNNodeKind = SvnWcDbCopy.readKind(this.getWcContext().getDb(), svnNgWcToWcCopy$SvnCopyPair.dst, false, true);
            if (sVNNodeKind != SVNNodeKind.NONE) {
                object3 = this.getWcContext().getNodePresence(svnNgWcToWcCopy$SvnCopyPair.dst, false);
                if (((SVNWCContext$NodePresence)object3).isExcluded || ((SVNWCContext$NodePresence)object3).isServerExcluded) {
                    object2 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Path ''{0}'' exists, but is excluded", (Object)svnNgWcToWcCopy$SvnCopyPair.dst);
                    SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
                } else {
                    object2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Path ''{0}'' already exists", (Object)svnNgWcToWcCopy$SvnCopyPair.dst);
                    SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
                }
            }
            object3 = SVNFileType.getType(svnNgWcToWcCopy$SvnCopyPair.source);
            object2 = SVNFileType.getType(svnNgWcToWcCopy$SvnCopyPair.dst);
            if (!((SvnCopy)this.getOperation()).isMetadataOnly()) {
                if (((SvnCopy)this.getOperation()).isVirtual()) {
                    this.verifyPathsExistenceForVirtualCopy(svnNgWcToWcCopy$SvnCopyPair.source, svnNgWcToWcCopy$SvnCopyPair.dst, (SVNFileType)object3, (SVNFileType)object2, svnNgWcToWcCopy$SvnCopyPair, bl3);
                } else {
                    boolean bl4 = this.verifyPaths((SVNFileType)object3, (SVNFileType)object2, svnNgWcToWcCopy$SvnCopyPair, collection.size(), bl3);
                    if (bl4) {
                        return;
                    }
                }
            }
            svnNgWcToWcCopy$SvnCopyPair.dstParent = new File(SVNPathUtil.validateFilePath(SVNFileUtil.getParentFile(svnNgWcToWcCopy$SvnCopyPair.dst).getAbsolutePath()));
            svnNgWcToWcCopy$SvnCopyPair.baseName = SVNFileUtil.getFileName(svnNgWcToWcCopy$SvnCopyPair.dst);
            SVNNodeKind sVNNodeKind2 = SvnWcDbCopy.readKind(this.getWcContext().getDb(), svnNgWcToWcCopy$SvnCopyPair.dstParent, false, true);
            if (bl2 && (sVNNodeKind2 == SVNNodeKind.NONE || ((SvnCopy)this.getOperation()).isVirtual())) {
                SVNFileUtil.ensureDirectoryExists(svnNgWcToWcCopy$SvnCopyPair.dstParent);
                object = ((SvnCopy)this.getOperation()).getOperationFactory().createScheduleForAddition();
                ((SvnOperation)object).setSingleTarget(SvnTarget.fromFile(svnNgWcToWcCopy$SvnCopyPair.dstParent));
                ((SvnOperation)object).setDepth(((SvnCopy)this.getOperation()).isVirtual() ? SVNDepth.EMPTY : SVNDepth.INFINITY);
                ((SvnScheduleForAddition)object).setIncludeIgnored(true);
                ((SvnScheduleForAddition)object).setForce(false);
                ((SvnScheduleForAddition)object).setAddParents(true);
                ((SvnOperation)object).setSleepForTimestamp(false);
                try {
                    ((SvnOperation)object).run();
                }
                catch (SVNException sVNException) {
                    if (sVNNodeKind2 == SVNNodeKind.NONE) {
                        SVNFileUtil.deleteAll(svnNgWcToWcCopy$SvnCopyPair.dstParent, true);
                    }
                    throw sVNException;
                }
            } else if (sVNNodeKind2 != SVNNodeKind.DIR) {
                object = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "Path ''{0}'' is not a directory", (Object)svnNgWcToWcCopy$SvnCopyPair.dstParent);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            if ((sVNNodeKind2 = SVNFileType.getNodeKind(SVNFileType.getType(svnNgWcToWcCopy$SvnCopyPair.dstParent))) == SVNNodeKind.DIR) continue;
            object = SVNErrorMessage.create(SVNErrorCode.WC_MISSING, "Path ''{0}'' is not a directory", (Object)svnNgWcToWcCopy$SvnCopyPair.dstParent);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
    }

    private boolean verifyPaths(SVNFileType sVNFileType, SVNFileType sVNFileType2, SvnNgWcToWcCopy$SvnCopyPair svnNgWcToWcCopy$SvnCopyPair, int n2, boolean bl2) {
        Serializable serializable;
        if (sVNFileType == SVNFileType.NONE) {
            serializable = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Path ''{0}'' does not exist", (Object)svnNgWcToWcCopy$SvnCopyPair.source);
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        if (sVNFileType2 != SVNFileType.NONE) {
            File file;
            if (bl2 && n2 == 1 && ((File)(serializable = SVNFileUtil.getFileDir(svnNgWcToWcCopy$SvnCopyPair.source))).equals(file = SVNFileUtil.getFileDir(svnNgWcToWcCopy$SvnCopyPair.dst)) && svnNgWcToWcCopy$SvnCopyPair.source.getName().equalsIgnoreCase(svnNgWcToWcCopy$SvnCopyPair.dst.getName())) {
                svnNgWcToWcCopy$SvnCopyPair.dstParent = new File(SVNPathUtil.validateFilePath(file.getAbsolutePath()));
                svnNgWcToWcCopy$SvnCopyPair.baseName = SVNFileUtil.getFileName(svnNgWcToWcCopy$SvnCopyPair.dst);
                return true;
            }
            serializable = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Path ''{0}'' already exists", (Object)svnNgWcToWcCopy$SvnCopyPair.dst);
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        return false;
    }

    private void verifyPathsExistenceForVirtualCopy(File file, File file2, SVNFileType sVNFileType, SVNFileType sVNFileType2, SvnNgWcToWcCopy$SvnCopyPair svnNgWcToWcCopy$SvnCopyPair, boolean bl2) {
        Object object;
        Object object2;
        String string;
        String string2 = string = bl2 ? "move" : "copy";
        if (bl2 && sVNFileType != SVNFileType.NONE) {
            object2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Cannot perform 'virtual' {0}: ''{1}'' still exists", string, svnNgWcToWcCopy$SvnCopyPair.source);
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
        }
        if (sVNFileType2 == SVNFileType.NONE) {
            object2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Cannot perform 'virtual' {0}: ''{1}'' does not exist", string, svnNgWcToWcCopy$SvnCopyPair.dst);
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
        }
        if (sVNFileType2 == SVNFileType.DIRECTORY) {
            object2 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot perform 'virtual' {0}: ''{1}'' is a directory", string, svnNgWcToWcCopy$SvnCopyPair.dst);
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
        }
        if (!bl2 && sVNFileType == SVNFileType.DIRECTORY) {
            object2 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot perform 'virtual' {0}: ''{1}'' is a directory", string, svnNgWcToWcCopy$SvnCopyPair.source);
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
        }
        if ((object2 = this.getStatus(file2)) != null && ((SvnStatus)object2).getNodeStatus() != SVNStatusType.STATUS_UNVERSIONED && ((SvnStatus)object2).getNodeStatus() != SVNStatusType.STATUS_ADDED && ((SvnStatus)object2).getNodeStatus() != SVNStatusType.STATUS_REPLACED) {
            object = SVNErrorMessage.create(SVNErrorCode.ENTRY_ATTRIBUTE_INVALID, "Cannot perform 'virtual' {0}: ''{1}'' is scheduled neither for addition nor for replacement", string, file2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if ((object = this.getStatus(file)) == null || ((SvnStatus)object).getNodeStatus() == SVNStatusType.STATUS_UNVERSIONED) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
    }

    private SvnStatus getStatus(File file) {
        String string = SVNFileUtil.getFilePath(file);
        SvnStatus[] svnStatusArray = new SvnStatus[1];
        SvnOperationFactory svnOperationFactory = ((SvnCopy)this.getOperation()).getOperationFactory();
        SvnGetStatus svnGetStatus = svnOperationFactory.createGetStatus();
        svnGetStatus.setDepth(SVNDepth.INFINITY);
        svnGetStatus.setRemote(false);
        svnGetStatus.setReportAll(true);
        svnGetStatus.setReportIgnored(true);
        svnGetStatus.setReportExternals(false);
        svnGetStatus.setApplicalbeChangelists(null);
        svnGetStatus.addTarget(SvnTarget.fromFile(file.getParentFile()));
        svnGetStatus.setReceiver(new SvnNgWcToWcCopy$1(this, string, svnStatusArray));
        svnGetStatus.run();
        return svnStatusArray[0];
    }

    public void move(SVNWCContext sVNWCContext, File file, File file2, boolean bl2) {
        Structure structure;
        boolean bl3 = this.copy(sVNWCContext, file, file2, true);
        if (!bl2) {
            SVNFileUtil.rename(file, file2);
        }
        if ((structure = sVNWCContext.getDb().readInfo(file, StructureFields$NodeInfo.kind, StructureFields$NodeInfo.conflicted)).get(StructureFields$NodeInfo.kind) == ISVNWCDb$SVNWCDbKind.Dir) {
            this.removeAllConflictMarkers(sVNWCContext.getDb(), file, file2);
        }
        if (structure.is(StructureFields$NodeInfo.conflicted)) {
            this.removeAllConflictMarkers(sVNWCContext.getDb(), file, file2);
        }
        SvnNgRemove.delete(this.getWcContext(), file, bl3 ? null : file2, true, false, this);
    }

    private void removeAllConflictMarkers(ISVNWCDb iSVNWCDb, File file, File file2) {
        HashMap hashMap = new HashMap();
        HashSet hashSet = new HashSet();
        iSVNWCDb.readChildren(file, hashMap, hashSet);
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            ISVNWCDb$SVNWCDbInfo iSVNWCDb$SVNWCDbInfo = (ISVNWCDb$SVNWCDbInfo)entry.getValue();
            if (iSVNWCDb$SVNWCDbInfo.conflicted) {
                this.removeNodeConflictMarkers(iSVNWCDb, SVNFileUtil.createFilePath(file, string), SVNFileUtil.createFilePath(file2, string));
            }
            if (iSVNWCDb$SVNWCDbInfo.kind != ISVNWCDb$SVNWCDbKind.Dir) continue;
            this.removeAllConflictMarkers(iSVNWCDb, SVNFileUtil.createFilePath(file, string), SVNFileUtil.createFilePath(file2, string));
        }
    }

    private void removeNodeConflictMarkers(ISVNWCDb iSVNWCDb, File file, File file2) {
        SVNSkel sVNSkel = iSVNWCDb.readConflict(file);
        if (sVNSkel != null) {
            File file3 = SVNFileUtil.getParentFile(file);
            File file4 = SVNFileUtil.getParentFile(file2);
            List list = SvnWcDbConflicts.readConflictMarkers((SVNWCDb)iSVNWCDb, file, sVNSkel);
            if (list != null) {
                for (File file5 : list) {
                    File file6 = SVNFileUtil.skipAncestor(file3, file5);
                    if (file6 == null) continue;
                    File file7 = SVNFileUtil.createFilePath(file4, file6);
                    SVNFileUtil.deleteFile(file7);
                }
            }
        }
    }

    protected boolean copy(SVNWCContext sVNWCContext, File file, File file2, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        File file3;
        ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus;
        File file4;
        Structure structure;
        File file5;
        boolean bl3;
        boolean bl4;
        block40: {
            Object object4;
            Object object5;
            block39: {
                Serializable serializable;
                SvnCopy svnCopy = (SvnCopy)this.getOperation();
                bl4 = svnCopy != null && svnCopy.isMove();
                bl3 = svnCopy == null || svnCopy.isAllowMixedRevisions();
                file5 = SVNFileUtil.getParentFile(file2);
                structure = null;
                try {
                    structure = sVNWCContext.getDb().readInfo(file, StructureFields$NodeInfo.status, StructureFields$NodeInfo.kind, StructureFields$NodeInfo.reposRelPath, StructureFields$NodeInfo.reposRootUrl, StructureFields$NodeInfo.reposUuid, StructureFields$NodeInfo.checksum, StructureFields$NodeInfo.conflicted);
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", (Object)file);
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                    }
                    throw sVNException;
                }
                file4 = sVNWCContext.getDb().getWCRoot(file);
                iSVNWCDb$SVNWCDbStatus = (ISVNWCDb$SVNWCDbStatus)((Object)structure.get(StructureFields$NodeInfo.status));
                switch (iSVNWCDb$SVNWCDbStatus) {
                    case Deleted: {
                        if (bl2) break;
                        serializable = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Deleted node ''{0}'' can''t be copied.", (Object)file);
                        SVNErrorManager.error(serializable, SVNLogType.WC);
                        break;
                    }
                    case Excluded: 
                    case ServerExcluded: 
                    case NotPresent: {
                        serializable = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)file);
                        SVNErrorManager.error(serializable, SVNLogType.WC);
                    }
                }
                if (bl4 && file.equals(file4)) {
                    serializable = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "''{0}'' is the root of a working copy and cannot be moved", (Object)file);
                    SVNErrorManager.error(serializable, SVNLogType.WC);
                }
                serializable = (File)structure.get(StructureFields$NodeInfo.reposRelPath);
                if (bl4 && serializable != null && "".equals(SVNFileUtil.getFilePath((File)serializable))) {
                    object5 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "''{0}'' represents the repository root and cannot be moved", (Object)file);
                    SVNErrorManager.error((SVNErrorMessage)object5, SVNLogType.WC);
                }
                object5 = null;
                try {
                    object5 = sVNWCContext.getDb().readInfo(file5, StructureFields$NodeInfo.status, StructureFields$NodeInfo.reposRootUrl, StructureFields$NodeInfo.reposUuid);
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) break block39;
                    object4 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", (Object)file5);
                    SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.WC);
                }
            }
            SVNURL sVNURL = (SVNURL)((Structure)object5).get(StructureFields$NodeInfo.reposRootUrl);
            object4 = (String)((Structure)object5).get(StructureFields$NodeInfo.reposUuid);
            ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus2 = (ISVNWCDb$SVNWCDbStatus)((Object)((Structure)object5).get(StructureFields$NodeInfo.status));
            ((Structure)object5).release();
            SVNURL sVNURL2 = (SVNURL)structure.get(StructureFields$NodeInfo.reposRootUrl);
            String string = (String)structure.get(StructureFields$NodeInfo.reposUuid);
            file3 = sVNWCContext.getDb().getWCRoot(file5);
            if (sVNURL2 == null) {
                if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Added) {
                    object3 = SvnWcDbShared.scanAddition((SVNWCDb)sVNWCContext.getDb(), file);
                    sVNURL2 = (SVNURL)((Structure)object3).get(StructureFields$AdditionInfo.reposRootUrl);
                    string = (String)((Structure)object3).get(StructureFields$AdditionInfo.reposUuid);
                    ((Structure)object3).release();
                } else {
                    object3 = sVNWCContext.getDb().scanBaseRepository(file, ISVNWCDb$WCDbRepositoryInfo$RepositoryInfoField.rootUrl, ISVNWCDb$WCDbRepositoryInfo$RepositoryInfoField.uuid);
                    sVNURL2 = ((ISVNWCDb$WCDbRepositoryInfo)object3).rootUrl;
                    string = ((ISVNWCDb$WCDbRepositoryInfo)object3).uuid;
                }
            }
            if (sVNURL == null) {
                if (iSVNWCDb$SVNWCDbStatus2 == ISVNWCDb$SVNWCDbStatus.Added) {
                    object3 = SvnWcDbShared.scanAddition((SVNWCDb)sVNWCContext.getDb(), file5);
                    sVNURL = (SVNURL)((Structure)object3).get(StructureFields$AdditionInfo.reposRootUrl);
                    object4 = (String)((Structure)object3).get(StructureFields$AdditionInfo.reposUuid);
                    ((Structure)object3).release();
                } else {
                    object3 = sVNWCContext.getDb().scanBaseRepository(file5, ISVNWCDb$WCDbRepositoryInfo$RepositoryInfoField.rootUrl, ISVNWCDb$WCDbRepositoryInfo$RepositoryInfoField.uuid);
                    sVNURL = ((ISVNWCDb$WCDbRepositoryInfo)object3).rootUrl;
                    object4 = ((ISVNWCDb$WCDbRepositoryInfo)object3).uuid;
                }
            }
            if (sVNURL2 != null && sVNURL != null && !sVNURL2.equals(sVNURL) || string != null && object4 != null && !string.equals(object4)) {
                object3 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is not from repository ''{1}''; it is from ''{2}''", file2, sVNURL2, sVNURL);
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
            }
            if (iSVNWCDb$SVNWCDbStatus2 == ISVNWCDb$SVNWCDbStatus.Deleted) {
                object3 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Cannot copy to ''{0}'', as it is scheduled for deletion", (Object)file2);
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
            }
            try {
                object3 = sVNWCContext.getDb().readInfo(file2, StructureFields$NodeInfo.status);
                object2 = (ISVNWCDb$SVNWCDbStatus)((Object)((Structure)object3).get(StructureFields$NodeInfo.status));
                switch (object2) {
                    case Excluded: {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' is already under version control but is excluded.", (Object)file2);
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                        break;
                    }
                    case ServerExcluded: {
                        object = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' is already under version control", (Object)file2);
                        SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
                        break;
                    }
                    case Deleted: 
                    case NotPresent: {
                        break;
                    }
                    default: {
                        if (bl2) break;
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "There is already a versioned item ''{0}''", (Object)file2);
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                        break;
                    }
                }
                ((Structure)object3).release();
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block40;
                throw sVNException;
            }
        }
        if (!bl2 && (object3 = SVNFileType.getType(file2)) != SVNFileType.NONE) {
            object2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' already exists and is in the way", (Object)file2);
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
        }
        object3 = sVNWCContext.getDb().getWCRootTempDir(file5);
        boolean bl5 = file4.equals(file3);
        boolean bl6 = false;
        if (bl4 && !bl5) {
            bl6 = true;
            bl4 = false;
        }
        if (!bl5) {
            SvnWcDbPristines.transferPristine((SVNWCDb)sVNWCContext.getDb(), file, file3);
        }
        if (structure.get(StructureFields$NodeInfo.kind) == ISVNWCDb$SVNWCDbKind.File || structure.get(StructureFields$NodeInfo.kind) == ISVNWCDb$SVNWCDbKind.Symlink) {
            boolean bl7 = this.shouldCopyBaseData(sVNWCContext, file, bl2, iSVNWCDb$SVNWCDbStatus);
            if (bl7 && ((SvnCopy)this.getOperation()).isVirtual()) {
                this.copyBaseDataOfFile(sVNWCContext, file, file2);
            } else {
                this.copyVersionedFile(sVNWCContext, file, file2, file2, (File)object3, bl2, structure.is(StructureFields$NodeInfo.conflicted), bl4, true);
            }
        } else {
            if (bl4 && iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Normal) {
                object = sVNWCContext.getDb().minMaxRevisions(file, false);
                Object object6 = object[0];
                Object object7 = object[1];
                if (SVNRevision.isValidRevisionNumber((long)object6) && SVNRevision.isValidRevisionNumber((long)object7) && object6 != object7) {
                    if (!bl3) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_MIXED_REVISIONS, "Cannot move mixed-revision subtree ''{0}'' [{1}:{2}]; try updating it first", file, (long)object6, (long)object7);
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                    }
                    bl4 = false;
                    bl6 = true;
                }
            }
            if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Deleted && bl2) {
                object = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot perform 'virtual' {0}: ''{1}'' is a directory", bl4 ? "move" : "copy", file);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            } else {
                this.copyVersionedDirectory(sVNWCContext, file, file2, file2, (File)object3, bl2, bl4, true);
            }
        }
        if (bl4) {
            sVNWCContext.getDb().opHandleMoveBack(file2, file, null);
        }
        sVNWCContext.wqRun(file2);
        return bl6;
    }

    private boolean shouldCopyBaseData(SVNWCContext sVNWCContext, File file, boolean bl2, ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus) {
        if (!bl2) {
            return false;
        }
        if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Deleted) {
            return true;
        }
        SvnStatus svnStatus = SVNStatusEditor17.internalStatus(sVNWCContext, file, true);
        return svnStatus != null && svnStatus.getNodeStatus() == SVNStatusType.STATUS_REPLACED;
    }

    private void copyBaseDataOfFile(SVNWCContext sVNWCContext, File file, File file2) {
        SVNProperties sVNProperties = sVNWCContext.getPristineProps(file);
        ISVNWCDb$WCDbBaseInfo iSVNWCDb$WCDbBaseInfo = sVNWCContext.getDb().getBaseInfo(file, ISVNWCDb$WCDbBaseInfo$BaseInfoField.changedAuthor, ISVNWCDb$WCDbBaseInfo$BaseInfoField.changedDate, ISVNWCDb$WCDbBaseInfo$BaseInfoField.changedRev, ISVNWCDb$WCDbBaseInfo$BaseInfoField.checksum, ISVNWCDb$WCDbBaseInfo$BaseInfoField.revision, ISVNWCDb$WCDbBaseInfo$BaseInfoField.reposRootUrl, ISVNWCDb$WCDbBaseInfo$BaseInfoField.reposUuid);
        String string = iSVNWCDb$WCDbBaseInfo.changedAuthor;
        SVNDate sVNDate = iSVNWCDb$WCDbBaseInfo.changedDate;
        long l2 = iSVNWCDb$WCDbBaseInfo.changedRev;
        SvnChecksum svnChecksum = iSVNWCDb$WCDbBaseInfo.checksum;
        long l3 = iSVNWCDb$WCDbBaseInfo.revision;
        SVNURL sVNURL = iSVNWCDb$WCDbBaseInfo.reposRootUrl;
        String string2 = iSVNWCDb$WCDbBaseInfo.reposUuid;
        sVNWCContext.getDb().opCopyFile(file2, sVNProperties, l2, sVNDate, string, sVNWCContext.getNodeReposRelPath(file.getAbsoluteFile()), sVNURL, string2, l3, svnChecksum, false, null, null, null);
        SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file2, SVNNodeKind.FILE, null, -1L, SVNEventAction.COPY, null, null, null);
        this.handleEvent(sVNEvent);
    }

    private void copyVersionedDirectory(SVNWCContext sVNWCContext, File file, File file2, File file3, File file4, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        Object object2;
        File file5;
        Object object3;
        Object object4;
        HashSet<String> hashSet;
        SVNSkel sVNSkel = null;
        File file6 = SVNFileUtil.getParentFile(file2);
        SVNNodeKind sVNNodeKind = SVNNodeKind.UNKNOWN;
        if (!bl2) {
            hashSet = this.copyToTmpDir(file, file2, file4, false, false);
            sVNSkel = ((SvnNgWcToWcCopy$CopyToTmpDir)((Object)hashSet)).workItem;
            sVNNodeKind = ((SvnNgWcToWcCopy$CopyToTmpDir)((Object)hashSet)).kind;
        }
        sVNWCContext.getDb().opCopy(file, file2, file3, bl3, sVNSkel);
        if (bl4 && sVNWCContext.getEventHandler() != null) {
            hashSet = SVNEventFactory.createSVNEvent(file2, SVNNodeKind.DIR, null, -1L, SVNEventAction.ADD, SVNEventAction.ADD, null, null);
            if (sVNSkel != null) {
                sVNWCContext.wqRun(file6);
            }
            sVNWCContext.getEventHandler().handleEvent((SVNEvent)((Object)hashSet), -1.0);
        }
        hashSet = null;
        if (!bl2 && sVNNodeKind == SVNNodeKind.DIR) {
            object4 = SVNFileListUtil.listFiles(file);
            if (object4 != null) {
                hashSet = new HashSet<String>();
                for (Object object5 : object4) {
                    hashSet.add(SVNFileUtil.getFileName((File)object5));
                }
            } else {
                hashSet = null;
            }
        } else {
            hashSet = null;
        }
        object4 = new HashMap();
        Object object6 = new HashSet();
        sVNWCContext.getDb().readChildren(file, (Map)object4, (Set)object6);
        for (Map.Entry entry : object4.entrySet()) {
            if (sVNWCContext.getEventHandler() != null) {
                sVNWCContext.getEventHandler().checkCancelled();
            }
            String string = (String)entry.getKey();
            object3 = (ISVNWCDb$SVNWCDbInfo)entry.getValue();
            file5 = SVNFileUtil.createFilePath(file, string);
            object2 = SVNFileUtil.createFilePath(file2, string);
            if (((ISVNWCDb$SVNWCDbInfo)object3).opRoot) {
                sVNWCContext.getDb().opCopyShadowedLayer(file5, (File)object2, bl3);
            }
            if (((ISVNWCDb$SVNWCDbInfo)object3).status == ISVNWCDb$SVNWCDbStatus.Normal || ((ISVNWCDb$SVNWCDbInfo)object3).status == ISVNWCDb$SVNWCDbStatus.Added) {
                if (((ISVNWCDb$SVNWCDbInfo)object3).kind == ISVNWCDb$SVNWCDbKind.File) {
                    if (!((ISVNWCDb$SVNWCDbInfo)object3).fileExternal) {
                        this.copyVersionedFile(sVNWCContext, file5, (File)object2, file3, file4, bl2, ((ISVNWCDb$SVNWCDbInfo)object3).conflicted, bl3, false);
                    }
                } else if (((ISVNWCDb$SVNWCDbInfo)object3).kind == ISVNWCDb$SVNWCDbKind.Dir) {
                    this.copyVersionedDirectory(sVNWCContext, file5, (File)object2, file3, file4, bl2, bl3, false);
                } else {
                    object = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "cannot handle node kind for ''{0}''", (Object)file5);
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
                }
            } else if (((ISVNWCDb$SVNWCDbInfo)object3).status == ISVNWCDb$SVNWCDbStatus.Deleted || ((ISVNWCDb$SVNWCDbInfo)object3).status == ISVNWCDb$SVNWCDbStatus.NotPresent || ((ISVNWCDb$SVNWCDbInfo)object3).status == ISVNWCDb$SVNWCDbStatus.Excluded) {
                sVNWCContext.getDb().opCopy(file5, (File)object2, file3, bl3, null);
            } else if (((ISVNWCDb$SVNWCDbInfo)object3).status == ISVNWCDb$SVNWCDbStatus.Incomplete) {
                object = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot handle status of ''{0}''", (Object)file5);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            } else {
                assert (((ISVNWCDb$SVNWCDbInfo)object3).status == ISVNWCDb$SVNWCDbStatus.ServerExcluded);
                object = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot copy ''{0}'' excluded by server", (Object)file5);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            if (hashSet == null || ((ISVNWCDb$SVNWCDbInfo)object3).status != ISVNWCDb$SVNWCDbStatus.Normal && ((ISVNWCDb$SVNWCDbInfo)object3).status != ISVNWCDb$SVNWCDbStatus.Added) continue;
            hashSet.remove(string);
        }
        if (hashSet != null && hashSet.size() > 0) {
            List list = sVNWCContext.getDb().getConflictMarkerFiles(file);
            sVNSkel = null;
            for (String string : hashSet) {
                String string2 = SVNPathUtil.tail(string);
                if (string2.equals(SVNFileUtil.getAdminDirectoryName())) continue;
                if (sVNWCContext.getEventHandler() != null) {
                    sVNWCContext.getEventHandler().checkCancelled();
                }
                object3 = SVNFileUtil.createFilePath(file, string2);
                file5 = SVNFileUtil.createFilePath(file2, string2);
                if (list != null && list.contains(object3)) continue;
                object2 = this.copyToTmpDir((File)object3, file5, file4, true, true);
                object = ((SvnNgWcToWcCopy$CopyToTmpDir)object2).workItem;
                if (object == null) continue;
                sVNSkel = SVNWCContext.wqMerge(sVNSkel, (SVNSkel)object);
            }
            sVNWCContext.getDb().addWorkQueue(file2, sVNSkel);
        }
    }

    private void copyVersionedFile(SVNWCContext sVNWCContext, File file, File file2, File file3, File file4, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Object object;
        SVNSkel sVNSkel = null;
        if (!bl2) {
            Object object2;
            object = file;
            boolean bl6 = false;
            if (bl3) {
                File file5;
                object2 = sVNWCContext.getDb().readConflict(file);
                try {
                    Structure structure = SvnWcDbConflicts.readTextConflict(sVNWCContext.getDb(), file, (SVNSkel)object2);
                    file5 = (File)structure.get(SvnWcDbConflicts$TextConflictInfo.mineAbsPath);
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_MISSING) {
                        throw sVNException;
                    }
                    file5 = null;
                }
                if (file5 != null && SVNFileType.getType(file5) == SVNFileType.FILE) {
                    bl6 = true;
                    object = file5;
                }
            }
            object2 = this.copyToTmpDir((File)object, file2, file4, true, bl6);
            sVNSkel = ((SvnNgWcToWcCopy$CopyToTmpDir)object2).workItem;
        }
        sVNWCContext.getDb().opCopy(file, file2, file3, bl4, sVNSkel);
        sVNWCContext.wqRun(SVNFileUtil.getParentFile(file2));
        if (bl5) {
            if (sVNSkel != null) {
                this.getWcContext().wqRun(file2);
            }
            object = SVNEventFactory.createSVNEvent(file2, SVNNodeKind.FILE, null, -1L, SVNEventAction.ADD, SVNEventAction.ADD, null, null, 1L, 1L);
            this.handleEvent((SVNEvent)object, -1.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SvnNgWcToWcCopy$CopyToTmpDir copyToTmpDir(File file, File file2, File file3, boolean bl2, boolean bl3) {
        Serializable serializable;
        boolean bl4;
        boolean bl5 = false;
        SvnNgWcToWcCopy$CopyToTmpDir svnNgWcToWcCopy$CopyToTmpDir = new SvnNgWcToWcCopy$CopyToTmpDir();
        svnNgWcToWcCopy$CopyToTmpDir.workItem = null;
        SVNFileType sVNFileType = SVNFileType.getType(file);
        svnNgWcToWcCopy$CopyToTmpDir.kind = SVNFileType.getNodeKind(sVNFileType);
        boolean bl6 = bl4 = sVNFileType == SVNFileType.SYMLINK;
        if (svnNgWcToWcCopy$CopyToTmpDir.kind == SVNNodeKind.NONE) {
            return svnNgWcToWcCopy$CopyToTmpDir;
        }
        if (svnNgWcToWcCopy$CopyToTmpDir.kind == SVNNodeKind.UNKNOWN) {
            serializable = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "Source ''{0}'' is unexpected kind", (Object)file);
            SVNErrorManager.error(serializable, SVNLogType.WC);
        } else {
            bl5 = svnNgWcToWcCopy$CopyToTmpDir.kind == SVNNodeKind.DIR;
        }
        serializable = null;
        try {
            if (bl2 && !bl3) {
                boolean bl7;
                boolean bl8 = bl7 = this.getWcContext().isTextModified(file, false) || this.getWcContext().isPropsModified(file);
                if (!bl7) {
                    svnNgWcToWcCopy$CopyToTmpDir.workItem = this.getWcContext().wqBuildFileInstall(file2, null, false, true);
                    SvnNgWcToWcCopy$CopyToTmpDir svnNgWcToWcCopy$CopyToTmpDir2 = svnNgWcToWcCopy$CopyToTmpDir;
                    return svnNgWcToWcCopy$CopyToTmpDir2;
                }
            }
            Serializable serializable2 = serializable = svnNgWcToWcCopy$CopyToTmpDir.kind == SVNNodeKind.DIR ? SVNFileUtil.createUniqueDir(file3, SVNFileUtil.getFileName(file), ".tmp", false) : SVNFileUtil.createUniqueFile(file3, SVNFileUtil.getFileName(file), ".tmp", false);
            if (svnNgWcToWcCopy$CopyToTmpDir.kind == SVNNodeKind.DIR) {
                if (bl2) {
                    SVNFileUtil.copyDirectory(file, (File)serializable, false, ((SvnCopy)this.getOperation()).getEventHandler());
                } else {
                    SVNFileUtil.ensureDirectoryExists((File)serializable);
                }
            } else if (!bl4) {
                SVNFileUtil.copyFile(file, (File)serializable, false, true);
            } else {
                SVNFileUtil.deleteFile((File)serializable);
                SVNFileUtil.copySymlink(file, (File)serializable);
            }
            if (bl2) {
                SVNFileUtil.setReadonly((File)serializable, false);
            }
            svnNgWcToWcCopy$CopyToTmpDir.workItem = this.getWcContext().wqBuildFileMove(file2, (File)serializable, file2);
            SvnNgWcToWcCopy$CopyToTmpDir svnNgWcToWcCopy$CopyToTmpDir3 = svnNgWcToWcCopy$CopyToTmpDir;
            return svnNgWcToWcCopy$CopyToTmpDir3;
        }
        finally {
            if (serializable != null && bl5 && svnNgWcToWcCopy$CopyToTmpDir.kind == SVNNodeKind.FILE) {
                SVNFileUtil.deleteFile((File)serializable);
            }
        }
    }
}

