/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNExternalsUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNCommitter17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo$BaseInfoField;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeOriginInfo;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgCommitUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgCommitUtil$ISvnUrlKindCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgWcToReposCopy$SvnCopyPair;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnCommitItem;
import org.tmatesoft.svn.core.wc2.SvnCommitPacket;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnRemoteCopy;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.hooks.ISvnCommitHandler;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgWcToReposCopy
extends SvnNgOperationRunner
implements SvnNgCommitUtil$ISvnUrlKindCallback {
    public boolean isApplicable(SvnRemoteCopy svnRemoteCopy, SvnWcGeneration svnWcGeneration) {
        return this.areAllSourcesLocal(svnRemoteCopy) && !svnRemoteCopy.getFirstTarget().isLocal();
    }

    private boolean areAllSourcesLocal(SvnRemoteCopy svnRemoteCopy) {
        for (SvnCopySource svnCopySource : svnRemoteCopy.getSources()) {
            if (svnCopySource.getSource().isFile() && (svnCopySource.getRevision() == SVNRevision.WORKING || svnCopySource.getRevision() == SVNRevision.UNDEFINED)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected SVNCommitInfo run(SVNWCContext sVNWCContext) {
        SVNCommitInfo sVNCommitInfo = null;
        try {
            sVNCommitInfo = this.doRun(sVNWCContext, ((SvnRemoteCopy)this.getOperation()).getFirstTarget().getURL());
        }
        catch (SVNException sVNException) {
            SVNErrorCode sVNErrorCode = sVNException.getErrorMessage().getErrorCode();
            if (!(((SvnRemoteCopy)this.getOperation()).isFailWhenDstExists() || ((SvnRemoteCopy)this.getOperation()).getSources().size() != 1 || sVNErrorCode != SVNErrorCode.ENTRY_EXISTS && sVNErrorCode != SVNErrorCode.FS_ALREADY_EXISTS)) {
                SvnCopySource svnCopySource = (SvnCopySource)((SvnRemoteCopy)this.getOperation()).getSources().iterator().next();
                SVNURL sVNURL = ((SvnRemoteCopy)this.getOperation()).getFirstTarget().getURL();
                sVNURL = sVNURL.appendPath(svnCopySource.getSource().getFile().getName(), false);
                sVNCommitInfo = this.doRun(sVNWCContext, sVNURL);
            }
            throw sVNException;
        }
        if (sVNCommitInfo != null) {
            ((SvnRemoteCopy)this.getOperation()).receive(((SvnRemoteCopy)this.getOperation()).getFirstTarget(), sVNCommitInfo);
        }
        return sVNCommitInfo;
    }

    protected SVNCommitInfo doRun(SVNWCContext sVNWCContext, SVNURL sVNURL) {
        Object object;
        if (((SvnRemoteCopy)this.getOperation()).isMove()) {
            object = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Moves between the working copy and the repository are not supported");
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = ((SvnRemoteCopy)this.getOperation()).getSources();
        ArrayList<SvnNgWcToReposCopy$SvnCopyPair> arrayList = new ArrayList<SvnNgWcToReposCopy$SvnCopyPair>();
        if (object.size() > 1) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                SvnCopySource svnCopySource = (SvnCopySource)iterator.next();
                SvnNgWcToReposCopy$SvnCopyPair svnNgWcToReposCopy$SvnCopyPair = new SvnNgWcToReposCopy$SvnCopyPair(null);
                svnNgWcToReposCopy$SvnCopyPair.source = svnCopySource.getSource().getFile();
                String string = svnNgWcToReposCopy$SvnCopyPair.source.getName();
                svnNgWcToReposCopy$SvnCopyPair.dst = sVNURL;
                svnNgWcToReposCopy$SvnCopyPair.dst = svnNgWcToReposCopy$SvnCopyPair.dst.appendPath(string, false);
                arrayList.add(svnNgWcToReposCopy$SvnCopyPair);
            }
        } else if (object.size() == 1) {
            SvnNgWcToReposCopy$SvnCopyPair svnNgWcToReposCopy$SvnCopyPair = new SvnNgWcToReposCopy$SvnCopyPair(null);
            SvnCopySource svnCopySource = (SvnCopySource)object.iterator().next();
            svnNgWcToReposCopy$SvnCopyPair.source = svnCopySource.getSource().getFile();
            svnNgWcToReposCopy$SvnCopyPair.dst = sVNURL;
            arrayList.add(svnNgWcToReposCopy$SvnCopyPair);
        }
        return this.copy(arrayList, ((SvnRemoteCopy)this.getOperation()).isMakeParents(), ((SvnRemoteCopy)this.getOperation()).getRevisionProperties(), ((SvnRemoteCopy)this.getOperation()).getCommitMessage(), ((SvnRemoteCopy)this.getOperation()).getCommitHandler());
    }

    private SVNCommitInfo copy(Collection collection, boolean bl2, SVNProperties sVNProperties, String string, ISvnCommitHandler iSvnCommitHandler) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object52;
        TreeMap treeMap;
        Object object62;
        Object object7;
        Object object82;
        SvnNgWcToReposCopy$SvnCopyPair svnNgWcToReposCopy$SvnCopyPair = (SvnNgWcToReposCopy$SvnCopyPair)collection.iterator().next();
        SVNURL sVNURL = svnNgWcToReposCopy$SvnCopyPair.dst.removePathTail();
        for (Object object82 : collection) {
            sVNURL = SVNURLUtil.getCommonURLAncestor(sVNURL, ((SvnNgWcToReposCopy$SvnCopyPair)object82).dst);
        }
        File file = this.getCommonCopyAncestor(collection);
        object82 = this.getRepositoryAccess().createRepository(sVNURL, file);
        sVNURL = ((SVNRepository)object82).getLocation();
        Collection collection2 = null;
        if (bl2) {
            collection2 = this.findMissingParents(sVNURL, (SVNRepository)object82);
        }
        for (SvnNgWcToReposCopy$SvnCopyPair svnNgWcToReposCopy$SvnCopyPair2 : collection) {
            object7 = SVNURLUtil.getRelativeURL(((SVNRepository)object82).getLocation(), svnNgWcToReposCopy$SvnCopyPair2.dst, false);
            if (((SVNRepository)object82).checkPath((String)object7, -1L) == SVNNodeKind.NONE) continue;
            object62 = SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "Path ''{0}'' already exists", (Object)svnNgWcToReposCopy$SvnCopyPair2.dst);
            SVNErrorManager.error((SVNErrorMessage)object62, SVNLogType.WC);
        }
        SvnCommitItem[] svnCommitItemArray = new SvnCommitItem[(collection2 != null ? collection2.size() : 0) + collection.size()];
        int n2 = 0;
        if (bl2 && collection2 != null) {
            for (Object object62 : collection2) {
                treeMap = new SvnCommitItem();
                ((SvnCommitItem)((Object)treeMap)).setUrl((SVNURL)object62);
                ((SvnCommitItem)((Object)treeMap)).setFlags(1);
                ((SvnCommitItem)((Object)treeMap)).setKind(SVNNodeKind.DIR);
                svnCommitItemArray[n2++] = treeMap;
            }
        }
        for (Object object62 : collection) {
            treeMap = new SvnCommitItem();
            ((SvnCommitItem)((Object)treeMap)).setUrl(((SvnNgWcToReposCopy$SvnCopyPair)object62).dst);
            ((SvnCommitItem)((Object)treeMap)).setPath(((SvnNgWcToReposCopy$SvnCopyPair)object62).source);
            ((SvnCommitItem)((Object)treeMap)).setFlags(1);
            ((SvnCommitItem)((Object)treeMap)).setKind(SVNNodeKind.DIR);
            svnCommitItemArray[n2++] = treeMap;
        }
        string = ((SvnRemoteCopy)this.getOperation()).getCommitHandler().getCommitMessage(string, svnCommitItemArray);
        if (string == null) {
            return SVNCommitInfo.NULL;
        }
        string = SVNCommitUtil.validateCommitMessage(string);
        sVNProperties = ((SvnRemoteCopy)this.getOperation()).getCommitHandler().getRevisionProperties(string, svnCommitItemArray, sVNProperties);
        if (sVNProperties == null) {
            return SVNCommitInfo.NULL;
        }
        object7 = new SvnCommitPacket();
        object62 = ((SVNRepository)object82).getRepositoryRoot(true);
        if (collection2 != null) {
            for (Object object52 : collection2) {
                object4 = SVNURLUtil.getRelativeURL((SVNURL)object62, (SVNURL)object52, false);
                ((SvnCommitPacket)object7).addItem(null, SVNNodeKind.DIR, (SVNURL)object62, (String)object4, -1L, null, -1L, null, 1);
            }
        }
        for (Object object52 : collection) {
            Map map;
            object4 = ((SvnRemoteCopy)this.getOperation()).getExternalsHandler() != null ? new HashMap() : null;
            SvnNgCommitUtil.harvestCopyCommitables(this.getWcContext(), ((SvnNgWcToReposCopy$SvnCopyPair)object52).source, ((SvnNgWcToReposCopy$SvnCopyPair)object52).dst, (SvnCommitPacket)object7, this, ((SvnRemoteCopy)this.getOperation()).getCommitParameters(), (Map)object4);
            object3 = ((SvnCommitPacket)object7).getItem(((SvnNgWcToReposCopy$SvnCopyPair)object52).source);
            if (object3 == null) continue;
            object2 = this.calculateTargetMergeInfo(((SvnNgWcToReposCopy$SvnCopyPair)object52).source, -1L, (SVNRepository)object82);
            object = this.getWcContext().getProperty(((SvnNgWcToReposCopy$SvnCopyPair)object52).source, "svn:mergeinfo");
            Map map2 = map = object != null ? SVNMergeInfoUtil.parseMergeInfo(new StringBuffer((String)object), null) : null;
            if (map != null && object2 != null) {
                object2 = SVNMergeInfoUtil.mergeMergeInfos((Map)object2, map);
            } else if (object2 == null) {
                object2 = map;
            }
            String string2 = null;
            if (object2 != null) {
                string2 = SVNMergeInfoUtil.formatMergeInfoToString(map, null);
                ((SvnCommitItem)object3).addOutgoingProperty("svn:mergeinfo", SVNPropertyValue.create(string2));
            }
            if (object4 != null && !object4.isEmpty()) {
                this.includeExternalsChanges((SVNRepository)object82, (SvnCommitPacket)object7, (Map)object4, (SvnNgWcToReposCopy$SvnCopyPair)object52);
            }
            if (!((SvnRemoteCopy)this.getOperation()).isPinExternals()) continue;
            Map map3 = SVNExternalsUtil.resolvePinnedExternals(this.getWcContext(), this.getRepositoryAccess(), ((SvnRemoteCopy)this.getOperation()).getExternalsToPin(), SvnTarget.fromFile(((SvnNgWcToReposCopy$SvnCopyPair)object52).source), SvnTarget.fromURL(((SvnNgWcToReposCopy$SvnCopyPair)object52).dst), -1L, (SVNRepository)object82, (SVNURL)object62);
            for (Map.Entry entry : map3.entrySet()) {
                SVNURL sVNURL2;
                SVNURL sVNURL3;
                String string3 = (String)entry.getKey();
                SVNPropertyValue sVNPropertyValue = (SVNPropertyValue)entry.getValue();
                boolean bl3 = true;
                if (bl3) {
                    sVNURL3 = ((SvnNgWcToReposCopy$SvnCopyPair)object52).dst;
                } else {
                    sVNURL2 = null;
                    sVNURL3 = this.getWcContext().getNodeUrl((File)((Object)sVNURL2));
                }
                sVNURL2 = sVNURL3.appendPath(string3, false);
                File file2 = SVNFileUtil.createFilePath(((SvnNgWcToReposCopy$SvnCopyPair)object52).source, string3);
                this.queuePropChangeCommitItems(file2, sVNURL2, (SvnCommitPacket)object7, "svn:externals", sVNPropertyValue, (SVNURL)object62);
            }
        }
        if (((SvnRemoteCopy)this.getOperation()).isDisableLocalModifications()) {
            treeMap = object7;
            if (((SvnCommitPacket)(object7 = this.filterLocalModifications((SvnCommitPacket)object7))).isEmpty()) {
                object52 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, this.buildErrorMessageWithDebugInformation((SvnCommitPacket)((Object)treeMap)));
                SVNErrorManager.error((SVNErrorMessage)object52, SVNLogType.DEFAULT);
            }
        }
        treeMap = new TreeMap();
        object52 = SvnNgCommitUtil.translateCommitables(((SvnCommitPacket)object7).getItems((SVNURL)((SvnCommitPacket)object7).getRepositoryRoots().iterator().next()), treeMap);
        ((SVNRepository)object82).setLocation((SVNURL)object52, false);
        object4 = ((SVNRepository)object82).getCommitEditor(string, null, false, sVNProperties, null);
        object3 = new SVNCommitter17(this.getWcContext(), treeMap, (SVNURL)object62, null, null, null);
        SVNCommitUtil.driveCommitEditor((ISVNCommitPathHandler)object3, treeMap.keySet(), (ISVNEditor)object4, -1L);
        ((SVNCommitter17)object3).sendTextDeltas((ISVNEditor)object4);
        object2 = SVNEventFactory.createSVNEvent(null, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.COMMIT_FINALIZING, SVNEventAction.COMMIT_FINALIZING, null, null);
        ((SVNEvent)object2).setURL((SVNURL)object52);
        this.handleEvent((SVNEvent)object2);
        object = object4.closeEdit();
        this.deleteDeleteFiles((SVNCommitter17)object3, ((SvnRemoteCopy)this.getOperation()).getCommitParameters());
        return object;
    }

    private void queuePropChangeCommitItems(File file, SVNURL sVNURL, SvnCommitPacket svnCommitPacket, String string, SVNPropertyValue sVNPropertyValue, SVNURL sVNURL2) {
        SvnCommitItem svnCommitItem = null;
        Collection collection = svnCommitPacket.getItems(sVNURL2);
        for (SvnCommitItem svnCommitItem2 : collection) {
            if (!svnCommitItem2.getUrl().equals(sVNURL)) continue;
            svnCommitItem = svnCommitItem2;
            break;
        }
        if (svnCommitItem == null) {
            svnCommitItem = new SvnCommitItem();
            svnCommitItem.setPath(file);
            svnCommitItem.setUrl(sVNURL);
            svnCommitItem.setKind(SVNNodeKind.DIR);
            svnCommitItem.setFlags(8);
            svnCommitPacket.addItem(svnCommitItem, sVNURL2);
        } else {
            svnCommitItem.setFlags(svnCommitItem.getFlags() | 8);
        }
        svnCommitItem.addOutgoingProperty(string, sVNPropertyValue);
    }

    private String buildErrorMessageWithDebugInformation(SvnCommitPacket svnCommitPacket) {
        StringBuilder stringBuilder = new StringBuilder("Unable to perform wc to remote copy without local modifications:").append('\n');
        stringBuilder.append("Commit packet was:").append('\n');
        Collection collection = svnCommitPacket.getRepositoryRoots();
        for (SVNURL sVNURL : collection) {
            stringBuilder.append(sVNURL).append("  :").append('\n');
            Collection collection2 = svnCommitPacket.getItems(sVNURL);
            if (collection2 == null) continue;
            for (SvnCommitItem svnCommitItem : collection2) {
                stringBuilder.append("path=").append(svnCommitItem.getPath()).append('\n');
                stringBuilder.append("kind=").append(svnCommitItem.getKind()).append('\n');
                stringBuilder.append("url=").append(svnCommitItem.getUrl()).append('\n');
                stringBuilder.append("revision=").append(svnCommitItem.getRevision()).append('\n');
                stringBuilder.append("copyUrl=").append(svnCommitItem.getCopyFromUrl()).append('\n');
                stringBuilder.append("copyRevision=").append(svnCommitItem.getCopyFromRevision()).append('\n');
                stringBuilder.append("flags=").append(svnCommitItem.getFlags()).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    private SvnCommitPacket filterLocalModifications(SvnCommitPacket svnCommitPacket) {
        SvnCommitPacket svnCommitPacket2 = new SvnCommitPacket();
        svnCommitPacket2.setLockTokens(svnCommitPacket.getLockTokens());
        svnCommitPacket2.setLockingContext(svnCommitPacket.getRunner(), svnCommitPacket.getLockingContext());
        Collection collection = svnCommitPacket.getRepositoryRoots();
        for (SVNURL sVNURL : collection) {
            Collection collection2 = svnCommitPacket.getItems(sVNURL);
            for (SvnCommitItem svnCommitItem : collection2) {
                if (svnCommitItem.hasFlag(2)) continue;
                if (svnCommitItem.hasFlag(1)) {
                    ISVNWCDb$WCDbBaseInfo iSVNWCDb$WCDbBaseInfo;
                    SVNURL sVNURL2;
                    if (!svnCommitItem.hasFlag(16) || (sVNURL2 = svnCommitItem.getCopyFromUrl()) == null) continue;
                    try {
                        iSVNWCDb$WCDbBaseInfo = this.getWcContext().getDb().getBaseInfo(svnCommitItem.getPath(), ISVNWCDb$WCDbBaseInfo$BaseInfoField.reposRootUrl, ISVNWCDb$WCDbBaseInfo$BaseInfoField.reposRelPath);
                    }
                    catch (SVNException sVNException) {
                        if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) continue;
                        throw sVNException;
                    }
                    SVNURL sVNURL3 = iSVNWCDb$WCDbBaseInfo.reposRootUrl.appendPath(SVNFileUtil.getFilePath(iSVNWCDb$WCDbBaseInfo.reposRelPath), false);
                    if (!sVNURL2.equals(sVNURL3)) continue;
                }
                svnCommitItem.setFlags(svnCommitItem.getFlags() & 0xFFFFFFFB & 0xFFFFFFF7);
                svnCommitPacket2.addItem(svnCommitItem, sVNURL);
            }
        }
        return svnCommitPacket2;
    }

    /*
     * WARNING - void declaration
     */
    private void includeExternalsChanges(SVNRepository sVNRepository, SvnCommitPacket svnCommitPacket, Map map, SvnNgWcToReposCopy$SvnCopyPair svnNgWcToReposCopy$SvnCopyPair) {
        for (File file : map.keySet()) {
            Object object;
            String string = (String)map.get(file);
            SVNExternal[] sVNExternalArray = SVNExternal.parseExternals(file.getAbsolutePath(), string);
            boolean bl2 = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            SVNURL sVNURL = this.getWcContext().getNodeUrl(file);
            if (sVNURL == null) continue;
            long l2 = this.getWcContext().getNodeBaseRev(file);
            File file2 = this.getWcContext().getNodeReposRelPath(file);
            File file3 = this.getWcContext().getNodeReposRelPath(svnNgWcToReposCopy$SvnCopyPair.source);
            String string2 = SVNWCUtils.getPathAsChild(file3, file2);
            SVNURL sVNURL2 = svnNgWcToReposCopy$SvnCopyPair.dst.appendPath(string2, false);
            for (int i2 = 0; i2 < sVNExternalArray.length; ++i2) {
                void var20_23;
                SVNRevision[] sVNRevisionArray;
                object = new File(file, sVNExternalArray[i2].getPath());
                SVNRevision sVNRevision = SVNRevision.UNDEFINED;
                try {
                    long l3 = this.getWcContext().getNodeBaseRev((File)object);
                    if (l3 >= 0L) {
                        SVNRevision sVNRevision2 = SVNRevision.create(l3);
                    }
                }
                catch (SVNException sVNException) {
                    // empty catch block
                }
                SVNURL sVNURL3 = sVNExternalArray[i2].resolveURL(sVNRepository.getRepositoryRoot(true), sVNURL);
                String string3 = sVNExternalArray[i2].getUnresolvedUrl();
                if (string3 != null && !SVNPathUtil.isURL(string3) && string3.startsWith("../")) {
                    string3 = SVNURLUtil.getRelativeURL(sVNRepository.getRepositoryRoot(true), sVNURL3, true);
                    string3 = string3.startsWith("/") ? "^" + string3 : "^/" + string3;
                }
                if ((sVNRevisionArray = ((SvnRemoteCopy)this.getOperation()).getExternalsHandler().handleExternal((File)object, sVNURL3, sVNExternalArray[i2].getRevision(), sVNExternalArray[i2].getPegRevision(), sVNExternalArray[i2].getRawValue(), (SVNRevision)var20_23)) != null && sVNRevisionArray.length == 2 && !sVNRevisionArray[0].equals(sVNExternalArray[i2].getRevision())) {
                    SVNExternal sVNExternal = new SVNExternal(sVNExternalArray[i2].getPath(), string3, sVNRevisionArray[1], sVNRevisionArray[0], true, sVNExternalArray[i2].isPegRevisionExplicit(), sVNExternalArray[i2].isNewFormat());
                    arrayList.add(sVNExternal.toString());
                    if (bl2) continue;
                    bl2 = true;
                    continue;
                }
                if (sVNRevisionArray == null) continue;
                arrayList.add(sVNExternalArray[i2].getRawValue());
            }
            if (!bl2) continue;
            String string4 = "";
            for (String string5 : arrayList) {
                string4 = string4 + string5 + '\n';
            }
            object = svnCommitPacket.getItem(file);
            if (object == null) {
                object = svnCommitPacket.addItem(file, sVNRepository.getRepositoryRoot(true), SVNNodeKind.DIR, sVNURL2, -1L, sVNURL, l2, 8);
            }
            ((SvnCommitItem)object).addOutgoingProperty("svn:externals", SVNPropertyValue.create(string4));
        }
    }

    private Collection findMissingParents(SVNURL sVNURL, SVNRepository sVNRepository) {
        SVNNodeKind sVNNodeKind = sVNRepository.checkPath("", -1L);
        ArrayList<SVNURL> arrayList = new ArrayList<SVNURL>();
        while (sVNNodeKind == SVNNodeKind.NONE) {
            arrayList.add(sVNURL);
            sVNURL = sVNURL.removePathTail();
            sVNRepository.setLocation(sVNURL, false);
            sVNNodeKind = sVNRepository.checkPath("", -1L);
        }
        if (sVNNodeKind != SVNNodeKind.DIR) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "Path ''{0}'' already exists, but it is not a directory", (Object)sVNURL);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        return arrayList;
    }

    private File getCommonCopyAncestor(Collection collection) {
        File file = null;
        for (SvnNgWcToReposCopy$SvnCopyPair svnNgWcToReposCopy$SvnCopyPair : collection) {
            if (file == null) {
                file = svnNgWcToReposCopy$SvnCopyPair.source;
                continue;
            }
            String string = file.getAbsolutePath().replace(File.separatorChar, '/');
            String string2 = svnNgWcToReposCopy$SvnCopyPair.source.getAbsolutePath().replace(File.separatorChar, '/');
            string = SVNPathUtil.getCommonPathAncestor(string, string2);
            file = new File(string);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map calculateTargetMergeInfo(File file, long l2, SVNRepository sVNRepository) {
        SVNURL sVNURL = null;
        SVNURL sVNURL2 = null;
        Structure structure = this.getWcContext().getNodeOrigin(file, false, StructureFields$NodeOriginInfo.revision, StructureFields$NodeOriginInfo.reposRelpath, StructureFields$NodeOriginInfo.reposRootUrl);
        if (structure != null && structure.get(StructureFields$NodeOriginInfo.reposRelpath) != null) {
            sVNURL = (SVNURL)structure.get(StructureFields$NodeOriginInfo.reposRootUrl);
            sVNURL = SVNWCUtils.join(sVNURL, (File)structure.get(StructureFields$NodeOriginInfo.reposRelpath));
            l2 = structure.lng(StructureFields$NodeOriginInfo.revision);
        }
        if (sVNURL != null) {
            Map map = null;
            SVNRepository sVNRepository2 = sVNRepository;
            try {
                String string = this.getRepositoryAccess().getPathRelativeToSession(sVNURL, null, sVNRepository2);
                if (string == null) {
                    sVNURL2 = sVNRepository2.getLocation();
                    sVNRepository2.setLocation(sVNURL, false);
                    string = "";
                }
                map = this.getRepositoryAccess().getReposMergeInfo(sVNRepository2, string, l2, SVNMergeInfoInheritance.INHERITED, true);
                if (sVNRepository == null) {
                    sVNRepository2.closeSession();
                } else if (sVNURL2 != null) {
                    sVNRepository2.setLocation(sVNURL2, false);
                }
            }
            catch (Throwable throwable) {
                if (sVNRepository == null) {
                    sVNRepository2.closeSession();
                } else if (sVNURL2 != null) {
                    sVNRepository2.setLocation(sVNURL2, false);
                }
                throw throwable;
            }
            return map;
        }
        return null;
    }

    @Override
    public SVNNodeKind getUrlKind(SVNURL sVNURL, long l2) {
        return this.getRepositoryAccess().createRepository(sVNURL, null).checkPath("", l2);
    }
}

