/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema$ACTUAL_NODE__Fields;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema$NODES__Fields;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb$1;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb$2;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb$Bumpable;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb$bumpTo20;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb$bumpTo21;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb$bumpTo22;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb$bumpTo23;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb$bumpTo24;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb$bumpTo25;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb$bumpTo26;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb$bumpTo27;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb$bumpTo28;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb$bumpTo29;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb$bumpTo30;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb$bumpTo31;
import org.tmatesoft.svn.core.internal.wc2.old.SvnOldUpgrade;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgUpgradeSDb {
    private static String PRISTINE_STORAGE_EXT = ".svn-base";
    private static int PRISTINE_BASENAME_OLD_LEN = 40;

    private static String versionStringFromFormat(int n2) {
        switch (n2) {
            case 4: {
                return "<=1.3";
            }
            case 8: {
                return "1.4";
            }
            case 9: {
                return "1.5";
            }
            case 10: {
                return "1.6";
            }
        }
        return "(unreleased development version)";
    }

    public static int upgrade(File file, SVNWCDb sVNWCDb, SVNSqlJetDb sVNSqlJetDb, int n2, ISVNEventHandler iSVNEventHandler) {
        Object object;
        int n3 = 0;
        if (n2 < 12) {
            object = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Working copy ''{0}'' is too old (format {1}, created by Subversion {2})", file, n2, SvnNgUpgradeSDb.versionStringFromFormat(n2));
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (n2 < 19) {
            object = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Working copy ''{0}'' is an old development version (format {1}); to upgrade it, use a format 18 client, then use ''tools/dev/wc-ng/bump-to-19.py'', then use the current client", (Object)file, n2);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        switch (n2) {
            case 19: {
                SvnNgUpgradeSDb.runBump(sVNWCDb, sVNSqlJetDb, file, new SvnNgUpgradeSDb$bumpTo20(null));
                n3 = 20;
            }
            case 20: {
                SvnNgUpgradeSDb.runBump(sVNWCDb, sVNSqlJetDb, file, new SvnNgUpgradeSDb$bumpTo21(null));
                n3 = 21;
            }
            case 21: {
                SvnNgUpgradeSDb.runBump(sVNWCDb, sVNSqlJetDb, file, new SvnNgUpgradeSDb$bumpTo22());
                n3 = 22;
            }
            case 22: {
                SvnNgUpgradeSDb.runBump(sVNWCDb, sVNSqlJetDb, file, new SvnNgUpgradeSDb$bumpTo23());
                n3 = 23;
            }
            case 23: {
                SvnNgUpgradeSDb.runBump(sVNWCDb, sVNSqlJetDb, file, new SvnNgUpgradeSDb$bumpTo24());
                n3 = 24;
            }
            case 24: {
                SvnNgUpgradeSDb.runBump(sVNWCDb, sVNSqlJetDb, file, new SvnNgUpgradeSDb$bumpTo25());
                n3 = 25;
            }
            case 25: {
                SvnNgUpgradeSDb.runBump(sVNWCDb, sVNSqlJetDb, file, new SvnNgUpgradeSDb$bumpTo26(null));
                n3 = 26;
            }
            case 26: {
                SvnNgUpgradeSDb.runBump(sVNWCDb, sVNSqlJetDb, file, new SvnNgUpgradeSDb$bumpTo27(null));
                n3 = 27;
            }
            case 27: {
                SvnNgUpgradeSDb.runBump(sVNWCDb, sVNSqlJetDb, file, new SvnNgUpgradeSDb$bumpTo28());
                n3 = 28;
            }
            case 28: {
                SvnNgUpgradeSDb.runBump(sVNWCDb, sVNSqlJetDb, file, new SvnNgUpgradeSDb$bumpTo29());
                n3 = 29;
            }
            case 29: {
                SvnNgUpgradeSDb.runBump(sVNWCDb, sVNSqlJetDb, file, new SvnNgUpgradeSDb$bumpTo30());
                n3 = 30;
            }
            case 30: {
                SvnNgUpgradeSDb.runBump(sVNWCDb, sVNSqlJetDb, file, new SvnNgUpgradeSDb$bumpTo31(null));
                n3 = 31;
            }
        }
        SvnOldUpgrade.wipeObsoleteFiles(file);
        if (n3 != 0 && iSVNEventHandler != null) {
            object = SVNEventFactory.createSVNEvent(file, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.UPGRADED_PATH, SVNEventAction.UPGRADED_PATH, null, null);
            iSVNEventHandler.handleEvent((SVNEvent)object, -1.0);
        }
        return n3;
    }

    private static void migrateTreeConflictData(SVNSqlJetDb sVNSqlJetDb) {
        SVNSqlJetSelectStatement sVNSqlJetSelectStatement = new SvnNgUpgradeSDb$1(sVNSqlJetDb, SVNWCDbSchema.ACTUAL_NODE);
        try {
            while (((SVNSqlJetStatement)sVNSqlJetSelectStatement).next()) {
                SvnNgUpgradeSDb.migrateSingleTreeConflictData(sVNSqlJetDb, sVNSqlJetSelectStatement.getColumnString(SVNWCDbSchema$ACTUAL_NODE__Fields.tree_conflict_data), sVNSqlJetSelectStatement.getColumnLong(SVNWCDbSchema$ACTUAL_NODE__Fields.wc_id), SVNFileUtil.createFilePath(sVNSqlJetSelectStatement.getColumnString(SVNWCDbSchema$ACTUAL_NODE__Fields.local_relpath)));
            }
        }
        finally {
            ((SVNSqlJetStatement)sVNSqlJetSelectStatement).reset();
        }
        sVNSqlJetSelectStatement = new SvnNgUpgradeSDb$2(sVNSqlJetDb, SVNWCDbSchema.ACTUAL_NODE);
        try {
            sVNSqlJetSelectStatement.exec();
        }
        finally {
            ((SVNSqlJetStatement)sVNSqlJetSelectStatement).reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void migrateSingleTreeConflictData(SVNSqlJetDb sVNSqlJetDb, String string, long l2, File file) {
        Map map = SVNTreeConflictUtil.readTreeConflicts(file, string);
        for (File file2 : map.keySet()) {
            SVNTreeConflictDescription sVNTreeConflictDescription = (SVNTreeConflictDescription)map.get(file2);
            SVNSqlJetStatement sVNSqlJetStatement = sVNSqlJetDb.getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
            sVNSqlJetStatement.bindf("is", l2, sVNTreeConflictDescription.getPath());
            boolean bl2 = false;
            try {
                bl2 = sVNSqlJetStatement.next();
            }
            finally {
                sVNSqlJetStatement.reset();
            }
            sVNSqlJetStatement = bl2 ? sVNSqlJetDb.getStatement(SVNWCDbStatements.UPDATE_ACTUAL_CONFLICT_DATA) : sVNSqlJetDb.getStatement(SVNWCDbStatements.INSERT_ACTUAL_CONFLICT_DATA);
            sVNSqlJetStatement.bindf("iss", l2, sVNTreeConflictDescription.getPath(), SVNTreeConflictUtil.getSingleTreeConflictData(sVNTreeConflictDescription));
            if (!bl2) {
                sVNSqlJetStatement.bindString(4, SVNFileUtil.getFilePath(file));
            }
            try {
                sVNSqlJetStatement.exec();
            }
            finally {
                sVNSqlJetStatement.reset();
            }
        }
    }

    public static void setVersion(SVNSqlJetDb sVNSqlJetDb, int n2) {
        try {
            sVNSqlJetDb.getDb().pragma("pragma user_version = " + n2);
        }
        catch (SqlJetException sqlJetException) {
            SVNSqlJetDb.createSqlJetError(sqlJetException);
        }
    }

    private static void runBump(SVNWCDb sVNWCDb, SVNSqlJetDb sVNSqlJetDb, File file, SvnNgUpgradeSDb$Bumpable svnNgUpgradeSDb$Bumpable) {
        sVNSqlJetDb.beginTransaction(SqlJetTransactionMode.WRITE);
        try {
            svnNgUpgradeSDb$Bumpable.bumpTo(sVNWCDb, sVNSqlJetDb, file);
        }
        catch (SVNException sVNException) {
            sVNSqlJetDb.rollback();
            throw sVNException;
        }
        finally {
            sVNSqlJetDb.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void upgradeExternals(SVNSqlJetDb sVNSqlJetDb, File file) {
        SVNSqlJetStatement sVNSqlJetStatement = sVNSqlJetDb.getStatement(SVNWCDbStatements.SELECT_EXTERNAL_PROPERTIES);
        sVNSqlJetStatement.bindf("is", 1, "");
        try {
            while (sVNSqlJetStatement.next()) {
                SVNExternal[] sVNExternalArray;
                SVNProperties sVNProperties = sVNSqlJetStatement.getColumnProperties(SVNWCDbSchema$NODES__Fields.properties);
                String string = sVNProperties.getStringValue("svn:externals");
                File file2 = SVNFileUtil.createFilePath(sVNSqlJetStatement.getColumnString(SVNWCDbSchema$NODES__Fields.properties));
                File file3 = SVNFileUtil.createFilePath(file, file2);
                if (string == null) continue;
                for (SVNExternal sVNExternal : sVNExternalArray = SVNExternal.parseExternals(file3, string)) {
                    File file4 = SVNFileUtil.createFilePath(file3, sVNExternal.getPath());
                    SVNSqlJetStatement sVNSqlJetStatement2 = sVNSqlJetDb.getStatement(SVNWCDbStatements.INSERT_EXTERNAL);
                    try {
                        sVNSqlJetStatement2.bindf("isssssis", 1, SVNFileUtil.getFilePath(file4), SVNFileUtil.getFilePath(SVNFileUtil.getFileDir(file4)), "normal", "unknown", SVNFileUtil.getFilePath(file2), 1, "");
                        sVNSqlJetStatement2.exec();
                    }
                    finally {
                        sVNSqlJetStatement2.reset();
                    }
                }
            }
        }
        finally {
            sVNSqlJetStatement.reset();
        }
    }

    static /* synthetic */ void access$1200(SVNSqlJetDb sVNSqlJetDb) {
        SvnNgUpgradeSDb.migrateTreeConflictData(sVNSqlJetDb);
    }

    static /* synthetic */ int access$1300() {
        return PRISTINE_BASENAME_OLD_LEN;
    }

    static /* synthetic */ String access$1400() {
        return PRISTINE_STORAGE_EXT;
    }

    static /* synthetic */ void access$1500(SVNSqlJetDb sVNSqlJetDb, File file) {
        SvnNgUpgradeSDb.upgradeExternals(sVNSqlJetDb, file);
    }
}

