/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnSetProperty;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnNgSetProperty
extends SvnNgOperationRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SVNPropertyData run(SVNWCContext sVNWCContext) {
        SvnNgPropertiesManager.checkPropertyName(((SvnSetProperty)this.getOperation()).getPropertyName(), ((SvnSetProperty)this.getOperation()).getPropertyValue());
        for (SvnTarget svnTarget : ((SvnSetProperty)this.getOperation()).getTargets()) {
            File file = svnTarget.getFile();
            SVNNodeKind sVNNodeKind = SVNNodeKind.NONE;
            try {
                sVNNodeKind = this.getWcContext().readKind(this.getFirstTarget(), false);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    this.notifyNonExistentPath(file);
                }
                throw sVNException;
            }
            if (sVNNodeKind == SVNNodeKind.NONE || sVNNodeKind == SVNNodeKind.UNKNOWN) {
                this.notifyNonExistentPath(file);
            }
            File file2 = sVNWCContext.acquireWriteLock(file, false, true);
            try {
                SvnNgPropertiesManager.setProperty(this.getWcContext(), file, ((SvnSetProperty)this.getOperation()).getPropertyName(), ((SvnSetProperty)this.getOperation()).getPropertyValue(), ((SvnSetProperty)this.getOperation()).getPropertyValueProvider(), ((SvnSetProperty)this.getOperation()).getDepth(), ((SvnSetProperty)this.getOperation()).isForce(), ((SvnSetProperty)this.getOperation()).getEventHandler(), (ISvnObjectReceiver)((Object)this.getOperation()), ((SvnSetProperty)this.getOperation()).getApplicableChangelists());
            }
            finally {
                sVNWCContext.releaseWriteLock(file2);
            }
        }
        return (SVNPropertyData)((SvnSetProperty)this.getOperation()).first();
    }

    private void notifyNonExistentPath(File file) {
        SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.NONE, null, -1L, SVNEventAction.PATH_NONEXISTENT, SVNEventAction.PATH_NONEXISTENT, null, null, -1L, -1L);
        if (((SvnSetProperty)this.getOperation()).getEventHandler() != null) {
            ((SvnSetProperty)this.getOperation()).getEventHandler().handleEvent(sVNEvent, -1.0);
        }
    }

    public boolean isApplicable(SvnSetProperty svnSetProperty, SvnWcGeneration svnWcGeneration) {
        return !svnSetProperty.isRevisionProperty() && super.isApplicable(svnSetProperty, svnWcGeneration);
    }
}

