/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb$Mode;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbInfo$InfoField;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb$DirParsedInfo;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbPristines;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbRevert;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbRevert$RevertInfo;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnRevert;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgRevert
extends SvnNgOperationRunner {
    @Override
    protected Void run(SVNWCContext sVNWCContext) {
        boolean bl2 = ((SvnRevert)this.getOperation()).getOptions().isUseCommitTimes();
        for (SvnTarget svnTarget : ((SvnRevert)this.getOperation()).getTargets()) {
            this.checkCancelled();
            boolean bl3 = sVNWCContext.getDb().isWCRoot(svnTarget.getFile());
            File file = bl3 ? svnTarget.getFile() : SVNFileUtil.getParentFile(svnTarget.getFile());
            File file2 = sVNWCContext.acquireWriteLock(file, false, true);
            try {
                this.revert(svnTarget.getFile(), ((SvnRevert)this.getOperation()).getDepth(), bl2, ((SvnRevert)this.getOperation()).getApplicableChangelists(), ((SvnRevert)this.getOperation()).isClearChangelists(), ((SvnRevert)this.getOperation()).isMetadataOnly());
            }
            catch (SVNException sVNException) {
                SVNErrorMessage sVNErrorMessage = sVNException.getErrorMessage();
                if (sVNErrorMessage.getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND || sVNErrorMessage.getErrorCode() == SVNErrorCode.UNVERSIONED_RESOURCE || sVNErrorMessage.getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(svnTarget.getFile(), SVNNodeKind.NONE, null, -1L, SVNEventAction.SKIP, SVNEventAction.REVERT, sVNErrorMessage, null, -1L, -1L);
                    this.handleEvent(sVNEvent);
                    continue;
                }
                if (!bl2) {
                    this.sleepForTimestamp();
                }
                throw sVNException;
            }
            finally {
                sVNWCContext.releaseWriteLock(file2);
            }
        }
        if (!bl2) {
            this.sleepForTimestamp();
        }
        return null;
    }

    private void revert(File file, SVNDepth sVNDepth, boolean bl2, Collection collection, boolean bl3, boolean bl4) {
        if (collection != null && collection.size() > 0) {
            this.revertChangelist(file, sVNDepth, bl2, collection, bl3, bl4);
            return;
        }
        if (sVNDepth == SVNDepth.EMPTY || sVNDepth == SVNDepth.INFINITY) {
            this.revert(file, sVNDepth, bl2, bl3, bl4);
            return;
        }
        if (sVNDepth == SVNDepth.IMMEDIATES || sVNDepth == SVNDepth.FILES) {
            this.revert(file, SVNDepth.EMPTY, bl2, bl3, bl4);
            Set set = ((SVNWCDb)this.getWcContext().getDb()).getWorkingChildren(file);
            for (String string : set) {
                SVNNodeKind sVNNodeKind;
                File file2 = SVNFileUtil.createFilePath(file, string);
                if (sVNDepth == SVNDepth.FILES && (sVNNodeKind = this.getWcContext().readKind(file2, true)) != SVNNodeKind.FILE) continue;
                this.revert(file2, SVNDepth.EMPTY, bl2, bl3, bl4);
            }
            return;
        }
        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OPERATION_DEPTH);
        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
    }

    private void revertChangelist(File file, SVNDepth sVNDepth, boolean bl2, Collection collection, boolean bl3, boolean bl4) {
        this.checkCancelled();
        if (this.getWcContext().isChangelistMatch(file, collection)) {
            this.revert(file, SVNDepth.EMPTY, bl2, bl3, bl4);
        }
        if (sVNDepth == SVNDepth.EMPTY) {
            return;
        }
        if (sVNDepth == SVNDepth.FILES || sVNDepth == SVNDepth.IMMEDIATES) {
            sVNDepth = SVNDepth.EMPTY;
        }
        Set set = ((SVNWCDb)this.getWcContext().getDb()).getWorkingChildren(file);
        for (String string : set) {
            File file2 = SVNFileUtil.createFilePath(file, string);
            this.revertChangelist(file2, sVNDepth, bl2, collection, bl3, bl4);
        }
    }

    private void revert(File file, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4) {
        assert (sVNDepth == SVNDepth.EMPTY || sVNDepth == SVNDepth.INFINITY);
        boolean bl5 = this.getWcContext().getDb().isWCRoot(file);
        File file2 = !bl5 ? SVNFileUtil.getFileDir(file) : file;
        this.getWcContext().writeCheck(file2);
        try {
            this.getWcContext().getDb().opRevert(file, sVNDepth, bl3);
            SvnNgRevert.restore(this.getWcContext(), file, sVNDepth, bl4, bl2, true, this.getWcContext().getEventHandler());
        }
        catch (SVNException sVNException) {
            SVNDebugLog.getDefaultLog().logError(SVNLogType.WC, sVNException);
            throw sVNException;
        }
        finally {
            SvnWcDbRevert.dropRevertList(this.getWcContext(), file);
        }
    }

    private void populateModifiedCopiesThatShouldBePreserved(File file, File file2, Set set) {
        block13: {
            if (!((SvnRevert)this.getOperation()).isPreserveModifiedCopies()) {
                return;
            }
            try {
                ISVNWCDb$WCDbInfo iSVNWCDb$WCDbInfo = this.getWcContext().getDb().readInfo(file, ISVNWCDb$WCDbInfo$InfoField.checksum, ISVNWCDb$WCDbInfo$InfoField.originalRootUrl, ISVNWCDb$WCDbInfo$InfoField.propsMod, ISVNWCDb$WCDbInfo$InfoField.lastModTime, ISVNWCDb$WCDbInfo$InfoField.translatedSize, ISVNWCDb$WCDbInfo$InfoField.kind);
                SVNNodeKind sVNNodeKind = SVNFileType.getNodeKind(SVNFileType.getType(file));
                if (sVNNodeKind != SVNNodeKind.NONE) {
                    if (sVNNodeKind == SVNNodeKind.DIR) {
                        if (iSVNWCDb$WCDbInfo.kind == ISVNWCDb$SVNWCDbKind.Dir) {
                            List list = this.getWcContext().getChildrenOfWorkingNode(file, false);
                            for (File file3 : list) {
                                this.populateModifiedCopiesThatShouldBePreserved(file3, file2, set);
                            }
                        }
                    } else {
                        if (iSVNWCDb$WCDbInfo.kind != ISVNWCDb$SVNWCDbKind.File) {
                            return;
                        }
                        if (iSVNWCDb$WCDbInfo.propsMod) {
                            set.add(file);
                            return;
                        }
                        if (iSVNWCDb$WCDbInfo.originalRootUrl != null && iSVNWCDb$WCDbInfo.checksum != null) {
                            long l2 = SVNFileUtil.getFileLength(file);
                            long l3 = SVNFileUtil.getFileLastModifiedMicros(file);
                            if (iSVNWCDb$WCDbInfo.translatedSize == -1L || iSVNWCDb$WCDbInfo.lastModTime == 0L || iSVNWCDb$WCDbInfo.translatedSize != l2 || !SVNFileUtil.compareFileTimestamps(iSVNWCDb$WCDbInfo.lastModTime, l3)) {
                                SVNWCDb sVNWCDb = (SVNWCDb)this.getWcContext().getDb();
                                SVNWCDb$DirParsedInfo sVNWCDb$DirParsedInfo = sVNWCDb.parseDir(file2, SVNSqlJetDb$Mode.ReadOnly);
                                File file4 = SvnWcDbPristines.getPristineFileName(sVNWCDb$DirParsedInfo.wcDbDir.getWCRoot(), iSVNWCDb$WCDbInfo.checksum, false);
                                if (this.getWcContext().compareAndVerify(file, file4, true, false, false)) {
                                    set.add(file);
                                }
                            }
                        }
                    }
                }
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND || sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block13;
                throw sVNException;
            }
        }
    }

    public static void restore(SVNWCContext sVNWCContext, File file, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, ISVNEventHandler iSVNEventHandler) {
        SvnNgRevert.restore(sVNWCContext, file, sVNDepth, bl2, bl3, bl4, iSVNEventHandler, Collections.emptySet());
    }

    public static void restore(SVNWCContext sVNWCContext, File file, SVNDepth sVNDepth, boolean bl2, boolean bl3, boolean bl4, ISVNEventHandler iSVNEventHandler, Set set) {
        Object object;
        sVNWCContext.checkCancelled();
        boolean bl5 = sVNWCContext.getDb().isWCRoot(file);
        if (bl5 && !bl4) {
            if (iSVNEventHandler != null) {
                SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.UPDATE_SKIP_OBSTRUCTION, SVNEventAction.UPDATE_SKIP_OBSTRUCTION, null, null);
                iSVNEventHandler.handleEvent(sVNEvent, -1.0);
            }
            return;
        }
        Structure structure = SvnWcDbRevert.readRevertInfo(sVNWCContext, file);
        ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus = ISVNWCDb$SVNWCDbStatus.Normal;
        ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind = ISVNWCDb$SVNWCDbKind.Unknown;
        long l2 = -1L;
        long l3 = 0L;
        boolean bl6 = structure.is(SvnWcDbRevert$RevertInfo.reverted);
        List list = (List)structure.get(SvnWcDbRevert$RevertInfo.markerFiles);
        try {
            object = sVNWCContext.getDb().readInfo(file, StructureFields$NodeInfo.status, StructureFields$NodeInfo.kind, StructureFields$NodeInfo.recordedSize, StructureFields$NodeInfo.recordedTime);
            iSVNWCDb$SVNWCDbStatus = (ISVNWCDb$SVNWCDbStatus)((Object)((Structure)object).get(StructureFields$NodeInfo.status));
            iSVNWCDb$SVNWCDbKind = (ISVNWCDb$SVNWCDbKind)((Object)((Structure)object).get(StructureFields$NodeInfo.kind));
            l2 = ((Structure)object).lng(StructureFields$NodeInfo.recordedSize);
            l3 = ((Structure)object).lng(StructureFields$NodeInfo.recordedTime);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                if (!structure.is(SvnWcDbRevert$RevertInfo.copiedHere)) {
                    if (bl6 && iSVNEventHandler != null) {
                        iSVNEventHandler.handleEvent(SVNEventFactory.createSVNEvent(file, SVNNodeKind.NONE, null, -1L, SVNEventAction.REVERT, SVNEventAction.REVERT, null, null, -1L, -1L), -1.0);
                    }
                    if (iSVNEventHandler != null) {
                        SvnWcDbRevert.notifyRevert(sVNWCContext, file, iSVNEventHandler);
                    }
                    return;
                }
            }
            throw sVNException;
        }
        if (!bl2) {
            bl6 = SvnNgRevert.revertWCData(sVNWCContext, file, bl3, set, structure, iSVNWCDb$SVNWCDbStatus, iSVNWCDb$SVNWCDbKind, l2, l3, bl6, iSVNEventHandler);
        }
        if (list != null) {
            for (Object object2 : list) {
                bl6 |= SVNFileUtil.deleteFile((File)object2);
            }
        }
        if (bl6 && iSVNEventHandler != null) {
            iSVNEventHandler.handleEvent(SVNEventFactory.createSVNEvent(file, SVNNodeKind.NONE, null, -1L, SVNEventAction.REVERT, SVNEventAction.REVERT, null, null, -1L, -1L), -1.0);
        }
        if (sVNDepth == SVNDepth.INFINITY && iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.Dir) {
            Object object2;
            SvnNgRevert.restoreCopiedDirectory(sVNWCContext, file, false, set);
            object = ((SVNWCDb)sVNWCContext.getDb()).getChildrenOfWorkingNode(file);
            object2 = object.iterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                File file2 = SVNFileUtil.createFilePath(file, string);
                SvnNgRevert.restore(sVNWCContext, file2, sVNDepth, bl2, bl3, false, iSVNEventHandler, set);
            }
        }
        SvnWcDbRevert.notifyRevert(sVNWCContext, file, iSVNEventHandler);
    }

    private static boolean revertWCData(SVNWCContext sVNWCContext, File file, boolean bl2, Set set, Structure structure, ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus, ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind, long l2, long l3, boolean bl3, ISVNEventHandler iSVNEventHandler) {
        SVNFileType sVNFileType = SVNFileType.getType(file);
        SVNNodeKind sVNNodeKind = null;
        boolean bl4 = false;
        if (sVNFileType == SVNFileType.NONE) {
            sVNNodeKind = SVNNodeKind.NONE;
            bl4 = false;
        } else {
            sVNNodeKind = sVNFileType == SVNFileType.FILE || sVNFileType == SVNFileType.SYMLINK ? SVNNodeKind.FILE : (sVNFileType == SVNFileType.DIRECTORY ? SVNNodeKind.DIR : SVNNodeKind.UNKNOWN);
            boolean bl5 = bl4 = sVNFileType == SVNFileType.SYMLINK;
        }
        if (structure.is(SvnWcDbRevert$RevertInfo.copiedHere)) {
            boolean bl6;
            if (structure.get(SvnWcDbRevert$RevertInfo.kind) == ISVNWCDb$SVNWCDbKind.File && sVNNodeKind == SVNNodeKind.FILE) {
                if (!set.contains(file)) {
                    SVNFileUtil.deleteFile(file);
                }
                sVNNodeKind = SVNNodeKind.NONE;
            } else if (structure.get(SvnWcDbRevert$RevertInfo.kind) == ISVNWCDb$SVNWCDbKind.Dir && sVNNodeKind == SVNNodeKind.DIR && (bl6 = SvnNgRevert.restoreCopiedDirectory(sVNWCContext, file, true, set))) {
                sVNNodeKind = SVNNodeKind.NONE;
            }
        }
        if (sVNNodeKind != SVNNodeKind.NONE && iSVNWCDb$SVNWCDbStatus != ISVNWCDb$SVNWCDbStatus.ServerExcluded && iSVNWCDb$SVNWCDbStatus != ISVNWCDb$SVNWCDbStatus.Deleted && iSVNWCDb$SVNWCDbStatus != ISVNWCDb$SVNWCDbStatus.Excluded && iSVNWCDb$SVNWCDbStatus != ISVNWCDb$SVNWCDbStatus.NotPresent) {
            if (sVNNodeKind == SVNNodeKind.DIR && iSVNWCDb$SVNWCDbKind != ISVNWCDb$SVNWCDbKind.Dir) {
                SVNFileUtil.deleteAll(file, true, iSVNEventHandler);
                sVNNodeKind = SVNNodeKind.NONE;
            } else if (sVNNodeKind == SVNNodeKind.FILE && iSVNWCDb$SVNWCDbKind != ISVNWCDb$SVNWCDbKind.File) {
                SVNFileUtil.deleteFile(file);
                sVNNodeKind = SVNNodeKind.NONE;
            } else if (sVNNodeKind == SVNNodeKind.FILE) {
                boolean bl7;
                SVNProperties sVNProperties = sVNWCContext.getDb().readPristineProperties(file);
                boolean bl8 = false;
                String string = sVNProperties.getStringValue("svn:special");
                if (SVNFileUtil.symlinksSupported() && string != null != bl4) {
                    SVNFileUtil.deleteFile(file);
                    sVNNodeKind = SVNNodeKind.NONE;
                } else {
                    long l4 = SVNFileUtil.getFileLastModifiedMicros(file);
                    long l5 = SVNFileUtil.getFileLength(file);
                    bl8 = l2 != -1L && l3 != 0L && l2 == l5 && SVNFileUtil.compareFileTimestamps(l3, l4) ? false : sVNWCContext.isTextModified(file, true);
                }
                if (bl8) {
                    SVNFileUtil.deleteFile(file);
                    sVNNodeKind = SVNNodeKind.NONE;
                } else if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Normal) {
                    boolean bl9 = sVNFileType != SVNFileType.SYMLINK && !file.canWrite();
                    boolean bl10 = bl7 = sVNProperties.getStringValue("svn:needs-lock") != null;
                    if (bl7 && !bl9) {
                        SVNFileUtil.setReadonly(file, true);
                        bl3 = true;
                    } else if (!bl7 && bl9) {
                        SVNFileUtil.setReadonly(file, false);
                        bl3 = true;
                    }
                }
                if (!(SVNFileUtil.isWindows || SVNFileUtil.isOpenVMS || SVNFileUtil.symlinksSupported() && bl4)) {
                    boolean bl11 = SVNFileUtil.isExecutable(file);
                    boolean bl12 = bl7 = sVNProperties.getStringValue("svn:executable") != null;
                    if (bl7 && !bl11) {
                        SVNFileUtil.setExecutable(file, true);
                        bl3 = true;
                    } else if (!bl7 && bl11) {
                        SVNFileUtil.setExecutable(file, false);
                        bl3 = true;
                    }
                }
            }
        }
        if (sVNNodeKind == SVNNodeKind.NONE && iSVNWCDb$SVNWCDbStatus != ISVNWCDb$SVNWCDbStatus.ServerExcluded && iSVNWCDb$SVNWCDbStatus != ISVNWCDb$SVNWCDbStatus.Deleted && iSVNWCDb$SVNWCDbStatus != ISVNWCDb$SVNWCDbStatus.Excluded && iSVNWCDb$SVNWCDbStatus != ISVNWCDb$SVNWCDbStatus.NotPresent) {
            if (iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.Dir) {
                SVNFileUtil.ensureDirectoryExists(file);
            } else if (iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.File) {
                SVNSkel sVNSkel = sVNWCContext.wqBuildFileInstall(file, null, bl2, true);
                sVNWCContext.getDb().addWorkQueue(file, sVNSkel);
                sVNWCContext.wqRun(file);
            }
            bl3 = true;
        }
        return bl3;
    }

    private static boolean restoreCopiedDirectory(SVNWCContext sVNWCContext, File file, boolean bl2, Set set) {
        ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind;
        boolean bl3 = false;
        Map map = SvnWcDbRevert.readRevertCopiedChildren(sVNWCContext, file);
        for (File file2 : map.keySet()) {
            SVNFileType sVNFileType;
            sVNWCContext.checkCancelled();
            iSVNWCDb$SVNWCDbKind = (ISVNWCDb$SVNWCDbKind)((Object)map.get(file2));
            if (iSVNWCDb$SVNWCDbKind != ISVNWCDb$SVNWCDbKind.File || (sVNFileType = SVNFileType.getType(file2)) != SVNFileType.FILE && sVNFileType != SVNFileType.SYMLINK) continue;
            if (!set.contains(file2)) {
                SVNFileUtil.deleteFile(file2);
                continue;
            }
            bl3 = false;
            bl2 = false;
        }
        for (File file2 : map.keySet()) {
            sVNWCContext.checkCancelled();
            iSVNWCDb$SVNWCDbKind = (ISVNWCDb$SVNWCDbKind)((Object)map.get(file2));
            if (iSVNWCDb$SVNWCDbKind != ISVNWCDb$SVNWCDbKind.Dir) continue;
            if (!set.contains(file2)) {
                SVNFileUtil.deleteFile(file2);
                continue;
            }
            bl3 = false;
            bl2 = false;
        }
        if (bl2) {
            SVNFileUtil.deleteFile(file);
            if (SVNFileType.getType(file) == SVNFileType.NONE) {
                bl3 = true;
            }
        }
        return bl3;
    }
}

