/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathRevision;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$SVNWCNodeReposInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeOriginInfo;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess$LocationsInfo;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess$RepositoryInfo;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess$RevisionsPair;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess$UrlInfo;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.ISvnOperationOptionsProvider;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgRepositoryAccess
extends SvnRepositoryAccess {
    public SvnNgRepositoryAccess(ISvnOperationOptionsProvider iSvnOperationOptionsProvider, SVNWCContext sVNWCContext) {
        super(iSvnOperationOptionsProvider, sVNWCContext);
    }

    @Override
    public Structure createRepositoryFor(SvnTarget svnTarget, SVNRevision sVNRevision, SVNRevision sVNRevision2, File file) {
        Structure structure;
        SVNRevision[] sVNRevisionArray;
        SVNURL sVNURL = this.getTargetURL(svnTarget);
        if (sVNURL == null) {
            sVNRevisionArray = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)svnTarget.getFile());
            SVNErrorManager.error((SVNErrorMessage)sVNRevisionArray, SVNLogType.WC);
        }
        sVNRevisionArray = this.resolveRevisions(sVNRevision2, sVNRevision, svnTarget.isURL(), true);
        SVNRevision sVNRevision3 = sVNRevisionArray[0];
        SVNRevision sVNRevision4 = sVNRevisionArray[1];
        SVNRepository sVNRepository = this.createRepository(sVNURL, file);
        Structure structure2 = this.getLocations(sVNRepository, svnTarget, sVNRevision3, sVNRevision4, SVNRevision.UNDEFINED);
        if (svnTarget.isURL() && !sVNURL.equals(sVNRepository.getLocation())) {
            sVNURL = sVNRepository.getLocation();
        }
        long l2 = structure2.lng(SvnRepositoryAccess$LocationsInfo.startRevision);
        sVNURL = (SVNURL)structure2.get(SvnRepositoryAccess$LocationsInfo.startUrl);
        structure2.release();
        sVNRepository.setLocation(sVNURL, false);
        if (l2 < 0L) {
            structure = this.getRevisionNumber(sVNRepository, svnTarget, SVNRevision.HEAD, null);
            l2 = structure.lng(SvnRepositoryAccess$RevisionsPair.revNumber);
            structure.release();
        }
        structure = Structure.obtain(SvnRepositoryAccess$RepositoryInfo.class);
        structure.set((Enum)SvnRepositoryAccess$RepositoryInfo.revision, l2);
        structure.set((Enum)SvnRepositoryAccess$RepositoryInfo.repository, sVNRepository);
        structure.set((Enum)SvnRepositoryAccess$RepositoryInfo.url, sVNURL);
        return structure;
    }

    @Override
    public Structure getURLFromPath(SvnTarget svnTarget, SVNRevision sVNRevision, SVNRepository sVNRepository) {
        Object object;
        Structure structure = Structure.obtain(SvnRepositoryAccess$UrlInfo.class);
        SVNURL sVNURL = null;
        if (sVNRevision == SVNRevision.WORKING) {
            object = this.getWCContext().getNodeOrigin(svnTarget.getFile(), false, new StructureFields$NodeOriginInfo[0]);
            structure.set((Enum)SvnRepositoryAccess$UrlInfo.pegRevision, ((Structure)object).lng(StructureFields$NodeOriginInfo.revision));
            if (((Structure)object).hasValue(StructureFields$NodeOriginInfo.reposRelpath)) {
                sVNURL = SVNWCUtils.join((SVNURL)((Structure)object).get(StructureFields$NodeOriginInfo.reposRootUrl), (File)((Structure)object).get(StructureFields$NodeOriginInfo.reposRelpath));
            }
            if (sVNURL != null && ((Structure)object).hasValue(StructureFields$NodeOriginInfo.isCopy) && ((Structure)object).is(StructureFields$NodeOriginInfo.isCopy) && sVNRepository != null && !sVNURL.equals(sVNRepository.getLocation())) {
                structure.set((Enum)SvnRepositoryAccess$UrlInfo.dropRepsitory, true);
                sVNRepository = null;
            }
        }
        if (sVNURL == null) {
            sVNURL = this.getWCContext().getNodeUrl(svnTarget.getFile());
        }
        if (sVNURL == null) {
            object = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)svnTarget.getFile());
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        structure.set((Enum)SvnRepositoryAccess$UrlInfo.url, sVNURL);
        return structure;
    }

    @Override
    public Structure getRevisionNumber(SVNRepository sVNRepository, SvnTarget svnTarget, SVNRevision sVNRevision, Structure structure) {
        SVNErrorMessage sVNErrorMessage;
        Structure structure2;
        Structure structure3 = structure2 = structure == null ? Structure.obtain(SvnRepositoryAccess$RevisionsPair.class) : structure;
        if (structure == null) {
            structure2.set((Enum)SvnRepositoryAccess$RevisionsPair.youngestRevision, -1L);
        }
        if (sVNRepository == null && (sVNRevision == SVNRevision.HEAD || sVNRevision.getDate() != null)) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_RA_ACCESS_REQUIRED);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (sVNRevision == SVNRevision.UNDEFINED) {
            structure2.set((Enum)SvnRepositoryAccess$RevisionsPair.revNumber, -1L);
        } else if (sVNRevision.getNumber() >= 0L) {
            structure2.set((Enum)SvnRepositoryAccess$RevisionsPair.revNumber, sVNRevision.getNumber());
        } else if (sVNRevision == SVNRevision.HEAD) {
            if (structure != null && structure.lng(SvnRepositoryAccess$RevisionsPair.youngestRevision) >= 0L) {
                structure2.set((Enum)SvnRepositoryAccess$RevisionsPair.revNumber, structure.lng(SvnRepositoryAccess$RevisionsPair.youngestRevision));
            } else {
                if (sVNRepository == null) {
                    sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_RA_ACCESS_REQUIRED);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
                long l2 = sVNRepository.getLatestRevision();
                structure2.set((Enum)SvnRepositoryAccess$RevisionsPair.revNumber, l2);
                structure2.set((Enum)SvnRepositoryAccess$RevisionsPair.youngestRevision, l2);
            }
        } else if (sVNRevision == SVNRevision.WORKING || sVNRevision == SVNRevision.BASE) {
            if (svnTarget == null) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_VERSIONED_PATH_REQUIRED);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            } else if (!svnTarget.isFile()) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "PREV, BASE or COMMITTTED revision keywords are invalid for URL");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            long l3 = -1L;
            try {
                l3 = this.getWCContext().getNodeCommitBaseRev(svnTarget.getFile());
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", (Object)svnTarget.getFile());
                    SVNErrorManager.error(sVNErrorMessage2, SVNLogType.WC);
                }
                throw sVNException;
            }
            if (l3 < 0L) {
                SVNErrorMessage sVNErrorMessage3 = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Path ''{0}'' has no committed revision", (Object)svnTarget.getFile());
                SVNErrorManager.error(sVNErrorMessage3, SVNLogType.WC);
            }
            structure2.set((Enum)SvnRepositoryAccess$RevisionsPair.revNumber, l3);
        } else if (sVNRevision == SVNRevision.COMMITTED || sVNRevision == SVNRevision.PREVIOUS) {
            Object object;
            if (svnTarget == null) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_VERSIONED_PATH_REQUIRED);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            } else if (!svnTarget.isFile()) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "PREV, BASE or COMMITTTED revision keywords are invalid for URL");
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            long l4 = -1L;
            try {
                object = this.getWCContext().getDb().readInfo(svnTarget.getFile(), StructureFields$NodeInfo.changedRev);
                l4 = ((Structure)object).lng(StructureFields$NodeInfo.changedRev);
                ((Structure)object).release();
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    SVNErrorMessage sVNErrorMessage4 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", (Object)svnTarget.getFile());
                    SVNErrorManager.error(sVNErrorMessage4, SVNLogType.WC);
                }
                throw sVNException;
            }
            if (l4 < 0L) {
                object = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Path ''{0}'' has no committed revision", (Object)svnTarget.getFile());
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            if (sVNRevision == SVNRevision.PREVIOUS) {
                --l4;
            }
            structure2.set((Enum)SvnRepositoryAccess$RevisionsPair.revNumber, l4);
        } else if (sVNRevision.getDate() != null) {
            if (sVNRepository == null) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_RA_ACCESS_REQUIRED);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            long l5 = sVNRepository.getDatedRevision(sVNRevision.getDate());
            structure2.set((Enum)SvnRepositoryAccess$RevisionsPair.revNumber, l5);
        } else {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Unrecognized revision type requested for ''{0}''", (Object)svnTarget.getFile());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (structure != null && (sVNRevision == SVNRevision.HEAD || sVNRevision.getDate() != null) && structure.lng(SvnRepositoryAccess$RevisionsPair.youngestRevision) >= 0L && structure2.lng(SvnRepositoryAccess$RevisionsPair.revNumber) >= 0L && structure2.lng(SvnRepositoryAccess$RevisionsPair.revNumber) > structure.lng(SvnRepositoryAccess$RevisionsPair.youngestRevision)) {
            structure2.set((Enum)SvnRepositoryAccess$RevisionsPair.revNumber, structure.lng(SvnRepositoryAccess$RevisionsPair.youngestRevision));
        }
        return structure2;
    }

    public SVNRepository createRepository(SVNURL sVNURL, File file) {
        String string;
        block3: {
            string = null;
            if (file != null) {
                SVNWCContext$SVNWCNodeReposInfo sVNWCContext$SVNWCNodeReposInfo = null;
                try {
                    sVNWCContext$SVNWCNodeReposInfo = this.getWCContext().getNodeReposInfo(file);
                    string = sVNWCContext$SVNWCNodeReposInfo.reposUuid;
                }
                catch (SVNException sVNException) {
                    SVNErrorCode sVNErrorCode = sVNException.getErrorMessage().getErrorCode();
                    if (sVNErrorCode == SVNErrorCode.WC_NOT_WORKING_COPY || sVNErrorCode == SVNErrorCode.WC_PATH_NOT_FOUND || sVNErrorCode == SVNErrorCode.WC_UPGRADE_REQUIRED) break block3;
                    throw sVNException;
                }
            }
        }
        return this.createRepository(sVNURL, string, true);
    }

    @Override
    public SvnCopySource createRemoteCopySource(SVNWCContext sVNWCContext, SvnCopySource svnCopySource) {
        Structure structure = sVNWCContext.getNodeOrigin(svnCopySource.getSource().getFile(), true, StructureFields$NodeOriginInfo.reposRelpath, StructureFields$NodeOriginInfo.reposRootUrl, StructureFields$NodeOriginInfo.revision);
        SVNURL sVNURL = (SVNURL)structure.get(StructureFields$NodeOriginInfo.reposRootUrl);
        sVNURL = sVNURL.appendPath(SVNFileUtil.getFilePath((File)structure.get(StructureFields$NodeOriginInfo.reposRelpath)), false);
        SVNRevision sVNRevision = svnCopySource.getSource().getResolvedPegRevision();
        SVNRevision sVNRevision2 = svnCopySource.getRevision();
        if (sVNRevision == SVNRevision.UNDEFINED || sVNRevision == SVNRevision.WORKING || sVNRevision == SVNRevision.BASE) {
            sVNRevision = SVNRevision.create(structure.lng(StructureFields$NodeOriginInfo.revision));
        }
        if (sVNRevision2 == SVNRevision.BASE) {
            sVNRevision2 = SVNRevision.create(structure.lng(StructureFields$NodeOriginInfo.revision));
        }
        structure.release();
        svnCopySource = SvnCopySource.create(SvnTarget.fromURL(sVNURL, sVNRevision), sVNRevision2);
        return svnCopySource;
    }

    public SVNPathRevision resolveRevisionAndUrl(SVNRepository sVNRepository, SvnTarget svnTarget, SVNRevision sVNRevision, SVNRevision sVNRevision2) {
        SVNRevision sVNRevision3 = sVNRevision2;
        SVNRevision[] sVNRevisionArray = this.resolveRevisions(sVNRevision, sVNRevision2, svnTarget.isURL(), true);
        sVNRevision = sVNRevisionArray[0];
        sVNRevision3 = sVNRevisionArray[1];
        Structure structure = this.getLocations(sVNRepository, svnTarget, sVNRevision, sVNRevision3, SVNRevision.UNDEFINED);
        SVNURL sVNURL = (SVNURL)structure.get(SvnRepositoryAccess$LocationsInfo.startUrl);
        long l2 = structure.lng(SvnRepositoryAccess$LocationsInfo.startRevision);
        return SVNPathRevision.createWithRepository(sVNRepository, sVNURL, l2);
    }

    protected SVNURL getTargetURL(SvnTarget svnTarget) {
        if (svnTarget.isURL()) {
            return svnTarget.getURL();
        }
        return this.getWCContext().getNodeUrl(svnTarget.getFile());
    }
}

