/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.Iterator;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$ExternalNodeInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemove$1;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc2.SvnOperation;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnReceivingOperation;
import org.tmatesoft.svn.core.wc2.SvnScheduleForRemoval;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgRemove
extends SvnNgOperationRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void run(SVNWCContext sVNWCContext) {
        for (SvnTarget svnTarget : ((SvnScheduleForRemoval)this.getOperation()).getTargets()) {
            File file = svnTarget.getFile();
            this.checkCancelled();
            File file2 = this.getWcContext().acquireWriteLock(file, true, true);
            try {
                if (!((SvnScheduleForRemoval)this.getOperation()).isForce() && ((SvnScheduleForRemoval)this.getOperation()).isDeleteFiles()) {
                    SvnNgRemove.checkCanDelete(((SvnScheduleForRemoval)this.getOperation()).getOperationFactory(), sVNWCContext, file);
                }
                if (((SvnScheduleForRemoval)this.getOperation()).isDryRun()) continue;
                SvnNgRemove.delete(sVNWCContext, file, null, !((SvnScheduleForRemoval)this.getOperation()).isDeleteFiles(), true, ((SvnScheduleForRemoval)this.getOperation()).getEventHandler());
            }
            finally {
                this.getWcContext().releaseWriteLock(file2);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkCanDelete(SvnOperationFactory svnOperationFactory, SVNWCContext sVNWCContext, File file) {
        Object object;
        Structure structure = null;
        try {
            structure = SvnWcDbExternals.readExternal(sVNWCContext, file, file, StructureFields$ExternalNodeInfo.kind);
            if (structure != null && structure.get(StructureFields$ExternalNodeInfo.kind) == ISVNWCDb$SVNWCDbKind.File) {
                object = SVNErrorMessage.create(SVNErrorCode.WC_CANNOT_DELETE_FILE_EXTERNAL, "Cannot remove the external at ''{0}''; please edit or delete the svn:externals property on ''{1}''", file, SVNFileUtil.getParentFile(file));
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw sVNException;
            }
        }
        finally {
            if (structure != null) {
                structure.release();
            }
        }
        object = svnOperationFactory.createGetStatus();
        ((SvnOperation)object).setSingleTarget(SvnTarget.fromFile(file));
        ((SvnOperation)object).setDepth(SVNDepth.INFINITY);
        ((SvnReceivingOperation)object).setReceiver(new SvnNgRemove$1());
        ((SvnOperation)object).run();
    }

    public static void delete(SVNWCContext sVNWCContext, File file, File file2, boolean bl2, boolean bl3, ISVNEventHandler iSVNEventHandler) {
        Object object;
        Structure structure = null;
        try {
            structure = sVNWCContext.getDb().readInfo(file, StructureFields$NodeInfo.status, StructureFields$NodeInfo.kind, StructureFields$NodeInfo.conflicted);
        }
        catch (SVNException sVNException) {
            if (bl3 && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                if (SVNFileType.getType(file) == SVNFileType.NONE) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.BAD_FILENAME, "''{0}'' does not exist", (Object)file);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
                if (!bl2) {
                    SVNFileUtil.deleteAll(file, iSVNEventHandler);
                }
                return;
            }
            throw sVNException;
        }
        ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus = (ISVNWCDb$SVNWCDbStatus)((Object)structure.get(StructureFields$NodeInfo.status));
        if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Excluded || iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.NotPresent) {
            object = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' cannot be deleted", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Normal && structure.get(StructureFields$NodeInfo.kind) == ISVNWCDb$SVNWCDbKind.Dir && sVNWCContext.getDb().isWCRoot(file)) {
            object = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "''{0}'' is the root of a working copy and cannot be deleted", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        sVNWCContext.writeCheck(SVNFileUtil.getParentFile(file));
        object = null;
        if (!bl2 && structure.is(StructureFields$NodeInfo.conflicted)) {
            object = sVNWCContext.getDb().readConflicts(file);
        }
        structure.release();
        SVNSkel sVNSkel = null;
        sVNWCContext.getDb().opDelete(file, file2, file2 != null || !bl2, null, sVNSkel, iSVNEventHandler);
        if (!bl2 && object != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                SVNConflictDescription sVNConflictDescription = (SVNConflictDescription)iterator.next();
                if (sVNConflictDescription.isTextConflict()) {
                    if (sVNConflictDescription.getMergeFiles() == null) continue;
                    SVNFileUtil.deleteFile(sVNConflictDescription.getMergeFiles().getBaseFile());
                    SVNFileUtil.deleteFile(sVNConflictDescription.getMergeFiles().getRepositoryFile());
                    SVNFileUtil.deleteFile(sVNConflictDescription.getMergeFiles().getLocalFile());
                    continue;
                }
                if (!sVNConflictDescription.isPropertyConflict() || sVNConflictDescription.getMergeFiles() == null) continue;
                SVNFileUtil.deleteFile(sVNConflictDescription.getMergeFiles().getRepositoryFile());
            }
        }
        if (!bl2) {
            SVNFileUtil.deleteAll(file, iSVNEventHandler);
        }
    }
}

