/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackResult;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemoteDiffEditor$DeletedPath;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemoteDiffEditor$DirBaton;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemoteDiffEditor$FileBaton;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgRemoteDiffEditor
implements ISVNEditor {
    private SVNWCContext context;
    private File target;
    private SVNRepository repository;
    private long revision;
    private boolean walkDeletedDirs;
    private boolean pureRemoteDiff;
    private ISvnDiffCallback diffCallback;
    private long targetRevision;
    private File emptyFile;
    private Map deletedPaths;
    private SvnNgRemoteDiffEditor$DirBaton currentDir;
    private SvnDiffCallbackResult currentResult;
    private SvnNgRemoteDiffEditor$FileBaton currentFile;
    private ISVNEventHandler eventHandler;
    private File globalTmpDir;
    private Collection tmpFiles;

    public static SvnNgRemoteDiffEditor createEditor(SVNWCContext sVNWCContext, File file, SVNDepth sVNDepth, SVNRepository sVNRepository, long l2, boolean bl2, boolean bl3, boolean bl4, ISvnDiffCallback iSvnDiffCallback, ISVNEventHandler iSVNEventHandler) {
        SvnNgRemoteDiffEditor svnNgRemoteDiffEditor = new SvnNgRemoteDiffEditor();
        svnNgRemoteDiffEditor.context = sVNWCContext;
        svnNgRemoteDiffEditor.target = file;
        svnNgRemoteDiffEditor.repository = sVNRepository;
        svnNgRemoteDiffEditor.revision = l2;
        svnNgRemoteDiffEditor.walkDeletedDirs = bl2;
        svnNgRemoteDiffEditor.diffCallback = iSvnDiffCallback;
        svnNgRemoteDiffEditor.deletedPaths = new HashMap();
        svnNgRemoteDiffEditor.pureRemoteDiff = bl4;
        svnNgRemoteDiffEditor.tmpFiles = new ArrayList();
        svnNgRemoteDiffEditor.currentResult = new SvnDiffCallbackResult();
        svnNgRemoteDiffEditor.eventHandler = iSVNEventHandler;
        return svnNgRemoteDiffEditor;
    }

    public File getGlobalTmpDir() {
        if (this.globalTmpDir == null) {
            this.globalTmpDir = SVNFileUtil.createTempDirectory("svndiff");
        }
        return this.globalTmpDir;
    }

    private SvnNgRemoteDiffEditor$DirBaton makeDirBaton(String string, SvnNgRemoteDiffEditor$DirBaton svnNgRemoteDiffEditor$DirBaton, boolean bl2) {
        SvnNgRemoteDiffEditor$DirBaton svnNgRemoteDiffEditor$DirBaton2 = new SvnNgRemoteDiffEditor$DirBaton(null);
        svnNgRemoteDiffEditor$DirBaton2.parent = svnNgRemoteDiffEditor$DirBaton;
        svnNgRemoteDiffEditor$DirBaton2.added = bl2;
        svnNgRemoteDiffEditor$DirBaton2.wcPath = SVNFileUtil.createFilePath(this.target, string);
        svnNgRemoteDiffEditor$DirBaton2.propChanges = new SVNProperties();
        return svnNgRemoteDiffEditor$DirBaton2;
    }

    private SvnNgRemoteDiffEditor$FileBaton makeFileBaton(String string, boolean bl2) {
        SvnNgRemoteDiffEditor$FileBaton svnNgRemoteDiffEditor$FileBaton = new SvnNgRemoteDiffEditor$FileBaton(this, null);
        svnNgRemoteDiffEditor$FileBaton.added = bl2;
        svnNgRemoteDiffEditor$FileBaton.repoPath = string;
        svnNgRemoteDiffEditor$FileBaton.wcPath = SVNFileUtil.createFilePath(this.target, string);
        svnNgRemoteDiffEditor$FileBaton.propChanges = new SVNProperties();
        svnNgRemoteDiffEditor$FileBaton.baseRevision = this.revision;
        return svnNgRemoteDiffEditor$FileBaton;
    }

    private void handleEvent(SVNEvent sVNEvent) {
        if (sVNEvent != null && this.eventHandler != null) {
            this.eventHandler.handleEvent(sVNEvent, -1.0);
        }
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        if (this.currentFile.skip) {
            return;
        }
        this.currentFile.deltaProcessor = new SVNDeltaProcessor();
        if (!this.currentFile.added) {
            this.currentFile.loadFile(this.context, this.repository, false, this.tmpFiles);
        } else {
            this.currentFile.startRevisionFile = this.getEmptyFile();
        }
        File file = this.pureRemoteDiff ? this.getGlobalTmpDir() : this.context.getDb().getWCRootTempDir(this.target);
        this.currentFile.endRevisionFile = SVNFileUtil.createUniqueFile(file, SVNPathUtil.tail(string), ".tmp", false);
        this.tmpFiles.add(this.currentFile.endRevisionFile);
        this.currentFile.deltaProcessor.applyTextDelta(this.currentFile.startRevisionFile, this.currentFile.endRevisionFile, true);
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        if (this.currentFile.deltaProcessor != null) {
            return this.currentFile.deltaProcessor.textDeltaChunk(sVNDiffWindow);
        }
        return SVNFileUtil.DUMMY_OUT;
    }

    @Override
    public void textDeltaEnd(String string) {
        if (this.currentFile.deltaProcessor != null) {
            String string2 = this.currentFile.deltaProcessor.textDeltaEnd();
            this.currentFile.resultMd5Checksum = SvnChecksum.fromString("$md5 $" + string2);
        }
    }

    @Override
    public void targetRevision(long l2) {
        this.targetRevision = l2;
    }

    @Override
    public void openRoot(long l2) {
        SvnNgRemoteDiffEditor$DirBaton svnNgRemoteDiffEditor$DirBaton = this.makeDirBaton("", null, false);
        svnNgRemoteDiffEditor$DirBaton.wcPath = this.target;
        svnNgRemoteDiffEditor$DirBaton.loadProperties(this.repository, "", l2);
        this.currentDir = svnNgRemoteDiffEditor$DirBaton;
    }

    @Override
    public void deleteEntry(String string, long l2) {
        Object object;
        if (this.currentDir.skip || this.currentDir.skipChildren || this.currentDir.treeConflicted) {
            return;
        }
        SVNNodeKind sVNNodeKind = this.repository.checkPath(string, this.revision);
        SVNEventAction sVNEventAction = SVNEventAction.SKIP;
        this.currentResult.contentState = SVNStatusType.INAPPLICABLE;
        if (sVNNodeKind == SVNNodeKind.FILE) {
            object = this.makeFileBaton(string, false);
            ((SvnNgRemoteDiffEditor$FileBaton)object).loadFile(this.context, this.repository, false, this.tmpFiles);
            ((SvnNgRemoteDiffEditor$FileBaton)object).endRevisionFile = this.getEmptyFile();
            String[] stringArray = ((SvnNgRemoteDiffEditor$FileBaton)object).getMimeTypes();
            this.diffCallback.fileDeleted(this.currentResult, ((SvnNgRemoteDiffEditor$FileBaton)object).wcPath, ((SvnNgRemoteDiffEditor$FileBaton)object).startRevisionFile, ((SvnNgRemoteDiffEditor$FileBaton)object).endRevisionFile, stringArray[0], stringArray[1], ((SvnNgRemoteDiffEditor$FileBaton)object).pristineProps);
        } else if (sVNNodeKind == SVNNodeKind.DIR) {
            this.diffCallback.dirDeleted(this.currentResult, SVNFileUtil.createFilePath(this.target, string));
            if (this.walkDeletedDirs) {
                this.diffDeletedDir(string, this.revision, this.repository);
            }
        }
        if (this.currentResult.contentState != SVNStatusType.MISSING && this.currentResult.contentState != SVNStatusType.OBSTRUCTED && !this.currentResult.treeConflicted) {
            sVNEventAction = SVNEventAction.UPDATE_DELETE;
        }
        if (this.eventHandler != null) {
            object = new SvnNgRemoteDiffEditor$DeletedPath(null);
            ((SvnNgRemoteDiffEditor$DeletedPath)object).action = this.currentResult.treeConflicted ? SVNEventAction.TREE_CONFLICT : sVNEventAction;
            ((SvnNgRemoteDiffEditor$DeletedPath)object).kind = sVNNodeKind;
            ((SvnNgRemoteDiffEditor$DeletedPath)object).state = this.currentResult.contentState;
            this.deletedPaths.put(SVNFileUtil.createFilePath(this.target, string), object);
        }
    }

    private void diffDeletedDir(String string, long l2, SVNRepository sVNRepository) {
        this.context.checkCancelled();
        Collection collection = sVNRepository.getDir(string, l2, null, 1, (Collection)null);
        for (SVNDirEntry sVNDirEntry : collection) {
            if (sVNDirEntry.getName() == null || "".equals(sVNDirEntry.getName())) continue;
            String string2 = SVNPathUtil.append(string, sVNDirEntry.getName());
            if (sVNDirEntry.getKind() == SVNNodeKind.FILE) {
                SvnNgRemoteDiffEditor$FileBaton svnNgRemoteDiffEditor$FileBaton = this.makeFileBaton(string2, false);
                svnNgRemoteDiffEditor$FileBaton.loadFile(this.context, sVNRepository, false, this.tmpFiles);
                File file = this.getEmptyFile();
                String[] stringArray = svnNgRemoteDiffEditor$FileBaton.getMimeTypes();
                this.diffCallback.fileDeleted(null, svnNgRemoteDiffEditor$FileBaton.wcPath, svnNgRemoteDiffEditor$FileBaton.startRevisionFile, file, stringArray[0], stringArray[1], svnNgRemoteDiffEditor$FileBaton.pristineProps);
                continue;
            }
            if (sVNDirEntry.getKind() != SVNNodeKind.DIR) continue;
            this.diffDeletedDir(string2, l2, sVNRepository);
        }
    }

    private File getEmptyFile() {
        if (this.emptyFile == null) {
            File file = this.pureRemoteDiff ? this.getGlobalTmpDir() : this.context.getDb().getWCRootTempDir(this.target);
            this.emptyFile = SVNFileUtil.createUniqueFile(file, "empty", ".tmp", false);
            this.tmpFiles.add(this.emptyFile);
        }
        return this.emptyFile;
    }

    @Override
    public void absentDir(String string) {
        File file = SVNFileUtil.createFilePath(this.currentDir.wcPath, SVNPathUtil.tail(string));
        SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.DIR, null, -1L, SVNStatusType.MISSING, SVNStatusType.MISSING, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.SKIP, null, null, null, null);
        this.handleEvent(sVNEvent);
    }

    @Override
    public void absentFile(String string) {
        File file = SVNFileUtil.createFilePath(this.currentDir.wcPath, SVNPathUtil.tail(string));
        SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, null, -1L, SVNStatusType.MISSING, SVNStatusType.MISSING, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.SKIP, null, null, null, null);
        this.handleEvent(sVNEvent);
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        SvnNgRemoteDiffEditor$DirBaton svnNgRemoteDiffEditor$DirBaton = this.makeDirBaton(string, this.currentDir, true);
        svnNgRemoteDiffEditor$DirBaton.pristineProperties = new SVNProperties();
        SvnNgRemoteDiffEditor$DirBaton svnNgRemoteDiffEditor$DirBaton2 = this.currentDir;
        this.currentDir = svnNgRemoteDiffEditor$DirBaton;
        if (svnNgRemoteDiffEditor$DirBaton2.skip || svnNgRemoteDiffEditor$DirBaton2.skipChildren || svnNgRemoteDiffEditor$DirBaton2.treeConflicted) {
            this.currentDir.skip = true;
            return;
        }
        this.diffCallback.dirAdded(this.currentResult.reset(), svnNgRemoteDiffEditor$DirBaton.wcPath, this.targetRevision, string2, l2);
        svnNgRemoteDiffEditor$DirBaton.skip = this.currentResult.skip;
        svnNgRemoteDiffEditor$DirBaton.skipChildren = this.currentResult.skipChildren;
        svnNgRemoteDiffEditor$DirBaton.treeConflicted = this.currentResult.treeConflicted;
        SVNNodeKind sVNNodeKind = SVNNodeKind.DIR;
        SVNEventAction sVNEventAction = null;
        SvnNgRemoteDiffEditor$DeletedPath svnNgRemoteDiffEditor$DeletedPath = (SvnNgRemoteDiffEditor$DeletedPath)this.deletedPaths.get(svnNgRemoteDiffEditor$DirBaton.wcPath);
        if (svnNgRemoteDiffEditor$DeletedPath != null) {
            this.currentResult.contentState = svnNgRemoteDiffEditor$DeletedPath.state;
            sVNNodeKind = svnNgRemoteDiffEditor$DeletedPath.kind;
            this.deletedPaths.remove(svnNgRemoteDiffEditor$DirBaton.wcPath);
        }
        sVNEventAction = svnNgRemoteDiffEditor$DirBaton.treeConflicted ? SVNEventAction.TREE_CONFLICT : (svnNgRemoteDiffEditor$DeletedPath != null ? (svnNgRemoteDiffEditor$DeletedPath.action == SVNEventAction.UPDATE_DELETE ? SVNEventAction.UPDATE_REPLACE : svnNgRemoteDiffEditor$DeletedPath.action) : (this.currentResult.contentState == SVNStatusType.MISSING || this.currentResult.contentState == SVNStatusType.OBSTRUCTED ? SVNEventAction.SKIP : SVNEventAction.UPDATE_ADD));
        SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(svnNgRemoteDiffEditor$DirBaton.wcPath, sVNNodeKind, null, -1L, this.currentResult.contentState, this.currentResult.contentState, SVNStatusType.LOCK_INAPPLICABLE, sVNEventAction, sVNEventAction, null, null, null);
        this.handleEvent(sVNEvent);
    }

    @Override
    public void openDir(String string, long l2) {
        SvnNgRemoteDiffEditor$DirBaton svnNgRemoteDiffEditor$DirBaton = this.makeDirBaton(string, this.currentDir, false);
        svnNgRemoteDiffEditor$DirBaton.pristineProperties = new SVNProperties();
        SvnNgRemoteDiffEditor$DirBaton svnNgRemoteDiffEditor$DirBaton2 = this.currentDir;
        this.currentDir = svnNgRemoteDiffEditor$DirBaton;
        if (svnNgRemoteDiffEditor$DirBaton2.skip || svnNgRemoteDiffEditor$DirBaton2.skipChildren || svnNgRemoteDiffEditor$DirBaton2.treeConflicted) {
            this.currentDir.skip = true;
            return;
        }
        svnNgRemoteDiffEditor$DirBaton.loadProperties(this.repository, string, l2);
        this.diffCallback.dirOpened(this.currentResult.reset(), svnNgRemoteDiffEditor$DirBaton.wcPath, l2);
        svnNgRemoteDiffEditor$DirBaton.skip = this.currentResult.skip;
        svnNgRemoteDiffEditor$DirBaton.skipChildren = this.currentResult.skipChildren;
        svnNgRemoteDiffEditor$DirBaton.treeConflicted = this.currentResult.treeConflicted;
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        if (this.currentDir.skip) {
            return;
        }
        this.currentDir.propChanges.put(string, sVNPropertyValue);
    }

    @Override
    public void closeDir() {
        boolean bl2 = false;
        this.currentResult.reset();
        this.currentResult.contentState = SVNStatusType.UNKNOWN;
        this.currentResult.propState = SVNStatusType.UNKNOWN;
        SvnNgRemoteDiffEditor$DirBaton svnNgRemoteDiffEditor$DirBaton = this.currentDir;
        if (svnNgRemoteDiffEditor$DirBaton.skip) {
            this.currentDir = svnNgRemoteDiffEditor$DirBaton.parent;
            return;
        }
        if (!svnNgRemoteDiffEditor$DirBaton.added && svnNgRemoteDiffEditor$DirBaton.propChanges.size() > 0) {
            this.removeNonPropChanges(svnNgRemoteDiffEditor$DirBaton.pristineProperties, svnNgRemoteDiffEditor$DirBaton.propChanges);
        }
        if (svnNgRemoteDiffEditor$DirBaton.propChanges.size() > 0) {
            this.diffCallback.dirPropsChanged(this.currentResult, svnNgRemoteDiffEditor$DirBaton.wcPath, svnNgRemoteDiffEditor$DirBaton.added, svnNgRemoteDiffEditor$DirBaton.propChanges, svnNgRemoteDiffEditor$DirBaton.pristineProperties);
            if (this.currentResult.propState == SVNStatusType.OBSTRUCTED || this.currentResult.propState == SVNStatusType.MISSING) {
                this.currentResult.contentState = this.currentResult.propState;
                bl2 = true;
            }
        }
        this.diffCallback.dirClosed(null, svnNgRemoteDiffEditor$DirBaton.wcPath, svnNgRemoteDiffEditor$DirBaton.added);
        if (!bl2 && !svnNgRemoteDiffEditor$DirBaton.added) {
            for (Object object : this.deletedPaths.keySet()) {
                SvnNgRemoteDiffEditor$DeletedPath svnNgRemoteDiffEditor$DeletedPath = (SvnNgRemoteDiffEditor$DeletedPath)this.deletedPaths.get(object);
                SVNEvent sVNEvent = SVNEventFactory.createSVNEvent((File)object, svnNgRemoteDiffEditor$DeletedPath.kind, null, -1L, svnNgRemoteDiffEditor$DeletedPath.state, svnNgRemoteDiffEditor$DeletedPath.state, SVNStatusType.LOCK_INAPPLICABLE, svnNgRemoteDiffEditor$DeletedPath.action, svnNgRemoteDiffEditor$DeletedPath.action, null, null, null);
                this.handleEvent(sVNEvent);
            }
            this.deletedPaths.clear();
        }
        if (!svnNgRemoteDiffEditor$DirBaton.added) {
            Object object;
            Object object2 = null;
            object2 = svnNgRemoteDiffEditor$DirBaton.treeConflicted ? SVNEventAction.TREE_CONFLICT : (bl2 ? SVNEventAction.SKIP : SVNEventAction.UPDATE_UPDATE);
            object = SVNEventFactory.createSVNEvent(svnNgRemoteDiffEditor$DirBaton.wcPath, SVNNodeKind.DIR, null, -1L, this.currentResult.contentState, this.currentResult.propState, SVNStatusType.LOCK_INAPPLICABLE, (SVNEventAction)object2, (SVNEventAction)object2, null, null, null);
            this.handleEvent((SVNEvent)object);
        }
        this.currentDir = svnNgRemoteDiffEditor$DirBaton.parent;
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        SvnNgRemoteDiffEditor$FileBaton svnNgRemoteDiffEditor$FileBaton;
        this.currentFile = svnNgRemoteDiffEditor$FileBaton = this.makeFileBaton(string, true);
        if (this.currentDir.skip || this.currentDir.skipChildren || this.currentDir.treeConflicted) {
            svnNgRemoteDiffEditor$FileBaton.skip = true;
            return;
        }
        svnNgRemoteDiffEditor$FileBaton.pristineProps = new SVNProperties();
    }

    @Override
    public void openFile(String string, long l2) {
        SvnNgRemoteDiffEditor$FileBaton svnNgRemoteDiffEditor$FileBaton;
        this.currentFile = svnNgRemoteDiffEditor$FileBaton = this.makeFileBaton(string, false);
        if (this.currentDir.skip || this.currentDir.skipChildren || this.currentDir.treeConflicted) {
            svnNgRemoteDiffEditor$FileBaton.skip = true;
            return;
        }
        svnNgRemoteDiffEditor$FileBaton.baseRevision = l2;
        this.diffCallback.fileOpened(this.currentResult.reset(), svnNgRemoteDiffEditor$FileBaton.wcPath, l2);
        svnNgRemoteDiffEditor$FileBaton.treeConflicted = this.currentResult.treeConflicted;
        svnNgRemoteDiffEditor$FileBaton.skip = this.currentResult.skip;
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        if (this.currentFile.skip) {
            return;
        }
        this.currentFile.propChanges.put(string2, sVNPropertyValue);
    }

    @Override
    public void closeFile(String string, String string2) {
        Object object;
        Object object2;
        if (this.currentFile.skip) {
            this.currentFile = null;
            return;
        }
        SvnNgRemoteDiffEditor$FileBaton svnNgRemoteDiffEditor$FileBaton = this.currentFile;
        if (string2 != null && (object2 = SvnChecksum.fromString("$md5 $" + string2)) != null && svnNgRemoteDiffEditor$FileBaton.resultMd5Checksum != null && !((SvnChecksum)object2).equals(svnNgRemoteDiffEditor$FileBaton.resultMd5Checksum)) {
            object = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''", (Object)svnNgRemoteDiffEditor$FileBaton.repoPath);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (!svnNgRemoteDiffEditor$FileBaton.added && svnNgRemoteDiffEditor$FileBaton.propChanges.size() > 0) {
            if (svnNgRemoteDiffEditor$FileBaton.pristineProps == null) {
                svnNgRemoteDiffEditor$FileBaton.loadFile(this.context, this.repository, true, this.tmpFiles);
            }
            this.removeNonPropChanges(svnNgRemoteDiffEditor$FileBaton.pristineProps, svnNgRemoteDiffEditor$FileBaton.propChanges);
        }
        if (svnNgRemoteDiffEditor$FileBaton.endRevisionFile != null || svnNgRemoteDiffEditor$FileBaton.propChanges.size() > 0) {
            object2 = svnNgRemoteDiffEditor$FileBaton.getMimeTypes();
            if (svnNgRemoteDiffEditor$FileBaton.added) {
                this.diffCallback.fileAdded(this.currentResult.reset(), svnNgRemoteDiffEditor$FileBaton.wcPath, svnNgRemoteDiffEditor$FileBaton.endRevisionFile != null ? svnNgRemoteDiffEditor$FileBaton.startRevisionFile : null, svnNgRemoteDiffEditor$FileBaton.endRevisionFile, 0L, this.targetRevision, (String)object2[0], (String)object2[1], null, -1L, svnNgRemoteDiffEditor$FileBaton.propChanges, svnNgRemoteDiffEditor$FileBaton.pristineProps);
                svnNgRemoteDiffEditor$FileBaton.treeConflicted = this.currentResult.treeConflicted;
            } else {
                this.diffCallback.fileChanged(this.currentResult.reset(), svnNgRemoteDiffEditor$FileBaton.wcPath, svnNgRemoteDiffEditor$FileBaton.endRevisionFile != null ? svnNgRemoteDiffEditor$FileBaton.startRevisionFile : null, svnNgRemoteDiffEditor$FileBaton.endRevisionFile, this.revision, this.targetRevision, (String)object2[0], (String)object2[1], svnNgRemoteDiffEditor$FileBaton.propChanges, svnNgRemoteDiffEditor$FileBaton.pristineProps);
                svnNgRemoteDiffEditor$FileBaton.treeConflicted = this.currentResult.treeConflicted;
            }
        }
        object2 = SVNNodeKind.FILE;
        object = null;
        SvnNgRemoteDiffEditor$DeletedPath svnNgRemoteDiffEditor$DeletedPath = (SvnNgRemoteDiffEditor$DeletedPath)this.deletedPaths.get(svnNgRemoteDiffEditor$FileBaton.wcPath);
        if (svnNgRemoteDiffEditor$DeletedPath != null) {
            this.deletedPaths.remove(svnNgRemoteDiffEditor$FileBaton.wcPath);
            object2 = svnNgRemoteDiffEditor$DeletedPath.kind;
            this.currentResult.contentState = svnNgRemoteDiffEditor$DeletedPath.state;
            this.currentResult.propState = svnNgRemoteDiffEditor$DeletedPath.state;
        }
        Object object3 = null;
        if (svnNgRemoteDiffEditor$FileBaton.treeConflicted) {
            object = SVNEventAction.TREE_CONFLICT;
        } else if (svnNgRemoteDiffEditor$DeletedPath != null) {
            object = svnNgRemoteDiffEditor$DeletedPath.action == SVNEventAction.UPDATE_DELETE && svnNgRemoteDiffEditor$FileBaton.added ? SVNEventAction.UPDATE_REPLACE : svnNgRemoteDiffEditor$DeletedPath.action;
        } else if (this.currentResult.contentState == SVNStatusType.OBSTRUCTED || this.currentResult.contentState == SVNStatusType.MISSING) {
            object = SVNEventAction.SKIP;
            object3 = svnNgRemoteDiffEditor$FileBaton.added ? SVNEventAction.UPDATE_ADD : SVNEventAction.UPDATE_UPDATE;
        } else {
            object = svnNgRemoteDiffEditor$FileBaton.added ? SVNEventAction.UPDATE_ADD : SVNEventAction.UPDATE_UPDATE;
        }
        if (object3 == null) {
            object3 = object;
        }
        SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(svnNgRemoteDiffEditor$FileBaton.wcPath, (SVNNodeKind)object2, null, -1L, this.currentResult.contentState, this.currentResult.propState, SVNStatusType.LOCK_INAPPLICABLE, (SVNEventAction)object, (SVNEventAction)object3, null, null, null);
        this.handleEvent(sVNEvent);
    }

    private void removeNonPropChanges(SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : sVNProperties2.nameSet()) {
            SVNPropertyValue sVNPropertyValue;
            SVNPropertyValue sVNPropertyValue2 = sVNProperties2.getSVNPropertyValue(string);
            if (sVNPropertyValue2 == null || (sVNPropertyValue = sVNProperties.getSVNPropertyValue(string)) == null || !sVNPropertyValue.equals(sVNPropertyValue2)) continue;
            hashSet.add(string);
        }
        for (String string : hashSet) {
            sVNProperties2.remove(string);
        }
    }

    @Override
    public SVNCommitInfo closeEdit() {
        this.cleanup();
        return null;
    }

    public void cleanup() {
        for (File file : this.tmpFiles) {
            try {
                SVNFileUtil.deleteFile(file);
            }
            catch (SVNException sVNException) {}
        }
        if (this.globalTmpDir != null) {
            SVNFileUtil.deleteAll(this.globalTmpDir, true);
        }
    }

    @Override
    public void abortEdit() {
    }

    static /* synthetic */ boolean access$000(SvnNgRemoteDiffEditor svnNgRemoteDiffEditor) {
        return svnNgRemoteDiffEditor.pureRemoteDiff;
    }
}

