/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNExternalsStore;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbRelocate;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbRelocate$ISvnRelocateValidator;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc2.SvnRelocate;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgRelocate
extends SvnNgOperationRunner
implements SvnWcDbRelocate$ISvnRelocateValidator {
    private Map collectedUuids;

    @Override
    protected SVNURL run(SVNWCContext sVNWCContext) {
        SVNURL sVNURL;
        if (((SvnRelocate)this.getOperation()).getFromUrl() == null) {
            sVNURL = sVNWCContext.getNodeUrl(this.getFirstTarget());
            ((SvnRelocate)this.getOperation()).setFromUrl(sVNURL);
        }
        if (((SvnRelocate)this.getOperation()).isIgnoreExternals()) {
            SvnWcDbRelocate.relocate(sVNWCContext, this.getFirstTarget(), ((SvnRelocate)this.getOperation()).getFromUrl(), ((SvnRelocate)this.getOperation()).getToUrl(), this);
            return ((SvnRelocate)this.getOperation()).getToUrl();
        }
        sVNURL = sVNWCContext.getNodeReposInfo((File)this.getFirstTarget()).reposRootUrl;
        SvnWcDbRelocate.relocate(sVNWCContext, this.getFirstTarget(), ((SvnRelocate)this.getOperation()).getFromUrl(), ((SvnRelocate)this.getOperation()).getToUrl(), this);
        SVNURL sVNURL2 = sVNWCContext.getNodeReposInfo((File)this.getFirstTarget()).reposRootUrl;
        SVNExternalsStore sVNExternalsStore = new SVNExternalsStore();
        sVNWCContext.getDb().gatherExternalDefinitions(this.getFirstTarget(), sVNExternalsStore);
        for (File file : sVNExternalsStore.getNewExternals().keySet()) {
            String string;
            SVNExternal[] sVNExternalArray = SVNExternal.parseExternals(file, string = (String)sVNExternalsStore.getNewExternals().get(file));
            if (sVNExternalArray == null || sVNExternalArray.length <= 0) continue;
            this.relocateExternals(file, sVNExternalArray, sVNURL, sVNURL2);
        }
        return ((SvnRelocate)this.getOperation()).getToUrl();
    }

    private void relocateExternals(File file, SVNExternal[] sVNExternalArray, SVNURL sVNURL, SVNURL sVNURL2) {
        for (int i2 = 0; i2 < sVNExternalArray.length; ++i2) {
            String string = sVNExternalArray[i2].getUnresolvedUrl();
            if (!string.startsWith("../") && !string.startsWith("^/")) continue;
            File file2 = SVNFileUtil.createFilePath(file, sVNExternalArray[i2].getPath());
            try {
                SVNURL sVNURL3 = this.getWcContext().getNodeReposInfo((File)file2).reposRootUrl;
                if (!sVNURL3.equals(sVNURL)) continue;
                SvnWcDbRelocate.relocate(this.getWcContext(), file2, sVNURL, sVNURL2, this);
                continue;
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) continue;
            }
        }
    }

    @Override
    public void validateRelocation(String string, SVNURL sVNURL, SVNURL sVNURL2) {
        Object object;
        String string2 = null;
        SVNURL sVNURL3 = null;
        for (String string3 : this.collectedUuids.keySet()) {
            SVNURL sVNURL4 = (SVNURL)this.collectedUuids.get(string3);
            if (SVNURLUtil.getRelativeURL(sVNURL4, sVNURL, false) == null) continue;
            string2 = string3;
            sVNURL3 = sVNURL4;
            break;
        }
        if (string2 == null) {
            object = this.getRepositoryAccess().createRepository(sVNURL, null);
            string2 = ((SVNRepository)object).getRepositoryUUID(true);
            sVNURL3 = ((SVNRepository)object).getRepositoryRoot(true);
        }
        if (sVNURL2 != null && !sVNURL2.equals(sVNURL3)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "''{0}'' is not the root of the repository", (Object)sVNURL);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (string != null && !string.equals(string2)) {
            object = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "The repository at ''{0}'' has uuid ''{1}'', but the WC has ''{2}''", sVNURL, string2, string);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
    }

    @Override
    public void reset(SvnWcGeneration svnWcGeneration) {
        super.reset(svnWcGeneration);
        this.collectedUuids = new HashMap();
    }
}

