/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNRevisionProperty;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb$Mode;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNFileContentFetcher;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb$DirParsedInfo;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$InheritedProperties;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbProperties;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager$1;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager$2;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager$3;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc2.ISvnAddParameters;
import org.tmatesoft.svn.core.wc2.ISvnAddParameters$Action;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.hooks.ISvnPropertyValueProvider;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgPropertiesManager {
    public static Collection getGlobalIgnores(ISVNOptions iSVNOptions) {
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = iSVNOptions.getIgnorePatterns();
        for (int i2 = 0; stringArray != null && i2 < stringArray.length; ++i2) {
            hashSet.add(stringArray[i2]);
        }
        return hashSet;
    }

    public static Collection getEffectiveIgnores(SVNWCContext sVNWCContext, File file, Collection collection) {
        HashSet<Object> hashSet = new HashSet<Object>();
        if (collection != null) {
            hashSet.addAll(collection);
        } else {
            hashSet.addAll(SvnNgPropertiesManager.getGlobalIgnores(sVNWCContext.getOptions()));
        }
        if (sVNWCContext != null && file != null) {
            try {
                Object object;
                Object object2;
                String string = sVNWCContext.getProperty(file, "svn:ignore");
                if (string != null) {
                    object2 = new StringTokenizer(string, "\r\n");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken().trim();
                        if (((String)object).length() <= 0) continue;
                        hashSet.add(object);
                    }
                }
                if ((string = sVNWCContext.getProperty(file, "svn:global-ignores")) != null) {
                    object2 = new StringTokenizer(string, "\r\n");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken().trim();
                        if (((String)object).length() <= 0) continue;
                        hashSet.add(object);
                    }
                }
                object2 = (SVNWCDb)sVNWCContext.getDb();
                object = ((SVNWCDb)object2).parseDir(file, SVNSqlJetDb$Mode.ReadOnly);
                List list = SvnWcDbProperties.readInheritedProperties(((SVNWCDb$DirParsedInfo)object).wcDbDir.getWCRoot(), ((SVNWCDb$DirParsedInfo)object).localRelPath, "svn:global-ignores");
                for (Structure structure : list) {
                    SVNProperties sVNProperties = (SVNProperties)structure.get(StructureFields$InheritedProperties.properties);
                    String string2 = (String)structure.get(StructureFields$InheritedProperties.pathOrURL);
                    string = sVNProperties.getStringValue("svn:global-ignores");
                    if (string == null) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken().trim();
                        if (string3.length() <= 0) continue;
                        hashSet.add(string3);
                    }
                }
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
        return hashSet;
    }

    public static boolean isIgnored(String string, Collection collection) {
        if (collection == null) {
            return false;
        }
        for (String string2 : collection) {
            if (!DefaultSVNOptions.matches(string2, string)) continue;
            return true;
        }
        return false;
    }

    public static Map parseAutoProperties(SVNPropertyValue sVNPropertyValue, Map map) {
        String[] stringArray;
        String string = SVNPropertyValue.getPropertyAsString(sVNPropertyValue);
        Map map2 = map = map == null ? new HashMap() : map;
        if (string == null) {
            return map;
        }
        for (String string2 : stringArray = string.split("\n")) {
            String[] stringArray2;
            int n2;
            if ((string2 = string2.trim()).length() == 0 || (n2 = string2.indexOf(61)) < 0) continue;
            String string3 = string2.substring(0, n2).trim();
            String string4 = string2.substring(n2 + 1).trim();
            HashMap<String, String> hashMap = (HashMap<String, String>)map.get(string3);
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
                map.put(string3, hashMap);
            }
            for (String string5 : stringArray2 = string4.split(";")) {
                String string6;
                String string7;
                if ((string5 = string5.trim()).length() == 0) continue;
                n2 = string5.indexOf(61);
                if (n2 < 0) {
                    string7 = string5.trim();
                    string6 = "*";
                } else {
                    string7 = string5.substring(0, n2).trim();
                    string6 = string5.substring(n2 + 1).trim();
                }
                hashMap.put(string7, string6);
            }
        }
        return map;
    }

    public static Map getMatchedAutoProperties(String string, Map map) {
        if (map == null) {
            return Collections.emptyMap();
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            String string2 = (String)entry.getKey();
            if (!DefaultSVNOptions.matches(string2, string)) continue;
            Map map2 = (Map)entry.getValue();
            hashMap.putAll(map2);
        }
        return hashMap;
    }

    public static void setProperty(SVNWCContext sVNWCContext, File file, String string, SVNPropertyValue sVNPropertyValue, SVNDepth sVNDepth, boolean bl2, ISVNEventHandler iSVNEventHandler, Collection collection) {
        SvnNgPropertiesManager.setProperty(sVNWCContext, file, string, sVNPropertyValue, null, sVNDepth, bl2, iSVNEventHandler, null, collection);
    }

    public static void setProperty(SVNWCContext sVNWCContext, File file, String string, SVNPropertyValue sVNPropertyValue, SVNDepth sVNDepth, boolean bl2, ISVNEventHandler iSVNEventHandler, ISvnObjectReceiver iSvnObjectReceiver, Collection collection) {
        SvnNgPropertiesManager.setProperty(sVNWCContext, file, string, sVNPropertyValue, null, sVNDepth, bl2, iSVNEventHandler, iSvnObjectReceiver, collection);
    }

    public static void setProperty(SVNWCContext sVNWCContext, File file, String string, SVNPropertyValue sVNPropertyValue, ISvnPropertyValueProvider iSvnPropertyValueProvider, SVNDepth sVNDepth, boolean bl2, ISVNEventHandler iSVNEventHandler, ISvnObjectReceiver iSvnObjectReceiver, Collection collection) {
        Serializable serializable;
        if (string != null) {
            if (SVNProperty.isEntryProperty(string)) {
                serializable = SVNErrorMessage.create(SVNErrorCode.BAD_PROP_KIND, "Property ''{0}'' is an entry property", (Object)string);
                SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
            } else if (SVNProperty.isWorkingCopyProperty(string)) {
                SVNProperties sVNProperties = sVNWCContext.getDb().getBaseDavCache(file);
                if (sVNProperties == null && sVNPropertyValue != null) {
                    sVNProperties = new SVNProperties();
                }
                if (sVNProperties != null) {
                    if (sVNPropertyValue != null) {
                        sVNProperties.put(string, sVNPropertyValue);
                    } else {
                        sVNProperties.remove(string);
                    }
                }
                sVNWCContext.getDb().setBaseDavCache(file, sVNProperties);
                return;
            }
        }
        File file2 = (serializable = sVNWCContext.readKind(file, true)) == SVNNodeKind.DIR ? file : SVNFileUtil.getParentFile(file);
        sVNWCContext.writeCheck(file2);
        if (sVNDepth == SVNDepth.EMPTY) {
            if (!sVNWCContext.matchesChangelist(file, collection)) {
                return;
            }
            SvnNgPropertiesManager.setProperty(sVNWCContext, file, serializable, string, sVNPropertyValue, iSvnPropertyValueProvider, bl2, iSVNEventHandler, iSvnObjectReceiver);
        } else {
            sVNWCContext.nodeWalkChildren(file, new SvnNgPropertiesManager$1(sVNWCContext, string, sVNPropertyValue, iSvnPropertyValueProvider, bl2, iSVNEventHandler, iSvnObjectReceiver), false, sVNDepth, collection);
        }
    }

    public static void setProperty(SVNWCContext sVNWCContext, File file, SVNNodeKind sVNNodeKind, String string, SVNPropertyValue serializable, ISvnPropertyValueProvider iSvnPropertyValueProvider, boolean bl2, ISVNEventHandler iSVNEventHandler, ISvnObjectReceiver iSvnObjectReceiver) {
        Object object;
        Object object2;
        Serializable serializable2;
        Object object3;
        Structure structure = sVNWCContext.getDb().readInfo(file, StructureFields$NodeInfo.status);
        ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus = (ISVNWCDb$SVNWCDbStatus)((Object)structure.get(StructureFields$NodeInfo.status));
        if (iSVNWCDb$SVNWCDbStatus != ISVNWCDb$SVNWCDbStatus.Normal && iSVNWCDb$SVNWCDbStatus != ISVNWCDb$SVNWCDbStatus.Added && iSVNWCDb$SVNWCDbStatus != ISVNWCDb$SVNWCDbStatus.Incomplete) {
            object3 = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Can''t set properties on ''{0}'': invalid status for updating properties.", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
        }
        if (iSvnPropertyValueProvider == null && serializable != null && SVNProperty.isSVNProperty(string)) {
            object3 = new SvnNgPropertiesManager$2(sVNWCContext, file);
            serializable = serializable2 = SVNPropertiesManager.validatePropertyValue(file, sVNNodeKind, string, (SVNPropertyValue)serializable, bl2, sVNWCContext.getOptions(), (ISVNFileContentFetcher)object3);
        }
        object3 = null;
        if (iSvnPropertyValueProvider == null && sVNNodeKind == SVNNodeKind.FILE && ("svn:executable".equals(string) || "svn:needs-lock".equals(string))) {
            object3 = sVNWCContext.wqBuildSyncFileFlags(file);
        }
        serializable2 = new SVNProperties();
        try {
            serializable2 = sVNWCContext.getDb().readProperties(file);
        }
        catch (SVNException sVNException) {
            object2 = sVNException.getErrorMessage().wrap("Failed to load current properties");
            SVNErrorManager.error((SVNErrorMessage)object2, sVNException, SVNLogType.WC);
        }
        if (iSvnPropertyValueProvider != null) {
            SVNPropertyValue sVNPropertyValue = ((SVNProperties)serializable2).getSVNPropertyValue("svn:keywords");
            object2 = ((SVNProperties)serializable2).getSVNPropertyValue("svn:eol-style");
            boolean bl3 = ((SVNProperties)serializable2).containsName("svn:executable");
            boolean bl4 = ((SVNProperties)serializable2).containsName("svn:needs-lock");
            if ((serializable2 = iSvnPropertyValueProvider.providePropertyValues(file, (SVNProperties)serializable2)) == null) {
                serializable2 = new SVNProperties();
            }
            SVNPropertyValue sVNPropertyValue2 = ((SVNProperties)serializable2).getSVNPropertyValue("svn:keywords");
            SVNPropertyValue sVNPropertyValue3 = ((SVNProperties)serializable2).getSVNPropertyValue("svn:eol-style");
            boolean bl5 = ((SVNProperties)serializable2).containsName("svn:executable");
            boolean bl6 = ((SVNProperties)serializable2).containsName("svn:needs-lock");
            if (bl5 != bl3 || bl6 != bl4) {
                object3 = sVNWCContext.wqBuildSyncFileFlags(file);
            }
            boolean bl7 = !SvnNgPropertiesManager.equals(sVNPropertyValue, sVNPropertyValue2) || !SvnNgPropertiesManager.equals((SVNPropertyValue)object2, sVNPropertyValue3);
            sVNWCContext.getDb().opSetProps(file, (SVNProperties)serializable2, null, bl7, (SVNSkel)object3);
            if (object3 != null) {
                sVNWCContext.wqRun(file);
            }
            return;
        }
        boolean bl8 = false;
        if (sVNNodeKind == SVNNodeKind.FILE && "svn:keywords".equals(string)) {
            HashMap hashMap;
            object2 = ((SVNProperties)serializable2).getStringValue("svn:keywords");
            object = object2 != null ? sVNWCContext.getKeyWords(file, (String)object2) : new HashMap();
            Map map = hashMap = serializable != null ? sVNWCContext.getKeyWords(file, ((SVNPropertyValue)serializable).getString()) : new HashMap();
            if (!object.equals(hashMap)) {
                bl8 = true;
            }
        } else if (sVNNodeKind == SVNNodeKind.FILE && "svn:eol-style".equals(string)) {
            object2 = ((SVNProperties)serializable2).getStringValue("svn:eol-style");
            if (object2 == null || serializable == null) {
                bl8 = object2 != null && serializable == null || object2 == null && serializable != null;
            } else {
                boolean bl9 = bl8 = !SVNPropertyValue.create((String)object2).equals(serializable);
            }
        }
        if (!((SVNProperties)serializable2).containsName(string)) {
            object2 = serializable == null ? SVNEventAction.PROPERTY_DELETE_NONEXISTENT : SVNEventAction.PROPERTY_ADD;
        } else {
            Object object4 = object2 = serializable == null ? SVNEventAction.PROPERTY_DELETE : SVNEventAction.PROPERTY_MODIFY;
        }
        if (serializable != null) {
            ((SVNProperties)serializable2).put(string, (SVNPropertyValue)serializable);
        } else {
            ((SVNProperties)serializable2).remove(string);
        }
        sVNWCContext.getDb().opSetProps(file, (SVNProperties)serializable2, null, bl8, (SVNSkel)object3);
        if (object3 != null) {
            sVNWCContext.wqRun(file);
        }
        if (iSvnObjectReceiver != null) {
            iSvnObjectReceiver.receive(SvnTarget.fromFile(file), new SVNPropertyData(string, (SVNPropertyValue)serializable, sVNWCContext.getOptions()));
        }
        if (iSVNEventHandler != null) {
            object = SVNEventFactory.createSVNEvent(file, SVNNodeKind.NONE, null, -1L, (SVNEventAction)object2, (SVNEventAction)object2, null, null, 1L, 1L, null, string);
            iSVNEventHandler.handleEvent((SVNEvent)object, -1.0);
        }
    }

    public static void setAutoProperties(SVNWCContext sVNWCContext, File file, SVNProperties sVNProperties, ISvnAddParameters iSvnAddParameters, Runnable runnable) {
        SvnNgPropertiesManager$3 svnNgPropertiesManager$3 = new SvnNgPropertiesManager$3(sVNProperties, file);
        SVNProperties sVNProperties2 = new SVNProperties(sVNProperties);
        String string = null;
        for (String string2 : sVNProperties2.nameSet()) {
            try {
                SVNPropertyValue sVNPropertyValue = SVNPropertiesManager.validatePropertyValue(file, SVNNodeKind.FILE, string2, sVNProperties.getSVNPropertyValue(string2), false, sVNWCContext.getOptions(), svnNgPropertiesManager$3);
                sVNProperties.put(string2, sVNPropertyValue);
            }
            catch (SVNException sVNException) {
                if ("svn:eol-style".equals(string2) && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.ILLEGAL_TARGET && sVNException.getErrorMessage().getMessage().indexOf("newlines") >= 0) {
                    ISvnAddParameters$Action iSvnAddParameters$Action = iSvnAddParameters.onInconsistentEOLs(file);
                    if (iSvnAddParameters$Action == ISvnAddParameters$Action.REPORT_ERROR) {
                        try {
                            runnable.run();
                        }
                        catch (Throwable throwable) {
                            SVNDebugLog.getDefaultLog().log(SVNLogType.WC, throwable, Level.INFO);
                        }
                        throw sVNException;
                    }
                    if (iSvnAddParameters$Action == ISvnAddParameters$Action.ADD_AS_IS) {
                        sVNProperties.remove(string2);
                        continue;
                    }
                    if (iSvnAddParameters$Action != ISvnAddParameters$Action.ADD_AS_BINARY) continue;
                    sVNProperties.remove(string2);
                    string = "application/octet-stream";
                    continue;
                }
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    SVNDebugLog.getDefaultLog().log(SVNLogType.WC, throwable, Level.INFO);
                }
                throw sVNException;
            }
        }
        if (string != null) {
            sVNProperties.put("svn:mime-type", string);
        }
        Object object = null;
        if (sVNProperties.containsName("svn:executable") || sVNProperties.containsName("svn:needs-lock")) {
            object = sVNWCContext.wqBuildSyncFileFlags(file);
        }
        boolean bl2 = sVNProperties.containsName("svn:keywords") || sVNProperties.containsName("svn:eol-style");
        sVNWCContext.getDb().opSetProps(file, sVNProperties, null, bl2, (SVNSkel)object);
        if (object != null) {
            sVNWCContext.wqRun(file);
        }
    }

    private static boolean equals(SVNPropertyValue sVNPropertyValue, SVNPropertyValue sVNPropertyValue2) {
        if (sVNPropertyValue == null || sVNPropertyValue2 == null) {
            return sVNPropertyValue == sVNPropertyValue2;
        }
        return sVNPropertyValue.equals(sVNPropertyValue2);
    }

    public static void checkPropertyName(String string, SVNPropertyValue sVNPropertyValue) {
        SVNErrorMessage sVNErrorMessage;
        if (SVNRevisionProperty.isRevisionProperty(string)) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Revision property ''{0}'' not allowed in this context", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (sVNPropertyValue != null && !SVNPropertiesManager.isValidPropertyName(string)) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Bad property name: ''{0}''", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (SVNProperty.isWorkingCopyProperty(string)) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", (Object)string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
    }

    public static void categorizeProperties(SVNProperties sVNProperties, SVNProperties sVNProperties2, SVNProperties sVNProperties3, SVNProperties sVNProperties4) {
        for (String string : sVNProperties.nameSet()) {
            SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string);
            if (SVNProperty.isEntryProperty(string) && sVNProperties3 != null) {
                sVNProperties3.put(string, sVNPropertyValue);
                continue;
            }
            if (SVNProperty.isRegularProperty(string) && sVNProperties2 != null) {
                sVNProperties2.put(string, sVNPropertyValue);
                continue;
            }
            if (!SVNProperty.isWorkingCopyProperty(string) || sVNProperties4 == null) continue;
            sVNProperties4.put(string, sVNPropertyValue);
        }
    }

    public static void splitAndAppend(List list, String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            list.add(string2);
        }
    }
}

