/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.Collection;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNCommitter17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc2.SvnLocalOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRepositoryAccess;
import org.tmatesoft.svn.core.wc2.ISvnCommitParameters;

public abstract class SvnNgOperationRunner
extends SvnLocalOperationRunner {
    private SvnNgRepositoryAccess repositoryAccess;

    @Override
    protected Object run() {
        return this.run(this.getWcContext());
    }

    protected boolean matchesChangelist(File file) {
        return this.getWcContext().matchesChangelist(file, this.getOperation().getApplicableChangelists());
    }

    protected SvnNgRepositoryAccess getRepositoryAccess() {
        if (this.repositoryAccess == null) {
            this.repositoryAccess = new SvnNgRepositoryAccess(this.getOperation(), this.getWcContext());
        }
        return this.repositoryAccess;
    }

    protected void setRepositoryAccess(SvnNgRepositoryAccess svnNgRepositoryAccess) {
        this.repositoryAccess = svnNgRepositoryAccess;
    }

    protected abstract Object run(SVNWCContext var1);

    @Override
    public void reset(SvnWcGeneration svnWcGeneration) {
        super.reset(svnWcGeneration);
        this.repositoryAccess = null;
    }

    @Override
    public SvnWcGeneration getWcGeneration() {
        return SvnWcGeneration.V17;
    }

    protected void deleteDeleteFiles(SVNCommitter17 sVNCommitter17, ISvnCommitParameters iSvnCommitParameters) {
        if (iSvnCommitParameters == null) {
            return;
        }
        Collection collection = sVNCommitter17.getDeletedPaths();
        for (File file : collection) {
            boolean bl2 = false;
            if (file.isFile()) {
                bl2 = iSvnCommitParameters.onFileDeletion(file);
            } else if (file.isDirectory()) {
                bl2 = iSvnCommitParameters.onDirectoryDeletion(file);
            }
            if (!bl2) continue;
            SVNFileUtil.deleteAll(file, true);
        }
    }
}

