/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$MergeInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$MergePropertiesInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$SVNWCNodeReposInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess$LocationsInfo;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackResult;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgMergeCallback$1;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgMergeDriver;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgMergeDriver$ObstructionState;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemove;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgReposToWcCopy;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRepositoryAccess;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgMergeCallback
implements ISvnDiffCallback {
    private Collection conflictedPaths;
    private SvnNgMergeDriver driver;

    public SvnNgMergeCallback(SvnNgMergeDriver svnNgMergeDriver) {
        this.driver = svnNgMergeDriver;
    }

    public Collection getConflictedPaths() {
        return this.conflictedPaths;
    }

    @Override
    public void fileOpened(SvnDiffCallbackResult svnDiffCallbackResult, File file, long l2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(SvnDiffCallbackResult svnDiffCallbackResult, File file, File file2, File file3, long l2, long l3, String string, String string2, SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        SvnNgMergeDriver$ObstructionState svnNgMergeDriver$ObstructionState = this.driver.performObstructionCheck(file, SVNNodeKind.UNKNOWN);
        if (svnNgMergeDriver$ObstructionState.obstructionState != SVNStatusType.INAPPLICABLE) {
            svnDiffCallbackResult.contentState = svnNgMergeDriver$ObstructionState.obstructionState;
            if (svnNgMergeDriver$ObstructionState.obstructionState == SVNStatusType.MISSING) {
                svnDiffCallbackResult.propState = SVNStatusType.MISSING;
            }
            return;
        }
        SVNNodeKind sVNNodeKind = svnNgMergeDriver$ObstructionState.kind;
        boolean bl2 = svnNgMergeDriver$ObstructionState.deleted;
        if (sVNNodeKind != SVNNodeKind.FILE || bl2) {
            SVNDepth sVNDepth;
            if (sVNNodeKind == SVNNodeKind.NONE && (sVNDepth = this.getContext().getNodeDepth(SVNFileUtil.getParentFile(file))) != SVNDepth.UNKNOWN && sVNDepth.compareTo(SVNDepth.FILES) < 0) {
                svnDiffCallbackResult.contentState = SVNStatusType.MISSING;
                svnDiffCallbackResult.propState = SVNStatusType.MISSING;
                return;
            }
            this.treeConflict(file, SVNNodeKind.FILE, SVNConflictAction.EDIT, SVNConflictReason.MISSING);
            svnDiffCallbackResult.treeConflicted = true;
            svnDiffCallbackResult.contentState = SVNStatusType.MISSING;
            svnDiffCallbackResult.propState = SVNStatusType.MISSING;
            return;
        }
        if (!sVNProperties.isEmpty()) {
            SVNWCContext$MergePropertiesInfo sVNWCContext$MergePropertiesInfo = this.mergePropChanges(file, sVNProperties, sVNProperties2);
            SVNStatusType sVNStatusType = svnDiffCallbackResult.propState = sVNWCContext$MergePropertiesInfo != null ? sVNWCContext$MergePropertiesInfo.mergeOutcome : null;
            if (sVNWCContext$MergePropertiesInfo != null && sVNWCContext$MergePropertiesInfo.treeConflicted) {
                svnDiffCallbackResult.treeConflicted = true;
                return;
            }
        } else {
            svnDiffCallbackResult.propState = SVNStatusType.UNCHANGED;
        }
        if (this.isRecordOnly()) {
            svnDiffCallbackResult.contentState = SVNStatusType.UNCHANGED;
            return;
        }
        if (file2 != null) {
            boolean bl3 = this.getContext().isTextModified(file, false);
            String string3 = ".working";
            String string4 = ".merge-left.r" + l2;
            String string5 = ".merge-right.r" + l3;
            SVNConflictVersion[] sVNConflictVersionArray = this.makeConflictVersions(file, SVNNodeKind.FILE);
            ISVNOptions iSVNOptions = this.getContext().getOptions();
            ISVNConflictHandler[] iSVNConflictHandlerArray = new ISVNConflictHandler[1];
            if (iSVNOptions instanceof DefaultSVNOptions) {
                iSVNConflictHandlerArray[0] = ((DefaultSVNOptions)iSVNOptions).getConflictResolver();
                ((DefaultSVNOptions)iSVNOptions).setConflictHandler(new SvnNgMergeCallback$1(this, iSVNConflictHandlerArray, file));
            }
            try {
                SVNWCContext$MergeInfo sVNWCContext$MergeInfo = this.getContext().mergeText(file2, file3, file, string4, string5, string3, sVNConflictVersionArray[0], sVNConflictVersionArray[1], this.isDryRun(), this.getDiffOptions(), sVNProperties);
                svnDiffCallbackResult.contentState = sVNWCContext$MergeInfo.mergeOutcome == SVNStatusType.CONFLICTED ? SVNStatusType.CONFLICTED : (bl3 && sVNWCContext$MergeInfo.mergeOutcome != SVNStatusType.UNCHANGED ? SVNStatusType.MERGED : (sVNWCContext$MergeInfo.mergeOutcome == SVNStatusType.MERGED ? SVNStatusType.CHANGED : (sVNWCContext$MergeInfo.mergeOutcome == SVNStatusType.NO_MERGE ? SVNStatusType.MISSING : SVNStatusType.UNCHANGED)));
            }
            finally {
                if (iSVNOptions instanceof DefaultSVNOptions) {
                    ((DefaultSVNOptions)iSVNOptions).setConflictHandler(iSVNConflictHandlerArray[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileAdded(SvnDiffCallbackResult svnDiffCallbackResult, File file, File file2, File file3, long l2, long l3, String string, String string2, File file4, long l4, SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        block22: {
            Object object2;
            block21: {
                if (this.isRecordOnly()) {
                    svnDiffCallbackResult.contentState = SVNStatusType.UNCHANGED;
                    svnDiffCallbackResult.propState = SVNStatusType.UNCHANGED;
                    return;
                }
                svnDiffCallbackResult.propState = SVNStatusType.UNKNOWN;
                SVNProperties sVNProperties3 = new SVNProperties(sVNProperties2);
                for (Object object2 : sVNProperties.nameSet()) {
                    if (SVNProperty.isWorkingCopyProperty((String)object2) || !this.isSameRepos() && !SVNProperty.isRegularProperty((String)object2) || !this.isSameRepos() && "svn:mergeinfo".equals(object2)) continue;
                    if (sVNProperties.getSVNPropertyValue((String)object2) != null) {
                        sVNProperties3.put((String)object2, sVNProperties.getSVNPropertyValue((String)object2));
                        continue;
                    }
                    sVNProperties3.remove((String)object2);
                }
                SvnNgMergeDriver$ObstructionState svnNgMergeDriver$ObstructionState = this.driver.performObstructionCheck(file, SVNNodeKind.UNKNOWN);
                if (svnNgMergeDriver$ObstructionState.obstructionState != SVNStatusType.INAPPLICABLE) {
                    if (this.isDryRun() && this.getAddedPath() != null && SVNWCUtils.isChild(this.getAddedPath(), file)) {
                        svnDiffCallbackResult.contentState = SVNStatusType.CHANGED;
                        if (!sVNProperties3.isEmpty()) {
                            svnDiffCallbackResult.propState = SVNStatusType.CHANGED;
                        }
                    } else {
                        svnDiffCallbackResult.contentState = svnNgMergeDriver$ObstructionState.obstructionState;
                    }
                    return;
                }
                object2 = SVNFileType.getNodeKind(SVNFileType.getType(file));
                if (object2 != SVNNodeKind.NONE) break block21;
                if (!this.isDryRun()) {
                    InputStream inputStream;
                    InputStream inputStream2;
                    block20: {
                        SVNURL sVNURL = null;
                        long l5 = -1L;
                        inputStream2 = null;
                        inputStream = null;
                        try {
                            SVNProperties sVNProperties4;
                            SVNProperties sVNProperties5;
                            Object object3;
                            if (this.isSameRepos()) {
                                object3 = SVNWCUtils.getPathAsChild(this.getTargetPath(), file);
                                sVNURL = object3 != null ? this.getSource2URL().appendPath((String)object3, false) : this.getSource2URL();
                                l5 = l3;
                                this.checkReposMatch(file, sVNURL);
                                inputStream2 = SVNFileUtil.openFileForReading(file3);
                                inputStream = null;
                                sVNProperties5 = sVNProperties3;
                                sVNProperties4 = null;
                            } else {
                                sVNProperties5 = new SVNProperties();
                                sVNProperties4 = sVNProperties3;
                                inputStream2 = SVNFileUtil.DUMMY_IN;
                                inputStream = SVNFileUtil.openFileForReading(file3);
                            }
                            object3 = this.getContext().getTreeConflict(file);
                            if (object3 != null) {
                                this.treeConflictOnAdd(file, SVNNodeKind.FILE, SVNConflictAction.ADD, SVNConflictReason.ADDED);
                                svnDiffCallbackResult.treeConflicted = true;
                                break block20;
                            }
                            SvnNgReposToWcCopy.addFileToWc(this.getContext(), file, inputStream2, inputStream, sVNProperties5, sVNProperties4, sVNURL, l5);
                        }
                        catch (Throwable throwable) {
                            SVNFileUtil.closeFile(inputStream2);
                            SVNFileUtil.closeFile(inputStream);
                            throw throwable;
                        }
                    }
                    SVNFileUtil.closeFile(inputStream2);
                    SVNFileUtil.closeFile(inputStream);
                }
                svnDiffCallbackResult.contentState = SVNStatusType.CHANGED;
                if (!sVNProperties3.isEmpty()) {
                    svnDiffCallbackResult.propState = SVNStatusType.CHANGED;
                }
                break block22;
            }
            if (object2 == SVNNodeKind.DIR) {
                this.treeConflictOnAdd(file, SVNNodeKind.FILE, SVNConflictAction.ADD, SVNConflictReason.OBSTRUCTED);
                svnDiffCallbackResult.treeConflicted = true;
                SVNNodeKind sVNNodeKind = this.getContext().readKind(file, false);
                svnDiffCallbackResult.contentState = sVNNodeKind != SVNNodeKind.NONE && this.driver.isDryRunDeletion(file) ? SVNStatusType.CHANGED : SVNStatusType.OBSTRUCTED;
            } else if (object2 == SVNNodeKind.FILE) {
                if (this.driver.isDryRunDeletion(file)) {
                    svnDiffCallbackResult.contentState = SVNStatusType.CHANGED;
                } else {
                    this.treeConflictOnAdd(file, SVNNodeKind.FILE, SVNConflictAction.ADD, SVNConflictReason.ADDED);
                    svnDiffCallbackResult.treeConflicted = true;
                }
            } else {
                svnDiffCallbackResult.contentState = SVNStatusType.UNKNOWN;
            }
        }
    }

    @Override
    public void fileDeleted(SvnDiffCallbackResult svnDiffCallbackResult, File file, File file2, File file3, String string, String string2, SVNProperties sVNProperties) {
        if (this.isDryRun()) {
            if (this.getDryRunDeletions() == null) {
                this.setDryRunDeletions(new HashSet());
            }
            this.getDryRunDeletions().add(file);
        }
        if (this.isRecordOnly()) {
            svnDiffCallbackResult.contentState = SVNStatusType.UNCHANGED;
            return;
        }
        SvnNgMergeDriver$ObstructionState svnNgMergeDriver$ObstructionState = this.driver.performObstructionCheck(file, SVNNodeKind.UNKNOWN);
        if (svnNgMergeDriver$ObstructionState.obstructionState != SVNStatusType.INAPPLICABLE) {
            svnDiffCallbackResult.contentState = svnNgMergeDriver$ObstructionState.obstructionState;
            return;
        }
        SVNNodeKind sVNNodeKind = SVNFileType.getNodeKind(SVNFileType.getType(file));
        if (sVNNodeKind == SVNNodeKind.FILE) {
            boolean bl2 = this.compareFiles(file2, sVNProperties, file);
            if (bl2 || this.isForce() || this.isRecordOnly()) {
                if (!this.isDryRun()) {
                    SvnNgRemove.delete(this.getContext(), file, null, false, true, null);
                }
                svnDiffCallbackResult.contentState = SVNStatusType.CHANGED;
            } else {
                this.treeConflict(file, SVNNodeKind.FILE, SVNConflictAction.DELETE, SVNConflictReason.EDITED);
                svnDiffCallbackResult.treeConflicted = true;
                svnDiffCallbackResult.contentState = SVNStatusType.OBSTRUCTED;
            }
        } else if (sVNNodeKind == SVNNodeKind.DIR) {
            this.treeConflict(file, SVNNodeKind.FILE, SVNConflictAction.DELETE, SVNConflictReason.OBSTRUCTED);
            svnDiffCallbackResult.treeConflicted = true;
            svnDiffCallbackResult.contentState = SVNStatusType.OBSTRUCTED;
        } else if (sVNNodeKind == SVNNodeKind.NONE) {
            this.treeConflict(file, SVNNodeKind.FILE, SVNConflictAction.DELETE, SVNConflictReason.DELETED);
            svnDiffCallbackResult.treeConflicted = true;
            svnDiffCallbackResult.contentState = SVNStatusType.MISSING;
        } else {
            svnDiffCallbackResult.contentState = SVNStatusType.UNKNOWN;
        }
    }

    private void setDryRunDeletions(Collection collection) {
        this.driver.dryRunDeletions = collection;
    }

    private void setDryRunAddtions(Collection collection) {
        this.driver.dryRunAdded = collection;
    }

    @Override
    public void dirDeleted(SvnDiffCallbackResult svnDiffCallbackResult, File file) {
        boolean bl2;
        if (this.isRecordOnly()) {
            svnDiffCallbackResult.contentState = SVNStatusType.UNCHANGED;
            return;
        }
        SvnNgMergeDriver$ObstructionState svnNgMergeDriver$ObstructionState = this.driver.performObstructionCheck(file, SVNNodeKind.UNKNOWN);
        boolean bl3 = bl2 = svnNgMergeDriver$ObstructionState.kind == SVNNodeKind.DIR || svnNgMergeDriver$ObstructionState.kind == SVNNodeKind.FILE;
        if (svnNgMergeDriver$ObstructionState.obstructionState != SVNStatusType.INAPPLICABLE) {
            svnDiffCallbackResult.contentState = svnNgMergeDriver$ObstructionState.obstructionState;
            return;
        }
        if (svnNgMergeDriver$ObstructionState.deleted) {
            svnNgMergeDriver$ObstructionState.kind = SVNNodeKind.NONE;
        }
        if (this.isDryRun()) {
            if (this.getDryRunDeletions() == null) {
                this.setDryRunDeletions(new HashSet());
            }
            this.getDryRunDeletions().add(file);
        }
        if (svnNgMergeDriver$ObstructionState.kind == SVNNodeKind.DIR) {
            if (bl2 && !svnNgMergeDriver$ObstructionState.deleted) {
                try {
                    if (!this.isForce()) {
                        SvnNgRemove.checkCanDelete(this.driver.operation.getOperationFactory(), this.getContext(), file);
                    }
                    if (!this.isDryRun()) {
                        SvnNgRemove.delete(this.getContext(), file, null, false, false, null);
                    }
                    svnDiffCallbackResult.contentState = SVNStatusType.CHANGED;
                }
                catch (SVNException sVNException) {
                    this.treeConflict(file, SVNNodeKind.DIR, SVNConflictAction.DELETE, SVNConflictReason.EDITED);
                    svnDiffCallbackResult.treeConflicted = true;
                    svnDiffCallbackResult.contentState = SVNStatusType.CONFLICTED;
                }
            } else {
                this.treeConflict(file, SVNNodeKind.DIR, SVNConflictAction.DELETE, SVNConflictReason.DELETED);
                svnDiffCallbackResult.treeConflicted = true;
            }
        } else if (svnNgMergeDriver$ObstructionState.kind == SVNNodeKind.FILE) {
            svnDiffCallbackResult.contentState = SVNStatusType.OBSTRUCTED;
        } else if (svnNgMergeDriver$ObstructionState.kind == SVNNodeKind.NONE) {
            this.treeConflict(file, SVNNodeKind.DIR, SVNConflictAction.DELETE, SVNConflictReason.DELETED);
            svnDiffCallbackResult.treeConflicted = true;
            svnDiffCallbackResult.contentState = SVNStatusType.MISSING;
        } else {
            svnDiffCallbackResult.contentState = SVNStatusType.UNKNOWN;
        }
    }

    @Override
    public void dirOpened(SvnDiffCallbackResult svnDiffCallbackResult, File file, long l2) {
        SvnNgMergeDriver$ObstructionState svnNgMergeDriver$ObstructionState = this.driver.performObstructionCheck(file, SVNNodeKind.UNKNOWN);
        if (svnNgMergeDriver$ObstructionState.obstructionState != SVNStatusType.INAPPLICABLE) {
            svnDiffCallbackResult.skipChildren = true;
            return;
        }
        if (svnNgMergeDriver$ObstructionState.kind != SVNNodeKind.DIR || svnNgMergeDriver$ObstructionState.deleted) {
            SVNDepth sVNDepth;
            if (svnNgMergeDriver$ObstructionState.kind == SVNNodeKind.NONE && (sVNDepth = this.getContext().getNodeDepth(SVNFileUtil.getParentFile(file))) != SVNDepth.UNKNOWN && sVNDepth.compareTo(SVNDepth.IMMEDIATES) < 0) {
                svnDiffCallbackResult.skipChildren = true;
                return;
            }
            if (svnNgMergeDriver$ObstructionState.kind == SVNNodeKind.FILE) {
                this.treeConflict(file, SVNNodeKind.DIR, SVNConflictAction.EDIT, SVNConflictReason.REPLACED);
                svnDiffCallbackResult.treeConflicted = true;
            } else if (svnNgMergeDriver$ObstructionState.deleted || svnNgMergeDriver$ObstructionState.kind == SVNNodeKind.NONE) {
                this.treeConflict(file, SVNNodeKind.DIR, SVNConflictAction.EDIT, SVNConflictReason.DELETED);
                svnDiffCallbackResult.treeConflicted = true;
            }
        }
    }

    @Override
    public void dirAdded(SvnDiffCallbackResult svnDiffCallbackResult, File file, long l2, String string, long l3) {
        Object object;
        boolean bl2;
        if (this.isRecordOnly()) {
            svnDiffCallbackResult.contentState = SVNStatusType.UNCHANGED;
            return;
        }
        File file2 = SVNFileUtil.getParentFile(file);
        String string2 = SVNWCUtils.getPathAsChild(this.getTargetPath(), file);
        SVNURL sVNURL = null;
        long l4 = -1L;
        if (this.isSameRepos()) {
            sVNURL = this.getSource2URL().appendPath(string2, false);
            l4 = l2;
            this.checkReposMatch(file2, sVNURL);
        }
        SvnNgMergeDriver$ObstructionState svnNgMergeDriver$ObstructionState = this.driver.performObstructionCheck(file, SVNNodeKind.UNKNOWN);
        boolean bl3 = bl2 = svnNgMergeDriver$ObstructionState.kind == SVNNodeKind.DIR || svnNgMergeDriver$ObstructionState.kind == SVNNodeKind.FILE;
        if (svnNgMergeDriver$ObstructionState.obstructionState == SVNStatusType.OBSTRUCTED && (svnNgMergeDriver$ObstructionState.deleted || svnNgMergeDriver$ObstructionState.kind == SVNNodeKind.NONE) && (object = SVNFileType.getType(file)) == SVNFileType.DIRECTORY) {
            svnNgMergeDriver$ObstructionState.obstructionState = SVNStatusType.INAPPLICABLE;
            svnNgMergeDriver$ObstructionState.kind = SVNNodeKind.DIR;
        }
        if (svnNgMergeDriver$ObstructionState.obstructionState != SVNStatusType.INAPPLICABLE) {
            svnDiffCallbackResult.contentState = this.isDryRun() && this.getAddedPath() != null && SVNWCUtils.isChild(this.getAddedPath(), file) ? SVNStatusType.CHANGED : svnNgMergeDriver$ObstructionState.obstructionState;
            return;
        }
        if (svnNgMergeDriver$ObstructionState.deleted) {
            svnNgMergeDriver$ObstructionState.kind = SVNNodeKind.NONE;
        }
        if (svnNgMergeDriver$ObstructionState.kind == SVNNodeKind.NONE) {
            if (this.isDryRun()) {
                if (this.getDryRunAdditions() == null) {
                    this.setDryRunAddtions(new HashSet());
                }
                this.getDryRunAdditions().add(file);
                this.setAddedPath(file);
            } else {
                file.mkdir();
                if (sVNURL != null) {
                    object = this.getContext().getNodeReposInfo(file2);
                    File file3 = new File(SVNURLUtil.getRelativeURL(((SVNWCContext$SVNWCNodeReposInfo)object).reposRootUrl, sVNURL, false));
                    this.getContext().getDb().opCopyDir(file, new SVNProperties(), l4, new SVNDate(0L, 0), null, file3, ((SVNWCContext$SVNWCNodeReposInfo)object).reposRootUrl, ((SVNWCContext$SVNWCNodeReposInfo)object).reposUuid, l4, null, false, SVNDepth.INFINITY, null, null);
                } else {
                    this.getContext().getDb().opAddDirectory(file, null, null);
                }
            }
            svnDiffCallbackResult.contentState = SVNStatusType.CHANGED;
        } else if (svnNgMergeDriver$ObstructionState.kind == SVNNodeKind.DIR) {
            if (!bl2 || svnNgMergeDriver$ObstructionState.deleted) {
                if (!this.isDryRun()) {
                    if (sVNURL != null) {
                        object = this.getContext().getNodeReposInfo(file2);
                        File file4 = new File(SVNURLUtil.getRelativeURL(((SVNWCContext$SVNWCNodeReposInfo)object).reposRootUrl, sVNURL, false));
                        this.getContext().getDb().opCopyDir(file, new SVNProperties(), l4, new SVNDate(0L, 0), null, file4, ((SVNWCContext$SVNWCNodeReposInfo)object).reposRootUrl, ((SVNWCContext$SVNWCNodeReposInfo)object).reposUuid, l4, null, false, SVNDepth.INFINITY, null, null);
                    } else {
                        this.getContext().getDb().opAddDirectory(file, null, null);
                    }
                } else {
                    this.setAddedPath(file);
                }
                svnDiffCallbackResult.contentState = SVNStatusType.CHANGED;
            } else if (this.driver.isDryRunDeletion(file)) {
                svnDiffCallbackResult.contentState = SVNStatusType.CHANGED;
            } else {
                this.treeConflictOnAdd(file, SVNNodeKind.DIR, SVNConflictAction.ADD, SVNConflictReason.ADDED);
                svnDiffCallbackResult.treeConflicted = true;
                svnDiffCallbackResult.contentState = SVNStatusType.OBSTRUCTED;
            }
        } else if (svnNgMergeDriver$ObstructionState.kind == SVNNodeKind.FILE) {
            if (this.isDryRun()) {
                this.setAddedPath(null);
            }
            if (bl2 && this.driver.isDryRunDeletion(file)) {
                svnDiffCallbackResult.contentState = SVNStatusType.CHANGED;
            } else {
                this.treeConflictOnAdd(file, SVNNodeKind.DIR, SVNConflictAction.ADD, SVNConflictReason.OBSTRUCTED);
                svnDiffCallbackResult.treeConflicted = true;
                svnDiffCallbackResult.contentState = SVNStatusType.OBSTRUCTED;
            }
        } else {
            if (this.isDryRun()) {
                this.setAddedPath(null);
            }
            svnDiffCallbackResult.contentState = SVNStatusType.UNKNOWN;
        }
    }

    @Override
    public void dirPropsChanged(SvnDiffCallbackResult svnDiffCallbackResult, File file, boolean bl2, SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        SvnNgMergeDriver$ObstructionState svnNgMergeDriver$ObstructionState = this.driver.performObstructionCheck(file, SVNNodeKind.DIR);
        if (svnNgMergeDriver$ObstructionState.obstructionState != SVNStatusType.INAPPLICABLE) {
            svnDiffCallbackResult.propState = svnNgMergeDriver$ObstructionState.obstructionState;
            return;
        }
        if (bl2 && this.isDryRun() && this.driver.isDryRunAddition(file)) {
            return;
        }
        SVNWCContext$MergePropertiesInfo sVNWCContext$MergePropertiesInfo = this.mergePropChanges(file, sVNProperties, sVNProperties2);
        svnDiffCallbackResult.treeConflicted = sVNWCContext$MergePropertiesInfo != null ? sVNWCContext$MergePropertiesInfo.treeConflicted : false;
        svnDiffCallbackResult.propState = sVNWCContext$MergePropertiesInfo != null ? sVNWCContext$MergePropertiesInfo.mergeOutcome : null;
    }

    @Override
    public void dirClosed(SvnDiffCallbackResult svnDiffCallbackResult, File file, boolean bl2) {
        if (this.isDryRun() && this.getDryRunDeletions() != null) {
            this.getDryRunDeletions().clear();
        }
    }

    private void checkReposMatch(File file, SVNURL sVNURL) {
        if (!SVNURLUtil.isAncestor(this.getReposRootURL(), sVNURL)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Url ''{0}'' of ''{1}'' is not in repository ''{2}''", sVNURL, file, this.getReposRootURL());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
    }

    private SVNWCContext$MergePropertiesInfo mergePropChanges(File file, SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        Object object;
        SVNProperties sVNProperties3 = new SVNProperties();
        SvnNgPropertiesManager.categorizeProperties(sVNProperties, sVNProperties3, null, null);
        if (this.isRecordOnly() && !sVNProperties3.isEmpty()) {
            object = new SVNProperties();
            if (sVNProperties3.containsName("svn:mergeinfo")) {
                ((SVNProperties)object).put("svn:mergeinfo", sVNProperties3.getStringValue("svn:mergeinfo"));
            }
            sVNProperties3 = object;
        }
        object = null;
        if (!sVNProperties3.isEmpty()) {
            if (this.getSource1Rev() < this.getSource2Rev() || !this.areSourcesAncestral()) {
                sVNProperties3 = this.filterSelfReferentialMergeInfo(sVNProperties3, file, this.isHonorMergeInfo(), this.isSameRepos(), this.isReintegrateMerge(), this.getRepos2());
            }
            SVNException sVNException = null;
            try {
                object = this.getContext().mergeProperties(file, null, null, sVNProperties2, sVNProperties3, this.isDryRun(), this.getContext().getOptions().getConflictResolver());
            }
            catch (SVNException sVNException2) {
                sVNException = sVNException2;
            }
            if (!this.isDryRun()) {
                for (String string : sVNProperties3.nameSet()) {
                    if (!"svn:mergeinfo".equals(string)) continue;
                    SVNProperties sVNProperties4 = this.getContext().getPristineProps(file);
                    boolean bl2 = false;
                    if (sVNProperties4 != null && sVNProperties4.containsName("svn:mergeinfo")) {
                        bl2 = true;
                    }
                    if (!bl2 && sVNProperties3.getSVNPropertyValue(string) != null) {
                        this.addPathWithAddedMergeInfo(file);
                        continue;
                    }
                    if (!bl2 || sVNProperties3.getSVNPropertyValue(string) != null) continue;
                    this.addPathWithDeletedMergeInfo(file);
                }
            }
            if (sVNException != null && (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND || sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_UNEXPECTED_STATUS)) {
                if (object != null) {
                    ((SVNWCContext$MergePropertiesInfo)object).mergeOutcome = SVNStatusType.MISSING;
                    ((SVNWCContext$MergePropertiesInfo)object).treeConflicted = true;
                }
            } else if (sVNException != null) {
                throw sVNException;
            }
        }
        return object;
    }

    private void addPathWithAddedMergeInfo(File file) {
        if (this.driver.pathsWithNewMergeInfo == null) {
            this.driver.pathsWithNewMergeInfo = new HashSet();
        }
        this.driver.pathsWithNewMergeInfo.add(file);
    }

    private void addPathWithDeletedMergeInfo(File file) {
        if (this.driver.pathsWithDeletedMergeInfo == null) {
            this.driver.pathsWithDeletedMergeInfo = new HashSet();
        }
        this.driver.pathsWithDeletedMergeInfo.add(file);
    }

    private SVNProperties filterSelfReferentialMergeInfo(SVNProperties sVNProperties, File file, boolean bl2, boolean bl3, boolean bl4, SVNRepository sVNRepository) {
        if (!bl3) {
            return SvnNgMergeCallback.omitMergeInfoChanges(sVNProperties);
        }
        if (!bl2 && !bl4) {
            return sVNProperties;
        }
        boolean bl5 = this.getContext().isNodeAdded(file);
        if (bl5) {
            return sVNProperties;
        }
        long l2 = this.getContext().getNodeBaseRev(file);
        SVNProperties sVNProperties2 = new SVNProperties();
        for (String string : sVNProperties.nameSet()) {
            Object object;
            if (!"svn:mergeinfo".equals(string) || sVNProperties.getSVNPropertyValue(string) == null || "".equals(sVNProperties.getSVNPropertyValue(string))) {
                sVNProperties2.put(string, sVNProperties.getSVNPropertyValue(string));
                continue;
            }
            SVNURL sVNURL = this.getContext().getUrlFromPath(file);
            SVNURL sVNURL2 = sVNRepository.getLocation();
            sVNRepository.setLocation(sVNURL, false);
            String string2 = sVNProperties.getStringValue(string);
            Map map = null;
            TreeMap<String, SVNMergeRangeList> treeMap = null;
            TreeMap<String, SVNMergeRangeList> treeMap2 = null;
            try {
                map = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(string2), null);
            }
            catch (SVNException sVNException) {
                sVNProperties2.put(string, sVNProperties.getSVNPropertyValue(string));
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.MERGE_INFO_PARSE_ERROR) {
                    sVNRepository.setLocation(sVNURL2, false);
                    continue;
                }
                throw sVNException;
            }
            Map[] mapArray = this.splitMergeInfoOnRevision(map, l2);
            Map map2 = mapArray[0];
            map = mapArray[1];
            if (map2 != null) {
                object = sVNRepository.getRepositoryRoot(true);
                for (String string3 : map2.keySet()) {
                    SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map2.get(string3);
                    SVNMergeRange[] sVNMergeRangeArray = sVNMergeRangeList.getRanges();
                    ArrayList<SVNMergeRange> arrayList = new ArrayList<SVNMergeRange>();
                    SVNURL sVNURL3 = ((SVNURL)object).appendPath(string3, false);
                    for (int i2 = 0; i2 < sVNMergeRangeArray.length; ++i2) {
                        SVNMergeRange sVNMergeRange = sVNMergeRangeArray[i2];
                        Structure structure = null;
                        try {
                            structure = new SvnNgRepositoryAccess(null, this.getContext()).getLocations(sVNRepository, SvnTarget.fromURL(sVNURL), SVNRevision.create(l2), SVNRevision.create(sVNMergeRange.getStartRevision() + 1L), SVNRevision.UNDEFINED);
                            SVNURL sVNURL4 = (SVNURL)structure.get(SvnRepositoryAccess$LocationsInfo.startUrl);
                            if (!sVNURL3.equals(sVNURL4)) {
                                arrayList.add(sVNMergeRange);
                            }
                            structure.release();
                            continue;
                        }
                        catch (SVNException sVNException) {
                            SVNErrorCode sVNErrorCode = sVNException.getErrorMessage().getErrorCode();
                            if (sVNErrorCode == SVNErrorCode.CLIENT_UNRELATED_RESOURCES || sVNErrorCode == SVNErrorCode.RA_DAV_PATH_NOT_FOUND || sVNErrorCode == SVNErrorCode.FS_NOT_FOUND || sVNErrorCode == SVNErrorCode.FS_NO_SUCH_REVISION) {
                                arrayList.add(sVNMergeRange);
                                continue;
                            }
                            throw sVNException;
                        }
                    }
                    if (arrayList.isEmpty()) continue;
                    if (treeMap == null) {
                        treeMap = new TreeMap<String, SVNMergeRangeList>();
                    }
                    SVNMergeRangeList sVNMergeRangeList2 = SVNMergeRangeList.fromCollection(arrayList);
                    treeMap.put(string3, sVNMergeRangeList2);
                }
            }
            if (map != null && !map.isEmpty()) {
                object = this.getRepositoryAccess().getHistoryAsMergeInfo(this.getRepos2(), SvnTarget.fromFile(file), l2, -1L);
                treeMap2 = SVNMergeInfoUtil.removeMergeInfo((Map)object, map, true);
            }
            if (sVNURL2 != null) {
                sVNRepository.setLocation(sVNURL2, false);
            }
            if (treeMap2 != null && treeMap != null) {
                treeMap2 = SVNMergeInfoUtil.mergeMergeInfos(treeMap2, treeMap);
            } else if (treeMap != null) {
                treeMap2 = treeMap;
            }
            if (treeMap2 == null || treeMap2.isEmpty()) continue;
            object = SVNMergeInfoUtil.formatMergeInfoToString(treeMap2, null);
            sVNProperties2.put("svn:mergeinfo", (String)object);
        }
        return sVNProperties2;
    }

    private Map[] splitMergeInfoOnRevision(Map map, long l2) {
        TreeMap<String, SVNMergeRangeList> treeMap = null;
        block0: for (String string : new HashSet(map.keySet())) {
            SVNMergeRangeList sVNMergeRangeList = (SVNMergeRangeList)map.get(string);
            for (int i2 = 0; i2 < sVNMergeRangeList.getSize(); ++i2) {
                SVNMergeRange sVNMergeRange = sVNMergeRangeList.getRanges()[i2];
                if (sVNMergeRange.getEndRevision() <= l2) continue;
                SVNMergeRangeList sVNMergeRangeList2 = new SVNMergeRangeList(new SVNMergeRange[0]);
                for (int i3 = 0; i3 < sVNMergeRangeList.getSize(); ++i3) {
                    SVNMergeRange sVNMergeRange2 = sVNMergeRangeList.getRanges()[i3];
                    SVNMergeRange sVNMergeRange3 = sVNMergeRange2.dup();
                    if (i2 == i3 && sVNMergeRange.getStartRevision() + 1L <= l2) {
                        sVNMergeRange3.setStartRevision(l2);
                        sVNMergeRange.setEndRevision(l2);
                    }
                    sVNMergeRangeList2.pushRange(sVNMergeRange3.getStartRevision(), sVNMergeRange3.getEndRevision(), sVNMergeRange3.isInheritable());
                }
                if (treeMap == null) {
                    treeMap = new TreeMap<String, SVNMergeRangeList>();
                }
                treeMap.put(string, sVNMergeRangeList2);
                map = SVNMergeInfoUtil.removeMergeInfo(treeMap, map, true);
                continue block0;
            }
        }
        Map[] mapArray = new Map[]{treeMap, map};
        return mapArray;
    }

    protected static SVNProperties omitMergeInfoChanges(SVNProperties sVNProperties) {
        SVNProperties sVNProperties2 = new SVNProperties();
        for (String string : sVNProperties.nameSet()) {
            if ("svn:mergeinfo".equals(string)) continue;
            SVNPropertyValue sVNPropertyValue = sVNProperties.getSVNPropertyValue(string);
            sVNProperties2.put(string, sVNPropertyValue);
        }
        return sVNProperties2;
    }

    private boolean isHonorMergeInfo() {
        return this.driver.isHonorMergeInfo();
    }

    private SVNConflictVersion[] makeConflictVersions(File file, SVNNodeKind sVNNodeKind) {
        SVNURL sVNURL;
        SVNURL sVNURL2;
        SVNURL sVNURL3 = this.getRepos1().getRepositoryRoot(true);
        String string = SVNWCUtils.getPathAsChild(this.getTargetPath(), file);
        if (string != null) {
            sVNURL2 = this.getSource1URL().appendPath(string, false);
            sVNURL = this.getSource2URL().appendPath(string, false);
        } else {
            sVNURL2 = this.getSource1URL();
            sVNURL = this.getSource2URL();
        }
        String string2 = SVNWCUtils.isChild(sVNURL3, sVNURL2);
        String string3 = SVNWCUtils.isChild(sVNURL3, sVNURL);
        SVNConflictVersion sVNConflictVersion = new SVNConflictVersion(sVNURL3, string2, this.getSource1Rev(), sVNNodeKind);
        SVNConflictVersion sVNConflictVersion2 = new SVNConflictVersion(sVNURL3, string3, this.getSource2Rev(), sVNNodeKind);
        return new SVNConflictVersion[]{sVNConflictVersion, sVNConflictVersion2};
    }

    private void treeConflictOnAdd(File file, SVNNodeKind sVNNodeKind, SVNConflictAction sVNConflictAction, SVNConflictReason sVNConflictReason) {
        if (this.isRecordOnly() || this.isDryRun()) {
            return;
        }
        SVNTreeConflictDescription sVNTreeConflictDescription = this.makeTreeConflict(file, sVNNodeKind, sVNConflictAction, sVNConflictReason);
        SVNTreeConflictDescription sVNTreeConflictDescription2 = this.getContext().getTreeConflict(file);
        if (sVNTreeConflictDescription2 == null) {
            this.getContext().getDb().opSetTreeConflict(file, sVNTreeConflictDescription);
            if (this.conflictedPaths == null) {
                this.conflictedPaths = new HashSet();
            }
            this.conflictedPaths.add(file);
        } else if (sVNTreeConflictDescription2.getConflictAction() == SVNConflictAction.DELETE && sVNTreeConflictDescription.getConflictAction() == SVNConflictAction.ADD) {
            sVNTreeConflictDescription2.setConflictAction(SVNConflictAction.REPLACE);
            this.getContext().getDb().opSetTreeConflict(file, sVNTreeConflictDescription2);
        }
    }

    private SVNTreeConflictDescription makeTreeConflict(File file, SVNNodeKind sVNNodeKind, SVNConflictAction sVNConflictAction, SVNConflictReason sVNConflictReason) {
        SVNConflictVersion[] sVNConflictVersionArray = this.makeConflictVersions(file, sVNNodeKind);
        SVNTreeConflictDescription sVNTreeConflictDescription = new SVNTreeConflictDescription(file, sVNNodeKind, sVNConflictAction, sVNConflictReason, SVNOperation.MERGE, sVNConflictVersionArray[0], sVNConflictVersionArray[1]);
        return sVNTreeConflictDescription;
    }

    private void treeConflict(File file, SVNNodeKind sVNNodeKind, SVNConflictAction sVNConflictAction, SVNConflictReason sVNConflictReason) {
        if (this.isRecordOnly() || this.isDryRun()) {
            return;
        }
        SVNTreeConflictDescription sVNTreeConflictDescription = this.getContext().getTreeConflict(file);
        if (sVNTreeConflictDescription == null) {
            sVNTreeConflictDescription = this.makeTreeConflict(file, sVNNodeKind, sVNConflictAction, sVNConflictReason);
            this.getContext().getDb().opSetTreeConflict(file, sVNTreeConflictDescription);
            if (this.conflictedPaths == null) {
                this.conflictedPaths = new HashSet();
            }
            this.conflictedPaths.add(file);
        }
    }

    private boolean compareProps(SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        if (sVNProperties == null || sVNProperties2 == null) {
            return sVNProperties == sVNProperties2;
        }
        SVNProperties sVNProperties3 = sVNProperties.compareTo(sVNProperties2);
        for (String string : sVNProperties3.nameSet()) {
            if (!SVNProperty.isRegularProperty(string) || "svn:mergeinfo".equals(string)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compareFiles(File file, SVNProperties sVNProperties, File file2) {
        SVNProperties sVNProperties2 = this.getContext().getActualProps(file2);
        boolean bl2 = this.compareProps(sVNProperties, sVNProperties2);
        if (bl2) {
            InputStream inputStream = null;
            InputStream inputStream2 = null;
            try {
                inputStream = sVNProperties2 != null && sVNProperties2.getStringValue("svn:special") != null ? SVNFileUtil.readSymlink(file2) : this.getContext().getTranslatedStream(file2, file2, true, false);
                inputStream2 = SVNFileUtil.openFileForReading(file);
                bl2 = SVNFileUtil.compare(inputStream, inputStream2);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(inputStream);
                SVNFileUtil.closeFile(inputStream2);
                throw throwable;
            }
            SVNFileUtil.closeFile(inputStream);
            SVNFileUtil.closeFile(inputStream2);
        }
        return bl2;
    }

    private SVNWCContext getContext() {
        return this.driver.context;
    }

    private boolean isReintegrateMerge() {
        return this.driver.reintegrateMerge;
    }

    private boolean isRecordOnly() {
        return this.driver.recordOnly;
    }

    private boolean isDryRun() {
        return this.driver.dryRun;
    }

    private boolean isForce() {
        return this.driver.forceDelete;
    }

    private boolean isSameRepos() {
        return this.driver.sameRepos;
    }

    private SVNDiffOptions getDiffOptions() {
        return this.driver.diffOptions;
    }

    private File getAddedPath() {
        return this.driver.addedPath;
    }

    private void setAddedPath(File file) {
        this.driver.addedPath = file;
    }

    private boolean areSourcesAncestral() {
        return this.driver.sourcesAncestral;
    }

    private File getTargetPath() {
        return this.driver.targetAbsPath;
    }

    private SVNRepository getRepos1() {
        return this.driver.repos1;
    }

    private SVNRepository getRepos2() {
        return this.driver.repos2;
    }

    private SVNURL getReposRootURL() {
        return this.driver.reposRootUrl;
    }

    private SvnRepositoryAccess getRepositoryAccess() {
        return this.driver.repositoryAccess;
    }

    private SVNURL getSource1URL() {
        return this.driver.mergeSource.url1;
    }

    private SVNURL getSource2URL() {
        return this.driver.mergeSource.url2;
    }

    private long getSource1Rev() {
        return this.driver.mergeSource.rev1;
    }

    private long getSource2Rev() {
        return this.driver.mergeSource.rev2;
    }

    private Collection getDryRunDeletions() {
        return this.driver.dryRunDeletions;
    }

    private Collection getDryRunAdditions() {
        return this.driver.dryRunAdded;
    }

    static /* synthetic */ Collection access$000(SvnNgMergeCallback svnNgMergeCallback) {
        return svnNgMergeCallback.conflictedPaths;
    }

    static /* synthetic */ Collection access$002(SvnNgMergeCallback svnNgMergeCallback, Collection collection) {
        svnNgMergeCallback.conflictedPaths = collection;
        return svnNgMergeCallback.conflictedPaths;
    }
}

