/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SvnConflictReport;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess$RevisionsPair;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgMergeDriver;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgMergeDriver$MergeData;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgMergeDriver$MergeSource;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.io.SVNLocationSegment;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnMerge;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgMerge
extends SvnNgOperationRunner {
    public boolean isApplicable(SvnMerge svnMerge, SvnWcGeneration svnWcGeneration) {
        return super.isApplicable(svnMerge, svnWcGeneration) && !svnMerge.isReintegrate() && svnMerge.getSource() == null && svnMerge.getRevisionRanges() == null && svnMerge.getFirstSource() != null && svnMerge.getSecondSource() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void run(SVNWCContext sVNWCContext) {
        SvnConflictReport svnConflictReport;
        File file = this.getLockPath(this.getFirstTarget());
        if (((SvnMerge)this.getOperation()).isDryRun()) {
            svnConflictReport = this.merge(this.getFirstTarget());
        } else {
            try {
                file = sVNWCContext.acquireWriteLock(file, false, true);
                svnConflictReport = this.merge(this.getFirstTarget());
            }
            finally {
                sVNWCContext.releaseWriteLock(file);
                this.sleepForTimestamp();
            }
        }
        SvnNgMergeDriver.makeMergeConflictError(svnConflictReport);
        return null;
    }

    private File getLockPath(File file) {
        SVNNodeKind sVNNodeKind = this.getWcContext().readKind(file, false);
        if (sVNNodeKind == SVNNodeKind.DIR) {
            return file;
        }
        return SVNFileUtil.getParentFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SvnConflictReport merge(File file) {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        Object object4;
        SVNFileType sVNFileType = SVNFileType.getType(file);
        if (sVNFileType == SVNFileType.NONE) {
            object4 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "Path ''{0}'' does not exist", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.WC);
        }
        object4 = ((SvnMerge)this.getOperation()).getFirstSource();
        SvnTarget svnTarget = ((SvnMerge)this.getOperation()).getSecondSource();
        if (((SvnTarget)object4).getResolvedPegRevision() == SVNRevision.UNDEFINED || svnTarget.getResolvedPegRevision() == SVNRevision.UNDEFINED) {
            object3 = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all revisions are specified");
            SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
        }
        if (((SvnTarget)object4).isURL() != svnTarget.isURL()) {
            object3 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Merge sources must both be either paths or URLs");
            SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
        }
        if ((object3 = this.getRepositoryAccess().getTargetURL((SvnTarget)object4)) == null) {
            object2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)((SvnTarget)object4).getFile());
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
        }
        if ((object2 = this.getRepositoryAccess().getTargetURL(svnTarget)) == null) {
            serializable = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)svnTarget.getFile());
            SVNErrorManager.error(serializable, SVNLogType.WC);
        }
        if ((serializable = this.getWcContext().readKind(file, false)) != SVNNodeKind.DIR && serializable != SVNNodeKind.FILE) {
            object = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Merge target ''{0}'' does not exist in the working copy", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = new SvnNgMergeDriver(this.getWcContext(), (SvnMerge)this.getOperation(), this.getRepositoryAccess(), ((SvnMerge)this.getOperation()).getMergeOptions());
        ((SvnNgMergeDriver)object).ensureWcIsSuitableForMerge(file, ((SvnMerge)this.getOperation()).isAllowMixedRevisions(), true, true);
        SVNURL sVNURL = this.getWcContext().getNodeReposInfo((File)file).reposRootUrl;
        SVNRepository sVNRepository = this.getRepositoryAccess().createRepository((SVNURL)object3, null, false);
        SVNRepository sVNRepository2 = this.getRepositoryAccess().createRepository((SVNURL)object2, null, false);
        try {
            Object object5;
            Object object6;
            Object object7;
            Structure structure = this.getRepositoryAccess().getRevisionNumber(sVNRepository, SvnTarget.fromURL((SVNURL)object3), ((SvnTarget)object4).getResolvedPegRevision(), null);
            long l2 = structure.lng(SvnRepositoryAccess$RevisionsPair.revNumber);
            structure.release();
            structure = this.getRepositoryAccess().getRevisionNumber(sVNRepository2, SvnTarget.fromURL((SVNURL)object2), svnTarget.getResolvedPegRevision(), null);
            long l3 = structure.lng(SvnRepositoryAccess$RevisionsPair.revNumber);
            structure.release();
            String string = sVNRepository.getRepositoryUUID(true);
            String string2 = sVNRepository2.getRepositoryUUID(true);
            if (!string.equals(string2)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_UUID_MISMATCH, "''{0}'' isn''t in the same repository as ''{1}''", object3, object2);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            boolean bl2 = true;
            SVNURL sVNURL2 = sVNRepository.getRepositoryRoot(true);
            if (!sVNURL.equals(sVNURL2)) {
                object7 = this.getWcContext().getNodeReposInfo((File)file).reposUuid;
                bl2 = ((String)object7).equals(string);
            }
            object7 = null;
            if (!((SvnMerge)this.getOperation()).isIgnoreAncestry()) {
                object7 = this.getRepositoryAccess().getYoungestCommonAncestor((SVNURL)object3, l2, (SVNURL)object2, l3);
            }
            List<Object> list = new ArrayList<Object>();
            boolean bl3 = false;
            boolean bl4 = false;
            if (object7 != null && ((SVNLocationSegment)object7).getPath() != null && ((SVNLocationSegment)object7).getStartRevision() >= 0L) {
                bl4 = true;
                object6 = sVNURL2.appendPath(((SVNLocationSegment)object7).getPath(), false);
                if (((SVNURL)object2).equals(object6) && ((SVNLocationSegment)object7).getStartRevision() == l3) {
                    bl3 = true;
                    object5 = new SVNRevisionRange(SVNRevision.create(l2), SVNRevision.create(((SVNLocationSegment)object7).getStartRevision()));
                    ArrayList<SVNRevisionRange> arrayList = new ArrayList<SVNRevisionRange>();
                    arrayList.add((SVNRevisionRange)object5);
                    list = ((SvnNgMergeDriver)object).normalizeMergeSources(SvnTarget.fromURL((SVNURL)object3), (SVNURL)object3, sVNURL2, SVNRevision.create(l2), arrayList, sVNRepository);
                } else if (((SVNURL)object3).equals(object6) && ((SVNLocationSegment)object7).getStartRevision() == l2) {
                    bl3 = true;
                    object5 = new SVNRevisionRange(SVNRevision.create(((SVNLocationSegment)object7).getStartRevision()), SVNRevision.create(l3));
                    ArrayList<SVNRevisionRange> arrayList = new ArrayList<SVNRevisionRange>();
                    arrayList.add((SVNRevisionRange)object5);
                    list = ((SvnNgMergeDriver)object).normalizeMergeSources(SvnTarget.fromURL((SVNURL)object2), (SVNURL)object2, sVNURL2, SVNRevision.create(l3), arrayList, sVNRepository2);
                } else {
                    ((SvnNgMergeDriver)object).mergeCousinsAndSupplementMergeInfo(file, sVNRepository, sVNRepository2, (SVNURL)object3, l2, (SVNURL)object2, l3, ((SVNLocationSegment)object7).getStartRevision(), sVNURL2, sVNURL, ((SvnMerge)this.getOperation()).getDepth(), ((SvnMerge)this.getOperation()).isIgnoreMergeInfo(), ((SvnMerge)this.getOperation()).isIgnoreAncestry(), ((SvnMerge)this.getOperation()).isForce(), ((SvnMerge)this.getOperation()).isRecordOnly(), ((SvnMerge)this.getOperation()).isDryRun());
                }
            } else {
                object6 = new SvnNgMergeDriver$MergeSource();
                ((SvnNgMergeDriver$MergeSource)object6).rev1 = l2;
                ((SvnNgMergeDriver$MergeSource)object6).rev2 = l3;
                ((SvnNgMergeDriver$MergeSource)object6).url1 = object3;
                ((SvnNgMergeDriver$MergeSource)object6).url2 = object2;
                list.add(object6);
            }
            object6 = ((SvnNgMergeDriver)object).doMerge(null, list, file, sVNRepository, bl4, bl2, ((SvnMerge)this.getOperation()).isIgnoreMergeInfo(), ((SvnMerge)this.getOperation()).isIgnoreAncestry(), ((SvnMerge)this.getOperation()).isForce(), ((SvnMerge)this.getOperation()).isDryRun(), ((SvnMerge)this.getOperation()).isRecordOnly(), null, false, false, ((SvnMerge)this.getOperation()).getDepth(), ((SvnMerge)this.getOperation()).getMergeOptions());
            if (((SvnNgMergeDriver$MergeData)object6).useSleep) {
                SVNFileUtil.sleepForTimestamp();
            }
            object5 = ((SvnNgMergeDriver$MergeData)object6).conflictReport;
            return object5;
        }
        finally {
            sVNRepository.closeSession();
            sVNRepository2.closeSession();
        }
    }
}

