/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNRemoteStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNReporter17;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusReporter17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$ExternalNodeInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnGetStatus;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgGetStatus
extends SvnNgOperationRunner
implements ISvnObjectReceiver {
    private boolean targetDeletedInRepository;

    @Override
    protected SvnStatus run(SVNWCContext sVNWCContext) {
        Object object;
        String string;
        File file;
        boolean bl2 = ((SvnGetStatus)this.getOperation()).isCheckWorkingCopy();
        if (!((SvnGetStatus)this.getOperation()).isRemote()) {
            bl2 = true;
        }
        SVNNodeKind sVNNodeKind = sVNWCContext.readKind(this.getFirstTarget(), false);
        SVNDepth sVNDepth = ((SvnGetStatus)this.getOperation()).getDepth();
        if (sVNNodeKind == SVNNodeKind.DIR) {
            file = this.getFirstTarget();
            string = "";
        } else {
            file = SVNFileUtil.getParentFile(this.getFirstTarget());
            string = SVNFileUtil.getFileName(this.getFirstTarget());
            if (sVNNodeKind == SVNNodeKind.FILE) {
                if (sVNDepth == SVNDepth.EMPTY) {
                    sVNDepth = SVNDepth.FILES;
                }
            } else {
                boolean bl3 = false;
                try {
                    sVNNodeKind = sVNWCContext.readKind(file, false);
                    bl3 = sVNNodeKind != SVNNodeKind.DIR;
                }
                catch (SVNException sVNException) {
                    bl3 = true;
                }
                if (bl3) {
                    object = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found", (Object)this.getFirstTarget());
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
                }
            }
        }
        String[] stringArray = sVNWCContext.getOptions().getIgnorePatterns();
        if (((SvnGetStatus)this.getOperation()).isRemote()) {
            Object object2;
            Object object3;
            object = sVNWCContext.getUrlFromPath(file);
            if (object == null) {
                object3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Entry ''{0}'' has no URL", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
            }
            object3 = this.getRepositoryAccess().createRepository((SVNURL)object, null, true);
            long l2 = ((SvnGetStatus)this.getOperation()).getRevision() == SVNRevision.HEAD ? -1L : sVNWCContext.getRevisionNumber(((SvnGetStatus)this.getOperation()).getRevision(), null, (SVNRepository)object3, this.getFirstTarget());
            sVNNodeKind = ((SVNRepository)object3).checkPath("", l2);
            this.checkCancelled();
            SVNStatusEditor17 sVNStatusEditor17 = null;
            SVNReporter17 sVNReporter17 = null;
            if (sVNNodeKind == SVNNodeKind.NONE) {
                boolean bl4;
                boolean bl5 = sVNWCContext.isNodeAdded(file);
                if (bl5 && (bl4 = sVNWCContext.isNodeReplaced(file))) {
                    bl5 = false;
                }
                this.setTargetDeletedInRepository(!bl5);
                sVNStatusEditor17 = new SVNStatusEditor17(this.getFirstTarget(), sVNWCContext, ((SvnGetStatus)this.getOperation()).getOptions(), ((SvnGetStatus)this.getOperation()).isReportIgnored(), ((SvnGetStatus)this.getOperation()).isReportAll(), sVNDepth, this);
                sVNStatusEditor17.setFileListHook(((SvnGetStatus)this.getOperation()).getFileListHook());
                this.checkCancelled();
                sVNStatusEditor17.closeEdit();
            } else {
                sVNStatusEditor17 = new SVNRemoteStatusEditor17(file, string, sVNWCContext, ((SvnGetStatus)this.getOperation()).getOptions(), ((SvnGetStatus)this.getOperation()).isReportIgnored(), ((SvnGetStatus)this.getOperation()).isReportAll(), sVNDepth, bl2, this);
                sVNStatusEditor17.setFileListHook(((SvnGetStatus)this.getOperation()).getFileListHook());
                SVNRepository sVNRepository = this.getRepositoryAccess().createRepository((SVNURL)object, null, false);
                this.checkCancelled();
                boolean bl6 = ((SVNRepository)object3).hasCapability(SVNCapability.DEPTH);
                sVNReporter17 = new SVNReporter17(this.getFirstTarget(), sVNWCContext, false, !bl6, sVNDepth, false, true, true, false, null);
                SVNStatusReporter17 sVNStatusReporter17 = new SVNStatusReporter17(sVNRepository, sVNReporter17, sVNStatusEditor17);
                String string2 = "".equals(string) ? null : string;
                object2 = ((SvnGetStatus)this.getOperation()).isDepthAsSticky() ? sVNDepth : SVNDepth.UNKNOWN;
                ((SVNRepository)object3).status(l2, string2, (SVNDepth)object2, (ISVNReporterBaton)sVNStatusReporter17, SVNCancellableEditor.newInstance((ISVNEditor)((Object)sVNStatusEditor17), this, null));
            }
            ((SvnGetStatus)this.getOperation()).setRemoteRevision(sVNStatusEditor17.getTargetRevision());
            long l3 = sVNReporter17 != null ? (long)sVNReporter17.getReportedFilesCount() : 0L;
            long l4 = sVNReporter17 != null ? (long)sVNReporter17.getTotalFilesCount() : 0L;
            object2 = SVNEventFactory.createSVNEvent(this.getFirstTarget(), SVNNodeKind.NONE, null, sVNStatusEditor17.getTargetRevision(), SVNEventAction.STATUS_COMPLETED, null, null, null, l3, l4);
            this.handleEvent((SVNEvent)object2, -1.0);
        } else {
            object = new SVNStatusEditor17(file, sVNWCContext, sVNWCContext.getOptions(), ((SvnGetStatus)this.getOperation()).isReportIgnored(), ((SvnGetStatus)this.getOperation()).isReportAll(), sVNDepth, this);
            ((SVNStatusEditor17)object).setFileListHook(((SvnGetStatus)this.getOperation()).getFileListHook());
            try {
                ((SVNStatusEditor17)object).walkStatus(this.getFirstTarget(), sVNDepth, ((SvnGetStatus)this.getOperation()).isReportAll(), ((SvnGetStatus)this.getOperation()).isReportIgnored(), false, stringArray != null ? Arrays.asList(stringArray) : null);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_MISSING) {
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_WORKING_COPY, "''{0}'' is not a working copy", (Object)this.getFirstTarget());
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
                throw sVNException;
            }
        }
        if (sVNDepth.isRecursive() && ((SvnGetStatus)this.getOperation()).isReportExternals()) {
            object = sVNWCContext.getDb().getExternalsDefinedBelow(this.getFirstTarget());
            this.doExternalStatus((Map)object);
        }
        return (SvnStatus)((SvnGetStatus)this.getOperation()).first();
    }

    private void doExternalStatus(Map map) {
        for (File file : map.keySet()) {
            File file2 = (File)map.get(file);
            Structure structure = SvnWcDbExternals.readExternal(this.getWcContext(), file, file2, StructureFields$ExternalNodeInfo.kind);
            ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind = (ISVNWCDb$SVNWCDbKind)((Object)structure.get(StructureFields$ExternalNodeInfo.kind));
            if (iSVNWCDb$SVNWCDbKind != ISVNWCDb$SVNWCDbKind.Dir || SVNFileType.getType(file) != SVNFileType.DIRECTORY) continue;
            this.handleEvent(SVNEventFactory.createSVNEvent(file, SVNNodeKind.DIR, null, -1L, SVNEventAction.STATUS_EXTERNAL, null, null, null), -1.0);
            try {
                SvnGetStatus svnGetStatus = ((SvnGetStatus)this.getOperation()).getOperationFactory().createGetStatus();
                svnGetStatus.setSingleTarget(SvnTarget.fromFile(file));
                svnGetStatus.setRevision(SVNRevision.HEAD);
                svnGetStatus.setDepth(((SvnGetStatus)this.getOperation()).getDepth());
                svnGetStatus.setRemote(((SvnGetStatus)this.getOperation()).isRemote());
                svnGetStatus.setReportAll(((SvnGetStatus)this.getOperation()).isReportAll());
                svnGetStatus.setReportIgnored(((SvnGetStatus)this.getOperation()).isReportIgnored());
                svnGetStatus.setReportExternals(((SvnGetStatus)this.getOperation()).isReportExternals());
                svnGetStatus.setReceiver(((SvnGetStatus)this.getOperation()).getReceiver());
                svnGetStatus.setFileListHook(((SvnGetStatus)this.getOperation()).getFileListHook());
                svnGetStatus.setCheckWorkingCopy(((SvnGetStatus)this.getOperation()).isCheckWorkingCopy());
                svnGetStatus.run();
            }
            catch (SVNException sVNException) {
                if (!(sVNException instanceof SVNCancelException)) continue;
                throw sVNException;
            }
        }
    }

    private void setTargetDeletedInRepository(boolean bl2) {
        this.targetDeletedInRepository = bl2;
    }

    private boolean isTargetDeletedInRepository() {
        return this.targetDeletedInRepository;
    }

    public void receive(SvnTarget svnTarget, SvnStatus svnStatus) {
        if (((SvnGetStatus)this.getOperation()).getApplicableChangelists() != null && !((SvnGetStatus)this.getOperation()).getApplicableChangelists().isEmpty() && !((SvnGetStatus)this.getOperation()).getApplicableChangelists().contains(svnStatus.getChangelist())) {
            return;
        }
        if (this.isTargetDeletedInRepository()) {
            svnStatus.setRepositoryNodeStatus(SVNStatusType.STATUS_DELETED);
        }
        ((SvnGetStatus)this.getOperation()).receive(svnTarget, svnStatus);
    }

    @Override
    public void reset(SvnWcGeneration svnWcGeneration) {
        super.reset(svnWcGeneration);
        this.setTargetDeletedInRepository(false);
    }
}

