/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$ISVNWCNodeHandler;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$SVNWCNodeReposInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$SVNWCSchedule;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$ScheduleInternalInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo$BaseInfoField;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbInfo$InfoField;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$AdditionInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$DeletionInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$ExternalNodeInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$MovedInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeOriginInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$PristineInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnGetInfo;
import org.tmatesoft.svn.core.wc2.SvnInfo;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnSchedule;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.SvnWorkingCopyInfo;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgGetInfo
extends SvnNgOperationRunner
implements SVNWCContext$ISVNWCNodeHandler {
    private boolean hasRootTreeConflict;
    private boolean isFirstInfo;
    private Map treeConflicts;

    @Override
    public void reset(SvnWcGeneration svnWcGeneration) {
        super.reset(svnWcGeneration);
        this.hasRootTreeConflict = false;
        this.isFirstInfo = false;
        this.treeConflicts = null;
    }

    @Override
    protected SvnInfo run(SVNWCContext sVNWCContext) {
        Object object;
        SVNRevision sVNRevision;
        SVNRevision sVNRevision2;
        SVNDepth sVNDepth;
        block9: {
            this.hasRootTreeConflict = false;
            this.isFirstInfo = true;
            this.getTreeConflicts().clear();
            sVNDepth = ((SvnGetInfo)this.getOperation()).getDepth();
            if (sVNDepth == SVNDepth.UNKNOWN) {
                sVNDepth = SVNDepth.EMPTY;
            }
            sVNRevision2 = ((SvnGetInfo)this.getOperation()).getRevision();
            sVNRevision = ((SvnGetInfo)this.getOperation()).getFirstTarget().getPegRevision();
            if (((SvnGetInfo)this.getOperation()).isFetchActualOnly() && (object = sVNWCContext.getDb().opReadTreeConflict(this.getFirstTarget())) != null) {
                this.hasRootTreeConflict = true;
                this.getTreeConflicts().put(this.getFirstTarget(), object);
            }
            try {
                sVNWCContext.nodeWalkChildren(this.getFirstTarget(), this, ((SvnGetInfo)this.getOperation()).isFetchExcluded(), sVNDepth, ((SvnGetInfo)this.getOperation()).getApplicableChangelists());
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND && this.hasRootTreeConflict) break block9;
                throw sVNException;
            }
        }
        if (sVNRevision2 == SVNRevision.UNDEFINED && sVNRevision == SVNRevision.UNDEFINED && ((SvnGetInfo)this.getOperation()).isIncludeExternals() && sVNDepth.isRecursive() && (object = sVNWCContext.getDb().getExternalsDefinedBelow(this.getFirstTarget())) != null) {
            this.doExternalsInfo((Map)object, sVNDepth);
        }
        object = null;
        if (!this.getTreeConflicts().isEmpty()) {
            object = this.getWcContext().getNodeReposInfo(this.getFirstTarget());
            if (((SVNWCContext$SVNWCNodeReposInfo)object).reposRootUrl == null) {
                object = null;
            }
        }
        for (File file : this.getTreeConflicts().keySet()) {
            SVNTreeConflictDescription sVNTreeConflictDescription = (SVNTreeConflictDescription)this.getTreeConflicts().get(file);
            if (!this.isDepthIncludes(this.getFirstTarget(), sVNDepth, file, sVNTreeConflictDescription.getNodeKind())) continue;
            SvnInfo svnInfo = this.buildUnversionedInfo(file);
            ArrayList<SVNTreeConflictDescription> arrayList = new ArrayList<SVNTreeConflictDescription>(1);
            arrayList.add(sVNTreeConflictDescription);
            svnInfo.getWcInfo().setConflicts(arrayList);
            if (object != null) {
                svnInfo.setRepositoryRootURL(((SVNWCContext$SVNWCNodeReposInfo)object).reposRootUrl);
                svnInfo.setRepositoryUuid(((SVNWCContext$SVNWCNodeReposInfo)object).reposUuid);
            }
            ((SvnGetInfo)this.getOperation()).receive(SvnTarget.fromFile(file), svnInfo);
        }
        return (SvnInfo)((SvnGetInfo)this.getOperation()).first();
    }

    private void doExternalsInfo(Map map, SVNDepth sVNDepth) {
        for (Map.Entry entry : map.entrySet()) {
            SVNNodeKind sVNNodeKind;
            File file = (File)entry.getKey();
            File file2 = (File)entry.getValue();
            Structure structure = SvnWcDbExternals.readExternal(this.getWcContext(), file, file2, StructureFields$ExternalNodeInfo.kind, StructureFields$ExternalNodeInfo.revision);
            if (structure == null) continue;
            ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind = (ISVNWCDb$SVNWCDbKind)((Object)structure.get(StructureFields$ExternalNodeInfo.kind));
            long l2 = structure.lng(StructureFields$ExternalNodeInfo.revision);
            if (iSVNWCDb$SVNWCDbKind != ISVNWCDb$SVNWCDbKind.Dir || (sVNNodeKind = SVNFileType.getNodeKind(SVNFileType.getType(file))) != SVNNodeKind.DIR) continue;
            this.handleEvent(SVNEventFactory.createSVNEvent(file, SVNNodeKind.UNKNOWN, null, -1L, SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN, SVNStatusType.LOCK_UNKNOWN, SVNEventAction.INFO_EXTERNAL, SVNEventAction.INFO_EXTERNAL, null, null));
            SvnOperationFactory svnOperationFactory = ((SvnGetInfo)this.getOperation()).getOperationFactory();
            SvnGetInfo svnGetInfo = svnOperationFactory.createGetInfo();
            svnGetInfo.setSingleTarget(SvnTarget.fromFile(file));
            svnGetInfo.setFetchExcluded(((SvnGetInfo)this.getOperation()).isFetchExcluded());
            svnGetInfo.setFetchActualOnly(((SvnGetInfo)this.getOperation()).isFetchActualOnly());
            svnGetInfo.setIncludeExternals(((SvnGetInfo)this.getOperation()).isIncludeExternals());
            svnGetInfo.run();
        }
    }

    @Override
    public void nodeFound(File file, ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind) {
        SvnInfo svnInfo = this.buildInfo(file, iSVNWCDb$SVNWCDbKind);
        if (svnInfo == null && this.isFirstInfo) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found", (Object)file), SVNLogType.WC);
        }
        this.isFirstInfo = false;
        if (svnInfo != null) {
            ((SvnGetInfo)this.getOperation()).receive(SvnTarget.fromFile(file), svnInfo);
        }
        if (((SvnGetInfo)this.getOperation()).isFetchActualOnly() && iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.Dir) {
            Map map = this.getWcContext().getDb().opReadAllTreeConflicts(file);
            for (String string : map.keySet()) {
                this.getTreeConflicts().put(SVNFileUtil.createFilePath(file, string), map.get(string));
            }
        }
        this.getTreeConflicts().remove(file);
    }

    private SvnInfo buildUnversionedInfo(File file) {
        SvnWorkingCopyInfo svnWorkingCopyInfo = new SvnWorkingCopyInfo();
        svnWorkingCopyInfo.setPath(file);
        SvnInfo svnInfo = new SvnInfo();
        svnInfo.setWcInfo(svnWorkingCopyInfo);
        svnInfo.setRevision(-1L);
        svnInfo.setLastChangedRevision(-1L);
        svnInfo.setSize(-1L);
        svnInfo.setLastChangedDate(SVNDate.NULL);
        svnInfo.setKind(SVNNodeKind.NONE);
        svnWorkingCopyInfo.setDepth(SVNDepth.UNKNOWN);
        svnWorkingCopyInfo.setRecordedSize(-1L);
        svnWorkingCopyInfo.setCopyFromRevision(-1L);
        svnWorkingCopyInfo.setSchedule(SvnSchedule.NORMAL);
        return svnInfo;
    }

    private SvnInfo buildInfo(File file, ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind) {
        Object object;
        Object object2;
        SvnInfo svnInfo = new SvnInfo();
        SvnWorkingCopyInfo svnWorkingCopyInfo = new SvnWorkingCopyInfo();
        svnWorkingCopyInfo.setPath(file);
        svnInfo.setWcInfo(svnWorkingCopyInfo);
        svnInfo.setKind(iSVNWCDb$SVNWCDbKind.toNodeKind());
        svnWorkingCopyInfo.setCopyFromRevision(-1L);
        ISVNWCDb$WCDbInfo iSVNWCDb$WCDbInfo = this.getWcContext().getDb().readInfo(file, ISVNWCDb$WCDbInfo$InfoField.status, ISVNWCDb$WCDbInfo$InfoField.kind, ISVNWCDb$WCDbInfo$InfoField.revision, ISVNWCDb$WCDbInfo$InfoField.reposRelPath, ISVNWCDb$WCDbInfo$InfoField.reposRootUrl, ISVNWCDb$WCDbInfo$InfoField.reposUuid, ISVNWCDb$WCDbInfo$InfoField.changedRev, ISVNWCDb$WCDbInfo$InfoField.changedDate, ISVNWCDb$WCDbInfo$InfoField.changedAuthor, ISVNWCDb$WCDbInfo$InfoField.depth, ISVNWCDb$WCDbInfo$InfoField.checksum, ISVNWCDb$WCDbInfo$InfoField.originalReposRelpath, ISVNWCDb$WCDbInfo$InfoField.originalRootUrl, ISVNWCDb$WCDbInfo$InfoField.originalUuid, ISVNWCDb$WCDbInfo$InfoField.originalRevision, ISVNWCDb$WCDbInfo$InfoField.lock, ISVNWCDb$WCDbInfo$InfoField.translatedSize, ISVNWCDb$WCDbInfo$InfoField.lastModTime, ISVNWCDb$WCDbInfo$InfoField.changelist, ISVNWCDb$WCDbInfo$InfoField.conflicted, ISVNWCDb$WCDbInfo$InfoField.opRoot, ISVNWCDb$WCDbInfo$InfoField.haveBase, ISVNWCDb$WCDbInfo$InfoField.movedHere, ISVNWCDb$WCDbInfo$InfoField.movedTo);
        svnInfo.setRevision(iSVNWCDb$WCDbInfo.revision);
        svnInfo.setRepositoryRootURL(iSVNWCDb$WCDbInfo.reposRootUrl);
        svnInfo.setRepositoryUuid(iSVNWCDb$WCDbInfo.reposUuid);
        svnInfo.setLastChangedDate(iSVNWCDb$WCDbInfo.changedDate);
        svnInfo.setLastChangedAuthor(iSVNWCDb$WCDbInfo.changedAuthor);
        svnInfo.setLastChangedRevision(iSVNWCDb$WCDbInfo.changedRev);
        svnWorkingCopyInfo.setDepth(iSVNWCDb$WCDbInfo.depth);
        svnWorkingCopyInfo.setChecksum(iSVNWCDb$WCDbInfo.checksum);
        svnWorkingCopyInfo.setRecordedSize(iSVNWCDb$WCDbInfo.translatedSize);
        svnWorkingCopyInfo.setRecordedTime(iSVNWCDb$WCDbInfo.lastModTime);
        svnWorkingCopyInfo.setChangelist(iSVNWCDb$WCDbInfo.changelist);
        svnWorkingCopyInfo.setMovedTo(iSVNWCDb$WCDbInfo.movedToAbsPath);
        if (iSVNWCDb$WCDbInfo.opRoot && iSVNWCDb$WCDbInfo.movedHere) {
            object2 = SvnWcDbShared.scanMoved((SVNWCDb)this.getWcContext().getDb(), file);
            svnWorkingCopyInfo.setMovedFrom((File)((Structure)object2).get(StructureFields$MovedInfo.movedFromAbsPath));
        }
        object2 = iSVNWCDb$WCDbInfo.reposRelPath;
        if (iSVNWCDb$WCDbInfo.originalRootUrl != null) {
            svnInfo.setRepositoryRootURL(iSVNWCDb$WCDbInfo.originalRootUrl);
            svnInfo.setRepositoryUuid(iSVNWCDb$WCDbInfo.originalUuid);
        }
        if (iSVNWCDb$WCDbInfo.status == ISVNWCDb$SVNWCDbStatus.Added) {
            if (iSVNWCDb$WCDbInfo.originalReposRelpath != null) {
                svnInfo.setRevision(iSVNWCDb$WCDbInfo.originalRevision);
                object2 = iSVNWCDb$WCDbInfo.originalReposRelpath;
                if (iSVNWCDb$WCDbInfo.opRoot) {
                    svnWorkingCopyInfo.setCopyFromUrl(SVNWCUtils.join(svnInfo.getRepositoryRootUrl(), iSVNWCDb$WCDbInfo.originalReposRelpath));
                    svnWorkingCopyInfo.setCopyFromRevision(iSVNWCDb$WCDbInfo.originalRevision);
                }
            } else if (iSVNWCDb$WCDbInfo.opRoot) {
                object = SvnWcDbShared.scanAddition((SVNWCDb)this.getWcContext().getDb(), file);
                svnInfo.setRepositoryRootURL((SVNURL)((Structure)object).get(StructureFields$AdditionInfo.reposRootUrl));
                svnInfo.setRepositoryUuid((String)((Structure)object).get(StructureFields$AdditionInfo.reposUuid));
                if (iSVNWCDb$WCDbInfo.haveBase) {
                    long l2 = this.getWcContext().getDb().getBaseInfo((File)file, (ISVNWCDb$WCDbBaseInfo$BaseInfoField[])new ISVNWCDb$WCDbBaseInfo$BaseInfoField[]{ISVNWCDb$WCDbBaseInfo$BaseInfoField.revision}).revision;
                    svnInfo.setRevision(l2);
                }
                ((Structure)object).release();
            } else {
                object = this.getWcContext().getNodeOrigin(file, true, new StructureFields$NodeOriginInfo[0]);
                svnInfo.setRepositoryRootURL((SVNURL)((Structure)object).get(StructureFields$NodeOriginInfo.reposRootUrl));
                svnInfo.setRepositoryUuid(((Structure)object).text(StructureFields$NodeOriginInfo.reposUuid));
                svnInfo.setRevision(((Structure)object).lng(StructureFields$NodeOriginInfo.revision));
                ((Structure)object).release();
            }
            object = this.getWcContext().getNodeScheduleInternal(file, true, false);
            svnWorkingCopyInfo.setSchedule(this.toSchedule(((SVNWCContext$ScheduleInternalInfo)object).schedule));
            svnInfo.setUrl(this.getWcContext().getNodeUrl(file));
        } else if (iSVNWCDb$WCDbInfo.status == ISVNWCDb$SVNWCDbStatus.Deleted) {
            object = this.getWcContext().getDb().readPristineInfo(file);
            svnInfo.setLastChangedRevision(((Structure)object).lng(StructureFields$PristineInfo.changed_rev));
            svnInfo.setLastChangedDate((SVNDate)((Structure)object).get(StructureFields$PristineInfo.changed_date));
            svnInfo.setLastChangedAuthor(((Structure)object).text(StructureFields$PristineInfo.changed_author));
            svnWorkingCopyInfo.setDepth((SVNDepth)((Structure)object).get(StructureFields$PristineInfo.depth));
            svnWorkingCopyInfo.setChecksum((SvnChecksum)((Structure)object).get(StructureFields$PristineInfo.checksum));
            if (((Structure)object).get(StructureFields$PristineInfo.status) == ISVNWCDb$SVNWCDbStatus.Deleted) {
                svnWorkingCopyInfo.setDepth(SVNDepth.EXCLUDE);
                svnInfo.setKind(SVNNodeKind.UNKNOWN);
            }
            ((Structure)object).release();
            Structure structure = SvnWcDbShared.scanDeletion((SVNWCDb)this.getWcContext().getDb(), file);
            File file2 = (File)structure.get(StructureFields$DeletionInfo.workDelAbsPath);
            structure.release();
            if (file2 != null) {
                File file3 = SVNFileUtil.getFileDir(file2);
                Structure structure2 = SvnWcDbShared.scanAddition((SVNWCDb)this.getWcContext().getDb(), file3);
                object2 = (File)structure2.get(StructureFields$AdditionInfo.reposRelPath);
                svnInfo.setRepositoryRootURL((SVNURL)structure2.get(StructureFields$AdditionInfo.reposRootUrl));
                svnInfo.setRepositoryUuid((String)structure2.get(StructureFields$AdditionInfo.reposUuid));
                svnInfo.setRevision(structure2.lng(StructureFields$AdditionInfo.originalRevision));
                structure2.release();
                File file4 = SVNFileUtil.createFilePath((File)object2, SVNWCUtils.skipAncestor(file3, file));
                svnInfo.setUrl(SVNWCUtils.join(svnInfo.getRepositoryRootUrl(), file4));
            } else {
                ISVNWCDb$WCDbBaseInfo iSVNWCDb$WCDbBaseInfo = this.getWcContext().getDb().getBaseInfo(file, ISVNWCDb$WCDbBaseInfo$BaseInfoField.revision, ISVNWCDb$WCDbBaseInfo$BaseInfoField.reposRelPath, ISVNWCDb$WCDbBaseInfo$BaseInfoField.reposRootUrl, ISVNWCDb$WCDbBaseInfo$BaseInfoField.reposUuid);
                object2 = iSVNWCDb$WCDbBaseInfo.reposRelPath;
                svnInfo.setRevision(iSVNWCDb$WCDbBaseInfo.revision);
                svnInfo.setRepositoryRootURL(iSVNWCDb$WCDbBaseInfo.reposRootUrl);
                svnInfo.setRepositoryUuid(iSVNWCDb$WCDbBaseInfo.reposUuid);
                svnInfo.setUrl(SVNWCUtils.join(svnInfo.getRepositoryRootUrl(), (File)object2));
            }
            svnWorkingCopyInfo.setSchedule(SvnSchedule.DELETE);
        } else {
            if (iSVNWCDb$WCDbInfo.status == ISVNWCDb$SVNWCDbStatus.NotPresent || iSVNWCDb$WCDbInfo.status == ISVNWCDb$SVNWCDbStatus.ServerExcluded) {
                return null;
            }
            if (svnInfo.getRepositoryRootUrl() != null) {
                if (object2 != null) {
                    svnInfo.setUrl(SVNWCUtils.join(svnInfo.getRepositoryRootUrl(), (File)object2));
                } else {
                    svnInfo.setUrl(svnInfo.getRepositoryRootUrl());
                }
            }
            svnWorkingCopyInfo.setSchedule(SvnSchedule.NORMAL);
        }
        if (iSVNWCDb$WCDbInfo.status == ISVNWCDb$SVNWCDbStatus.Excluded) {
            svnWorkingCopyInfo.setDepth(SVNDepth.EXCLUDE);
        }
        svnInfo.setSize(-1L);
        svnWorkingCopyInfo.setWcRoot(this.getWcContext().getDb().getWCRoot(file));
        if (iSVNWCDb$WCDbInfo.conflicted) {
            svnWorkingCopyInfo.setConflicts(this.getWcContext().getDb().readConflicts(file));
        }
        if (iSVNWCDb$WCDbInfo.lock != null) {
            object = new SVNLock(null, iSVNWCDb$WCDbInfo.lock.token, iSVNWCDb$WCDbInfo.lock.owner, iSVNWCDb$WCDbInfo.lock.comment, iSVNWCDb$WCDbInfo.lock.date, null);
            svnInfo.setLock((SVNLock)object);
        }
        return svnInfo;
    }

    private SvnSchedule toSchedule(SVNWCContext$SVNWCSchedule sVNWCContext$SVNWCSchedule) {
        if (sVNWCContext$SVNWCSchedule == SVNWCContext$SVNWCSchedule.add) {
            return SvnSchedule.ADD;
        }
        if (sVNWCContext$SVNWCSchedule == SVNWCContext$SVNWCSchedule.delete) {
            return SvnSchedule.DELETE;
        }
        if (sVNWCContext$SVNWCSchedule == SVNWCContext$SVNWCSchedule.normal) {
            return SvnSchedule.NORMAL;
        }
        if (sVNWCContext$SVNWCSchedule == SVNWCContext$SVNWCSchedule.replace) {
            return SvnSchedule.REPLACE;
        }
        return null;
    }

    private boolean isDepthIncludes(File file, SVNDepth sVNDepth, File file2, SVNNodeKind sVNNodeKind) {
        if (sVNDepth == SVNDepth.INFINITY) {
            return true;
        }
        File file3 = SVNFileUtil.getParentFile(file2);
        if (sVNDepth == SVNDepth.IMMEDIATES) {
            return file.equals(file3);
        }
        if (sVNDepth == SVNDepth.FILES) {
            return sVNNodeKind == SVNNodeKind.FILE && file.equals(file3);
        }
        return file.equals(file2);
    }

    private Map getTreeConflicts() {
        if (this.treeConflicts == null) {
            this.treeConflicts = new HashMap();
        }
        return this.treeConflicts;
    }
}

