/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$PristineContentsInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$ExternalNodeInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeOriginInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnExport;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgExport
extends SvnNgOperationRunner {
    @Override
    protected Long run(SVNWCContext sVNWCContext) {
        SVNRevision sVNRevision = ((SvnExport)this.getOperation()).getRevision();
        File file = ((SvnExport)this.getOperation()).getFirstTarget().getFile();
        File file2 = ((SvnExport)this.getOperation()).getSource().getFile();
        String string = ((SvnExport)this.getOperation()).getEolStyle();
        boolean bl2 = !((SvnExport)this.getOperation()).isExpandKeywords();
        boolean bl3 = ((SvnExport)this.getOperation()).isForce();
        SVNDepth sVNDepth = ((SvnExport)this.getOperation()).getDepth();
        if (sVNRevision == SVNRevision.UNDEFINED) {
            sVNRevision = SVNRevision.WORKING;
        }
        if (SVNFileType.getType(file2) == SVNFileType.FILE && SVNFileType.getType(file) == SVNFileType.DIRECTORY) {
            file = new File(file, file2.getName());
        }
        this.copyVersionedDir(file2, file, sVNRevision, string, bl2, bl3, sVNDepth);
        this.handleEvent(SVNEventFactory.createSVNEvent(file, SVNNodeKind.NONE, null, -1L, SVNEventAction.UPDATE_COMPLETED, null, null, null));
        return sVNRevision.getNumber();
    }

    private void copyVersionedDir(File file, File file2, SVNRevision sVNRevision, String string, boolean bl2, boolean bl3, SVNDepth sVNDepth) {
        Object object;
        if (sVNRevision != SVNRevision.WORKING) {
            object = this.getWcContext().getNodeOrigin(file, false, StructureFields$NodeOriginInfo.isCopy, StructureFields$NodeOriginInfo.reposRelpath);
            if (((Structure)object).is(StructureFields$NodeOriginInfo.isCopy) && !((Structure)object).hasValue(StructureFields$NodeOriginInfo.reposRelpath)) {
                return;
            }
            ((Structure)object).release();
        } else {
            boolean bl4 = this.getWcContext().isNodeStatusDeleted(file);
            if (bl4) {
                return;
            }
        }
        object = this.getWcContext().readKind(file, false);
        if (object == SVNNodeKind.DIR) {
            Object object2;
            Object object3;
            SVNExternal[] sVNExternalArray;
            Object object4;
            Object object5;
            if (file2.exists() && !bl3) {
                object5 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Destination directory exists, and will not be overwritten unless forced");
                SVNErrorManager.error((SVNErrorMessage)object5, SVNLogType.WC);
            }
            SVNFileUtil.ensureDirectoryExists(file2);
            object5 = this.getWcContext().getNodeChildren(file, false);
            Object object6 = object5.iterator();
            while (object6.hasNext()) {
                object4 = (File)object6.next();
                this.checkCancelled();
                sVNExternalArray = new File(file2, ((File)object4).getName());
                SVNNodeKind sVNNodeKind = this.getWcContext().readKind((File)object4, false);
                if (sVNNodeKind == SVNNodeKind.DIR && sVNDepth.compareTo(SVNDepth.IMMEDIATES) >= 0) {
                    this.handleEvent(SVNEventFactory.createSVNEvent((File)sVNExternalArray, SVNNodeKind.NONE, null, -1L, SVNEventAction.UPDATE_ADD, null, null, null));
                    if (sVNDepth == SVNDepth.INFINITY) {
                        this.copyVersionedDir((File)object4, (File)sVNExternalArray, sVNRevision, string, bl2, bl3, sVNDepth);
                        continue;
                    }
                    SVNFileUtil.ensureDirectoryExists((File)sVNExternalArray);
                    continue;
                }
                if (sVNNodeKind != SVNNodeKind.FILE || sVNDepth.compareTo(SVNDepth.FILES) < 0) continue;
                object3 = null;
                try {
                    object2 = SvnWcDbExternals.readExternal(this.getWcContext(), (File)object4, (File)object4, StructureFields$ExternalNodeInfo.kind);
                    object3 = (ISVNWCDb$SVNWCDbKind)((Object)((Structure)object2).get(StructureFields$ExternalNodeInfo.kind));
                    ((Structure)object2).release();
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                        throw sVNException;
                    }
                    object3 = null;
                }
                if (object3 == ISVNWCDb$SVNWCDbKind.File) continue;
                this.copyVersionedFile((File)object4, (File)sVNExternalArray, sVNRevision, string, bl2);
            }
            object6 = this.getWcContext().getNodeDepth(file);
            if (!((SvnExport)this.getOperation()).isIgnoreExternals() && sVNDepth == SVNDepth.INFINITY && object6 == SVNDepth.INFINITY && (object4 = this.getWcContext().getProperty(file, "svn:externals")) != null) {
                sVNExternalArray = SVNExternal.parseExternals(file, (String)object4);
                for (int i2 = 0; i2 < sVNExternalArray.length; ++i2) {
                    object3 = new File(file, sVNExternalArray[i2].getPath());
                    object2 = new File(file2, sVNExternalArray[i2].getPath());
                    if (((File)object2).getParentFile() != null) {
                        SVNFileUtil.ensureDirectoryExists(((File)object2).getParentFile());
                    }
                    this.copyVersionedDir((File)object3, (File)object2, sVNRevision, string, bl2, bl3, SVNDepth.INFINITY);
                }
            }
        } else if (object == SVNNodeKind.FILE) {
            SVNFileType sVNFileType = SVNFileType.getType(file2);
            if (!(sVNFileType != SVNFileType.FILE && sVNFileType != SVNFileType.UNKNOWN || bl3)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Destination file ''{0}'' exists, and will not be overwritten unless forced", (Object)file2);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            } else if (sVNFileType == SVNFileType.DIRECTORY) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Destination ''{0}'' exists. Cannot overwrite directory with non-directory", (Object)file2);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            this.copyVersionedFile(file, file2, sVNRevision, string, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyVersionedFile(File file, File file2, SVNRevision sVNRevision, String string, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        SVNDate sVNDate;
        long l2;
        byte[] byArray;
        Object object5;
        boolean bl3 = this.getWcContext().isNodeStatusDeleted(file);
        if (sVNRevision == SVNRevision.WORKING && bl3) {
            return;
        }
        File file3 = null;
        SVNProperties sVNProperties = null;
        boolean bl4 = false;
        if (sVNRevision != SVNRevision.WORKING) {
            object5 = this.getWcContext().getPristineContents(file, false, true);
            if (object5 != null) {
                file3 = ((SVNWCContext$PristineContentsInfo)object5).path;
            }
            if (file3 == null) {
                return;
            }
            sVNProperties = this.getWcContext().getPristineProps(file);
        } else {
            sVNProperties = this.getWcContext().getDb().readProperties(file);
            object5 = SVNStatusEditor17.internalStatus(this.getWcContext(), file, true);
            bl4 = ((SvnStatus)object5).getTextStatus() != SVNStatusType.STATUS_NORMAL;
            file3 = file;
        }
        boolean bl5 = sVNProperties.getStringValue("svn:special") != null;
        boolean bl6 = sVNProperties.getStringValue("svn:executable") != null;
        String string2 = sVNProperties.getStringValue("svn:keywords");
        String string3 = sVNProperties.getStringValue("svnkit:charset");
        String string4 = sVNProperties.getStringValue("svn:mime-type");
        String string5 = SVNTranslator.getCharset(string3, string4, file, ((SvnExport)this.getOperation()).getOptions());
        if (bl5 && SVNFileUtil.symlinksSupported()) {
            String string6 = SVNFileUtil.getSymlinkName(file);
            SVNFileUtil.createSymlink(file2, string6);
            return;
        }
        byte[] byArray2 = byArray = string != null ? SVNTranslator.getEOL(string, ((SvnExport)this.getOperation()).getOptions()) : null;
        if (byArray == null) {
            string = sVNProperties.getStringValue("svn:eol-style");
            byArray = SVNTranslator.getEOL(string, ((SvnExport)this.getOperation()).getOptions());
        }
        if (bl4) {
            l2 = SVNFileUtil.getFileLastModified(file);
            sVNDate = new SVNDate(l2, 0);
        } else {
            object4 = this.getWcContext().getDb().readInfo(file, StructureFields$NodeInfo.changedDate);
            sVNDate = (SVNDate)((Structure)object4).get(StructureFields$NodeInfo.changedDate);
            l2 = sVNDate.getTime();
            ((Structure)object4).release();
        }
        object4 = null;
        if (string2 != null) {
            object3 = this.getWcContext().getDb().readInfo(file, StructureFields$NodeInfo.changedAuthor, StructureFields$NodeInfo.changedRev, StructureFields$NodeInfo.reposRootUrl);
            object2 = Long.toString(((Structure)object3).lng(StructureFields$NodeInfo.changedRev));
            object = (String)((Structure)object3).get(StructureFields$NodeInfo.changedAuthor);
            SVNURL sVNURL = (SVNURL)((Structure)object3).get(StructureFields$NodeInfo.reposRootUrl);
            ((Structure)object3).release();
            if (bl4) {
                object = "(local)";
                object2 = (String)object2 + "M";
            }
            SVNURL sVNURL2 = this.getWcContext().getNodeUrl(file);
            object4 = SVNTranslator.computeKeywords(string2, sVNURL2.toString(), sVNURL == null ? null : sVNURL.toString(), (String)object, SVNDate.formatDate(sVNDate), (String)object2, ((SvnExport)this.getOperation()).getOptions());
        }
        object3 = SVNFileUtil.createUniqueFile(file2.getParentFile(), "svnkit", ".tmp", false);
        try {
            object2 = null;
            object = null;
            try {
                object = SVNFileUtil.openFileForReading(file3);
                object2 = SVNFileUtil.openFileForWriting((File)object3);
                if (byArray != null || object4 != null) {
                    object2 = SVNTranslator.getTranslatingOutputStream((OutputStream)object2, string5, byArray, false, (Map)object4, !bl2);
                }
                SVNTranslator.copy((InputStream)object, (OutputStream)object2);
            }
            catch (IOException iOException) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException), SVNLogType.WC);
            }
            finally {
                SVNFileUtil.closeFile((InputStream)object);
                SVNFileUtil.closeFile((OutputStream)object2);
            }
            SVNFileUtil.rename((File)object3, file2);
        }
        finally {
            SVNFileUtil.deleteFile((File)object3);
        }
        if (bl6) {
            SVNFileUtil.setExecutable(file2, true);
        }
        if (!bl5 && l2 > 0L) {
            SVNFileUtil.setLastModified(file2, l2);
        }
        this.handleEvent(SVNEventFactory.createSVNEvent(file2, SVNNodeKind.NONE, null, -1L, SVNEventAction.UPDATE_ADD, null, null, null));
    }
}

