/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.Serializable;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess$LocationsInfo;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess$RevisionsPair;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess$UrlInfo;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback2;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackWrapper;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffSummarizeCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgDiffSummarize$1;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgDiffSummarize$2;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgDiffUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemoteDiffEditor2;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnReverseOrderDiffCallback;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNDiffStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnDiffStatus;
import org.tmatesoft.svn.core.wc2.SvnDiffSummarize;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgDiffSummarize
extends SvnNgOperationRunner {
    private SvnNgRepositoryAccess repositoryAccess;

    public boolean isApplicable(SvnDiffSummarize svnDiffSummarize, SvnWcGeneration svnWcGeneration) {
        if (svnDiffSummarize.getSource() != null) {
            return !svnDiffSummarize.getSource().isFile() || svnWcGeneration == SvnWcGeneration.V17;
        }
        if (svnDiffSummarize.getFirstSource().isFile() && svnWcGeneration != SvnWcGeneration.V17) {
            return false;
        }
        return !svnDiffSummarize.getSecondSource().isFile() || svnWcGeneration == SvnWcGeneration.V17;
    }

    @Override
    protected SvnDiffStatus run(SVNWCContext sVNWCContext) {
        boolean bl2;
        SvnTarget svnTarget = ((SvnDiffSummarize)this.getOperation()).getSource();
        SvnTarget svnTarget2 = ((SvnDiffSummarize)this.getOperation()).getFirstSource();
        SvnTarget svnTarget3 = ((SvnDiffSummarize)this.getOperation()).getSecondSource();
        ISVNDiffStatusHandler iSVNDiffStatusHandler = SvnNgDiffSummarize.createHandlerForReceiver((ISvnObjectReceiver)((Object)this.getOperation()));
        SVNDepth sVNDepth = ((SvnDiffSummarize)this.getOperation()).getDepth();
        boolean bl3 = bl2 = !((SvnDiffSummarize)this.getOperation()).isIgnoreAncestry();
        if (svnTarget != null) {
            this.doDiff(svnTarget, ((SvnDiffSummarize)this.getOperation()).getStartRevision(), svnTarget, ((SvnDiffSummarize)this.getOperation()).getEndRevision(), svnTarget.getPegRevision(), sVNDepth, bl2, ((SvnDiffSummarize)this.getOperation()).isRecurseIntoDeletedDirectories(), iSVNDiffStatusHandler);
        } else {
            this.doDiff(svnTarget2, svnTarget2.getResolvedPegRevision(), svnTarget3, svnTarget3.getResolvedPegRevision(), SVNRevision.UNDEFINED, sVNDepth, bl2, ((SvnDiffSummarize)this.getOperation()).isRecurseIntoDeletedDirectories(), iSVNDiffStatusHandler);
        }
        return null;
    }

    private void doDiff(SvnTarget svnTarget, SVNRevision sVNRevision, SvnTarget svnTarget2, SVNRevision sVNRevision2, SVNRevision sVNRevision3, SVNDepth sVNDepth, boolean bl2, boolean bl3, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        boolean bl4;
        boolean bl5;
        if (sVNRevision == SVNRevision.UNDEFINED || sVNRevision2 == SVNRevision.UNDEFINED) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all required revisions are specified");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        boolean bl6 = sVNRevision == SVNRevision.BASE || sVNRevision == SVNRevision.WORKING;
        boolean bl7 = bl5 = sVNRevision2 == SVNRevision.BASE || sVNRevision2 == SVNRevision.WORKING;
        if (sVNRevision3 != SVNRevision.UNDEFINED && bl6 && bl5) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "At least one revision must be something other than BASE or WORKING when diffing a URL");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        boolean bl8 = !bl6 || svnTarget.isURL();
        boolean bl9 = bl4 = !bl5 || svnTarget2.isURL();
        if (bl8) {
            if (bl4) {
                this.doDiffReposRepos(svnTarget.getURL(), svnTarget.getFile(), sVNRevision, svnTarget2.getURL(), svnTarget2.getFile(), sVNRevision2, sVNRevision3, sVNDepth, bl2, bl3, iSVNDiffStatusHandler);
            } else {
                this.doDiffReposWC(svnTarget, sVNRevision, svnTarget2, sVNRevision2, sVNRevision3, false, sVNDepth, bl2, bl3, iSVNDiffStatusHandler);
            }
        } else if (bl4) {
            this.doDiffReposWC(svnTarget2, sVNRevision2, svnTarget, sVNRevision, sVNRevision3, true, sVNDepth, bl2, bl3, iSVNDiffStatusHandler);
        } else if (sVNRevision == SVNRevision.WORKING && sVNRevision2 == SVNRevision.WORKING) {
            SvnTarget svnTarget3;
            File file = svnTarget.getFile();
            File file2 = svnTarget2.getFile();
            SVNNodeKind sVNNodeKind = SVNFileType.getNodeKind(SVNFileType.getType(file));
            if (sVNNodeKind == SVNNodeKind.DIR) {
                String string = "";
                svnTarget3 = svnTarget;
            } else {
                String string = SVNFileUtil.getFileName(file);
                svnTarget3 = SvnTarget.fromFile(SVNFileUtil.getParentFile(svnTarget.getFile()), svnTarget.getPegRevision());
            }
            SvnNgDiffUtil.doArbitraryNodesDiff(svnTarget, svnTarget2, sVNDepth, this.getWcContext(), new SvnDiffSummarizeCallback(sVNNodeKind == SVNNodeKind.DIR ? file : SVNFileUtil.getParentFile(file), false, this.getRepositoryAccess().getTargetURL(svnTarget3), svnTarget3.getFile(), iSVNDiffStatusHandler), ((SvnDiffSummarize)this.getOperation()).getEventHandler());
        } else {
            this.doDiffWCWC(svnTarget, sVNRevision, svnTarget2, sVNRevision2, sVNDepth, bl2, iSVNDiffStatusHandler);
        }
    }

    private void doDiffURL(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, SVNDepth sVNDepth, boolean bl2, boolean bl3, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        if (iSVNDiffStatusHandler == null) {
            return;
        }
        this.doDiffReposRepos(sVNURL, file, sVNRevision, sVNURL, file, sVNRevision2, sVNRevision3, sVNDepth, bl2, bl3, iSVNDiffStatusHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDiffReposRepos(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNURL sVNURL2, File file2, SVNRevision sVNRevision2, SVNRevision sVNRevision3, SVNDepth sVNDepth, boolean bl2, boolean bl3, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        Object object;
        long l2;
        Object object2;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        Serializable serializable;
        boolean bl7;
        if (sVNRevision == SVNRevision.UNDEFINED || sVNRevision2 == SVNRevision.UNDEFINED) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all revisions are specified");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        boolean bl8 = sVNRevision == SVNRevision.BASE || sVNRevision == SVNRevision.WORKING;
        boolean bl9 = bl7 = sVNRevision2 == SVNRevision.BASE || sVNRevision2 == SVNRevision.WORKING;
        if (sVNRevision3 != SVNRevision.UNDEFINED) {
            if (bl8 && bl7) {
                serializable = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "At least one revision must be non-local for a pegged diff");
                SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
            }
            bl6 = !bl8;
            bl5 = !bl7;
        } else {
            bl6 = !bl8 || sVNURL != null;
            boolean bl10 = bl5 = !bl7 || sVNURL2 != null;
        }
        if (!bl6 || !bl5) {
            serializable = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Summarizing diff can only compare repository to repository");
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        serializable = null;
        if (file != null) {
            serializable = file;
        }
        if (file2 != null) {
            serializable = file2;
        }
        if (sVNRevision3.isValid()) {
            sVNURL2 = this.resolvePeggedDiffTargetUrl(sVNURL2, file2, sVNRevision3, sVNRevision2);
            sVNURL = this.resolvePeggedDiffTargetUrl(sVNURL, file, sVNRevision3, sVNRevision);
            if (sVNURL2 != null && sVNURL == null) {
                sVNURL = sVNURL2;
            }
            if (sVNURL != null && sVNURL2 == null) {
                sVNURL2 = sVNURL;
            }
        } else {
            sVNURL = sVNURL == null ? this.getURL(file) : sVNURL;
            sVNURL2 = sVNURL2 == null ? this.getURL(file2) : sVNURL2;
        }
        SVNRepository sVNRepository = this.createRepository(sVNURL, null, true);
        SVNRepository sVNRepository2 = this.createRepository(sVNURL2, null, false);
        long l3 = this.getRevisionNumber(sVNRevision, sVNRepository, sVNURL);
        long l4 = -1L;
        SVNNodeKind sVNNodeKind = null;
        SVNNodeKind sVNNodeKind2 = null;
        SVNURL sVNURL3 = sVNURL;
        SVNURL sVNURL4 = sVNURL2;
        String string = "";
        String string2 = "";
        try {
            Object object3;
            l4 = this.getRevisionNumber(sVNRevision2, sVNRepository2, sVNURL2);
            sVNNodeKind = sVNRepository.checkPath("", l3);
            sVNNodeKind2 = sVNRepository2.checkPath("", l4);
            if (sVNNodeKind == SVNNodeKind.NONE && sVNNodeKind2 == SVNNodeKind.NONE) {
                if (sVNURL.equals(sVNURL2)) {
                    object3 = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff target ''{0}'' was not found in the repository at revisions ''{1}'' and ''{2}''", sVNURL, l3, l4);
                    SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
                } else {
                    object3 = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff targets ''{0}'' and ''{1}'' were not found in the repository at revisions ''{2}'' and ''{3}''");
                    SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
                }
            } else if (sVNNodeKind == SVNNodeKind.NONE) {
                this.checkDiffTargetExists(sVNURL, l4, l3, sVNRepository);
            } else if (sVNNodeKind2 == SVNNodeKind.NONE) {
                this.checkDiffTargetExists(sVNURL2, l3, l4, sVNRepository2);
            }
            object3 = sVNRepository.getRepositoryRoot(true);
            if (!sVNURL.equals(object3) && !sVNURL2.equals(object3)) {
                sVNURL3 = sVNURL.removePathTail();
                sVNURL4 = sVNURL2.removePathTail();
                string = SVNPathUtil.tail(sVNURL.toDecodedString());
                string2 = SVNPathUtil.tail(sVNURL2.toDecodedString());
            }
        }
        finally {
            sVNRepository2.closeSession();
        }
        boolean bl11 = bl4 = sVNNodeKind != SVNNodeKind.DIR || sVNNodeKind2 != SVNNodeKind.DIR;
        if (serializable == null) {
            serializable = bl4 ? new File(SVNPathUtil.tail(sVNURL.toDecodedString())).getAbsoluteFile() : new File("").getAbsoluteFile();
        }
        SvnDiffSummarizeCallback svnDiffSummarizeCallback = new SvnDiffSummarizeCallback(file != null ? SVNFileUtil.createFilePath(file.getParentFile(), string) : SVNFileUtil.createFilePath(new File("").getAbsolutePath(), string), false, sVNURL3, (File)(bl4 ? ((File)serializable).getParentFile() : serializable), iSVNDiffStatusHandler);
        ISvnDiffCallback2 iSvnDiffCallback2 = new SvnDiffCallbackWrapper(svnDiffSummarizeCallback, bl3, (File)(bl4 ? ((File)serializable).getParentFile() : serializable));
        if (sVNNodeKind2 == SVNNodeKind.NONE) {
            object2 = sVNURL;
            sVNURL = sVNURL2;
            sVNURL2 = object2;
            l2 = l3;
            l3 = l4;
            l4 = l2;
            object2 = sVNURL3;
            sVNURL3 = sVNURL4;
            sVNURL4 = object2;
            object = string;
            string = string2;
            string2 = object;
            iSvnDiffCallback2 = new SvnReverseOrderDiffCallback(iSvnDiffCallback2, null);
        }
        sVNRepository.setLocation(sVNURL3, true);
        sVNRepository2.setLocation(sVNURL3, true);
        object2 = null;
        try {
            object2 = new SvnNgRemoteDiffEditor2(l3, false, sVNRepository2, iSvnDiffCallback2);
            l2 = l3;
            object = new SvnNgDiffSummarize$1(this, l2);
            sVNRepository.diff(sVNURL2, l4, l3, string, !bl2, sVNDepth, false, (ISVNReporterBaton)object, SVNCancellableEditor.newInstance((ISVNEditor)object2, this, this.getDebugLog()));
        }
        finally {
            sVNRepository2.closeSession();
            if (object2 != null) {
                ((SvnNgRemoteDiffEditor2)object2).cleanup();
            }
        }
    }

    private void doDiffReposWC(SvnTarget svnTarget, SVNRevision sVNRevision, SvnTarget svnTarget2, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl2, SVNDepth sVNDepth, boolean bl3, boolean bl4, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        SvnNgDiffUtil.doDiffSummarizeReposWC(svnTarget, sVNRevision, sVNRevision3, svnTarget2, sVNRevision2, bl2, this.getRepositoryAccess(), this.getWcContext(), false, sVNDepth, bl3, bl4, ((SvnDiffSummarize)this.getOperation()).getApplicableChangelists(), false, null, iSVNDiffStatusHandler, this);
    }

    private void doDiffWCWC(SvnTarget svnTarget, SVNRevision sVNRevision, SvnTarget svnTarget2, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl2, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        Serializable serializable;
        File file;
        assert (!svnTarget.isURL());
        assert (!svnTarget2.isURL());
        File file2 = svnTarget.getFile();
        if (!file2.equals(file = svnTarget2.getFile()) || sVNRevision != SVNRevision.BASE || sVNRevision2 != SVNRevision.WORKING) {
            serializable = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Summarized diffs are only supported between a path's text-base and its working files at this time");
            SVNErrorManager.error(serializable, SVNLogType.WC);
        }
        String string = (serializable = SVNFileType.getNodeKind(SVNFileType.getType(file2))) == SVNNodeKind.DIR ? "" : SVNFileUtil.getFileName(file2);
        File file3 = serializable == SVNNodeKind.DIR ? file2 : SVNFileUtil.getParentFile(file2);
        SVNURL sVNURL = serializable == SVNNodeKind.DIR ? this.getRepositoryAccess().getTargetURL(svnTarget) : this.getRepositoryAccess().getTargetURL(SvnTarget.fromFile(SVNFileUtil.getParentFile(svnTarget.getFile())));
        SvnDiffSummarizeCallback svnDiffSummarizeCallback = new SvnDiffSummarizeCallback(file2, false, sVNURL, file3, iSVNDiffStatusHandler);
        SvnNgDiffUtil.doDiffWCWC(file2, this.getRepositoryAccess(), this.getWcContext(), sVNDepth, bl2, ((SvnDiffSummarize)this.getOperation()).isRecurseIntoDeletedDirectories(), ((SvnDiffSummarize)this.getOperation()).getApplicableChangelists(), false, false, null, svnDiffSummarizeCallback, ((SvnDiffSummarize)this.getOperation()).getEventHandler());
    }

    private SVNURL resolvePeggedDiffTargetUrl(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNRevision sVNRevision2) {
        try {
            Structure structure = this.getRepositoryAccess().getLocations(null, sVNURL == null ? SvnTarget.fromFile(file) : SvnTarget.fromURL(sVNURL), sVNRevision, sVNRevision2, SVNRevision.UNDEFINED);
            return (SVNURL)structure.get(SvnRepositoryAccess$LocationsInfo.startUrl);
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.CLIENT_UNRELATED_RESOURCES || sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                return null;
            }
            throw sVNException;
        }
    }

    private void checkDiffTargetExists(SVNURL sVNURL, long l2, long l3, SVNRepository sVNRepository) {
        SVNNodeKind sVNNodeKind;
        SVNURL sVNURL2 = sVNRepository.getLocation();
        boolean bl2 = sVNURL2.equals(sVNURL);
        if (!bl2) {
            sVNRepository.setLocation(sVNURL, true);
        }
        if ((sVNNodeKind = sVNRepository.checkPath("", l2)) == SVNNodeKind.NONE) {
            if (l2 == l3) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff target ''{0}'' was not found in the repository at revision ''{1}''", sVNURL, l2);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            } else {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Diff target ''{0}'' was not found in the repository at revision ''{1}'' or ''{2}''", sVNURL, l2, l3);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
        }
        if (!bl2) {
            sVNRepository.setLocation(sVNURL, true);
        }
    }

    private ISVNDebugLog getDebugLog() {
        return SVNDebugLog.getDefaultLog();
    }

    private long getRevisionNumber(SVNRevision sVNRevision, SVNRepository sVNRepository, SVNURL sVNURL) {
        Structure structure = this.getRepositoryAccess().getRevisionNumber(sVNRepository, SvnTarget.fromURL(sVNURL, sVNRevision), sVNRevision, null);
        return structure.lng(SvnRepositoryAccess$RevisionsPair.revNumber);
    }

    private SVNURL getURL(File file) {
        return (SVNURL)this.getRepositoryAccess().getURLFromPath(SvnTarget.fromFile(file), SVNRevision.UNDEFINED, null).get(SvnRepositoryAccess$UrlInfo.url);
    }

    protected SVNRepository createRepository(SVNURL sVNURL, File file, boolean bl2) {
        return this.getRepositoryAccess().createRepository(sVNURL, null, bl2);
    }

    private static ISVNDiffStatusHandler createHandlerForReceiver(ISvnObjectReceiver iSvnObjectReceiver) {
        return new SvnNgDiffSummarize$2(iSvnObjectReceiver);
    }

    @Override
    protected SvnNgRepositoryAccess getRepositoryAccess() {
        if (this.repositoryAccess == null) {
            this.repositoryAccess = new SvnNgRepositoryAccess(this.getOperation(), this.getWcContext());
        }
        return this.repositoryAccess;
    }
}

