/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb$Mode;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$NodePresence;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$SVNWCNodeReposInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbLock;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo$BaseInfoField;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb$DirParsedInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeOriginInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbReader;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbReader$ReplaceInfo;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgCommitUtil$1;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgCommitUtil$CommitStatusWalker;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgCommitUtil$ISvnUrlKindCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgCommitUtil$NodeCommitStatus;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc2.ISvnCommitParameters;
import org.tmatesoft.svn.core.wc2.SvnCommitItem;
import org.tmatesoft.svn.core.wc2.SvnCommitPacket;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgCommitUtil {
    public static SvnCommitPacket harvestCopyCommitables(SVNWCContext sVNWCContext, File file, SVNURL sVNURL, SvnCommitPacket svnCommitPacket, SvnNgCommitUtil$ISvnUrlKindCallback svnNgCommitUtil$ISvnUrlKindCallback, ISvnCommitParameters iSvnCommitParameters, Map map) {
        SVNWCContext$SVNWCNodeReposInfo sVNWCContext$SVNWCNodeReposInfo = sVNWCContext.getNodeReposInfo(file);
        File file2 = new File(SVNURLUtil.getRelativeURL(sVNWCContext$SVNWCNodeReposInfo.reposRootUrl, sVNURL, false));
        SvnNgCommitUtil.harvestCommittables(sVNWCContext, file, svnCommitPacket, null, sVNWCContext$SVNWCNodeReposInfo.reposRootUrl, file2, true, SVNDepth.INFINITY, false, null, null, false, false, svnNgCommitUtil$ISvnUrlKindCallback, iSvnCommitParameters, map, sVNWCContext.getEventHandler());
        return svnCommitPacket;
    }

    public static SvnCommitPacket harvestCommittables(SVNWCContext sVNWCContext, SvnCommitPacket svnCommitPacket, Map map, File file, Collection collection, int n2, SVNDepth sVNDepth, boolean bl2, Collection collection2, SvnNgCommitUtil$ISvnUrlKindCallback svnNgCommitUtil$ISvnUrlKindCallback, ISvnCommitParameters iSvnCommitParameters, Map map2) {
        Object object;
        Serializable serializable;
        File file2;
        HashMap<File, File> hashMap = new HashMap<File, File>();
        int n3 = -1;
        for (Object object2 : collection) {
            Object object3;
            ++n3;
            file2 = SVNFileUtil.createFilePath(file, (String)object2);
            serializable = sVNWCContext.readKind(file2, true, true);
            if (serializable == SVNNodeKind.NONE) {
                try {
                    object = sVNWCContext.getDb().readInfo(file2, StructureFields$NodeInfo.status);
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                        object3 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not under version control", (Object)file2);
                        SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
                    }
                    throw sVNException;
                }
                object = sVNWCContext.getTreeConflict(file2);
                if (object != null) {
                    object3 = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in conflict", (Object)file2);
                    SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
                } else {
                    object3 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not under version control", (Object)file2);
                    SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
                }
            }
            try {
                object3 = sVNWCContext.getNodeReposInfo(file2);
                object = ((SVNWCContext$SVNWCNodeReposInfo)object3).reposRootUrl;
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                    throw sVNException;
                }
                object = null;
            }
            boolean bl3 = sVNWCContext.isNodeAdded(file2);
            if (bl3) {
                Object object4;
                File file3 = SVNFileUtil.getParentFile(file2);
                try {
                    boolean bl4 = sVNWCContext.isNodeAdded(file3);
                    if (bl4) {
                        object4 = sVNWCContext.getNodeOrigin(file3, false, StructureFields$NodeOriginInfo.copyRootAbsPath, StructureFields$NodeOriginInfo.isCopy);
                        if (((Structure)object4).is(StructureFields$NodeOriginInfo.isCopy)) {
                            file3 = (File)((Structure)object4).get(StructureFields$NodeOriginInfo.copyRootAbsPath);
                        }
                        ((Structure)object4).release();
                        hashMap.put(file3, file2);
                    }
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                        object4 = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "''{0}'' is scheduled for addition within unversioned parent", (Object)file2);
                        SVNErrorManager.error((SVNErrorMessage)object4, SVNLogType.WC);
                    }
                    throw sVNException;
                }
            }
            SvnNgCommitUtil.bailOnTreeConflictedAncestor(sVNWCContext, file2);
            if (n3 == n2) {
                sVNDepth = SVNDepth.EMPTY;
            }
            SvnNgCommitUtil.harvestCommittables(sVNWCContext, file2, svnCommitPacket, map, (SVNURL)object, null, false, sVNDepth, bl2, collection2, hashMap, false, false, svnNgCommitUtil$ISvnUrlKindCallback, iSvnCommitParameters, map2, sVNWCContext.getEventHandler());
        }
        for (Object object2 : svnCommitPacket.getRepositoryRoots()) {
            SvnNgCommitUtil.handleDescendants(sVNWCContext, svnCommitPacket, (SVNURL)object2, new ArrayList(svnCommitPacket.getItems((SVNURL)object2)), svnNgCommitUtil$ISvnUrlKindCallback, sVNWCContext.getEventHandler());
        }
        for (Object object2 : hashMap.keySet()) {
            if (svnCommitPacket.hasItem((File)object2)) continue;
            file2 = (File)hashMap.get(object2);
            serializable = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not known to exist in the repository and is not part of the commit, yet its child ''{1}'' is part of the commit", ((File)object2).getAbsolutePath(), file2.getAbsolutePath());
            object = sVNWCContext.getEventHandler();
            if (object != null) {
                SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file2, SVNNodeKind.UNKNOWN, null, -1L, SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN, SVNStatusType.LOCK_UNKNOWN, SVNEventAction.FAILED_NO_PARENT, SVNEventAction.FAILED_NO_PARENT, (SVNErrorMessage)serializable, null);
                object.handleEvent(sVNEvent, -1.0);
            }
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        return svnCommitPacket;
    }

    private static void handleDescendants(SVNWCContext sVNWCContext, SvnCommitPacket svnCommitPacket, SVNURL sVNURL, Collection collection, SvnNgCommitUtil$ISvnUrlKindCallback svnNgCommitUtil$ISvnUrlKindCallback, ISVNEventHandler iSVNEventHandler) {
        for (SvnCommitItem svnCommitItem : collection) {
            if (!svnCommitItem.hasFlag(1) || svnCommitItem.getCopyFromUrl() == null) continue;
            if (iSVNEventHandler != null) {
                iSVNEventHandler.checkCancelled();
            }
            Collection collection2 = SvnWcDbReader.getNotPresentDescendants((SVNWCDb)sVNWCContext.getDb(), svnCommitItem.getPath());
            for (File file : collection2) {
                Object object2;
                boolean bl2 = false;
                File file2 = SVNFileUtil.createFilePath(svnCommitItem.getPath(), file);
                for (Object object2 : collection) {
                    if (!((SvnCommitItem)object2).getPath().equals(file2)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                SVNURL sVNURL2 = SVNWCUtils.join(svnCommitItem.getCopyFromUrl(), file);
                object2 = SVNNodeKind.UNKNOWN;
                if (svnNgCommitUtil$ISvnUrlKindCallback != null && (object2 = svnNgCommitUtil$ISvnUrlKindCallback.getUrlKind(sVNURL2, svnCommitItem.getCopyFromRevision())) == SVNNodeKind.NONE) continue;
                svnCommitPacket.addItem(file2, sVNURL, (SVNNodeKind)object2, SVNWCUtils.join(svnCommitItem.getUrl(), file), -1L, null, -1L, 2);
            }
        }
    }

    public static void harvestCommittables(SVNWCContext sVNWCContext, File file, SvnCommitPacket svnCommitPacket, Map map, SVNURL sVNURL, File file2, boolean bl2, SVNDepth sVNDepth, boolean bl3, Collection collection, Map map2, boolean bl4, boolean bl5, SvnNgCommitUtil$ISvnUrlKindCallback svnNgCommitUtil$ISvnUrlKindCallback, ISvnCommitParameters iSvnCommitParameters, Map map3, ISVNEventHandler iSVNEventHandler) {
        SvnNgCommitUtil$CommitStatusWalker svnNgCommitUtil$CommitStatusWalker = new SvnNgCommitUtil$CommitStatusWalker(null);
        svnNgCommitUtil$CommitStatusWalker.rootAbsPath = file;
        svnNgCommitUtil$CommitStatusWalker.committables = svnCommitPacket;
        svnNgCommitUtil$CommitStatusWalker.lockTokens = map;
        svnNgCommitUtil$CommitStatusWalker.commitRelPath = file2;
        svnNgCommitUtil$CommitStatusWalker.depth = sVNDepth;
        svnNgCommitUtil$CommitStatusWalker.justLocked = bl3;
        svnNgCommitUtil$CommitStatusWalker.changeLists = collection;
        svnNgCommitUtil$CommitStatusWalker.danglers = map2;
        svnNgCommitUtil$CommitStatusWalker.checkUrlCallback = svnNgCommitUtil$ISvnUrlKindCallback;
        svnNgCommitUtil$CommitStatusWalker.context = sVNWCContext;
        svnNgCommitUtil$CommitStatusWalker.eventHandler = iSVNEventHandler;
        svnNgCommitUtil$CommitStatusWalker.externalsStorage = map3;
        SVNStatusEditor17 sVNStatusEditor17 = new SVNStatusEditor17(file, sVNWCContext, sVNWCContext.getOptions(), false, file2 != null, sVNDepth, svnNgCommitUtil$CommitStatusWalker);
        sVNStatusEditor17.walkStatus(file, sVNDepth, file2 != null, false, false, null);
    }

    private static void harvestNotPresentForCopy(SVNWCContext sVNWCContext, File file, SvnCommitPacket svnCommitPacket, SVNURL sVNURL, File file2, SvnNgCommitUtil$ISvnUrlKindCallback svnNgCommitUtil$ISvnUrlKindCallback) {
        List list = sVNWCContext.getChildrenOfWorkingNode(file, true);
        for (File file3 : list) {
            SVNNodeKind sVNNodeKind;
            String string = SVNFileUtil.getFileName(file3);
            SVNWCContext$NodePresence sVNWCContext$NodePresence = sVNWCContext.getNodePresence(file3, false);
            if (!sVNWCContext$NodePresence.isNotPresent) continue;
            File file4 = file2 == null ? null : SVNFileUtil.createFilePath(file2, string);
            if (svnNgCommitUtil$ISvnUrlKindCallback != null) {
                Structure structure = sVNWCContext.getNodeOrigin(SVNFileUtil.getParentFile(file3), false, StructureFields$NodeOriginInfo.revision, StructureFields$NodeOriginInfo.reposRelpath, StructureFields$NodeOriginInfo.reposRootUrl);
                long l2 = structure.lng(StructureFields$NodeOriginInfo.revision);
                File file5 = (File)structure.get(StructureFields$NodeOriginInfo.reposRelpath);
                SVNURL sVNURL2 = (SVNURL)structure.get(StructureFields$NodeOriginInfo.reposRootUrl);
                SVNURL sVNURL3 = sVNURL2.appendPath(SVNFileUtil.getFilePath(file5), false).appendPath(SVNFileUtil.getFileName(file3), false);
                sVNNodeKind = svnNgCommitUtil$ISvnUrlKindCallback.getUrlKind(sVNURL3, l2);
                if (sVNNodeKind == SVNNodeKind.NONE) {
                    continue;
                }
            } else {
                sVNNodeKind = sVNWCContext.readKind(file3, true);
            }
            svnCommitPacket.addItem(file3, sVNNodeKind, sVNURL, SVNFileUtil.getFilePath(file4), -1L, null, -1L, null, 2);
        }
    }

    private static Structure getNodeCommitStatus(SVNWCContext sVNWCContext, File file) {
        Object object;
        Structure structure = Structure.obtain(SvnNgCommitUtil$NodeCommitStatus.class);
        Structure structure2 = sVNWCContext.getDb().readInfo(file, StructureFields$NodeInfo.status, StructureFields$NodeInfo.kind, StructureFields$NodeInfo.revision, StructureFields$NodeInfo.reposRelPath, StructureFields$NodeInfo.originalRevision, StructureFields$NodeInfo.originalReposRelpath, StructureFields$NodeInfo.lock, StructureFields$NodeInfo.changelist, StructureFields$NodeInfo.conflicted, StructureFields$NodeInfo.opRoot, StructureFields$NodeInfo.hadProps, StructureFields$NodeInfo.propsMod, StructureFields$NodeInfo.haveBase, StructureFields$NodeInfo.haveMoreWork);
        if (structure2.get(StructureFields$NodeInfo.kind) == ISVNWCDb$SVNWCDbKind.File) {
            structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.kind, SVNNodeKind.FILE);
        } else if (structure2.get(StructureFields$NodeInfo.kind) == ISVNWCDb$SVNWCDbKind.Dir) {
            structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.kind, SVNNodeKind.DIR);
        } else {
            structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.kind, SVNNodeKind.UNKNOWN);
        }
        structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.reposRelPath, structure2.get(StructureFields$NodeInfo.reposRelPath));
        structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.revision, structure2.lng(StructureFields$NodeInfo.revision));
        structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.originalReposRelPath, structure2.get(StructureFields$NodeInfo.originalReposRelpath));
        structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.originalRevision, structure2.lng(StructureFields$NodeInfo.originalRevision));
        structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.changelist, structure2.get(StructureFields$NodeInfo.changelist));
        structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.propsMod, structure2.is(StructureFields$NodeInfo.propsMod));
        ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus = (ISVNWCDb$SVNWCDbStatus)((Object)structure2.get(StructureFields$NodeInfo.status));
        structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.added, iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Added);
        structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.deleted, iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Deleted);
        structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.notPresent, iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.NotPresent);
        structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.excluded, iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Excluded);
        structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.isOpRoot, structure2.is(StructureFields$NodeInfo.opRoot));
        structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.conflicted, structure2.is(StructureFields$NodeInfo.conflicted));
        if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Added && structure2.is(StructureFields$NodeInfo.opRoot) && (structure2.is(StructureFields$NodeInfo.haveBase) || structure2.is(StructureFields$NodeInfo.haveMoreWork))) {
            object = SvnWcDbReader.readNodeReplaceInfo((SVNWCDb)sVNWCContext.getDb(), file, SvnWcDbReader$ReplaceInfo.replaceRoot);
            structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.isReplaceRoot, ((Structure)object).is(SvnWcDbReader$ReplaceInfo.replaceRoot));
            ((Structure)object).release();
        } else {
            structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.isReplaceRoot, false);
        }
        if (structure2.get(StructureFields$NodeInfo.kind) == ISVNWCDb$SVNWCDbKind.File && (structure2.is(StructureFields$NodeInfo.hadProps) || structure2.is(StructureFields$NodeInfo.propsMod))) {
            object = sVNWCContext.getDb().readProperties(file);
            structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.symlink, ((SVNProperties)object).getStringValue("svn:special") != null);
        } else {
            structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.symlink, false);
        }
        if (structure2.is(StructureFields$NodeInfo.haveBase) && (structure2.lng(StructureFields$NodeInfo.revision) < 0L || iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Normal)) {
            object = sVNWCContext.getDb().getBaseInfo(file, ISVNWCDb$WCDbBaseInfo$BaseInfoField.revision, ISVNWCDb$WCDbBaseInfo$BaseInfoField.updateRoot);
            structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.revision, ((ISVNWCDb$WCDbBaseInfo)object).revision);
            structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.updateRoot, ((ISVNWCDb$WCDbBaseInfo)object).updateRoot);
        } else {
            structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.updateRoot, false);
        }
        object = (ISVNWCDb$SVNWCDbLock)structure2.get(StructureFields$NodeInfo.lock);
        structure.set((Enum)SvnNgCommitUtil$NodeCommitStatus.lockToken, object != null ? ((ISVNWCDb$SVNWCDbLock)object).token : null);
        structure2.release();
        return structure;
    }

    private static void bailOnTreeConflictedChildren(SVNWCContext sVNWCContext, File file, SVNNodeKind sVNNodeKind, SVNDepth sVNDepth, Collection collection) {
        if (sVNDepth == SVNDepth.EMPTY || sVNNodeKind != SVNNodeKind.DIR) {
            return;
        }
        Map map = sVNWCContext.getDb().opReadAllTreeConflicts(file);
        if (map == null || map.isEmpty()) {
            return;
        }
        for (SVNTreeConflictDescription sVNTreeConflictDescription : map.values()) {
            if (sVNTreeConflictDescription.getNodeKind() == SVNNodeKind.DIR && sVNDepth == SVNDepth.FILES || !sVNWCContext.isChangelistMatch(file, collection)) continue;
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in conflict", (Object)sVNTreeConflictDescription.getPath());
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
    }

    private static void collectLocks(SVNWCContext sVNWCContext, File file, Map map) {
        SvnNgCommitUtil$1 svnNgCommitUtil$1 = new SvnNgCommitUtil$1(sVNWCContext, map);
        sVNWCContext.nodeWalkChildren(file, svnNgCommitUtil$1, false, SVNDepth.INFINITY, null);
    }

    private static void bailOnTreeConflictedAncestor(SVNWCContext sVNWCContext, File file) {
        SVNWCDb$DirParsedInfo sVNWCDb$DirParsedInfo = ((SVNWCDb)sVNWCContext.getDb()).parseDir(file, SVNSqlJetDb$Mode.ReadOnly);
        SVNWCDbRoot sVNWCDbRoot = sVNWCDb$DirParsedInfo.wcDbDir.getWCRoot();
        File file2 = SVNFileUtil.getFileDir(file);
        while (SVNPathUtil.isAncestor(SVNFileUtil.getFilePath(sVNWCDbRoot.getAbsPath()), SVNFileUtil.getFilePath(file2))) {
            boolean bl2 = sVNWCContext.getConflicted((File)file2, (boolean)false, (boolean)false, (boolean)true).treeConflicted;
            if (bl2) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in tree-conflict", (Object)file2);
                ISVNEventHandler iSVNEventHandler = sVNWCContext.getEventHandler();
                if (iSVNEventHandler != null) {
                    SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file2, SVNNodeKind.UNKNOWN, null, -1L, SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN, SVNStatusType.LOCK_UNKNOWN, SVNEventAction.FAILED_CONFLICT, SVNEventAction.FAILED_CONFLICT, sVNErrorMessage, null);
                    iSVNEventHandler.handleEvent(sVNEvent, -1.0);
                }
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                return;
            }
            if (file2.getParentFile() == null || file2.getParentFile().equals(file2)) break;
            file2 = SVNFileUtil.getFileDir(file2);
        }
    }

    public static SVNURL translateCommitables(Collection collection, Map map) {
        Object object;
        Object object22;
        HashMap<SVNURL, Object> hashMap = new HashMap<SVNURL, Object>();
        for (Object object22 : collection) {
            if (hashMap.containsKey(((SvnCommitItem)object22).getUrl())) {
                object = (SvnCommitItem)hashMap.get(((SvnCommitItem)object22).getUrl());
                Object object3 = SVNErrorMessage.create(SVNErrorCode.CLIENT_DUPLICATE_COMMIT_URL, "Cannot commit both ''{0}'' and ''{1}'' as they refer to the same URL", ((SvnCommitItem)object22).getPath(), ((SvnCommitItem)object).getPath());
                SVNErrorManager.error((SVNErrorMessage)object3, SVNLogType.WC);
            }
            hashMap.put(((SvnCommitItem)object22).getUrl(), object22);
        }
        Iterator<Object> iterator = hashMap.keySet().iterator();
        object22 = (SVNURL)iterator.next();
        while (iterator.hasNext()) {
            object = (SVNURL)iterator.next();
            object22 = SVNURLUtil.getCommonURLAncestor((SVNURL)object22, (SVNURL)object);
        }
        if (hashMap.containsKey(object22)) {
            object = (SvnCommitItem)hashMap.get(object22);
            if (((SvnCommitItem)object).getKind() != SVNNodeKind.DIR) {
                object22 = ((SVNURL)object22).removePathTail();
            } else if (((SvnCommitItem)object).getKind() == SVNNodeKind.DIR && (((SvnCommitItem)object).hasFlag(1) || ((SvnCommitItem)object).hasFlag(2) || ((SvnCommitItem)object).hasFlag(16) || ((SvnCommitItem)object).hasFlag(32))) {
                object22 = ((SVNURL)object22).removePathTail();
            }
        }
        if (object22 == null) {
            object = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Cannot compute base URL for commit operation");
            SVNErrorManager.error(object, SVNLogType.WC);
        }
        for (Object object3 : hashMap.keySet()) {
            SvnCommitItem svnCommitItem = (SvnCommitItem)hashMap.get(object3);
            String string = ((SVNURL)object3).equals(object22) ? "" : SVNPathUtil.getRelativePath(((SVNURL)object22).getPath(), ((SVNURL)object3).getPath());
            map.put(string, svnCommitItem);
        }
        return object22;
    }

    public static Map translateLockTokens(Map map, SVNURL sVNURL) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (SVNURL sVNURL2 : map.keySet()) {
            if (!SVNURLUtil.isAncestor(sVNURL, sVNURL2)) continue;
            String string = (String)map.get(sVNURL2);
            String string2 = sVNURL2.getPath().substring(sVNURL.getPath().length());
            if (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            treeMap.put(string2, string);
        }
        return treeMap;
    }

    static /* synthetic */ Structure access$100(SVNWCContext sVNWCContext, File file) {
        return SvnNgCommitUtil.getNodeCommitStatus(sVNWCContext, file);
    }

    static /* synthetic */ void access$200(SVNWCContext sVNWCContext, File file, SvnCommitPacket svnCommitPacket, SVNURL sVNURL, File file2, SvnNgCommitUtil$ISvnUrlKindCallback svnNgCommitUtil$ISvnUrlKindCallback) {
        SvnNgCommitUtil.harvestNotPresentForCopy(sVNWCContext, file, svnCommitPacket, sVNURL, file2, svnNgCommitUtil$ISvnUrlKindCallback);
    }
}

