/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc17.SVNCommitMediator17;
import org.tmatesoft.svn.core.internal.wc17.SVNCommitter17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$CommittableExternalInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$NodeMovedAway;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$NodeMovedHere;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeInfo;
import org.tmatesoft.svn.core.internal.wc2.ISvnCommitRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgCommit$SvnCommittedQueue;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgCommit$SvnCommittedQueueItem;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgCommitUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgCommitUtil$ISvnUrlKindCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnCommit;
import org.tmatesoft.svn.core.wc2.SvnCommitItem;
import org.tmatesoft.svn.core.wc2.SvnCommitPacket;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgCommit
extends SvnNgOperationRunner
implements ISvnCommitRunner,
SvnNgCommitUtil$ISvnUrlKindCallback {
    @Override
    public SvnCommitPacket collectCommitItems(SvnCommit svnCommit) {
        Object object2;
        int n2 = -1;
        this.setOperation(svnCommit);
        SvnCommitPacket svnCommitPacket = new SvnCommitPacket();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = new String[((SvnCommit)this.getOperation()).getTargets().size()];
        int n3 = 0;
        for (Object object2 : ((SvnCommit)this.getOperation()).getTargets()) {
            stringArray[n3] = ((SvnTarget)object2).getFile().getAbsolutePath();
            stringArray[n3] = stringArray[n3].replace(File.separatorChar, '/');
            ++n3;
        }
        String string = SVNPathUtil.condencePaths(stringArray, arrayList, false);
        if (string == null) {
            return svnCommitPacket;
        }
        object2 = new File(string).getAbsoluteFile();
        if (arrayList.isEmpty()) {
            arrayList.add("");
        }
        if (((SvnCommit)this.getOperation()).isIncludeFileExternals() || ((SvnCommit)this.getOperation()).isIncludeDirectoryExternals()) {
            if (((SvnCommit)this.getOperation()).getDepth() != SVNDepth.UNKNOWN && ((SvnCommit)this.getOperation()).getDepth() != SVNDepth.INFINITY) {
                n2 = arrayList.size();
            }
            this.appendExternalsAsExplicitTargets(arrayList, (File)object2, ((SvnCommit)this.getOperation()).isIncludeFileExternals(), ((SvnCommit)this.getOperation()).isIncludeDirectoryExternals(), ((SvnCommit)this.getOperation()).getDepth(), this.getWcContext());
        }
        Collection collection = this.determineLockTargets((File)object2, arrayList);
        HashSet<File> hashSet = new HashSet<File>();
        try {
            for (Serializable serializable : collection) {
                File file = this.getWcContext().acquireWriteLock((File)serializable, false, true);
                hashSet.add(file);
            }
            svnCommitPacket.setLockingContext(this, hashSet);
            HashMap hashMap = new HashMap();
            SvnNgCommitUtil.harvestCommittables(this.getWcContext(), svnCommitPacket, hashMap, (File)object2, arrayList, n2, ((SvnCommit)this.getOperation()).getDepth(), !((SvnCommit)this.getOperation()).isKeepLocks(), ((SvnCommit)this.getOperation()).getApplicableChangelists(), this, ((SvnCommit)this.getOperation()).getCommitParameters(), null);
            svnCommitPacket.setLockTokens(hashMap);
            if (((SvnCommit)this.getOperation()).isFailOnMultipleRepositories() && svnCommitPacket.getRepositoryRoots().size() > 1) {
                Serializable serializable;
                serializable = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Commit can only commit to a single repository at a time.\nAre all targets part of the same working copy?");
                SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
            }
            if (!svnCommitPacket.isEmpty()) {
                return svnCommitPacket;
            }
            svnCommitPacket.dispose();
            return new SvnCommitPacket();
        }
        catch (SVNException sVNException) {
            svnCommitPacket.dispose();
            SVNErrorMessage sVNErrorMessage = sVNException.getErrorMessage().wrap("Commit failed (details follow):");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            return null;
        }
    }

    private void appendExternalsAsExplicitTargets(Collection collection, File file, boolean bl2, boolean bl3, SVNDepth sVNDepth, SVNWCContext sVNWCContext) {
        if (!bl2 && !bl3) {
            return;
        }
        if (sVNDepth == SVNDepth.EMPTY) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : collection) {
            File file2 = SVNFileUtil.createFilePath(file, string);
            List list = sVNWCContext.committableExternalsBelow(null, file2, sVNDepth);
            if (list == null) continue;
            for (SVNWCContext$CommittableExternalInfo sVNWCContext$CommittableExternalInfo : list) {
                if (sVNWCContext$CommittableExternalInfo.kind == SVNNodeKind.FILE && !bl2 || sVNWCContext$CommittableExternalInfo.kind == SVNNodeKind.DIR && !bl3) continue;
                File file3 = SVNFileUtil.skipAncestor(file, sVNWCContext$CommittableExternalInfo.localAbsPath);
                assert (file3 != null && SVNFileUtil.getFilePath(file3).length() != 0);
                arrayList.add(SVNFileUtil.getFilePath(file3));
            }
        }
        collection.addAll(arrayList);
    }

    @Override
    protected SVNCommitInfo run(SVNWCContext sVNWCContext) {
        SvnCommitPacket[] svnCommitPacketArray = ((SvnCommit)this.getOperation()).splitCommitPackets(((SvnCommit)this.getOperation()).isCombinePackets());
        SVNCommitInfo sVNCommitInfo = SVNCommitInfo.NULL;
        for (int i2 = 0; i2 < svnCommitPacketArray.length; ++i2) {
            if (svnCommitPacketArray[i2] == null || svnCommitPacketArray[i2].isEmpty()) continue;
            svnCommitPacketArray[i2] = svnCommitPacketArray[i2].removeSkippedItems();
            SVNURL sVNURL = (SVNURL)svnCommitPacketArray[i2].getRepositoryRoots().iterator().next();
            sVNCommitInfo = this.doRun(sVNWCContext, svnCommitPacketArray[i2]);
            if (sVNCommitInfo == null) continue;
            ((SvnCommit)this.getOperation()).receive(SvnTarget.fromURL(sVNURL), sVNCommitInfo);
        }
        return sVNCommitInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SVNCommitInfo doRun(SVNWCContext sVNWCContext, SvnCommitPacket svnCommitPacket) {
        SVNProperties sVNProperties = ((SvnCommit)this.getOperation()).getRevisionProperties();
        SVNPropertiesManager.validateRevisionProperties(sVNProperties);
        SVNException sVNException = null;
        SVNCommitInfo sVNCommitInfo = null;
        try {
            Object object102;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            HashMap hashMap;
            Object object7;
            for (Object object8 : svnCommitPacket.getRepositoryRoots()) {
                object7 = svnCommitPacket.getItems((SVNURL)object8);
                for (SvnCommitItem object62 : object7) {
                    if (object62.hasFlag(64)) {
                        hashMap = sVNWCContext.nodeWasMovedHere(object62.getPath());
                        object4 = ((SVNWCContext$NodeMovedHere)((Object)hashMap)).movedFromAbsPath;
                        object3 = ((SVNWCContext$NodeMovedHere)((Object)hashMap)).deleteOpRootAbsPath;
                        if (object4 != null && object3 != null && ((File)object4).equals(object3)) {
                            boolean bl2;
                            boolean bl3 = bl2 = svnCommitPacket.getItem((File)object3) != null;
                            if (!bl2 && !((File)object3).equals(object2 = SVNFileUtil.getFileDir((File)object3)) && (object = sVNWCContext.getNodeDeletedAncestor((File)object2)) != null) {
                                boolean bl4 = bl2 = svnCommitPacket.getItem((File)object) != null;
                            }
                            if (!bl2) {
                                object2 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot commit ''{0}'' because it was moved from ''{1}'' which is not part of the commit; both sides of the move must be committed together", SVNFileUtil.getFilePath(object62.getPath()), SVNFileUtil.getFilePath((File)object3));
                                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
                            }
                        }
                    }
                    if (!object62.hasFlag(2)) continue;
                    hashMap = sVNWCContext.nodeWasMovedAway(object62.getPath());
                    object4 = ((SVNWCContext$NodeMovedAway)((Object)hashMap)).movedToAbsPath;
                    object3 = ((SVNWCContext$NodeMovedAway)((Object)hashMap)).opRootAbsPath;
                    if (object4 == null || object3 == null || !((File)object4).equals(object3) || svnCommitPacket.getItem((File)object3) != null) continue;
                    SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot commit ''{0}'' because it was moved to ''{1}'' which is not part of the commit; both sides of the move must be committed together", object62.getPath(), object3);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
            }
            Object object9 = ((SvnCommit)this.getOperation()).getCommitMessage();
            if (((SvnCommit)this.getOperation()).getCommitHandler() != null) {
                block41: {
                    Object object8;
                    object8 = new ArrayList();
                    for (Object object102 : svnCommitPacket.getRepositoryRoots()) {
                        object8.addAll(svnCommitPacket.getItems((SVNURL)object102));
                    }
                    object7 = object8.toArray(new SvnCommitItem[object8.size()]);
                    object9 = ((SvnCommit)this.getOperation()).getCommitHandler().getCommitMessage((String)object9, (SvnCommitItem[])object7);
                    if (object9 != null) break block41;
                    object102 = SVNCommitInfo.NULL;
                    return object102;
                }
                try {
                    sVNProperties = ((SvnCommit)this.getOperation()).getCommitHandler().getRevisionProperties((String)object9, (SvnCommitItem[])object7, sVNProperties);
                }
                catch (SVNException sVNException2) {
                    SVNErrorMessage sVNErrorMessage = sVNException2.getErrorMessage().wrap("Commit failed (details follow):");
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
            }
            object9 = object9 == null ? "" : SVNCommitUtil.validateCommitMessage((String)object9);
            boolean bl5 = ((SvnCommit)this.getOperation()).isKeepLocks();
            object7 = (SVNURL)svnCommitPacket.getRepositoryRoots().iterator().next();
            if (svnCommitPacket.isEmpty((SVNURL)object7)) {
                object102 = SVNCommitInfo.NULL;
                return object102;
            }
            object102 = new TreeMap();
            HashMap hashMap2 = new HashMap();
            hashMap = new HashMap();
            object4 = SvnNgCommitUtil.translateCommitables(svnCommitPacket.getItems((SVNURL)object7), (Map)object102);
            object3 = SvnNgCommitUtil.translateLockTokens(svnCommitPacket.getLockTokens(), (SVNURL)object4);
            SvnCommitItem svnCommitItem = (SvnCommitItem)svnCommitPacket.getItems((SVNURL)object7).iterator().next();
            object2 = this.getRepositoryAccess().createRepository((SVNURL)object4, svnCommitItem.getPath());
            object = new SVNCommitMediator17(sVNWCContext, (Map)object102);
            ISVNEditor iSVNEditor = null;
            try {
                iSVNEditor = ((SVNRepository)object2).getCommitEditor((String)object9, (Map)object3, bl5, sVNProperties, (ISVNWorkspaceMediator)object);
                SVNCommitter17 sVNException5 = new SVNCommitter17(sVNWCContext, (Map)object102, (SVNURL)object7, ((SVNCommitMediator17)object).getTmpFiles(), hashMap2, hashMap);
                SVNCommitUtil.driveCommitEditor(sVNException5, object102.keySet(), iSVNEditor, -1L);
                sVNException5.sendTextDeltas(iSVNEditor);
                SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(null, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.COMMIT_FINALIZING, SVNEventAction.COMMIT_FINALIZING, null, null);
                sVNEvent.setURL((SVNURL)object4);
                this.handleEvent(sVNEvent);
                sVNCommitInfo = iSVNEditor.closeEdit();
                iSVNEditor = null;
                if (sVNCommitInfo.getErrorMessage() == null || sVNCommitInfo.getErrorMessage().getErrorCode() == SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED) {
                    SvnNgCommit$SvnCommittedQueue svnNgCommit$SvnCommittedQueue = new SvnNgCommit$SvnCommittedQueue(null);
                    try {
                        for (SvnCommitItem svnCommitItem2 : svnCommitPacket.getItems((SVNURL)object7)) {
                            this.postProcessCommitItem(svnNgCommit$SvnCommittedQueue, svnCommitItem2, ((SvnCommit)this.getOperation()).isKeepChangelists(), ((SvnCommit)this.getOperation()).isKeepLocks(), (SvnChecksum)hashMap.get(svnCommitItem2.getPath()));
                        }
                        this.processCommittedQueue(svnNgCommit$SvnCommittedQueue, sVNCommitInfo.getNewRevision(), sVNCommitInfo.getDate(), sVNCommitInfo.getAuthor());
                        this.deleteDeleteFiles(sVNException5, ((SvnCommit)this.getOperation()).getCommitParameters());
                    }
                    catch (SVNException sVNException2) {
                        sVNException = sVNException2;
                        throw sVNException2;
                    }
                    finally {
                        if (svnCommitPacket.isLastPacket()) {
                            this.sleepForTimestamp();
                        }
                    }
                }
                this.handleEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, sVNCommitInfo.getNewRevision(), SVNEventAction.COMMIT_COMPLETED, SVNEventAction.COMMIT_COMPLETED, null, null, -1L, -1L));
            }
            catch (SVNException sVNException3) {
                if (sVNException3 instanceof SVNCancelException) {
                    throw sVNException3;
                }
                Serializable serializable = sVNException3.getErrorMessage().wrap("Commit failed (details follow):");
                sVNCommitInfo = new SVNCommitInfo(-1L, null, null, (SVNErrorMessage)serializable);
                this.handleEvent(SVNEventFactory.createErrorEvent(serializable, SVNEventAction.COMMIT_COMPLETED), -1.0);
                if (svnCommitPacket.getRepositoryRoots().size() == 1) {
                    SVNErrorManager.error(serializable, SVNLogType.WC);
                }
            }
            finally {
                if (iSVNEditor != null) {
                    try {
                        iSVNEditor.abortEdit();
                    }
                    catch (SVNException sVNException4) {
                        SVNDebugLog.getDefaultLog().log(SVNLogType.CLIENT, sVNException4, Level.WARNING);
                    }
                }
                for (Serializable serializable : ((SVNCommitMediator17)object).getTmpFiles()) {
                    SVNFileUtil.deleteFile((File)serializable);
                }
            }
        }
        finally {
            if (sVNException == null) {
                svnCommitPacket.dispose();
            }
        }
        return sVNCommitInfo;
    }

    private void postProcessCommitItem(SvnNgCommit$SvnCommittedQueue svnNgCommit$SvnCommittedQueue, SvnCommitItem svnCommitItem, boolean bl2, boolean bl3, SvnChecksum svnChecksum) {
        boolean bl4 = !bl3 && svnCommitItem.hasFlag(32);
        Map map = svnCommitItem.getIncomingProperties();
        SVNProperties sVNProperties = null;
        if (map != null) {
            try {
                sVNProperties = this.getWcContext().getDb().getBaseDavCache(svnCommitItem.getPath());
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
            if (sVNProperties == null) {
                sVNProperties = new SVNProperties();
            }
            for (String string : map.keySet()) {
                SVNPropertyValue sVNPropertyValue = (SVNPropertyValue)map.get(string);
                if (sVNPropertyValue == null) {
                    sVNProperties.remove(string);
                    continue;
                }
                sVNProperties.put(string, sVNPropertyValue);
            }
        }
        boolean bl5 = svnCommitItem.getFlags() == 32 && map == null;
        this.queueCommitted(svnNgCommit$SvnCommittedQueue, svnCommitItem.getPath(), false, sVNProperties, bl5, bl4, !bl2, svnChecksum);
    }

    @Override
    public SVNNodeKind getUrlKind(SVNURL sVNURL, long l2) {
        return this.getRepositoryAccess().createRepository(sVNURL, null).checkPath("", l2);
    }

    private Collection determineLockTargets(File file, Collection collection) {
        Object object;
        HashMap<Object, HashSet<File>> hashMap = new HashMap<Object, HashSet<File>>();
        for (Object object2 : collection) {
            File file2 = SVNFileUtil.createFilePath(file, (String)object2);
            object = null;
            try {
                object = this.getWcContext().getDb().getWCRoot(file2);
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) continue;
                throw sVNException;
            }
            HashSet<File> hashSet = (HashSet<File>)hashMap.get(object);
            if (hashSet == null) {
                hashSet = new HashSet<File>();
                hashMap.put(object, hashSet);
            }
            hashSet.add(file2);
        }
        HashSet hashSet = new HashSet();
        for (File file2 : hashMap.keySet()) {
            object = (Collection)hashMap.get(file2);
            if (object.size() == 1) {
                if (file2.equals(object.iterator().next())) {
                    hashSet.add(file2);
                    continue;
                }
                hashSet.add(SVNFileUtil.getParentFile((File)object.iterator().next()));
                continue;
            }
            if (object.size() <= 1) continue;
            hashSet.add(file2);
        }
        return hashSet;
    }

    @Override
    public Object splitLockingContext(Object object, SvnCommitPacket svnCommitPacket) {
        if (!(object instanceof Collection)) {
            return object;
        }
        Collection collection = (Collection)object;
        ArrayList<File> arrayList = new ArrayList<File>();
        for (SVNURL sVNURL : svnCommitPacket.getRepositoryRoots()) {
            block1: for (SvnCommitItem svnCommitItem : svnCommitPacket.getItems(sVNURL)) {
                File file = svnCommitItem.getPath();
                for (File file2 : collection) {
                    if (!file.equals(file2) && (!file.isFile() || !file.getParentFile().equals(file2))) continue;
                    arrayList.add(file2);
                    continue block1;
                }
            }
        }
        return arrayList;
    }

    @Override
    public void disposeCommitPacket(Object object, boolean bl2) {
        if (!(object instanceof Collection)) {
            if (bl2) {
                this.getWcContext().close();
            }
            return;
        }
        if (bl2) {
            Collection collection = (Collection)object;
            for (File file : collection) {
                try {
                    this.getWcContext().releaseWriteLock(file);
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) continue;
                    throw sVNException;
                }
            }
            this.getWcContext().close();
        }
    }

    private void queueCommitted(SvnNgCommit$SvnCommittedQueue svnNgCommit$SvnCommittedQueue, File file, boolean bl2, SVNProperties sVNProperties, boolean bl3, boolean bl4, boolean bl5, SvnChecksum svnChecksum) {
        SvnNgCommit$SvnCommittedQueueItem svnNgCommit$SvnCommittedQueueItem = new SvnNgCommit$SvnCommittedQueueItem(null);
        svnNgCommit$SvnCommittedQueueItem.localAbspath = file;
        svnNgCommit$SvnCommittedQueueItem.recurse = bl2;
        svnNgCommit$SvnCommittedQueueItem.noUnlock = !bl4;
        svnNgCommit$SvnCommittedQueueItem.keepChangelist = !bl5;
        svnNgCommit$SvnCommittedQueueItem.sha1Checksum = svnChecksum;
        svnNgCommit$SvnCommittedQueueItem.newDavCache = sVNProperties;
        svnNgCommit$SvnCommittedQueueItem.unlockOnly = bl3;
        svnNgCommit$SvnCommittedQueue.queue.put(file, svnNgCommit$SvnCommittedQueueItem);
    }

    private void processCommittedQueue(SvnNgCommit$SvnCommittedQueue svnNgCommit$SvnCommittedQueue, long l2, Date date, String string) {
        Object object;
        HashMap hashMap = new HashMap();
        for (Object object2 : svnNgCommit$SvnCommittedQueue.queue.values()) {
            object = this.getWcContext().getDb().getWCRoot(((SvnNgCommit$SvnCommittedQueueItem)object2).localAbspath);
            if (!hashMap.containsKey(object)) {
                hashMap.put((File)object, new ArrayList());
            }
            ((Collection)hashMap.get(object)).add(object2);
        }
        svnNgCommit$SvnCommittedQueue.queue.clear();
        for (Object object2 : hashMap.keySet()) {
            object = this.getWcContext().getDb().getSDb((File)object2);
            ((SVNSqlJetDb)object).beginTransaction(SqlJetTransactionMode.WRITE);
            try {
                for (SvnNgCommit$SvnCommittedQueueItem svnNgCommit$SvnCommittedQueueItem : (Collection)hashMap.get(object2)) {
                    this.processCommittedInternal(svnNgCommit$SvnCommittedQueueItem.localAbspath, svnNgCommit$SvnCommittedQueueItem.recurse, true, l2, new SVNDate(date.getTime(), 0), string, svnNgCommit$SvnCommittedQueueItem.newDavCache, svnNgCommit$SvnCommittedQueueItem.unlockOnly, svnNgCommit$SvnCommittedQueueItem.noUnlock, svnNgCommit$SvnCommittedQueueItem.keepChangelist, svnNgCommit$SvnCommittedQueueItem.sha1Checksum, svnNgCommit$SvnCommittedQueue);
                }
                this.getWcContext().wqRun((File)object2);
            }
            catch (SVNException sVNException) {
                ((SVNSqlJetDb)object).rollback();
                throw sVNException;
            }
            finally {
                ((SVNSqlJetDb)object).commit();
            }
        }
    }

    private void processCommittedInternal(File file, boolean bl2, boolean bl3, long l2, SVNDate sVNDate, String string, SVNProperties sVNProperties, boolean bl4, boolean bl5, boolean bl6, SvnChecksum svnChecksum, SvnNgCommit$SvnCommittedQueue svnNgCommit$SvnCommittedQueue) {
        this.processCommittedLeaf(file, !bl3, l2, sVNDate, string, sVNProperties, bl4, bl5, bl6, svnChecksum);
    }

    private void processCommittedLeaf(File file, boolean bl2, long l2, SVNDate sVNDate, String string, SVNProperties sVNProperties, boolean bl3, boolean bl4, boolean bl5, SvnChecksum svnChecksum) {
        long l3 = l2;
        assert (SVNFileUtil.isAbsolute(file));
        Structure structure = this.getWcContext().getDb().readInfo(file, StructureFields$NodeInfo.status, StructureFields$NodeInfo.kind, StructureFields$NodeInfo.checksum, StructureFields$NodeInfo.hadProps, StructureFields$NodeInfo.propsMod, StructureFields$NodeInfo.haveBase, StructureFields$NodeInfo.haveWork);
        File file2 = structure.get(StructureFields$NodeInfo.kind) == ISVNWCDb$SVNWCDbKind.Dir ? file : SVNFileUtil.getFileDir(file);
        this.getWcContext().writeCheck(file2);
        if (structure.get(StructureFields$NodeInfo.status) == ISVNWCDb$SVNWCDbStatus.Deleted) {
            this.getWcContext().getDb().removeBase(file, false, false, true, !bl2 ? l2 : -1L, null, null);
            structure.release();
            return;
        }
        if (structure.get(StructureFields$NodeInfo.status) == ISVNWCDb$SVNWCDbStatus.NotPresent) {
            structure.release();
            return;
        }
        if (bl3) {
            if (!bl4) {
                this.getWcContext().getDb().removeLock(file);
            }
        } else {
            SVNSkel sVNSkel = null;
            ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind = (ISVNWCDb$SVNWCDbKind)((Object)structure.get(StructureFields$NodeInfo.kind));
            if (iSVNWCDb$SVNWCDbKind != ISVNWCDb$SVNWCDbKind.Dir) {
                if (svnChecksum == null) {
                    svnChecksum = (SvnChecksum)structure.get(StructureFields$NodeInfo.checksum);
                    if (bl2 && !structure.is(StructureFields$NodeInfo.propsMod)) {
                        Structure structure2 = this.getWcContext().getDb().readInfo(file, StructureFields$NodeInfo.changedRev, StructureFields$NodeInfo.changedDate, StructureFields$NodeInfo.changedAuthor);
                        l3 = structure2.lng(StructureFields$NodeInfo.changedRev);
                        sVNDate = (SVNDate)structure2.get(StructureFields$NodeInfo.changedDate);
                        string = (String)structure2.get(StructureFields$NodeInfo.changedAuthor);
                        structure2.release();
                    }
                }
                sVNSkel = this.getWcContext().wqBuildFileCommit(file, structure.is(StructureFields$NodeInfo.propsMod));
            }
            this.getWcContext().getDb().globalCommit(file, l2, l3, sVNDate, string, svnChecksum, null, sVNProperties, bl5, bl4, sVNSkel);
        }
    }
}

