/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbOpenMode;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbInfo$InfoField;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgCleanup$CleanupStatusWalk;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.wc2.SvnCleanup;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgCleanup
extends SvnNgOperationRunner {
    @Override
    protected Void run(SVNWCContext sVNWCContext) {
        SVNWCContext sVNWCContext2;
        Object object;
        Serializable serializable;
        if (((SvnCleanup)this.getOperation()).getFirstTarget().isURL()) {
            serializable = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not a local path", (Object)((SvnCleanup)this.getOperation()).getFirstTarget().getURL());
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        serializable = ((SvnCleanup)this.getOperation()).getFirstTarget().getFile().getAbsoluteFile();
        if (((SvnCleanup)this.getOperation()).isBreakLocks()) {
            object = new SVNWCDb();
            sVNWCContext2 = new SVNWCContext((ISVNWCDb)object, sVNWCContext.getEventHandler());
        } else {
            sVNWCContext2 = sVNWCContext;
        }
        object = sVNWCContext2.getOptions();
        String[] stringArray = object == null ? new String[]{} : object.getIgnorePatterns();
        this.doCleanup((File)serializable, sVNWCContext2, Arrays.asList(stringArray));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanup(File file, SVNWCContext sVNWCContext, List list) {
        this.cleanup(sVNWCContext, file);
        this.sleepForTimestamp();
        if (((SvnCleanup)this.getOperation()).isRemoveUnversionedItems() || ((SvnCleanup)this.getOperation()).isRemoveIgnoredItems() || ((SvnCleanup)this.getOperation()).isIncludeExternals()) {
            SvnNgCleanup$CleanupStatusWalk svnNgCleanup$CleanupStatusWalk = new SvnNgCleanup$CleanupStatusWalk();
            SvnNgCleanup$CleanupStatusWalk.access$102(svnNgCleanup$CleanupStatusWalk, ((SvnCleanup)this.getOperation()).isRemoveUnversionedItems());
            SvnNgCleanup$CleanupStatusWalk.access$202(svnNgCleanup$CleanupStatusWalk, ((SvnCleanup)this.getOperation()).isRemoveIgnoredItems());
            SvnNgCleanup$CleanupStatusWalk.access$302(svnNgCleanup$CleanupStatusWalk, ((SvnCleanup)this.getOperation()).isIncludeExternals());
            SvnNgCleanup$CleanupStatusWalk.access$402(svnNgCleanup$CleanupStatusWalk, sVNWCContext.getEventHandler());
            SvnNgCleanup$CleanupStatusWalk.access$502(svnNgCleanup$CleanupStatusWalk, sVNWCContext);
            SvnNgCleanup$CleanupStatusWalk.access$602(svnNgCleanup$CleanupStatusWalk, list);
            SvnNgCleanup$CleanupStatusWalk.access$702(svnNgCleanup$CleanupStatusWalk, (SvnCleanup)this.getOperation());
            File file2 = sVNWCContext.acquireWriteLock(file, false, true);
            try {
                SVNStatusEditor17 sVNStatusEditor17 = new SVNStatusEditor17(file, this.getWcContext(), ((SvnCleanup)this.getOperation()).getOptions(), ((SvnCleanup)this.getOperation()).isRemoveIgnoredItems(), true, SVNDepth.INFINITY, svnNgCleanup$CleanupStatusWalk);
                sVNStatusEditor17.walkStatus(file, SVNDepth.INFINITY, true, ((SvnCleanup)this.getOperation()).isRemoveIgnoredItems(), true, list);
            }
            finally {
                sVNWCContext.releaseWriteLock(file2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(SVNWCContext sVNWCContext, File file) {
        boolean bl2 = ((SvnCleanup)this.getOperation()).isBreakLocks();
        try {
            if (bl2) {
                sVNWCContext.getDb().open(ISVNWCDb$SVNWCDbOpenMode.ReadWrite, null, true, false);
            }
            this.cleanupInternal(sVNWCContext, file);
            if (((SvnCleanup)this.getOperation()).isDeleteWCProperties()) {
                sVNWCContext.getDb().clearDavCacheRecursive(file);
            }
        }
        finally {
            if (bl2) {
                sVNWCContext.getDb().close();
            }
        }
    }

    private int canBeCleaned(SVNWCContext sVNWCContext, File file) {
        SVNErrorMessage sVNErrorMessage;
        int n2 = sVNWCContext.checkWC(file);
        if (n2 == 0) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_NOT_WORKING_COPY, "''{0}'' is not a working copy directory", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (n2 < 12) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT, "Log format too old, please use Subversion 1.6 or earlier");
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        return n2;
    }

    private void cleanupInternal(SVNWCContext sVNWCContext, File file) {
        File file2;
        int n2 = this.canBeCleaned(sVNWCContext, file);
        sVNWCContext.getDb().obtainWCLock(file, -1, ((SvnCleanup)this.getOperation()).isBreakLocks());
        if (n2 >= 13) {
            sVNWCContext.wqRun(file);
        }
        if ((file2 = sVNWCContext.getDb().getWCRoot(file)).equals(file) && ((SvnCleanup)this.getOperation()).isVacuumPristines()) {
            SVNWCUtils.admCleanupTmpArea(sVNWCContext, file);
            sVNWCContext.getDb().cleanupPristine(file);
        }
        SvnNgCleanup.repairTimestamps(sVNWCContext, file);
        sVNWCContext.getDb().releaseWCLock(file);
    }

    public static void repairTimestamps(SVNWCContext sVNWCContext, File file) {
        sVNWCContext.checkCancelled();
        ISVNWCDb$WCDbInfo iSVNWCDb$WCDbInfo = sVNWCContext.getDb().readInfo(file, ISVNWCDb$WCDbInfo$InfoField.status, ISVNWCDb$WCDbInfo$InfoField.kind);
        if (iSVNWCDb$WCDbInfo.status == ISVNWCDb$SVNWCDbStatus.ServerExcluded || iSVNWCDb$WCDbInfo.status == ISVNWCDb$SVNWCDbStatus.Deleted || iSVNWCDb$WCDbInfo.status == ISVNWCDb$SVNWCDbStatus.Excluded || iSVNWCDb$WCDbInfo.status == ISVNWCDb$SVNWCDbStatus.NotPresent) {
            return;
        }
        if (iSVNWCDb$WCDbInfo.kind == ISVNWCDb$SVNWCDbKind.File || iSVNWCDb$WCDbInfo.kind == ISVNWCDb$SVNWCDbKind.Symlink) {
            try {
                sVNWCContext.isTextModified(file, false);
            }
            catch (SVNException sVNException) {
                SVNDebugLog.getDefaultLog().log(SVNLogType.WC, sVNException, Level.WARNING);
            }
        } else if (iSVNWCDb$WCDbInfo.kind == ISVNWCDb$SVNWCDbKind.Dir) {
            Set set = sVNWCContext.getDb().readChildren(file);
            for (String string : set) {
                File file2 = SVNFileUtil.createFilePath(file, string);
                SvnNgCleanup.repairTimestamps(sVNWCContext, file2);
            }
        }
    }

    static /* synthetic */ void access$800(SvnNgCleanup svnNgCleanup, File file, SVNWCContext sVNWCContext, List list) {
        svnNgCleanup.doCleanup(file, sVNWCContext, list);
    }
}

