/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc2.SvnOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgCleanup;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnCleanup;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;

class SvnNgCleanup$CleanupStatusWalk
implements ISvnObjectReceiver {
    private boolean removeUnversionedItems;
    private boolean removeIgnoredItems;
    private boolean includeExternals;
    private SVNWCContext context;
    private ISVNEventHandler eventHandler;
    private SVNWCContext wcContext;
    private List ignores;
    private SvnCleanup operation;

    private SvnNgCleanup$CleanupStatusWalk() {
    }

    public void receive(SvnTarget svnTarget, SvnStatus svnStatus) {
        SVNFileType sVNFileType;
        File file = svnTarget.getFile();
        if (svnStatus.getNodeStatus() == SVNStatusType.STATUS_EXTERNAL && this.includeExternals) {
            SVNFileType sVNFileType2 = SVNFileType.getType(file);
            if (sVNFileType2 == SVNFileType.DIRECTORY) {
                Object object;
                if (this.eventHandler != null) {
                    object = SVNEventFactory.createSVNEvent(file, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.CLEANUP_EXTERNAL, SVNEventAction.CLEANUP_EXTERNAL, null, null);
                    this.eventHandler.handleEvent((SVNEvent)object, -1.0);
                }
                try {
                    object = new SvnNgCleanup();
                    ((SvnOperationRunner)object).setOperation(this.operation);
                    SvnNgCleanup.access$800((SvnNgCleanup)object, file, this.wcContext, this.ignores);
                }
                catch (SVNException sVNException) {
                    if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_WORKING_COPY) {
                        return;
                    }
                    throw sVNException;
                }
            }
            return;
        }
        if (svnStatus.getNodeStatus() == SVNStatusType.STATUS_IGNORED) {
            if (!this.removeIgnoredItems) {
                return;
            }
        } else if (svnStatus.getNodeStatus() == SVNStatusType.STATUS_UNVERSIONED) {
            if (!this.removeUnversionedItems) {
                return;
            }
        } else {
            return;
        }
        if ((sVNFileType = SVNFileType.getType(file)) == SVNFileType.FILE || sVNFileType == SVNFileType.SYMLINK) {
            SVNFileUtil.deleteFile(file);
        } else if (sVNFileType == SVNFileType.DIRECTORY) {
            SVNFileUtil.deleteAll(file, true, this.eventHandler);
        } else {
            return;
        }
        if (this.eventHandler != null) {
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, SVNFileType.getNodeKind(sVNFileType), null, -1L, SVNEventAction.DELETE, SVNEventAction.DELETE, null, null);
            this.eventHandler.handleEvent(sVNEvent, -1.0);
        }
    }

    static /* synthetic */ boolean access$102(SvnNgCleanup$CleanupStatusWalk svnNgCleanup$CleanupStatusWalk, boolean bl2) {
        svnNgCleanup$CleanupStatusWalk.removeUnversionedItems = bl2;
        return svnNgCleanup$CleanupStatusWalk.removeUnversionedItems;
    }

    static /* synthetic */ boolean access$202(SvnNgCleanup$CleanupStatusWalk svnNgCleanup$CleanupStatusWalk, boolean bl2) {
        svnNgCleanup$CleanupStatusWalk.removeIgnoredItems = bl2;
        return svnNgCleanup$CleanupStatusWalk.removeIgnoredItems;
    }

    static /* synthetic */ boolean access$302(SvnNgCleanup$CleanupStatusWalk svnNgCleanup$CleanupStatusWalk, boolean bl2) {
        svnNgCleanup$CleanupStatusWalk.includeExternals = bl2;
        return svnNgCleanup$CleanupStatusWalk.includeExternals;
    }

    static /* synthetic */ ISVNEventHandler access$402(SvnNgCleanup$CleanupStatusWalk svnNgCleanup$CleanupStatusWalk, ISVNEventHandler iSVNEventHandler) {
        svnNgCleanup$CleanupStatusWalk.eventHandler = iSVNEventHandler;
        return svnNgCleanup$CleanupStatusWalk.eventHandler;
    }

    static /* synthetic */ SVNWCContext access$502(SvnNgCleanup$CleanupStatusWalk svnNgCleanup$CleanupStatusWalk, SVNWCContext sVNWCContext) {
        svnNgCleanup$CleanupStatusWalk.wcContext = sVNWCContext;
        return svnNgCleanup$CleanupStatusWalk.wcContext;
    }

    static /* synthetic */ List access$602(SvnNgCleanup$CleanupStatusWalk svnNgCleanup$CleanupStatusWalk, List list) {
        svnNgCleanup$CleanupStatusWalk.ignores = list;
        return svnNgCleanup$CleanupStatusWalk.ignores;
    }

    static /* synthetic */ SvnCleanup access$702(SvnNgCleanup$CleanupStatusWalk svnNgCleanup$CleanupStatusWalk, SvnCleanup svnCleanup) {
        svnNgCleanup$CleanupStatusWalk.operation = svnCleanup;
        return svnNgCleanup$CleanupStatusWalk.operation;
    }
}

