/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$ConflictInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbAdditionInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbAdditionInfo$AdditionInfoField;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbRepositoryInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbRepositoryInfo$RepositoryInfoField;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbRevert;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgAdd$1;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgAdd$2;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgAdd$CheckCanAddNode;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgAdd$CheckCanAddToParent;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgReposToWcCopy;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRevert;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgWcToWcCopy;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.ISvnAddParameters;
import org.tmatesoft.svn.core.wc2.SvnGetProperties;
import org.tmatesoft.svn.core.wc2.SvnInheritedProperties;
import org.tmatesoft.svn.core.wc2.SvnOperation;
import org.tmatesoft.svn.core.wc2.SvnScheduleForAddition;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgAdd
extends SvnNgOperationRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void run(SVNWCContext sVNWCContext) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (Object object5 : ((SvnScheduleForAddition)this.getOperation()).getTargets()) {
            object4 = ((SvnTarget)object5).getFile();
            object3 = SVNFileType.getType(((SvnTarget)object5).getFile());
            if (object3 == SVNFileType.FILE || !this.getWcContext().getDb().isWCRoot((File)object4, true)) {
                object2 = SVNFileUtil.getParentFile((File)object4);
                if (((SvnScheduleForAddition)this.getOperation()).isAddParents()) {
                    object2 = this.findExistingParent((File)object2);
                }
                object = this.getWcContext().getDb().getWCRoot((File)object2);
            } else {
                object = object4;
            }
            object2 = (List)hashMap.get(object);
            if (object2 == null) {
                object2 = new ArrayList<Object>();
                hashMap.put(object, object2);
            }
            object2.add(object5);
        }
        for (Object object5 : hashMap.keySet()) {
            object4 = (List)hashMap.get(object5);
            object = this.getWcContext().acquireWriteLock((File)object5, false, true);
            try {
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (SvnTarget)object3.next();
                    this.add((SvnTarget)object2);
                }
            }
            finally {
                this.getWcContext().releaseWriteLock((File)object);
            }
        }
        return null;
    }

    private void add(SvnTarget svnTarget) {
        Serializable serializable;
        if (svnTarget.isURL()) {
            serializable = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not a local path", (Object)svnTarget.getURL());
            SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.WC);
        }
        File file = serializable = svnTarget.getFile();
        Serializable serializable2 = serializable;
        if (!this.getWcContext().getDb().isWCRoot((File)serializable, true)) {
            file = serializable2 = SVNFileUtil.getParentFile(serializable);
            if (((SvnScheduleForAddition)this.getOperation()).isAddParents()) {
                file = this.findExistingParent((File)serializable2);
            }
        }
        SVNFileType sVNFileType = SVNFileType.getType(serializable);
        if (!((SvnScheduleForAddition)this.getOperation()).isAddParents() && ((SvnScheduleForAddition)this.getOperation()).isMkDir() && sVNFileType != SVNFileType.NONE) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Can''t create directory ''{0}'': Cannot create a file when that file already exists.", (Object)serializable);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        } else if (((SvnScheduleForAddition)this.getOperation()).isMkDir() && ((SvnScheduleForAddition)this.getOperation()).isAddParents()) {
            SVNFileUtil.ensureDirectoryExists(serializable);
        } else if (sVNFileType == SVNFileType.NONE && ((SvnScheduleForAddition)this.getOperation()).isMkDir()) {
            SVNFileUtil.ensureDirectoryExists(serializable);
        }
        try {
            this.add((File)serializable, (File)serializable2, file);
        }
        catch (SVNException sVNException) {
            if (sVNFileType == SVNFileType.NONE) {
                SVNFileUtil.deleteAll(serializable, true);
            }
            throw sVNException;
        }
    }

    private void add(File file, File file2, File file3) {
        block11: {
            Object object;
            Object object2;
            Object object3;
            if (!file3.equals(file2)) {
                object3 = file2.getAbsolutePath().replace(File.separatorChar, '/');
                object2 = file3.getAbsolutePath().replace(File.separatorChar, '/');
                object = SVNPathUtil.getRelativePath((String)object2, (String)object3);
                file2 = file3;
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, "/");
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    this.checkCancelled();
                    file2 = SVNFileUtil.createFilePath(file2, string);
                    SVNFileType sVNFileType = SVNFileType.getType(file2);
                    if (sVNFileType != SVNFileType.NONE && sVNFileType != SVNFileType.DIRECTORY) {
                        SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_NO_VERSIONED_PARENT, "''{0}'' prevents creating of '''{1}''", file2, file);
                        SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                    }
                    SVNFileUtil.ensureDirectoryExists(file2);
                    this.addFromDisk(file2, null, true);
                }
            }
            object3 = SVNFileType.getNodeKind(SVNFileType.getType(file));
            try {
                if (object3 == SVNNodeKind.DIR) {
                    this.addDirectory(file, ((SvnScheduleForAddition)this.getOperation()).getDepth(), !((SvnScheduleForAddition)this.getOperation()).isIncludeIgnored());
                    break block11;
                }
                if (object3 == SVNNodeKind.FILE) {
                    this.addFile(file);
                    break block11;
                }
                if (object3 == SVNNodeKind.NONE) {
                    object2 = null;
                    try {
                        object2 = this.getWcContext().getConflicted(file, false, false, true);
                    }
                    catch (SVNException sVNException) {
                        // empty catch block
                    }
                    if (object2 != null && ((SVNWCContext$ConflictInfo)object2).treeConflicted) {
                        object = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "''{0}'' is an existing item in conflict; please mark the conflict as resolved before adding a new item here", (Object)file);
                        SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
                    }
                    object = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' not found", (Object)file);
                    SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
                    break block11;
                }
                object2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Unsupported node kind for path ''{0}''", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
            }
            catch (SVNException sVNException) {
                if (((SvnScheduleForAddition)this.getOperation()).isForce() && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_EXISTS) break block11;
                throw sVNException;
            }
        }
    }

    private void addFile(File file) {
        Object object;
        boolean bl2 = SVNFileType.getType(file) == SVNFileType.SYMLINK;
        SVNProperties sVNProperties = null;
        if (!bl2) {
            if (((SvnScheduleForAddition)this.getOperation()).isApplyAutoProperties() && (object = this.getAllAutoProperties(((SvnScheduleForAddition)this.getOperation()).getOptions(), file)) != null && !object.isEmpty()) {
                sVNProperties = SVNProperties.wrap((Map)object);
            }
        } else {
            sVNProperties = new SVNProperties();
            sVNProperties.put("svn:special", "*");
        }
        this.addFromDisk(file, null, false);
        if (sVNProperties != null) {
            object = ((SvnScheduleForAddition)this.getOperation()).getAddParameters() == null ? ISvnAddParameters.DEFAULT : ((SvnScheduleForAddition)this.getOperation()).getAddParameters();
            SvnNgPropertiesManager.setAutoProperties(this.getWcContext(), file, sVNProperties, (ISvnAddParameters)object, new SvnNgAdd$1(this, file));
        }
        this.handleEvent(SVNEventFactory.createSVNEvent(file, SVNNodeKind.FILE, sVNProperties != null ? sVNProperties.getStringValue("svn:mime-type") : null, -1L, SVNEventAction.ADD, SVNEventAction.ADD, null, null, 1L, 1L));
    }

    private Map getAllAutoProperties(ISVNOptions iSVNOptions, File file) {
        Object object;
        SVNProperties sVNProperties;
        Object object2;
        HashMap hashMap = new HashMap();
        Map map = SVNPropertiesManager.computeAutoProperties(iSVNOptions, file, null);
        if (map != null) {
            hashMap.putAll(map);
        }
        SVNRevision sVNRevision = SVNRevision.WORKING;
        File file2 = SVNFileUtil.getParentFile(file);
        List[] listArray = new List[1];
        while (true) {
            object2 = ((SvnScheduleForAddition)this.getOperation()).getOperationFactory().createGetProperties();
            ((SvnOperation)object2).setSingleTarget(SvnTarget.fromFile(file2, sVNRevision));
            ((SvnOperation)object2).setRevision(sVNRevision);
            ((SvnOperation)object2).setDepth(SVNDepth.EMPTY);
            ((SvnGetProperties)object2).setTargetInheritedPropertiesReceiver(new SvnNgAdd$2(this, listArray));
            try {
                sVNProperties = (SVNProperties)((SvnOperation)object2).run();
            }
            catch (SVNException sVNException) {
                if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.UNVERSIONED_RESOURCE) {
                    throw sVNException;
                }
                file2 = this.findExistingParent(file2);
                continue;
            }
            break;
        }
        if (listArray[0] != null) {
            for (Object object3 : listArray[0]) {
                SVNProperties object4 = ((SvnInheritedProperties)object3).getProperties();
                object = object4.asMap();
                for (Map.Entry entry : object.entrySet()) {
                    String string = (String)entry.getKey();
                    if (!"svn:auto-props".equals(string)) continue;
                    SVNPropertyValue sVNPropertyValue = (SVNPropertyValue)entry.getValue();
                    hashMap.putAll(SvnNgPropertiesManager.getMatchedAutoProperties(file.getName(), SvnNgPropertiesManager.parseAutoProperties(sVNPropertyValue, null)));
                }
            }
        }
        if (sVNProperties != null) {
            object2 = sVNProperties.asMap();
            for (Map.Entry entry : object2.entrySet()) {
                object = (String)entry.getKey();
                if (!"svn:auto-props".equals(object)) continue;
                SVNPropertyValue sVNPropertyValue = (SVNPropertyValue)entry.getValue();
                hashMap.putAll(SvnNgPropertiesManager.getMatchedAutoProperties(file.getName(), SvnNgPropertiesManager.parseAutoProperties(sVNPropertyValue, null)));
            }
        }
        return hashMap;
    }

    private void doRevert(File file) {
        try {
            try {
                this.getWcContext().getDb().opRevert(file, SVNDepth.EMPTY, false);
                SvnNgRevert.restore(this.getWcContext(), file, SVNDepth.EMPTY, false, false, true, null);
            }
            catch (SVNException sVNException) {
                SVNDebugLog.getDefaultLog().logError(SVNLogType.WC, sVNException);
                throw sVNException;
            }
            finally {
                SvnWcDbRevert.dropRevertList(this.getWcContext(), file);
            }
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
    }

    private void addDirectory(File file, SVNDepth sVNDepth, boolean bl2) {
        boolean bl3 = false;
        this.checkCancelled();
        try {
            this.addFromDisk(file, null, true);
        }
        catch (SVNException sVNException) {
            if (!((SvnScheduleForAddition)this.getOperation()).isForce() || sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.ENTRY_EXISTS) {
                throw sVNException;
            }
            bl3 = true;
        }
        if (sVNDepth.compareTo(SVNDepth.EMPTY) <= 0) {
            return;
        }
        Collection collection = null;
        if (bl2) {
            collection = SvnNgPropertiesManager.getEffectiveIgnores(this.getWcContext(), file, null);
        }
        File[] fileArray = SVNFileListUtil.listFiles(file);
        for (int i2 = 0; fileArray != null && i2 < fileArray.length; ++i2) {
            this.checkCancelled();
            String string = fileArray[i2].getName();
            if (string.equals(SVNFileUtil.getAdminDirectoryName()) || collection != null && SvnNgPropertiesManager.isIgnored(string, collection)) continue;
            SVNNodeKind sVNNodeKind = SVNFileType.getNodeKind(SVNFileType.getType(fileArray[i2]));
            if (sVNNodeKind == SVNNodeKind.DIR && sVNDepth.compareTo(SVNDepth.IMMEDIATES) >= 0) {
                SVNDepth sVNDepth2 = sVNDepth;
                if (sVNDepth == SVNDepth.IMMEDIATES) {
                    sVNDepth2 = SVNDepth.EMPTY;
                }
                if (bl2 && !bl3) {
                    bl2 = false;
                }
                this.addDirectory(fileArray[i2], sVNDepth2, bl2);
                continue;
            }
            if (sVNNodeKind != SVNNodeKind.FILE || sVNDepth.compareTo(SVNDepth.FILES) < 0) continue;
            try {
                this.addFile(fileArray[i2]);
                continue;
            }
            catch (SVNException sVNException) {
                if (((SvnScheduleForAddition)this.getOperation()).isForce() && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_EXISTS) continue;
                throw sVNException;
            }
        }
    }

    public void addFromDisk(File file, SVNProperties sVNProperties, boolean bl2) {
        SVNNodeKind sVNNodeKind = this.checkCanAddNode(file);
        this.checkCanAddtoParent(file);
        if (sVNNodeKind == SVNNodeKind.FILE) {
            SVNSkel sVNSkel = null;
            if (sVNProperties != null && (sVNProperties.getSVNPropertyValue("svn:executable") != null || sVNProperties.getSVNPropertyValue("svn:needs-lock") != null)) {
                sVNSkel = this.getWcContext().wqBuildSyncFileFlags(file);
            }
            this.getWcContext().getDb().opAddFile(file, sVNProperties, sVNSkel);
            if (sVNSkel != null) {
                this.getWcContext().wqRun(file);
            }
        } else {
            this.getWcContext().getDb().opAddDirectory(file, sVNProperties, null);
        }
        if (bl2) {
            this.handleEvent(SVNEventFactory.createSVNEvent(file, sVNNodeKind, null, -1L, SVNEventAction.ADD, SVNEventAction.ADD, null, null, 1L, 1L));
        }
    }

    protected void add(File file, SVNDepth sVNDepth, SVNURL sVNURL, long l2, boolean bl2) {
        Object object;
        SvnNgAdd$CheckCanAddNode svnNgAdd$CheckCanAddNode = this.checkCanAddNode(file, sVNURL, l2);
        SVNNodeKind sVNNodeKind = svnNgAdd$CheckCanAddNode.kind;
        boolean bl3 = svnNgAdd$CheckCanAddNode.dbRowExists;
        boolean bl4 = svnNgAdd$CheckCanAddNode.isWcRoot;
        SvnNgAdd$CheckCanAddToParent svnNgAdd$CheckCanAddToParent = this.checkCanAddtoParent(file);
        SVNURL sVNURL2 = svnNgAdd$CheckCanAddToParent.reposRootUrl;
        String string = svnNgAdd$CheckCanAddToParent.reposUuid;
        if (sVNURL != null && !SVNPathUtil.isAncestor(sVNURL2.toString(), sVNURL.toString())) {
            object = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "The URL ''{0}'' has a different repository root than its parent", (Object)sVNURL);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (bl4) {
            Object object2;
            object = this.getWcContext().getDb().scanBaseRepository(file, ISVNWCDb$WCDbRepositoryInfo$RepositoryInfoField.relPath, ISVNWCDb$WCDbRepositoryInfo$RepositoryInfoField.rootUrl, ISVNWCDb$WCDbRepositoryInfo$RepositoryInfoField.uuid);
            File file2 = ((ISVNWCDb$WCDbRepositoryInfo)object).relPath;
            SVNURL sVNURL3 = ((ISVNWCDb$WCDbRepositoryInfo)object).rootUrl;
            String string2 = ((ISVNWCDb$WCDbRepositoryInfo)object).uuid;
            if (!string2.equals(string) || !sVNURL2.equals(sVNURL3)) {
                object2 = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Can't schedule the working copy at ''{0}'' from repository ''{1}'' with uuid ''{2}'' for addition under a working copy from repository ''{3}'' with uuid ''{4}''.", file, sVNURL3, string2, sVNURL2, string);
                SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
            }
            if (!((SVNURL)(object2 = sVNURL2.appendPath(SVNFileUtil.getFilePath(file2), false))).equals(sVNURL)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Can't add ''{0}'' with URL ''{1}'', but with the data from ''{2}''", file, sVNURL, object2);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
        }
        if (sVNURL == null) {
            boolean bl5;
            this.addFromDisk(file, null, false);
            if (sVNNodeKind == SVNNodeKind.DIR && !bl3 && !(bl5 = this.getWcContext().getDb().isWCLockOwns(file, false))) {
                this.getWcContext().getDb().obtainWCLock(file, 0, false);
            }
        } else if (!bl4) {
            if (sVNNodeKind == SVNNodeKind.FILE) {
                SvnNgReposToWcCopy.addFileToWc(this.getWcContext(), file, null, null, null, null, sVNURL, l2);
            } else {
                object = SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(sVNURL2.toDecodedString(), sVNURL.toDecodedString()));
                this.getWcContext().getDb().opCopyDir(file, new SVNProperties(), l2, SVNDate.NULL, null, (File)object, sVNURL2, string, l2, null, false, null, null, null);
            }
        } else {
            this.integrateNestedWcAsCopy(file);
        }
        if (bl2 && this.getWcContext().getEventHandler() != null) {
            SVNEvent sVNEvent = SVNEventFactory.createSVNEvent(file, sVNNodeKind, null, -1L, SVNEventAction.ADD, SVNEventAction.ADD, null, null);
            this.getWcContext().getEventHandler().handleEvent(sVNEvent, -1.0);
        }
    }

    private SvnNgAdd$CheckCanAddToParent checkCanAddtoParent(File file) {
        File file2 = SVNFileUtil.getParentFile(file);
        this.getWcContext().writeCheck(file2);
        SvnNgAdd$CheckCanAddToParent svnNgAdd$CheckCanAddToParent = new SvnNgAdd$CheckCanAddToParent();
        try {
            Object object;
            Structure structure = this.getWcContext().getDb().readInfo(file2, StructureFields$NodeInfo.status, StructureFields$NodeInfo.kind, StructureFields$NodeInfo.reposRootUrl, StructureFields$NodeInfo.reposUuid);
            ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus = (ISVNWCDb$SVNWCDbStatus)((Object)structure.get(StructureFields$NodeInfo.status));
            ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind = (ISVNWCDb$SVNWCDbKind)((Object)structure.get(StructureFields$NodeInfo.kind));
            svnNgAdd$CheckCanAddToParent.reposRootUrl = (SVNURL)structure.get(StructureFields$NodeInfo.reposRootUrl);
            svnNgAdd$CheckCanAddToParent.reposUuid = (String)structure.get(StructureFields$NodeInfo.reposUuid);
            if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.NotPresent || iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Excluded || iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.ServerExcluded) {
                object = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Can''t find parent directory''s node while trying to add ''{0}''", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Deleted) {
                object = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "Can''t add ''{0}'' to a parent directory scheduled for deletion", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            } else if (iSVNWCDb$SVNWCDbKind != ISVNWCDb$SVNWCDbKind.Dir) {
                object = SVNErrorMessage.create(SVNErrorCode.WC_SCHEDULE_CONFLICT, "Can''t schedule an addition of ''{0}'' below a not-directory node", (Object)file);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            if (svnNgAdd$CheckCanAddToParent.reposRootUrl == null || svnNgAdd$CheckCanAddToParent.reposUuid == null) {
                if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Added) {
                    object = this.getWcContext().getDb().scanAddition(file2, ISVNWCDb$WCDbAdditionInfo$AdditionInfoField.reposRootUrl, ISVNWCDb$WCDbAdditionInfo$AdditionInfoField.reposUuid);
                    svnNgAdd$CheckCanAddToParent.reposRootUrl = ((ISVNWCDb$WCDbAdditionInfo)object).reposRootUrl;
                    svnNgAdd$CheckCanAddToParent.reposUuid = ((ISVNWCDb$WCDbAdditionInfo)object).reposUuid;
                } else {
                    object = this.getWcContext().getDb().scanBaseRepository(file2, ISVNWCDb$WCDbRepositoryInfo$RepositoryInfoField.rootUrl, ISVNWCDb$WCDbRepositoryInfo$RepositoryInfoField.uuid);
                    svnNgAdd$CheckCanAddToParent.reposRootUrl = ((ISVNWCDb$WCDbRepositoryInfo)object).rootUrl;
                    svnNgAdd$CheckCanAddToParent.reposUuid = ((ISVNWCDb$WCDbRepositoryInfo)object).uuid;
                }
            }
            structure.release();
        }
        catch (SVNException sVNException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Can''t find parent directory''s node while trying to add ''{0}''", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        return svnNgAdd$CheckCanAddToParent;
    }

    private SvnNgAdd$CheckCanAddNode checkCanAddNode(File file, SVNURL sVNURL, long l2) {
        Object object;
        Object object2;
        String string = SVNFileUtil.getFileName(file);
        assert (SVNFileUtil.isAbsolute(file));
        assert (sVNURL == null || SVNRevision.isValidRevisionNumber(l2));
        if (SVNFileUtil.getAdminDirectoryName().equals(string)) {
            object2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_FORBIDDEN, "Can't create an entry with a reserved name while trying to add ''{0}''", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object2, SVNLogType.WC);
        }
        if ((object2 = SVNFileType.getType(file)) == SVNFileType.NONE) {
            object = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' not found", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        if (object2 == SVNFileType.UNKNOWN) {
            object = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Unsupported node kind for ''{0}''", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
        }
        object = new SvnNgAdd$CheckCanAddNode();
        ((SvnNgAdd$CheckCanAddNode)object).kind = SVNFileType.getNodeKind((SVNFileType)object2);
        try {
            SVNErrorMessage sVNErrorMessage;
            Structure structure = this.getWcContext().getDb().readInfo(file, true, StructureFields$NodeInfo.status, StructureFields$NodeInfo.conflicted);
            ((SvnNgAdd$CheckCanAddNode)object).isWcRoot = false;
            ((SvnNgAdd$CheckCanAddNode)object).dbRowExists = true;
            if (structure.is(StructureFields$NodeInfo.conflicted)) {
                sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "''{0}'' is an existing item in conflict; please mark the conflict as resolved before adding a new item here", (Object)file);
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            switch ((ISVNWCDb$SVNWCDbStatus)((Object)structure.get(StructureFields$NodeInfo.status))) {
                case NotPresent: {
                    break;
                }
                case Deleted: {
                    break;
                }
                case Normal: {
                    ((SvnNgAdd$CheckCanAddNode)object).isWcRoot = this.getWcContext().getDb().isWCRoot(file);
                    if (((SvnNgAdd$CheckCanAddNode)object).isWcRoot && sVNURL != null || ((SvnNgAdd$CheckCanAddNode)object).isWcRoot && object2 == SVNFileType.SYMLINK) break;
                }
                default: {
                    sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "''{0}'' is already under version control", (Object)file);
                    SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
                }
            }
            structure.release();
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw sVNException;
            }
            ((SvnNgAdd$CheckCanAddNode)object).dbRowExists = false;
            ((SvnNgAdd$CheckCanAddNode)object).isWcRoot = false;
        }
        return object;
    }

    private SVNNodeKind checkCanAddNode(File file) {
        SvnNgAdd$CheckCanAddNode svnNgAdd$CheckCanAddNode = this.checkCanAddNode(file, null, -1L);
        return svnNgAdd$CheckCanAddNode.kind;
    }

    private File findExistingParent(File file) {
        SVNErrorMessage sVNErrorMessage;
        SVNNodeKind sVNNodeKind = this.getWcContext().readKind(file, false);
        if (sVNNodeKind == SVNNodeKind.DIR && !this.getWcContext().isNodeStatusDeleted(file)) {
            return file;
        }
        if (file.getParentFile() == null) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_NO_VERSIONED_PARENT);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (SVNFileUtil.getAdminDirectoryName().equals(SVNFileUtil.getFileName(file))) {
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RESERVED_FILENAME_SPECIFIED, "''{0}'' ends in a reserved name", (Object)file);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        file = SVNFileUtil.getParentFile(file);
        this.checkCancelled();
        return this.findExistingParent(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void integrateNestedWcAsCopy(File file) {
        this.getWcContext().getDb().dropRoot(file);
        File file2 = this.getWcContext().getDb().getWCRootTempDir(file);
        File file3 = SVNFileUtil.createUniqueFile(file2, "", "", false);
        try {
            SVNFileUtil.ensureDirectoryExists(file3);
            File file4 = SVNFileUtil.createFilePath(file, SVNFileUtil.getAdminDirectoryName());
            File file5 = SVNFileUtil.createFilePath(file3, SVNFileUtil.getAdminDirectoryName());
            SVNFileUtil.moveDir(file4, file5);
            SvnNgWcToWcCopy svnNgWcToWcCopy = new SvnNgWcToWcCopy();
            svnNgWcToWcCopy.copy(this.getWcContext(), file3, file, true);
            this.getWcContext().getDb().dropRoot(file3);
        }
        finally {
            SVNFileUtil.deleteAll(file3, null);
        }
        boolean bl2 = this.getWcContext().getDb().isWCLockOwns(file, false);
        if (!bl2) {
            this.getWcContext().getDb().obtainWCLock(file, 0, false);
        }
    }

    static /* synthetic */ void access$000(SvnNgAdd svnNgAdd, File file) {
        svnNgAdd.doRevert(file);
    }
}

