/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnPropertiesDiffHandler;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallback$OperationKind;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnOldDiffGenerator;
import org.tmatesoft.svn.core.wc.DefaultSVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnNewDiffGenerator
implements ISvnPropertiesDiffHandler,
ISVNDiffGenerator {
    private final ISvnDiffGenerator generator;
    private boolean diffDeleted;
    private boolean diffAdded;
    private boolean diffCopied;
    private boolean diffUnversioned;
    private SVNProperties lastOriginalProperties;
    private SVNProperties lastPropChanges;

    public SvnNewDiffGenerator(ISvnDiffGenerator iSvnDiffGenerator) {
        this.generator = iSvnDiffGenerator;
        if (iSvnDiffGenerator instanceof DefaultSVNDiffGenerator) {
            DefaultSVNDiffGenerator defaultSVNDiffGenerator = (DefaultSVNDiffGenerator)((Object)iSvnDiffGenerator);
            this.diffAdded = defaultSVNDiffGenerator.isDiffAdded();
            this.diffDeleted = defaultSVNDiffGenerator.isDiffDeleted();
            this.diffCopied = defaultSVNDiffGenerator.isDiffCopied();
            this.diffUnversioned = defaultSVNDiffGenerator.isDiffUnversioned();
        } else {
            this.diffAdded = true;
            this.diffDeleted = true;
            this.diffCopied = false;
            this.diffUnversioned = false;
        }
    }

    public ISvnDiffGenerator getDelegate() {
        return this.generator;
    }

    @Override
    public void init(String string, String string2) {
        this.generator.setOriginalTargets(this.getAbsoluteTarget(string), this.getAbsoluteTarget(string2));
        this.generator.setAnchors(this.getAbsoluteTarget(string), this.getAbsoluteTarget(string2));
    }

    @Override
    public void setBasePath(File file) {
        this.generator.setBaseTarget(SvnTarget.fromFile(file));
    }

    @Override
    public void setForcedBinaryDiff(boolean bl2) {
        this.generator.setForcedBinaryDiff(bl2);
    }

    @Override
    public void setEncoding(String string) {
        this.generator.setEncoding(string);
    }

    @Override
    public String getEncoding() {
        return this.generator.getEncoding();
    }

    @Override
    public void setEOL(byte[] byArray) {
        this.generator.setEOL(byArray);
    }

    @Override
    public byte[] getEOL() {
        return this.generator.getEOL();
    }

    @Override
    public void setDiffDeleted(boolean bl2) {
        if (this.generator instanceof SvnDiffGenerator) {
            ((SvnDiffGenerator)this.generator).setDiffDeleted(bl2);
        } else if (this.generator instanceof SvnOldDiffGenerator) {
            ((SvnOldDiffGenerator)this.generator).getDelegate().setDiffDeleted(bl2);
        }
        this.diffDeleted = bl2;
    }

    @Override
    public boolean isDiffDeleted() {
        return this.diffDeleted;
    }

    @Override
    public void setDiffAdded(boolean bl2) {
        this.diffAdded = bl2;
    }

    @Override
    public boolean isDiffAdded() {
        return this.diffAdded;
    }

    @Override
    public void setDiffCopied(boolean bl2) {
        this.diffCopied = bl2;
    }

    @Override
    public boolean isDiffCopied() {
        return this.diffCopied;
    }

    @Override
    public void setDiffUnversioned(boolean bl2) {
        this.diffUnversioned = bl2;
    }

    @Override
    public boolean isDiffUnversioned() {
        return this.diffUnversioned;
    }

    @Override
    public File createTempDirectory() {
        return SVNFileUtil.createTempDirectory("diff");
    }

    @Override
    public void displayPropDiff(String string, SVNProperties sVNProperties, SVNProperties sVNProperties2, OutputStream outputStream) {
        this.generator.displayPropsChanged(this.getTarget(string), "", "", false, sVNProperties, sVNProperties2, outputStream);
    }

    @Override
    public void handlePropertiesDiff(SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        this.lastOriginalProperties = sVNProperties;
        this.lastPropChanges = sVNProperties;
    }

    @Override
    public void displayFileDiff(String string, File file, File file2, String string2, String string3, String string4, String string5, OutputStream outputStream) {
        this.generator.displayContentChanged(this.getTarget(string), file, file2, string2, string3, string4, string5, SvnDiffCallback$OperationKind.Modified, null, this.lastOriginalProperties, this.lastPropChanges, outputStream);
    }

    @Override
    public void displayDeletedDirectory(String string, String string2, String string3) {
        this.generator.displayDeletedDirectory(this.getTarget(string), string2, string3, null);
    }

    @Override
    public void displayAddedDirectory(String string, String string2, String string3) {
        this.generator.displayAddedDirectory(this.getTarget(string), string2, string3, null);
    }

    @Override
    public boolean isForcedBinaryDiff() {
        return this.generator.isForcedBinaryDiff();
    }

    private SvnTarget getTarget(String string) {
        return SvnTarget.fromFile(SVNFileUtil.createFilePath(string));
    }

    private SvnTarget getAbsoluteTarget(String string) {
        if (SVNPathUtil.isURL(string)) {
            try {
                return SvnTarget.fromURL(SVNURL.parseURIEncoded(string));
            }
            catch (SVNException sVNException) {
                return SvnTarget.fromFile(SVNFileUtil.createFilePath(string));
            }
        }
        return SvnTarget.fromFile(SVNFileUtil.createFilePath(string));
    }
}

