/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackResult;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.wc.ISVNDiffStatusHandler;
import org.tmatesoft.svn.core.wc.SVNDiffStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SvnDiffSummarizeCallback
implements ISvnDiffCallback {
    private final ISVNDiffStatusHandler handler;
    private final Set propChanges;
    private final boolean reversed;
    private final SVNURL baseUrl;
    private final File baseDirectory;
    private final File target;

    public SvnDiffSummarizeCallback(File file, boolean bl2, SVNURL sVNURL, File file2, ISVNDiffStatusHandler iSVNDiffStatusHandler) {
        this.handler = iSVNDiffStatusHandler;
        this.reversed = bl2;
        this.target = file;
        this.baseUrl = sVNURL;
        this.baseDirectory = file2;
        this.propChanges = new HashSet();
    }

    @Override
    public void fileOpened(SvnDiffCallbackResult svnDiffCallbackResult, File file, long l2) {
    }

    @Override
    public void fileChanged(SvnDiffCallbackResult svnDiffCallbackResult, File file, File file2, File file3, long l2, long l3, String string, String string2, SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        boolean bl2;
        boolean bl3 = file3 != null;
        SVNProperties sVNProperties3 = new SVNProperties();
        SvnNgPropertiesManager.categorizeProperties(sVNProperties, sVNProperties3, null, null);
        boolean bl4 = bl2 = sVNProperties3.size() > 0;
        if (bl3 || bl2) {
            this.sendSummary(file, bl3 ? SVNStatusType.STATUS_MODIFIED : SVNStatusType.STATUS_NORMAL, bl2, SVNNodeKind.FILE);
        }
    }

    @Override
    public void fileAdded(SvnDiffCallbackResult svnDiffCallbackResult, File file, File file2, File file3, long l2, long l3, String string, String string2, File file4, long l4, SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        SVNProperties sVNProperties3 = new SVNProperties();
        SvnNgPropertiesManager.categorizeProperties(sVNProperties, sVNProperties3, null, null);
        this.sendSummary(file, SVNStatusType.STATUS_ADDED, sVNProperties3.size() > 0, SVNNodeKind.FILE);
    }

    @Override
    public void fileDeleted(SvnDiffCallbackResult svnDiffCallbackResult, File file, File file2, File file3, String string, String string2, SVNProperties sVNProperties) {
        this.sendSummary(file, SVNStatusType.STATUS_DELETED, false, SVNNodeKind.FILE);
    }

    @Override
    public void dirDeleted(SvnDiffCallbackResult svnDiffCallbackResult, File file) {
        this.sendSummary(file, SVNStatusType.STATUS_DELETED, false, SVNNodeKind.DIR);
    }

    @Override
    public void dirOpened(SvnDiffCallbackResult svnDiffCallbackResult, File file, long l2) {
    }

    @Override
    public void dirAdded(SvnDiffCallbackResult svnDiffCallbackResult, File file, long l2, String string, long l3) {
    }

    @Override
    public void dirPropsChanged(SvnDiffCallbackResult svnDiffCallbackResult, File file, boolean bl2, SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        SVNProperties sVNProperties3 = new SVNProperties();
        SvnNgPropertiesManager.categorizeProperties(sVNProperties, sVNProperties3, null, null);
        if (sVNProperties3.size() > 0) {
            this.propChanges.add(file);
        }
    }

    @Override
    public void dirClosed(SvnDiffCallbackResult svnDiffCallbackResult, File file, boolean bl2) {
        if (SVNFileUtil.skipAncestor(this.target, file) == null) {
            return;
        }
        boolean bl3 = this.propChanges.contains(file);
        if (bl2 || bl3) {
            this.sendSummary(file, bl2 ? SVNStatusType.STATUS_ADDED : SVNStatusType.STATUS_NORMAL, bl3, SVNNodeKind.DIR);
        }
    }

    private void sendSummary(File file, SVNStatusType sVNStatusType, boolean bl2, SVNNodeKind sVNNodeKind) {
        File file2;
        assert (sVNStatusType != SVNStatusType.STATUS_NORMAL || bl2);
        if (this.reversed) {
            if (sVNStatusType == SVNStatusType.STATUS_ADDED) {
                sVNStatusType = SVNStatusType.STATUS_DELETED;
            } else if (sVNStatusType == SVNStatusType.STATUS_DELETED) {
                sVNStatusType = SVNStatusType.STATUS_ADDED;
            }
        }
        File file3 = file2 = SVNFileUtil.isAbsolute(file) ? SVNFileUtil.skipAncestor(this.baseDirectory, file) : file;
        File file4 = this.target == null ? null : (SVNFileUtil.isAbsolute(this.target) ? SVNFileUtil.skipAncestor(new File("").getAbsoluteFile(), this.target) : this.target);
        File file5 = file4 == null ? file2 : SVNFileUtil.skipAncestor(file4, file2);
        SVNDiffStatus sVNDiffStatus = new SVNDiffStatus(file, this.baseUrl == null ? null : this.baseUrl.appendPath(SVNFileUtil.getFilePath(file2), false), SVNFileUtil.getFilePath(file5), sVNStatusType, sVNStatusType == SVNStatusType.STATUS_MODIFIED || sVNStatusType == SVNStatusType.STATUS_NORMAL ? bl2 : false, sVNNodeKind);
        this.handler.handleDiffStatus(sVNDiffStatus);
    }
}

