/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbNodeCheckReplaceData;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbAdditionInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbAdditionInfo$AdditionInfoField;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo$BaseInfoField;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeInfo;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$PristineInfo;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffEditor;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnDiffStatusReceiver
implements ISvnObjectReceiver {
    private final SVNWCContext context;
    private final File anchor;
    private final ISVNWCDb db;
    private final ISvnDiffCallback callback;
    private final boolean showCopiesAsAdds;
    private final boolean gitFormat;
    private final boolean ignoreAncestry;
    private final Collection changelists;

    public SvnDiffStatusReceiver(SVNWCContext sVNWCContext, File file, ISVNWCDb iSVNWCDb, ISvnDiffCallback iSvnDiffCallback, boolean bl2, boolean bl3, boolean bl4, Collection collection) {
        this.context = sVNWCContext;
        this.anchor = file;
        this.db = iSVNWCDb;
        this.callback = iSvnDiffCallback;
        this.ignoreAncestry = bl2;
        this.showCopiesAsAdds = bl3;
        this.gitFormat = bl4;
        this.changelists = collection;
    }

    public SVNWCContext getContext() {
        return this.context;
    }

    public File getAnchor() {
        return this.anchor;
    }

    public ISVNWCDb getDb() {
        return this.db;
    }

    public ISvnDiffCallback getCallback() {
        return this.callback;
    }

    public boolean isIgnoreAncestry() {
        return this.ignoreAncestry;
    }

    public boolean isShowCopiesAsAdds() {
        return this.showCopiesAsAdds;
    }

    public boolean isGitFormat() {
        return this.gitFormat;
    }

    public void receive(SvnTarget svnTarget, SvnStatus svnStatus) {
        SVNStatusType sVNStatusType = svnStatus.getNodeStatus();
        if (sVNStatusType == SVNStatusType.STATUS_UNVERSIONED) {
            return;
        }
        if (sVNStatusType == SVNStatusType.OBSTRUCTED || sVNStatusType == SVNStatusType.MISSING) {
            return;
        }
        File file = svnTarget.getFile();
        if (this.changelists != null && !this.context.matchesChangelist(file, this.changelists)) {
            return;
        }
        if (svnStatus.getKind() == SVNNodeKind.FILE) {
            if (svnStatus.getTextStatus() == SVNStatusType.STATUS_MODIFIED || svnStatus.getPropertiesStatus() == SVNStatusType.STATUS_MODIFIED || svnStatus.getNodeStatus() == SVNStatusType.STATUS_DELETED || svnStatus.getNodeStatus() == SVNStatusType.STATUS_REPLACED || (this.isShowCopiesAsAdds() || this.isGitFormat()) && svnStatus.isCopied()) {
                String string = SVNPathUtil.getRelativePath(this.getAnchor().getAbsolutePath(), file.getAbsolutePath());
                this.fileDiff(file, string);
            }
        } else if (svnStatus.getNodeStatus() == SVNStatusType.STATUS_DELETED || svnStatus.getNodeStatus() == SVNStatusType.STATUS_REPLACED || svnStatus.getPropertiesStatus() == SVNStatusType.STATUS_MODIFIED) {
            String string = SVNPathUtil.getRelativePath(this.getAnchor().getAbsolutePath(), file.getAbsolutePath());
            SVNProperties sVNProperties = this.getDb().readPristineProperties(file);
            if (sVNProperties == null) {
                sVNProperties = new SVNProperties();
            }
            SVNProperties sVNProperties2 = this.getDb().readProperties(file);
            SVNProperties sVNProperties3 = SvnDiffEditor.computePropDiff(sVNProperties, sVNProperties2);
            this.getCallback().dirPropsChanged(null, file, false, sVNProperties3, sVNProperties);
        }
    }

    private void fileDiff(File file, String string) {
        String string2;
        Serializable serializable;
        Object object;
        Object object2;
        Structure structure = this.getDb().readInfo(file, StructureFields$NodeInfo.status, StructureFields$NodeInfo.kind, StructureFields$NodeInfo.revision, StructureFields$NodeInfo.checksum, StructureFields$NodeInfo.originalReposRelpath, StructureFields$NodeInfo.opRoot, StructureFields$NodeInfo.hadProps, StructureFields$NodeInfo.propsMod, StructureFields$NodeInfo.haveBase, StructureFields$NodeInfo.haveMoreWork);
        ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus = (ISVNWCDb$SVNWCDbStatus)((Object)structure.get(StructureFields$NodeInfo.status));
        ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind = (ISVNWCDb$SVNWCDbKind)((Object)structure.get(StructureFields$NodeInfo.kind));
        long l2 = structure.lng(StructureFields$NodeInfo.revision);
        SvnChecksum svnChecksum = (SvnChecksum)structure.get(StructureFields$NodeInfo.checksum);
        File file2 = (File)structure.get(StructureFields$NodeInfo.originalReposRelpath);
        Boolean bl2 = structure.is(StructureFields$NodeInfo.opRoot);
        boolean bl3 = structure.is(StructureFields$NodeInfo.hadProps);
        boolean bl4 = structure.is(StructureFields$NodeInfo.propsMod);
        boolean bl5 = structure.is(StructureFields$NodeInfo.haveBase);
        boolean bl6 = structure.is(StructureFields$NodeInfo.haveMoreWork);
        boolean bl7 = false;
        boolean bl8 = false;
        SvnChecksum svnChecksum2 = null;
        if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Added && (bl5 || bl6)) {
            object2 = this.getDb().nodeCheckReplace(file);
            bl7 = ((ISVNWCDb$SVNWCDbNodeCheckReplaceData)object2).replace;
            bl8 = ((ISVNWCDb$SVNWCDbNodeCheckReplaceData)object2).baseReplace;
            if (bl7 && bl8) {
                object = this.getDb().getBaseInfo(file, ISVNWCDb$WCDbBaseInfo$BaseInfoField.status, ISVNWCDb$WCDbBaseInfo$BaseInfoField.kind, ISVNWCDb$WCDbBaseInfo$BaseInfoField.revision, ISVNWCDb$WCDbBaseInfo$BaseInfoField.checksum);
                ISVNWCDb$SVNWCDbStatus iSVNWCDb$SVNWCDbStatus2 = ((ISVNWCDb$WCDbBaseInfo)object).status;
                ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind2 = ((ISVNWCDb$WCDbBaseInfo)object).kind;
                long l3 = ((ISVNWCDb$WCDbBaseInfo)object).revision;
                svnChecksum2 = ((ISVNWCDb$WCDbBaseInfo)object).checksum;
                if (iSVNWCDb$SVNWCDbStatus2 != ISVNWCDb$SVNWCDbStatus.Normal || iSVNWCDb$SVNWCDbKind2 != iSVNWCDb$SVNWCDbKind) {
                    bl7 = false;
                    bl8 = false;
                }
            } else {
                bl7 = false;
                bl8 = false;
            }
        }
        if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Added) {
            object2 = this.getDb().scanAddition(file, ISVNWCDb$WCDbAdditionInfo$AdditionInfoField.status);
            iSVNWCDb$SVNWCDbStatus = ((ISVNWCDb$WCDbAdditionInfo)object2).status;
        }
        if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Deleted || bl8 && !this.isIgnoreAncestry()) {
            if (bl8 && !this.isIgnoreAncestry()) {
                object = this.getDb().getBaseProps(file);
                object2 = svnChecksum2;
            } else {
                assert (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Deleted);
                object = this.getContext().getPristineProps(file);
                object2 = (SvnChecksum)this.getDb().readPristineInfo(file).get(StructureFields$PristineInfo.checksum);
            }
            assert (object2 != null);
            serializable = this.getDb().getPristinePath(file, (SvnChecksum)object2);
            if (object == null) {
                object = new SVNProperties();
            }
            string2 = ((SVNProperties)object).getStringValue("svn:mime-type");
            this.getCallback().fileDeleted(null, file, (File)serializable, this.getEmptyFile(), string2, null, (SVNProperties)object);
            if (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Deleted) {
                return;
            }
        }
        File file3 = svnChecksum != null ? this.getDb().getPristinePath(file, svnChecksum) : (bl8 && this.isIgnoreAncestry() ? this.getDb().getPristinePath(file, svnChecksum2) : this.getEmptyFile());
        if (!bl8 && iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Added || bl8 && !this.isIgnoreAncestry() || (iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Copied || iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.MovedHere) && (this.isShowCopiesAsAdds() || this.isGitFormat())) {
            object = new SVNProperties();
            serializable = this.getContext().getActualProps(file);
            if (serializable == null) {
                serializable = new SVNProperties();
            }
            string2 = ((SVNProperties)serializable).getStringValue("svn:mime-type");
            SVNProperties sVNProperties = SvnDiffEditor.computePropDiff((SVNProperties)object, (SVNProperties)serializable);
            object2 = this.getContext().getTranslatedFile(file, file, true, false, false, false, false);
            this.getCallback().fileAdded(null, file, !this.isShowCopiesAsAdds() && this.isGitFormat() && iSVNWCDb$SVNWCDbStatus != ISVNWCDb$SVNWCDbStatus.Added ? file3 : this.getEmptyFile(), (File)object2, 0L, l2, null, string2, file2, -1L, sVNProperties, (SVNProperties)object);
        } else {
            object2 = null;
            boolean bl9 = this.getContext().isTextModified(file, false);
            if (bl9) {
                object2 = this.getContext().getTranslatedFile(file, file, true, false, false, false, false);
            }
            if (bl8 && this.isIgnoreAncestry()) {
                object = this.getDb().getBaseProps(file);
            } else {
                assert (!bl7 || iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.Copied || iSVNWCDb$SVNWCDbStatus == ISVNWCDb$SVNWCDbStatus.MovedHere);
                object = this.getDb().readPristineProperties(file);
                if (object == null) {
                    object = new SVNProperties();
                }
            }
            string2 = ((SVNProperties)object).getStringValue("svn:mime-type");
            SVNProperties sVNProperties = this.getDb().readProperties(file);
            String string3 = sVNProperties.getStringValue("svn:mime-type");
            SVNProperties sVNProperties2 = SvnDiffEditor.computePropDiff((SVNProperties)object, sVNProperties);
            if (bl9 || !sVNProperties2.isEmpty()) {
                this.getCallback().fileChanged(null, file, bl9 ? file3 : null, (File)object2, l2, -1L, string2, string3, sVNProperties2, (SVNProperties)object);
            }
        }
    }

    private File getEmptyFile() {
        return null;
    }
}

