/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb$Mode;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext$PropDiffs;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbKind;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$SVNWCDbStatus;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbBaseInfo$BaseInfoField;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbInfo;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb$WCDbInfo$InfoField;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb$DirParsedInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$PristineInfo;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbPristines;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback2;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnCopyAsChangedDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackResult;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackWrapper;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffEditor$Entry;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffSource;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgDiffUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnReverseOrderDiffCallback;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnChecksum$Kind;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnDiffEditor
implements ISVNUpdateEditor,
ISVNEditor {
    private SVNDepth depth;
    private SVNWCContext context;
    private ISVNWCDb db;
    private File anchorAbspath;
    private String target;
    private boolean showCopiesAsAdds;
    private ISvnDiffCallback2 callback;
    private Collection changelists;
    private boolean ignoreAncestry;
    private boolean useGitDiffFormat;
    private ISVNCanceller canceller;
    private boolean reverseOrder;
    private boolean localBeforeRemote;
    private boolean diffPristine;
    private long revision;
    private boolean rootOpened;
    private SvnDiffEditor$Entry rootEntry;
    private SvnDiffEditor$Entry currentEntry;
    private Collection tempFiles;
    private SVNWCDbRoot wcRoot;
    private final SVNDeltaProcessor deltaProcessor;
    private final SvnDiffCallbackResult result;

    public SvnDiffEditor(File file, String string, ISvnDiffCallback iSvnDiffCallback, SVNDepth sVNDepth, SVNWCContext sVNWCContext, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Collection collection, boolean bl7, ISVNCanceller iSVNCanceller) {
        if (bl7) {
            bl4 = true;
        }
        this.depth = sVNDepth;
        this.context = sVNWCContext;
        this.db = sVNWCContext.getDb();
        this.anchorAbspath = file;
        this.target = string;
        this.diffPristine = bl3;
        this.showCopiesAsAdds = bl4;
        this.callback = new SvnDiffCallbackWrapper(iSvnDiffCallback, bl6, file);
        if (!bl4) {
            this.callback = new SvnCopyAsChangedDiffCallback(this.callback);
        }
        if (bl2) {
            this.callback = new SvnReverseOrderDiffCallback(this.callback, null);
        }
        this.changelists = collection;
        if (bl4) {
            bl5 = false;
        }
        this.ignoreAncestry = bl5;
        this.useGitDiffFormat = bl7;
        this.canceller = iSVNCanceller;
        this.reverseOrder = bl2;
        this.deltaProcessor = new SVNDeltaProcessor();
        this.tempFiles = new ArrayList();
        this.result = new SvnDiffCallbackResult();
    }

    public SvnDiffEditor() {
        this.deltaProcessor = new SVNDeltaProcessor();
        this.result = new SvnDiffCallbackResult();
    }

    @Override
    public void targetRevision(long l2) {
        this.revision = l2;
    }

    @Override
    public void openRoot(long l2) {
        this.rootOpened = true;
        this.currentEntry = this.rootEntry = new SvnDiffEditor$Entry(this, false, "", null, false, this.depth, this.anchorAbspath);
        if (this.target.length() == 0) {
            SvnDiffEditor$Entry.access$002(this.currentEntry, new SvnDiffSource(this.revision));
            SvnDiffEditor$Entry.access$102(this.currentEntry, new SvnDiffSource(-1L));
            this.callback.dirOpened(this.result, new File(""), SvnDiffEditor$Entry.access$000(this.currentEntry), SvnDiffEditor$Entry.access$100(this.currentEntry), null, null);
            SvnDiffEditor$Entry.access$202(this.currentEntry, this.result.skip);
            SvnDiffEditor$Entry.access$302(this.currentEntry, this.result.skipChildren);
        } else {
            SvnDiffEditor$Entry.access$202(this.currentEntry, true);
        }
    }

    @Override
    public void deleteEntry(String string, long l2) {
        File file = this.getLocalAbspath(string);
        String string2 = SVNPathUtil.tail(string);
        SvnDiffEditor$Entry svnDiffEditor$Entry = this.currentEntry;
        if (SvnDiffEditor$Entry.access$400(svnDiffEditor$Entry) == null) {
            SvnDiffEditor$Entry.access$402(svnDiffEditor$Entry, new HashSet());
        }
        SvnDiffEditor$Entry.access$400(svnDiffEditor$Entry).add(string2);
    }

    @Override
    public void absentDir(String string) {
    }

    @Override
    public void absentFile(String string) {
    }

    @Override
    public void addDir(String string, String string2, long l2) {
        SVNDepth sVNDepth = this.depth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : this.depth;
        SvnDiffEditor$Entry svnDiffEditor$Entry = this.currentEntry;
        this.currentEntry = new SvnDiffEditor$Entry(this, false, string, this.currentEntry, true, sVNDepth, this.getLocalAbspath(string));
        if (SvnDiffEditor$Entry.access$500(svnDiffEditor$Entry) || !this.ignoreAncestry) {
            SvnDiffEditor$Entry.access$502(this.currentEntry, true);
        } else {
            svnDiffEditor$Entry.ensureLocalInfo();
            ISVNWCDb$SVNWCDbInfo iSVNWCDb$SVNWCDbInfo = (ISVNWCDb$SVNWCDbInfo)SvnDiffEditor$Entry.access$700(svnDiffEditor$Entry).get(SvnDiffEditor$Entry.access$600(this.currentEntry));
            if (iSVNWCDb$SVNWCDbInfo == null || iSVNWCDb$SVNWCDbInfo.kind != ISVNWCDb$SVNWCDbKind.Dir || iSVNWCDb$SVNWCDbInfo.status.isNotPresent()) {
                SvnDiffEditor$Entry.access$502(this.currentEntry, true);
            }
            if (!SvnDiffEditor$Entry.access$500(this.currentEntry) && iSVNWCDb$SVNWCDbInfo.status != ISVNWCDb$SVNWCDbStatus.Added) {
                SvnDiffEditor$Entry.access$502(this.currentEntry, true);
            }
            if (!SvnDiffEditor$Entry.access$500(this.currentEntry)) {
                SvnDiffEditor$Entry.access$102(this.currentEntry, new SvnDiffSource(-1L));
                SvnDiffEditor$Entry.access$802(this.currentEntry, true);
                if (SvnDiffEditor$Entry.access$900(svnDiffEditor$Entry) == null) {
                    SvnDiffEditor$Entry.access$902(svnDiffEditor$Entry, new HashSet());
                }
                SvnDiffEditor$Entry.access$900(svnDiffEditor$Entry).add(SvnDiffEditor$Entry.access$600(this.currentEntry));
            }
        }
        SvnDiffEditor$Entry.access$002(this.currentEntry, new SvnDiffSource(this.revision));
        if (this.localBeforeRemote && !SvnDiffEditor$Entry.access$500(this.currentEntry) && !SvnDiffEditor$Entry.access$800(this.currentEntry)) {
            this.handleLocalOnly(svnDiffEditor$Entry, SvnDiffEditor$Entry.access$600(this.currentEntry));
        }
        this.result.reset();
        this.callback.dirOpened(this.result, new File(SvnDiffEditor$Entry.access$1000(this.currentEntry)), SvnDiffEditor$Entry.access$000(this.currentEntry), SvnDiffEditor$Entry.access$100(this.currentEntry), null, null);
        SvnDiffEditor$Entry.access$202(this.currentEntry, this.result.skip);
        SvnDiffEditor$Entry.access$302(this.currentEntry, this.result.skipChildren);
    }

    @Override
    public void openDir(String string, long l2) {
        SVNDepth sVNDepth = this.depth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : this.depth;
        SvnDiffEditor$Entry svnDiffEditor$Entry = this.currentEntry;
        this.currentEntry = new SvnDiffEditor$Entry(this, false, string, this.currentEntry, false, sVNDepth, this.getLocalAbspath(string));
        if (SvnDiffEditor$Entry.access$500(svnDiffEditor$Entry)) {
            SvnDiffEditor$Entry.access$502(this.currentEntry, true);
        } else {
            svnDiffEditor$Entry.ensureLocalInfo();
            ISVNWCDb$SVNWCDbInfo iSVNWCDb$SVNWCDbInfo = (ISVNWCDb$SVNWCDbInfo)SvnDiffEditor$Entry.access$700(svnDiffEditor$Entry).get(SvnDiffEditor$Entry.access$600(this.currentEntry));
            if (iSVNWCDb$SVNWCDbInfo == null || iSVNWCDb$SVNWCDbInfo.kind != ISVNWCDb$SVNWCDbKind.Dir || iSVNWCDb$SVNWCDbInfo.status.isNotPresent()) {
                SvnDiffEditor$Entry.access$502(this.currentEntry, true);
            }
            if (!SvnDiffEditor$Entry.access$500(this.currentEntry)) {
                switch (iSVNWCDb$SVNWCDbInfo.status) {
                    case Normal: {
                        break;
                    }
                    case Deleted: {
                        SvnDiffEditor$Entry.access$502(this.currentEntry, true);
                        if (iSVNWCDb$SVNWCDbInfo.haveMoreWork) break;
                        if (SvnDiffEditor$Entry.access$900(svnDiffEditor$Entry) == null) {
                            SvnDiffEditor$Entry.access$902(svnDiffEditor$Entry, new HashSet());
                        }
                        SvnDiffEditor$Entry.access$900(svnDiffEditor$Entry).add(SvnDiffEditor$Entry.access$600(this.currentEntry));
                        break;
                    }
                    case Added: {
                        if (this.ignoreAncestry) {
                            SvnDiffEditor$Entry.access$802(this.currentEntry, true);
                            break;
                        }
                        SvnDiffEditor$Entry.access$502(this.currentEntry, true);
                        break;
                    }
                    default: {
                        SVNErrorManager.assertionFailure(false, null, SVNLogType.WC);
                    }
                }
            }
            if (!SvnDiffEditor$Entry.access$500(this.currentEntry)) {
                SvnDiffEditor$Entry.access$102(this.currentEntry, new SvnDiffSource(-1L));
                if (SvnDiffEditor$Entry.access$900(svnDiffEditor$Entry) == null) {
                    SvnDiffEditor$Entry.access$902(svnDiffEditor$Entry, new HashSet());
                }
                SvnDiffEditor$Entry.access$900(svnDiffEditor$Entry).add(SvnDiffEditor$Entry.access$600(this.currentEntry));
            }
        }
        SvnDiffEditor$Entry.access$002(this.currentEntry, new SvnDiffSource(this.revision));
        if (this.localBeforeRemote && !SvnDiffEditor$Entry.access$500(this.currentEntry) && !SvnDiffEditor$Entry.access$800(this.currentEntry)) {
            this.handleLocalOnly(svnDiffEditor$Entry, SvnDiffEditor$Entry.access$600(this.currentEntry));
        }
        this.callback.dirOpened(this.result, new File(SvnDiffEditor$Entry.access$1000(this.currentEntry)), SvnDiffEditor$Entry.access$000(this.currentEntry), SvnDiffEditor$Entry.access$100(this.currentEntry), null, null);
        SvnDiffEditor$Entry.access$202(this.currentEntry, this.result.skip);
        SvnDiffEditor$Entry.access$302(this.currentEntry, this.result.skipChildren);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeDir() {
        try {
            Object object;
            Object object2;
            Cloneable cloneable;
            boolean bl2 = false;
            SvnDiffEditor$Entry svnDiffEditor$Entry = SvnDiffEditor$Entry.access$1100(this.currentEntry);
            if (!SvnDiffEditor$Entry.access$300(this.currentEntry) && SvnDiffEditor$Entry.access$400(this.currentEntry) != null && SvnDiffEditor$Entry.access$400(this.currentEntry).size() > 0) {
                cloneable = new ArrayList(SvnDiffEditor$Entry.access$400(this.currentEntry));
                Collections.sort(cloneable);
                object2 = cloneable.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    this.handleLocalOnly(this.currentEntry, (String)object);
                    if (SvnDiffEditor$Entry.access$900(this.currentEntry) == null) {
                        SvnDiffEditor$Entry.access$902(this.currentEntry, new HashSet());
                    }
                    SvnDiffEditor$Entry.access$900(this.currentEntry).add(object);
                }
            }
            if (!SvnDiffEditor$Entry.access$500(this.currentEntry) && !SvnDiffEditor$Entry.access$300(this.currentEntry)) {
                this.walkLocalNodesDiff(SvnDiffEditor$Entry.access$1200(this.currentEntry), SvnDiffEditor$Entry.access$1000(this.currentEntry), SvnDiffEditor$Entry.access$1300(this.currentEntry), SvnDiffEditor$Entry.access$900(this.currentEntry));
            }
            if (!SvnDiffEditor$Entry.access$200(this.currentEntry) && (SvnDiffEditor$Entry.access$1400(this.currentEntry).size() > 0 || SvnDiffEditor$Entry.access$500(this.currentEntry) || SvnDiffEditor$Entry.access$1500(this.currentEntry))) {
                cloneable = SvnDiffEditor$Entry.access$1600(this.currentEntry) ? new SVNProperties() : this.db.getBaseProps(SvnDiffEditor$Entry.access$1200(this.currentEntry));
                if (SvnDiffEditor$Entry.access$1400(this.currentEntry).size() > 0 || SvnDiffEditor$Entry.access$1500(this.currentEntry)) {
                    ((SVNProperties)cloneable).putAll(SvnDiffEditor$Entry.access$1400(this.currentEntry));
                    ((SVNProperties)cloneable).removeNullValues();
                }
                if (SvnDiffEditor$Entry.access$500(this.currentEntry)) {
                    this.result.reset();
                    this.callback.dirDeleted(this.result, new File(SvnDiffEditor$Entry.access$1000(this.currentEntry)), SvnDiffEditor$Entry.access$000(this.currentEntry), (SVNProperties)cloneable, null);
                    bl2 = true;
                } else {
                    if (this.diffPristine) {
                        object = this.db.readPristineInfo(SvnDiffEditor$Entry.access$1200(this.currentEntry));
                        object2 = (SVNProperties)((Structure)object).get(StructureFields$PristineInfo.props);
                    } else {
                        object2 = this.db.readProperties(SvnDiffEditor$Entry.access$1200(this.currentEntry));
                    }
                    object = ((SVNProperties)cloneable).compareTo((SVNProperties)object2);
                    if (((SVNProperties)object).size() > 0) {
                        this.result.reset();
                        this.callback.dirChanged(this.result, new File(SvnDiffEditor$Entry.access$1000(this.currentEntry)), SvnDiffEditor$Entry.access$000(this.currentEntry), SvnDiffEditor$Entry.access$100(this.currentEntry), (SVNProperties)cloneable, (SVNProperties)object2, (SVNProperties)object, null);
                        bl2 = true;
                    }
                }
            }
            if (!bl2 && !SvnDiffEditor$Entry.access$200(this.currentEntry)) {
                this.result.reset();
                this.callback.dirClosed(this.result, new File(SvnDiffEditor$Entry.access$1000(this.currentEntry)), SvnDiffEditor$Entry.access$000(this.currentEntry), SvnDiffEditor$Entry.access$100(this.currentEntry), null);
            }
            if (!(svnDiffEditor$Entry == null || this.localBeforeRemote || SvnDiffEditor$Entry.access$500(this.currentEntry) || SvnDiffEditor$Entry.access$800(this.currentEntry))) {
                this.handleLocalOnly(svnDiffEditor$Entry, SvnDiffEditor$Entry.access$600(this.currentEntry));
            }
        }
        finally {
            this.currentEntry = SvnDiffEditor$Entry.access$1100(this.currentEntry);
        }
    }

    @Override
    public void addFile(String string, String string2, long l2) {
        SvnDiffEditor$Entry svnDiffEditor$Entry = this.currentEntry;
        this.currentEntry = new SvnDiffEditor$Entry(this, true, string, this.currentEntry, true, SVNDepth.UNKNOWN, this.getLocalAbspath(string));
        if (SvnDiffEditor$Entry.access$300(svnDiffEditor$Entry)) {
            SvnDiffEditor$Entry.access$202(this.currentEntry, true);
            return;
        }
        if (SvnDiffEditor$Entry.access$500(svnDiffEditor$Entry) || !this.ignoreAncestry) {
            SvnDiffEditor$Entry.access$502(this.currentEntry, true);
        } else {
            svnDiffEditor$Entry.ensureLocalInfo();
            ISVNWCDb$SVNWCDbInfo iSVNWCDb$SVNWCDbInfo = (ISVNWCDb$SVNWCDbInfo)SvnDiffEditor$Entry.access$700(svnDiffEditor$Entry).get(SvnDiffEditor$Entry.access$600(this.currentEntry));
            if (iSVNWCDb$SVNWCDbInfo == null || iSVNWCDb$SVNWCDbInfo.kind != ISVNWCDb$SVNWCDbKind.File || iSVNWCDb$SVNWCDbInfo.status.isNotPresent()) {
                SvnDiffEditor$Entry.access$502(this.currentEntry, true);
            }
            if (!SvnDiffEditor$Entry.access$500(this.currentEntry) && iSVNWCDb$SVNWCDbInfo.status != ISVNWCDb$SVNWCDbStatus.Added) {
                SvnDiffEditor$Entry.access$502(this.currentEntry, true);
            }
            if (!SvnDiffEditor$Entry.access$500(this.currentEntry)) {
                SvnDiffEditor$Entry.access$102(this.currentEntry, new SvnDiffSource(-1L));
                SvnDiffEditor$Entry.access$802(this.currentEntry, true);
                if (SvnDiffEditor$Entry.access$900(svnDiffEditor$Entry) == null) {
                    SvnDiffEditor$Entry.access$902(svnDiffEditor$Entry, new HashSet());
                }
                SvnDiffEditor$Entry.access$900(svnDiffEditor$Entry).add(SvnDiffEditor$Entry.access$600(this.currentEntry));
            }
        }
        SvnDiffEditor$Entry.access$002(this.currentEntry, new SvnDiffSource(this.revision));
        this.result.reset();
        this.callback.fileOpened(this.result, new File(SvnDiffEditor$Entry.access$1000(this.currentEntry)), SvnDiffEditor$Entry.access$000(this.currentEntry), SvnDiffEditor$Entry.access$100(this.currentEntry), null, false, null);
        SvnDiffEditor$Entry.access$202(this.currentEntry, this.result.skip);
    }

    @Override
    public void openFile(String string, long l2) {
        Object object;
        SvnDiffEditor$Entry svnDiffEditor$Entry = this.currentEntry;
        this.currentEntry = new SvnDiffEditor$Entry(this, true, string, this.currentEntry, false, SVNDepth.UNKNOWN, this.getLocalAbspath(string));
        if (SvnDiffEditor$Entry.access$300(svnDiffEditor$Entry)) {
            SvnDiffEditor$Entry.access$202(this.currentEntry, true);
        } else if (SvnDiffEditor$Entry.access$500(svnDiffEditor$Entry)) {
            SvnDiffEditor$Entry.access$502(this.currentEntry, true);
        } else {
            svnDiffEditor$Entry.ensureLocalInfo();
            object = (ISVNWCDb$SVNWCDbInfo)SvnDiffEditor$Entry.access$700(svnDiffEditor$Entry).get(SvnDiffEditor$Entry.access$600(this.currentEntry));
            if (object == null || ((ISVNWCDb$SVNWCDbInfo)object).kind != ISVNWCDb$SVNWCDbKind.File || ((ISVNWCDb$SVNWCDbInfo)object).status.isNotPresent()) {
                SvnDiffEditor$Entry.access$502(this.currentEntry, true);
            }
            if (!SvnDiffEditor$Entry.access$500(this.currentEntry)) {
                switch (((ISVNWCDb$SVNWCDbInfo)object).status) {
                    case Normal: {
                        break;
                    }
                    case Deleted: {
                        SvnDiffEditor$Entry.access$502(this.currentEntry, true);
                        if (((ISVNWCDb$SVNWCDbInfo)object).haveMoreWork) break;
                        if (SvnDiffEditor$Entry.access$900(svnDiffEditor$Entry) == null) {
                            SvnDiffEditor$Entry.access$902(svnDiffEditor$Entry, new HashSet());
                        }
                        SvnDiffEditor$Entry.access$900(svnDiffEditor$Entry).add(SvnDiffEditor$Entry.access$600(this.currentEntry));
                        break;
                    }
                    case Added: {
                        if (this.ignoreAncestry) {
                            SvnDiffEditor$Entry.access$802(this.currentEntry, true);
                            break;
                        }
                        SvnDiffEditor$Entry.access$502(this.currentEntry, true);
                        break;
                    }
                    default: {
                        SVNErrorManager.assertionFailure(false, null, SVNLogType.WC);
                    }
                }
            }
            if (!SvnDiffEditor$Entry.access$500(this.currentEntry)) {
                SvnDiffEditor$Entry.access$102(this.currentEntry, new SvnDiffSource(-1L));
                if (SvnDiffEditor$Entry.access$900(svnDiffEditor$Entry) == null) {
                    SvnDiffEditor$Entry.access$902(svnDiffEditor$Entry, new HashSet());
                }
                SvnDiffEditor$Entry.access$900(svnDiffEditor$Entry).add(SvnDiffEditor$Entry.access$600(this.currentEntry));
            }
        }
        SvnDiffEditor$Entry.access$002(this.currentEntry, new SvnDiffSource(this.revision));
        object = this.db.getBaseInfo(SvnDiffEditor$Entry.access$1200(this.currentEntry), ISVNWCDb$WCDbBaseInfo$BaseInfoField.checksum, ISVNWCDb$WCDbBaseInfo$BaseInfoField.props);
        SvnDiffEditor$Entry.access$1702(this.currentEntry, ((ISVNWCDb$WCDbBaseInfo)object).checksum);
        SvnDiffEditor$Entry.access$1802(this.currentEntry, ((ISVNWCDb$WCDbBaseInfo)object).props);
        this.result.reset();
        this.callback.fileOpened(this.result, new File(SvnDiffEditor$Entry.access$1000(this.currentEntry)), SvnDiffEditor$Entry.access$000(this.currentEntry), SvnDiffEditor$Entry.access$100(this.currentEntry), null, false, null);
        SvnDiffEditor$Entry.access$202(this.currentEntry, this.result.skip);
    }

    @Override
    public void applyTextDelta(String string, String string2) {
        InputStream inputStream;
        if (SvnDiffEditor$Entry.access$200(this.currentEntry)) {
            return;
        }
        if (string2 != null && SvnDiffEditor$Entry.access$1700(this.currentEntry) != null) {
            SvnChecksum svnChecksum = this.db.getPristineMD5(this.anchorAbspath, SvnDiffEditor$Entry.access$1700(this.currentEntry));
            if (svnChecksum != null && !svnChecksum.getDigest().equals(string2)) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''", (Object)SvnDiffEditor$Entry.access$1200(this.currentEntry));
                SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
            }
            inputStream = this.db.readPristine(SvnDiffEditor$Entry.access$1200(this.currentEntry), SvnDiffEditor$Entry.access$1700(this.currentEntry));
        } else {
            inputStream = SvnDiffEditor$Entry.access$1700(this.currentEntry) != null ? this.db.readPristine(SvnDiffEditor$Entry.access$1200(this.currentEntry), SvnDiffEditor$Entry.access$1700(this.currentEntry)) : SVNFileUtil.DUMMY_IN;
        }
        SvnDiffEditor$Entry.access$1902(this.currentEntry, this.createTempFile(this.db.getWCRootTempDir(SvnDiffEditor$Entry.access$1200(this.currentEntry))));
        this.deltaProcessor.applyTextDelta(inputStream, SvnDiffEditor$Entry.access$1900(this.currentEntry), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFile(String string, String string2) {
        try {
            Serializable serializable;
            Object object;
            SvnDiffEditor$Entry svnDiffEditor$Entry = SvnDiffEditor$Entry.access$1100(this.currentEntry);
            if (!SvnDiffEditor$Entry.access$200(this.currentEntry) && string2 != null) {
                object = SvnDiffEditor$Entry.access$1900(this.currentEntry) != null ? SvnDiffEditor$Entry.access$2000(this.currentEntry) : SvnDiffEditor$Entry.access$1700(this.currentEntry);
                if (((SvnChecksum)object).getKind() != SvnChecksum$Kind.md5) {
                    object = this.db.getPristineMD5(SvnDiffEditor$Entry.access$1200(this.currentEntry), (SvnChecksum)object);
                }
                if (!string2.equals(((SvnChecksum)object).getDigest())) {
                    serializable = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''", (Object)SvnDiffEditor$Entry.access$1200(this.currentEntry));
                    SVNErrorManager.error((SVNErrorMessage)serializable, SVNLogType.DEFAULT);
                }
            }
            if (this.localBeforeRemote && !SvnDiffEditor$Entry.access$500(this.currentEntry) && !SvnDiffEditor$Entry.access$800(this.currentEntry)) {
                this.handleLocalOnly(svnDiffEditor$Entry, SvnDiffEditor$Entry.access$600(this.currentEntry));
            }
            object = SvnDiffEditor$Entry.access$1600(this.currentEntry) ? new SVNProperties() : SvnDiffEditor$Entry.access$1800(this.currentEntry);
            serializable = new SVNProperties((SVNProperties)object);
            ((SVNProperties)serializable).putAll(SvnDiffEditor$Entry.access$1400(this.currentEntry));
            ((SVNProperties)serializable).removeNullValues();
            File file = SvnDiffEditor$Entry.access$1900(this.currentEntry);
            if (file == null && !SvnDiffEditor$Entry.access$200(this.currentEntry)) {
                assert (SvnDiffEditor$Entry.access$1700(this.currentEntry) != null);
                file = SvnWcDbPristines.getPristinePath(this.getWcRoot(), SvnDiffEditor$Entry.access$1700(this.currentEntry));
            }
            if (!SvnDiffEditor$Entry.access$200(this.currentEntry)) {
                if (SvnDiffEditor$Entry.access$500(this.currentEntry)) {
                    this.result.reset();
                    this.callback.fileDeleted(this.result, new File(SvnDiffEditor$Entry.access$1000(this.currentEntry)), SvnDiffEditor$Entry.access$000(this.currentEntry), SvnDiffEditor$Entry.access$1900(this.currentEntry), (SVNProperties)serializable);
                } else {
                    File file2;
                    SVNProperties sVNProperties;
                    Object object2;
                    if (this.diffPristine) {
                        object2 = this.db.readPristineInfo(SvnDiffEditor$Entry.access$1200(this.currentEntry));
                        SvnChecksum svnChecksum = (SvnChecksum)((Structure)object2).get(StructureFields$PristineInfo.checksum);
                        sVNProperties = (SVNProperties)((Structure)object2).get(StructureFields$PristineInfo.props);
                        assert (svnChecksum != null);
                        file2 = SvnWcDbPristines.getPristinePath(this.getWcRoot(), svnChecksum);
                    } else {
                        sVNProperties = this.db.readProperties(SvnDiffEditor$Entry.access$1200(this.currentEntry));
                        file2 = this.context.getTranslatedFile(SvnDiffEditor$Entry.access$1200(this.currentEntry), SvnDiffEditor$Entry.access$1200(this.currentEntry), true, false, false, false, false);
                    }
                    object2 = ((SVNProperties)serializable).compareTo(sVNProperties);
                    this.result.reset();
                    this.callback.fileChanged(this.result, new File(SvnDiffEditor$Entry.access$1000(this.currentEntry)), SvnDiffEditor$Entry.access$000(this.currentEntry), SvnDiffEditor$Entry.access$100(this.currentEntry), file, file2, (SVNProperties)serializable, sVNProperties, true, (SVNProperties)object2);
                }
            }
            if (!(this.localBeforeRemote || SvnDiffEditor$Entry.access$500(this.currentEntry) || SvnDiffEditor$Entry.access$800(this.currentEntry))) {
                this.handleLocalOnly(svnDiffEditor$Entry, SvnDiffEditor$Entry.access$600(this.currentEntry));
            }
        }
        finally {
            this.currentEntry = SvnDiffEditor$Entry.access$1100(this.currentEntry);
        }
    }

    @Override
    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) {
        if (SVNProperty.isWorkingCopyProperty(string)) {
            return;
        }
        if (SVNProperty.isRegularProperty(string)) {
            SvnDiffEditor$Entry.access$2102(this.currentEntry, true);
            if (SvnDiffEditor$Entry.access$1400(this.currentEntry) == null) {
                SvnDiffEditor$Entry.access$1402(this.currentEntry, new SVNProperties());
            }
            SvnDiffEditor$Entry.access$1400(this.currentEntry).put(string, sVNPropertyValue);
        }
        SvnDiffEditor$Entry.access$1502(this.currentEntry, true);
    }

    @Override
    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) {
        if (SVNProperty.isWorkingCopyProperty(string2)) {
            return;
        }
        if (SVNProperty.isRegularProperty(string2)) {
            SvnDiffEditor$Entry.access$2102(this.currentEntry, true);
            if (SvnDiffEditor$Entry.access$1400(this.currentEntry) == null) {
                SvnDiffEditor$Entry.access$1402(this.currentEntry, new SVNProperties());
            }
            SvnDiffEditor$Entry.access$1400(this.currentEntry).put(string2, sVNPropertyValue);
        }
    }

    @Override
    public SVNCommitInfo closeEdit() {
        if (!this.rootOpened) {
            this.walkLocalNodesDiff(this.anchorAbspath, "", this.depth, null);
        }
        return null;
    }

    @Override
    public void abortEdit() {
    }

    @Override
    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) {
        if (SvnDiffEditor$Entry.access$200(this.currentEntry)) {
            return null;
        }
        return this.deltaProcessor.textDeltaChunk(sVNDiffWindow);
    }

    @Override
    public void textDeltaEnd(String string) {
        if (SvnDiffEditor$Entry.access$200(this.currentEntry)) {
            return;
        }
        String string2 = this.deltaProcessor.textDeltaEnd();
        SvnDiffEditor$Entry.access$2002(this.currentEntry, new SvnChecksum(SvnChecksum$Kind.md5, string2));
    }

    private File getLocalAbspath(String string) {
        return new File(this.anchorAbspath, string);
    }

    private void checkCancelled() {
        this.canceller.checkCancelled();
    }

    private void walkLocalNodesDiff(File file, String string, SVNDepth sVNDepth, Set set) {
        Cloneable cloneable;
        Object object;
        if (this.diffPristine) {
            return;
        }
        boolean bl2 = string.length() == 0 && this.target.length() != 0;
        ISVNWCDb$WCDbInfo iSVNWCDb$WCDbInfo = this.db.readInfo(file, ISVNWCDb$WCDbInfo$InfoField.revision, ISVNWCDb$WCDbInfo$InfoField.propsMod);
        long l2 = iSVNWCDb$WCDbInfo.revision;
        boolean bl3 = iSVNWCDb$WCDbInfo.propsMod;
        SvnDiffSource svnDiffSource = new SvnDiffSource(l2);
        SvnDiffSource svnDiffSource2 = new SvnDiffSource(-1L);
        boolean bl4 = false;
        boolean bl5 = false;
        if (set != null) {
            bl4 = true;
        } else if (!bl2) {
            this.result.reset();
            this.callback.dirOpened(this.result, new File(string), svnDiffSource, svnDiffSource2, null, null);
            bl4 = this.result.skip;
            bl5 = this.result.skipChildren;
        }
        if (!bl5 && sVNDepth != SVNDepth.EMPTY) {
            object = sVNDepth;
            if (object == SVNDepth.IMMEDIATES) {
                object = SVNDepth.EMPTY;
            }
            boolean bl6 = sVNDepth == SVNDepth.UNKNOWN || sVNDepth.compareTo(SVNDepth.FILES) >= 0;
            boolean bl7 = sVNDepth == SVNDepth.UNKNOWN || sVNDepth.compareTo(SVNDepth.IMMEDIATES) >= 0;
            cloneable = new HashMap();
            this.db.readChildren(file, (Map)((Object)cloneable), new HashSet());
            ArrayList arrayList = new ArrayList(cloneable.keySet());
            Collections.sort(arrayList);
            for (String string2 : arrayList) {
                ISVNWCDb$WCDbBaseInfo iSVNWCDb$WCDbBaseInfo;
                ISVNWCDb$SVNWCDbInfo iSVNWCDb$SVNWCDbInfo = (ISVNWCDb$SVNWCDbInfo)cloneable.get(string2);
                if (bl2 && !this.target.equals(string2) || set != null && set.contains(string2) || iSVNWCDb$SVNWCDbInfo.status.isNotPresent()) continue;
                assert (iSVNWCDb$SVNWCDbInfo.status == ISVNWCDb$SVNWCDbStatus.Normal || iSVNWCDb$SVNWCDbInfo.status == ISVNWCDb$SVNWCDbStatus.Added || iSVNWCDb$SVNWCDbInfo.status == ISVNWCDb$SVNWCDbStatus.Deleted);
                File file2 = SVNFileUtil.createFilePath(file, string2);
                File file3 = SVNFileUtil.createFilePath(string, string2);
                boolean bl8 = false;
                boolean bl9 = false;
                ISVNWCDb$SVNWCDbKind iSVNWCDb$SVNWCDbKind = ISVNWCDb$SVNWCDbKind.Unknown;
                if (!iSVNWCDb$SVNWCDbInfo.haveBase) {
                    bl9 = true;
                    if (iSVNWCDb$SVNWCDbInfo.status == ISVNWCDb$SVNWCDbStatus.Deleted) {
                        continue;
                    }
                } else if (iSVNWCDb$SVNWCDbInfo.status == ISVNWCDb$SVNWCDbStatus.Normal) {
                    iSVNWCDb$SVNWCDbKind = iSVNWCDb$SVNWCDbInfo.kind;
                } else if (!(iSVNWCDb$SVNWCDbInfo.status != ISVNWCDb$SVNWCDbStatus.Deleted || this.diffPristine && iSVNWCDb$SVNWCDbInfo.haveMoreWork)) {
                    bl8 = true;
                    iSVNWCDb$WCDbBaseInfo = this.db.getBaseInfo(file2, ISVNWCDb$WCDbBaseInfo$BaseInfoField.status, ISVNWCDb$WCDbBaseInfo$BaseInfoField.kind);
                    iSVNWCDb$SVNWCDbKind = iSVNWCDb$WCDbBaseInfo.kind;
                    if (iSVNWCDb$WCDbBaseInfo.status.isNotPresent()) {
                        continue;
                    }
                } else {
                    iSVNWCDb$WCDbBaseInfo = this.db.getBaseInfo(file2, ISVNWCDb$WCDbBaseInfo$BaseInfoField.status, ISVNWCDb$WCDbBaseInfo$BaseInfoField.kind);
                    iSVNWCDb$SVNWCDbKind = iSVNWCDb$WCDbBaseInfo.kind;
                    if (iSVNWCDb$WCDbBaseInfo.status.isNotPresent()) {
                        bl9 = true;
                    } else if (iSVNWCDb$SVNWCDbKind != iSVNWCDb$SVNWCDbInfo.kind || !this.ignoreAncestry) {
                        bl8 = true;
                        bl9 = true;
                    }
                }
                if (this.localBeforeRemote && bl9) {
                    if (iSVNWCDb$SVNWCDbInfo.kind == ISVNWCDb$SVNWCDbKind.File && bl6) {
                        SvnNgDiffUtil.diffLocalOnlyFile(file2, file3, this.changelists, this.diffPristine, this.context, this.callback);
                    } else if (iSVNWCDb$SVNWCDbInfo.kind == ISVNWCDb$SVNWCDbKind.Dir && bl7) {
                        SvnNgDiffUtil.diffLocalOnlyDirectory(file2, file3, (SVNDepth)object, this.changelists, this.diffPristine, this.context, this.callback);
                    }
                }
                if (bl8) {
                    if (iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.File && bl6) {
                        SvnNgDiffUtil.diffBaseOnlyFile(file2, file3, this.revision, this.db, this.callback);
                    } else if (iSVNWCDb$SVNWCDbKind == ISVNWCDb$SVNWCDbKind.Dir && bl7) {
                        SvnNgDiffUtil.diffBaseOnlyDirectory(file2, file3, this.revision, (SVNDepth)object, this.db, this.callback);
                    }
                } else if (!bl9) {
                    if (iSVNWCDb$SVNWCDbInfo.kind == ISVNWCDb$SVNWCDbKind.File && bl6) {
                        if (iSVNWCDb$SVNWCDbInfo.status != ISVNWCDb$SVNWCDbStatus.Normal || !this.diffPristine) {
                            SvnNgDiffUtil.diffBaseWorkingDiff(file2, file3, this.revision, this.changelists, this.diffPristine, this.context, this.callback);
                        }
                    } else if (iSVNWCDb$SVNWCDbInfo.kind == ISVNWCDb$SVNWCDbKind.Dir && bl7) {
                        this.walkLocalNodesDiff(file2, SVNFileUtil.getFilePath(file3), (SVNDepth)object, null);
                    }
                }
                if (this.localBeforeRemote || !bl9) continue;
                if (iSVNWCDb$SVNWCDbInfo.kind == ISVNWCDb$SVNWCDbKind.File && bl6) {
                    SvnNgDiffUtil.diffLocalOnlyFile(file2, file3, this.changelists, this.diffPristine, this.context, this.callback);
                    continue;
                }
                if (iSVNWCDb$SVNWCDbInfo.kind != ISVNWCDb$SVNWCDbKind.Dir || !bl7) continue;
                SvnNgDiffUtil.diffLocalOnlyDirectory(file2, file3, (SVNDepth)object, this.changelists, this.diffPristine, this.context, this.callback);
            }
        }
        if (set != null) {
            return;
        }
        if (!bl4 && this.changelists == null && !bl2 && bl3) {
            object = this.context.getPropDiffs(file);
            SVNProperties sVNProperties = ((SVNWCContext$PropDiffs)object).propChanges;
            SVNProperties sVNProperties2 = ((SVNWCContext$PropDiffs)object).originalProps;
            cloneable = new SVNProperties(sVNProperties2);
            ((SVNProperties)cloneable).putAll(sVNProperties);
            ((SVNProperties)cloneable).removeNullValues();
            this.result.reset();
            this.callback.dirChanged(this.result, new File(string), svnDiffSource, svnDiffSource2, sVNProperties2, (SVNProperties)cloneable, sVNProperties, null);
        } else if (!bl4) {
            this.result.reset();
            this.callback.dirClosed(this.result, new File(string), svnDiffSource, svnDiffSource2, null);
        }
    }

    private File createTempFile(File file) {
        File file2 = SVNFileUtil.createUniqueFile(file, "diff.", ".tmp", true);
        this.tempFiles.add(file2);
        return file2;
    }

    private void addToCompared(SvnDiffEditor$Entry svnDiffEditor$Entry, String string) {
        if (SvnDiffEditor$Entry.access$900(svnDiffEditor$Entry) == null) {
            SvnDiffEditor$Entry.access$902(this.currentEntry, new HashSet());
        }
        SvnDiffEditor$Entry.access$900(this.currentEntry).add(string);
    }

    public void cleanup() {
        for (File file : this.tempFiles) {
            try {
                SVNFileUtil.deleteFile(file);
            }
            catch (SVNException sVNException) {}
        }
    }

    @Override
    public long getTargetRevision() {
        return this.revision;
    }

    public static SVNProperties computePropDiff(SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        SVNProperties sVNProperties3 = new SVNProperties();
        if (sVNProperties2 != null) {
            for (String string : sVNProperties2.nameSet()) {
                if (sVNProperties.containsName(string)) {
                    SVNPropertyValue sVNPropertyValue = sVNProperties2.getSVNPropertyValue(string);
                    SVNPropertyValue sVNPropertyValue2 = sVNProperties.getSVNPropertyValue(string);
                    if (sVNPropertyValue != null && !sVNPropertyValue.equals(sVNPropertyValue2)) {
                        sVNProperties3.put(string, sVNPropertyValue);
                        continue;
                    }
                    if (sVNPropertyValue != null || sVNPropertyValue2 == null) continue;
                    sVNProperties3.put(string, sVNPropertyValue);
                    continue;
                }
                sVNProperties3.put(string, sVNProperties2.getSVNPropertyValue(string));
            }
        }
        if (sVNProperties != null) {
            for (String string : sVNProperties.nameSet()) {
                if (sVNProperties2.containsName(string)) continue;
                sVNProperties3.put(string, (String)null);
            }
        }
        return sVNProperties3;
    }

    private SVNWCDbRoot getWcRoot() {
        if (this.wcRoot == null) {
            SVNWCDb$DirParsedInfo sVNWCDb$DirParsedInfo = ((SVNWCDb)this.db).parseDir(this.anchorAbspath, SVNSqlJetDb$Mode.ReadOnly);
            this.wcRoot = sVNWCDb$DirParsedInfo.wcDbDir.getWCRoot();
        }
        return this.wcRoot;
    }

    private void handleLocalOnly(SvnDiffEditor$Entry svnDiffEditor$Entry, String string) {
        boolean bl2;
        boolean bl3 = bl2 = SvnDiffEditor$Entry.access$400(svnDiffEditor$Entry) != null && SvnDiffEditor$Entry.access$400(svnDiffEditor$Entry).contains(string);
        assert (!string.contains("/"));
        assert (!SvnDiffEditor$Entry.access$1600(svnDiffEditor$Entry) || this.ignoreAncestry);
        if (SvnDiffEditor$Entry.access$300(svnDiffEditor$Entry)) {
            return;
        }
        svnDiffEditor$Entry.ensureLocalInfo();
        ISVNWCDb$SVNWCDbInfo iSVNWCDb$SVNWCDbInfo = (ISVNWCDb$SVNWCDbInfo)SvnDiffEditor$Entry.access$700(svnDiffEditor$Entry).get(string);
        if (iSVNWCDb$SVNWCDbInfo == null || iSVNWCDb$SVNWCDbInfo.status.isNotPresent()) {
            return;
        }
        switch (iSVNWCDb$SVNWCDbInfo.status) {
            case Incomplete: {
                return;
            }
            case Normal: {
                if (!bl2) {
                    return;
                }
                SvnDiffEditor$Entry.access$400(svnDiffEditor$Entry).remove(string);
                break;
            }
            case Deleted: {
                if (this.diffPristine && bl2) break;
                return;
            }
        }
        if (iSVNWCDb$SVNWCDbInfo.kind == ISVNWCDb$SVNWCDbKind.Dir) {
            this.depth = SvnDiffEditor$Entry.access$1300(svnDiffEditor$Entry) == SVNDepth.INFINITY || SvnDiffEditor$Entry.access$1300(svnDiffEditor$Entry) == SVNDepth.UNKNOWN ? SvnDiffEditor$Entry.access$1300(svnDiffEditor$Entry) : SVNDepth.EMPTY;
            SvnNgDiffUtil.diffLocalOnlyDirectory(SVNFileUtil.createFilePath(SvnDiffEditor$Entry.access$1200(svnDiffEditor$Entry), string), SVNFileUtil.createFilePath(SvnDiffEditor$Entry.access$1000(svnDiffEditor$Entry), string), bl2 ? SVNDepth.INFINITY : this.depth, this.changelists, this.diffPristine, this.context, this.callback);
        } else {
            SvnNgDiffUtil.diffLocalOnlyFile(SVNFileUtil.createFilePath(SvnDiffEditor$Entry.access$1200(svnDiffEditor$Entry), string), SVNFileUtil.createFilePath(SvnDiffEditor$Entry.access$1000(svnDiffEditor$Entry), string), this.changelists, this.diffPristine, this.context, this.callback);
        }
    }

    static /* synthetic */ ISVNWCDb access$2200(SvnDiffEditor svnDiffEditor) {
        return svnDiffEditor.db;
    }
}

