/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.util.SVNCharsetOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallback$OperationKind;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackResult;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnDiffCallback
implements ISvnDiffCallback {
    private static final long NON_EXSTENT_REVISION = -100L;
    private ISvnDiffGenerator generator;
    private OutputStream outputStream;
    private long revision2;
    private long revision1;
    private boolean noCopyFromOnAdd;
    private boolean diffTargetIsCopy;

    public SvnDiffCallback(ISvnDiffGenerator iSvnDiffGenerator, long l2, long l3, boolean bl2, boolean bl3, OutputStream outputStream) {
        this.generator = iSvnDiffGenerator;
        this.noCopyFromOnAdd = bl2;
        this.revision1 = l2;
        this.revision2 = l3;
        this.diffTargetIsCopy = bl3;
        this.outputStream = outputStream;
    }

    @Override
    public void fileOpened(SvnDiffCallbackResult svnDiffCallbackResult, File file, long l2) {
    }

    @Override
    public void fileChanged(SvnDiffCallbackResult svnDiffCallbackResult, File file, File file2, File file3, long l2, long l3, String string, String string2, SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        if (file2 != null) {
            this.displayContentChanged(file, file2, file3, l2, l3, string, string2, sVNProperties, sVNProperties2, SvnDiffCallback$OperationKind.Modified, null);
        }
        if (sVNProperties != null && !sVNProperties.isEmpty()) {
            this.propertiesChanged(file, l2, l3, false, sVNProperties, sVNProperties2);
        }
    }

    @Override
    public void fileAdded(SvnDiffCallbackResult svnDiffCallbackResult, File file, File file2, File file3, long l2, long l3, String string, String string2, File file4, long l4, SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        this.generator.setForceEmpty(true);
        if (this.diffTargetIsCopy) {
            if (l2 == -1L && this.revision1 != -1L) {
                l2 = this.revision1;
            }
            if (l3 == -1L && this.revision2 != -1L) {
                l3 = this.revision2;
            }
        }
        if (this.noCopyFromOnAdd && (file4 != null || SVNRevision.isValidRevisionNumber(l4))) {
            SVNProperties sVNProperties3 = new SVNProperties(sVNProperties2);
            sVNProperties3.putAll(sVNProperties);
            file2 = null;
            sVNProperties = sVNProperties3;
            sVNProperties2 = new SVNProperties();
            l4 = -1L;
        }
        if (file3 != null && file4 != null) {
            this.displayContentChanged(file, file2, file3, -100L, l3, string, string2, sVNProperties, sVNProperties2, SvnDiffCallback$OperationKind.Copied, file4);
        } else if (file3 != null) {
            this.displayContentChanged(file, file2, file3, -100L, l3, string, string2, sVNProperties, sVNProperties2, SvnDiffCallback$OperationKind.Added, null);
        }
        if (sVNProperties != null && !sVNProperties.isEmpty()) {
            this.propertiesChanged(file, -100L, l3, false, sVNProperties, sVNProperties2);
        }
        this.generator.setForceEmpty(false);
    }

    @Override
    public void fileDeleted(SvnDiffCallbackResult svnDiffCallbackResult, File file, File file2, File file3, String string, String string2, SVNProperties sVNProperties) {
        this.displayContentChanged(file, file2, null, this.revision1, -100L, string, string2, null, sVNProperties, SvnDiffCallback$OperationKind.Deleted, null);
    }

    @Override
    public void dirDeleted(SvnDiffCallbackResult svnDiffCallbackResult, File file) {
        this.generator.displayDeletedDirectory(this.getTarget(file), this.getRevisionString(this.revision1), this.getRevisionString(-100L), this.outputStream);
    }

    @Override
    public void dirOpened(SvnDiffCallbackResult svnDiffCallbackResult, File file, long l2) {
    }

    @Override
    public void dirAdded(SvnDiffCallbackResult svnDiffCallbackResult, File file, long l2, String string, long l3) {
        this.generator.displayAddedDirectory(this.getTarget(file), this.getRevisionString(-100L), this.getRevisionString(l2), this.outputStream);
    }

    @Override
    public void dirPropsChanged(SvnDiffCallbackResult svnDiffCallbackResult, File file, boolean bl2, SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        sVNProperties2 = sVNProperties2 == null ? new SVNProperties() : sVNProperties2;
        SVNProperties sVNProperties3 = SvnDiffCallback.getRegularProperties(sVNProperties = sVNProperties == null ? new SVNProperties() : sVNProperties);
        if (sVNProperties3 == null || sVNProperties3.isEmpty()) {
            return;
        }
        this.generator.displayPropsChanged(this.getTarget(file), bl2 ? this.getRevisionString(-100L) : this.getRevisionString(this.revision1), this.getRevisionString(this.revision2), bl2, sVNProperties2, sVNProperties3, this.outputStream);
    }

    @Override
    public void dirClosed(SvnDiffCallbackResult svnDiffCallbackResult, File file, boolean bl2) {
    }

    private String getRevisionString(long l2) {
        if (l2 >= 0L) {
            return "(revision " + l2 + ")";
        }
        if (l2 == -100L) {
            return "(nonexistent)";
        }
        return "(working copy)";
    }

    private static SVNProperties getRegularProperties(SVNProperties sVNProperties) {
        if (sVNProperties == null) {
            return null;
        }
        SVNProperties sVNProperties2 = new SVNProperties();
        SvnNgPropertiesManager.categorizeProperties(sVNProperties, sVNProperties2, null, null);
        return sVNProperties2;
    }

    public void propertiesChanged(File file, long l2, long l3, boolean bl2, SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        sVNProperties2 = sVNProperties2 == null ? new SVNProperties() : sVNProperties2;
        SVNProperties sVNProperties3 = SvnDiffCallback.getRegularProperties(sVNProperties = sVNProperties == null ? new SVNProperties() : sVNProperties);
        if (sVNProperties3 != null && !sVNProperties3.isEmpty()) {
            this.generator.displayPropsChanged(this.getTarget(file), this.getRevisionString(l2), this.getRevisionString(l3), bl2, sVNProperties2, sVNProperties3, this.outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayContentChanged(File file, File file2, File file3, long l2, long l3, String string, String string2, SVNProperties sVNProperties, SVNProperties sVNProperties2, SvnDiffCallback$OperationKind svnDiffCallback$OperationKind, File file4) {
        boolean bl2 = false;
        OutputStream outputStream = this.outputStream;
        String string3 = this.defineEncoding(sVNProperties2, sVNProperties);
        if (string3 != null) {
            this.generator.setEncoding(string3);
            bl2 = true;
        } else {
            String string4 = this.defineConversionEncoding(sVNProperties2, sVNProperties);
            if (string4 != null) {
                bl2 = this.adjustDiffGenerator("UTF-8");
                outputStream = new SVNCharsetOutputStream(outputStream, Charset.forName("UTF-8"), Charset.forName(string4), CodingErrorAction.IGNORE, CodingErrorAction.IGNORE);
            }
        }
        try {
            this.generator.displayContentChanged(this.getTarget(file), file2, file3, this.getRevisionString(l2), this.getRevisionString(l3), string, string2, svnDiffCallback$OperationKind, file4, sVNProperties2, sVNProperties, outputStream);
        }
        finally {
            if (bl2) {
                this.generator.setEncoding(null);
                this.generator.setEOL(null);
            }
            if (outputStream instanceof SVNCharsetOutputStream) {
                try {
                    outputStream.flush();
                }
                catch (IOException iOException) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, iOException), iOException, SVNLogType.WC);
                }
            }
        }
    }

    private String defineEncoding(SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        ISvnDiffGenerator iSvnDiffGenerator = this.generator;
        if (iSvnDiffGenerator.getEncoding() != null) {
            return null;
        }
        String string = this.getCharsetByMimeType(sVNProperties, iSvnDiffGenerator);
        if (string != null) {
            return string;
        }
        String string2 = this.getCharsetByMimeType(sVNProperties2, iSvnDiffGenerator);
        if (string2 != null) {
            return string2;
        }
        return null;
    }

    private String getCharsetByMimeType(SVNProperties sVNProperties, ISvnDiffGenerator iSvnDiffGenerator) {
        if (sVNProperties == null) {
            return null;
        }
        String string = sVNProperties.getStringValue("svn:mime-type");
        String string2 = SVNPropertiesManager.determineEncodingByMimeType(string);
        return this.getCharset(string2, iSvnDiffGenerator, false);
    }

    private String getCharset(SVNProperties sVNProperties, ISvnDiffGenerator iSvnDiffGenerator) {
        if (sVNProperties == null) {
            return null;
        }
        String string = sVNProperties.getStringValue("svnkit:charset");
        return this.getCharset(string, iSvnDiffGenerator, true);
    }

    private String getCharset(String string, ISvnDiffGenerator iSvnDiffGenerator, boolean bl2) {
        if (string == null) {
            return null;
        }
        if (bl2 && "native".equals(string)) {
            return iSvnDiffGenerator.getEncoding();
        }
        if (Charset.isSupported(string)) {
            return string;
        }
        return null;
    }

    private String defineConversionEncoding(SVNProperties sVNProperties, SVNProperties sVNProperties2) {
        ISvnDiffGenerator iSvnDiffGenerator = this.generator;
        if (iSvnDiffGenerator.getEncoding() != null) {
            return null;
        }
        String string = this.getCharset(sVNProperties, iSvnDiffGenerator);
        if (string != null) {
            return string;
        }
        String string2 = this.getCharset(sVNProperties2, iSvnDiffGenerator);
        if (string2 != null) {
            return string2;
        }
        String string3 = this.getCharset(iSvnDiffGenerator.getGlobalEncoding(), iSvnDiffGenerator, false);
        if (string3 != null) {
            return string3;
        }
        return null;
    }

    private boolean adjustDiffGenerator(String string) {
        boolean bl2 = false;
        if (this.generator.getEncoding() == null) {
            this.generator.setEncoding(string);
            bl2 = true;
        }
        if (this.generator.getEOL() == null) {
            byte[] byArray;
            String string2 = System.getProperty("line.separator");
            try {
                byArray = string2.getBytes(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string2.getBytes();
            }
            this.generator.setEOL(byArray);
        }
        return bl2;
    }

    private SvnTarget getTarget(File file) {
        return SvnTarget.fromFile(file);
    }
}

