/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNMergeDriver;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields$NodeOriginInfo;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess$1;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess$LocationsInfo;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess$RepositoryInfo;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess$RevisionsPair;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess$UrlInfo;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNLocationSegment;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.ISvnOperationOptionsProvider;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class SvnRepositoryAccess {
    private SVNWCContext context;
    private ISvnOperationOptionsProvider operationOptionsProvider;

    protected SvnRepositoryAccess(ISvnOperationOptionsProvider iSvnOperationOptionsProvider, SVNWCContext sVNWCContext) {
        this.operationOptionsProvider = iSvnOperationOptionsProvider;
        this.context = sVNWCContext;
    }

    protected ISvnOperationOptionsProvider getOperationOptionsProvider() {
        return this.operationOptionsProvider;
    }

    protected SVNWCContext getWCContext() {
        return this.context;
    }

    public abstract SvnCopySource createRemoteCopySource(SVNWCContext var1, SvnCopySource var2);

    public abstract Structure createRepositoryFor(SvnTarget var1, SVNRevision var2, SVNRevision var3, File var4);

    public abstract Structure getRevisionNumber(SVNRepository var1, SvnTarget var2, SVNRevision var3, Structure var4);

    public abstract Structure getURLFromPath(SvnTarget var1, SVNRevision var2, SVNRepository var3);

    public SVNURL resolveUrl(SvnTarget svnTarget, SVNRepository sVNRepository, SVNRevision sVNRevision, SVNRevision sVNRevision2) {
        SVNRevision[] sVNRevisionArray = this.resolveRevisions(sVNRevision, sVNRevision2, svnTarget.isURL(), true);
        SVNRevision sVNRevision3 = sVNRevisionArray[0];
        SVNRevision sVNRevision4 = sVNRevisionArray[1];
        Structure structure = this.getLocations(sVNRepository, svnTarget, sVNRevision3, sVNRevision4, SVNRevision.UNDEFINED);
        SVNURL sVNURL = (SVNURL)structure.get(SvnRepositoryAccess$LocationsInfo.startUrl);
        structure.release();
        return sVNURL;
    }

    protected SVNRevision[] resolveRevisions(SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl2, boolean bl3) {
        if (!sVNRevision.isValid()) {
            sVNRevision = bl2 ? SVNRevision.HEAD : (bl3 ? SVNRevision.WORKING : SVNRevision.BASE);
        }
        if (!sVNRevision2.isValid()) {
            sVNRevision2 = sVNRevision;
        }
        return new SVNRevision[]{sVNRevision, sVNRevision2};
    }

    public SVNRepository createRepository(SVNURL sVNURL, String string, boolean bl2) {
        String string2;
        SVNRepository sVNRepository = null;
        if (this.getOperationOptionsProvider().getRepositoryPool() == null) {
            sVNRepository = SVNRepositoryFactory.create(sVNURL, null);
            sVNRepository.setAuthenticationManager(this.getOperationOptionsProvider().getAuthenticationManager());
        } else {
            sVNRepository = this.getOperationOptionsProvider().getRepositoryPool().createRepository(sVNURL, bl2);
        }
        if (string != null && !string.equals(string2 = sVNRepository.getRepositoryUUID(true))) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.RA_UUID_MISMATCH, "Repository UUID ''{0}'' doesn''t match expected UUID ''{1}''", string2, string);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        sVNRepository.setCanceller(this.getOperationOptionsProvider().getCanceller());
        sVNRepository.setEventHandler(this.getOperationOptionsProvider().getEventHandler());
        return sVNRepository;
    }

    public Structure getLocations(SVNRepository sVNRepository, SvnTarget svnTarget, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3) {
        SVNErrorMessage sVNErrorMessage;
        Object object;
        long[] lArray;
        long l2;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (!sVNRevision.isValid() || !sVNRevision2.isValid()) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION), SVNLogType.DEFAULT);
        }
        long l3 = -1L;
        SVNURL sVNURL = null;
        if (svnTarget.isFile()) {
            if (sVNRevision == SVNRevision.WORKING && this.getWCContext() != null) {
                object5 = this.getWCContext().getNodeOrigin(svnTarget.getFile(), false, StructureFields$NodeOriginInfo.isCopy, StructureFields$NodeOriginInfo.revision, StructureFields$NodeOriginInfo.reposRelpath, StructureFields$NodeOriginInfo.reposRootUrl);
                boolean bl2 = ((Structure)object5).is(StructureFields$NodeOriginInfo.isCopy);
                long l4 = ((Structure)object5).lng(StructureFields$NodeOriginInfo.revision);
                object4 = (File)((Structure)object5).get(StructureFields$NodeOriginInfo.reposRelpath);
                object3 = (SVNURL)((Structure)object5).get(StructureFields$NodeOriginInfo.reposRootUrl);
                sVNURL = object4 != null ? ((SVNURL)object3).appendPath(SVNFileUtil.getFilePath((File)object4), false) : null;
                if (sVNURL != null && bl2 && sVNRepository != null && !((SVNURL)(object2 = sVNRepository.getLocation())).equals(sVNURL)) {
                    sVNRepository = null;
                }
            } else {
                sVNURL = null;
            }
            if (sVNURL == null) {
                object5 = this.getURLFromPath(svnTarget, sVNRevision, sVNRepository);
                if (((Structure)object5).hasValue(SvnRepositoryAccess$UrlInfo.dropRepsitory) && ((Structure)object5).is(SvnRepositoryAccess$UrlInfo.dropRepsitory)) {
                    sVNRepository = null;
                }
                sVNURL = (SVNURL)((Structure)object5).get(SvnRepositoryAccess$UrlInfo.url);
                if (((Structure)object5).hasValue(SvnRepositoryAccess$UrlInfo.pegRevision)) {
                    l3 = ((Structure)object5).lng(SvnRepositoryAccess$UrlInfo.pegRevision);
                }
                ((Structure)object5).release();
            }
            if (sVNURL == null) {
                object5 = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)svnTarget.getFile());
                SVNErrorManager.error((SVNErrorMessage)object5, SVNLogType.WC);
            }
        } else {
            sVNURL = svnTarget.getURL();
        }
        if (sVNRepository == null) {
            sVNRepository = this.createRepository(sVNURL, null, true);
        } else {
            sVNRepository.setLocation(sVNURL, false);
        }
        object5 = null;
        if (l3 < 0L) {
            object5 = this.getRevisionNumber(sVNRepository, svnTarget, sVNRevision, (Structure)object5);
            l3 = ((Structure)object5).lng(SvnRepositoryAccess$RevisionsPair.revNumber);
        }
        object5 = this.getRevisionNumber(sVNRepository, svnTarget, sVNRevision2, (Structure)object5);
        long l5 = ((Structure)object5).lng(SvnRepositoryAccess$RevisionsPair.revNumber);
        if (sVNRevision3 == SVNRevision.UNDEFINED) {
            l2 = l5;
        } else {
            object5 = this.getRevisionNumber(sVNRepository, svnTarget, sVNRevision3, (Structure)object5);
            l2 = ((Structure)object5).lng(SvnRepositoryAccess$RevisionsPair.revNumber);
        }
        ((Structure)object5).release();
        Structure structure = Structure.obtain(SvnRepositoryAccess$LocationsInfo.class);
        structure.set((Enum)SvnRepositoryAccess$LocationsInfo.startRevision, l5);
        if (sVNRevision3 != SVNRevision.UNDEFINED) {
            structure.set((Enum)SvnRepositoryAccess$LocationsInfo.startRevision, l2);
        }
        sVNURL = sVNRepository.getLocation();
        if (!(l5 != l3 || l2 != l3 && SVNRevision.isValidRevisionNumber(l2))) {
            structure.set((Enum)SvnRepositoryAccess$LocationsInfo.startUrl, sVNURL);
            structure.set((Enum)SvnRepositoryAccess$LocationsInfo.endUrl, sVNURL);
            return structure;
        }
        SVNURL sVNURL2 = sVNRepository.getRepositoryRoot(true);
        if (l5 == l2) {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = l5;
        } else {
            long[] lArray3 = new long[2];
            lArray3[0] = l5;
            lArray = lArray3;
            lArray3[1] = l2;
        }
        long[] lArray4 = lArray;
        object4 = sVNRepository.getLocations("", (Map)null, l3, lArray4);
        object3 = (SVNLocationEntry)object4.get(l5);
        object2 = (SVNLocationEntry)object4.get(l2);
        if (object3 == null) {
            object = svnTarget != null ? svnTarget : sVNURL;
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "Unable to find repository location for ''{0}'' in revision ''{1}''", object, l5);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (object2 == null) {
            object = svnTarget != null ? svnTarget : sVNURL;
            sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "The location for ''{0}'' for revision {1} does not exist in the repository or refers to an unrelated object", object, l2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        structure.set((Enum)SvnRepositoryAccess$LocationsInfo.startUrl, sVNURL2.appendPath(((SVNLocationEntry)object3).getPath(), false));
        if (sVNRevision3.isValid()) {
            structure.set((Enum)SvnRepositoryAccess$LocationsInfo.endUrl, sVNURL2.appendPath(((SVNLocationEntry)object2).getPath(), false));
        }
        return structure;
    }

    public Map getReposMergeInfo(SVNRepository sVNRepository, String string, long l2, SVNMergeInfoInheritance sVNMergeInfoInheritance, boolean bl2) {
        SVNMergeInfo sVNMergeInfo;
        Map map;
        block3: {
            map = null;
            try {
                map = sVNRepository.getMergeInfo(new String[]{string}, l2, sVNMergeInfoInheritance, false);
            }
            catch (SVNException sVNException) {
                if (bl2 && sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.UNSUPPORTED_FEATURE) break block3;
                throw sVNException;
            }
        }
        String string2 = this.getPathRelativeToRoot(sVNRepository.getLocation(), sVNRepository.getRepositoryRoot(false), sVNRepository);
        Map map2 = null;
        if (map != null && (sVNMergeInfo = (SVNMergeInfo)map.get(string2)) != null) {
            map2 = sVNMergeInfo.getMergeSourcesToMergeLists();
        }
        return map2;
    }

    protected String getPathRelativeToRoot(SVNURL sVNURL, SVNURL sVNURL2, SVNRepository sVNRepository) {
        if (sVNURL2 == null) {
            sVNURL2 = sVNRepository.getRepositoryRoot(true);
        }
        String string = sVNURL2.getPath();
        String string2 = sVNURL.getPath();
        if (!string2.startsWith(string)) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "URL ''{0}'' is not a child of repository root URL ''{1}''", sVNURL, sVNURL2);
            SVNErrorManager.error(sVNErrorMessage, SVNLogType.WC);
        }
        if (!(string2 = string2.substring(string.length())).startsWith("/")) {
            string2 = "/" + string2;
        }
        return string2;
    }

    public String getPathRelativeToSession(SVNURL sVNURL, SVNURL sVNURL2, SVNRepository sVNRepository) {
        if (sVNURL2 == null) {
            sVNURL2 = sVNRepository.getLocation();
        }
        String string = sVNURL2.getPath();
        String string2 = sVNURL.getPath();
        if (!string2.startsWith(string + "/") && !string2.equals(string)) {
            return null;
        }
        if ((string2 = string2.substring(string.length())).startsWith("/")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    public SVNLocationSegment getYoungestCommonAncestor(SVNURL sVNURL, long l2, SVNURL sVNURL2, long l3) {
        boolean[] blArray = new boolean[1];
        boolean[] blArray2 = new boolean[1];
        Map map = this.getHistoryAsMergeInfo(sVNURL, SVNRevision.create(l2), -1L, -1L, blArray, null);
        Map map2 = this.getHistoryAsMergeInfo(sVNURL2, SVNRevision.create(l3), -1L, -1L, blArray2, null);
        long l4 = -1L;
        String string = null;
        for (String string2 : map.keySet()) {
            SVNMergeRangeList sVNMergeRangeList;
            SVNMergeRangeList sVNMergeRangeList2 = (SVNMergeRangeList)map.get(string2);
            SVNMergeRangeList sVNMergeRangeList3 = (SVNMergeRangeList)map2.get(string2);
            if (sVNMergeRangeList3 == null || (sVNMergeRangeList = sVNMergeRangeList2.intersect(sVNMergeRangeList3, true)) == null || sVNMergeRangeList.isEmpty()) continue;
            SVNMergeRange sVNMergeRange = sVNMergeRangeList.getRanges()[sVNMergeRangeList.getSize() - 1];
            if (l4 >= 0L && sVNMergeRange.getEndRevision() <= l4) continue;
            l4 = sVNMergeRange.getEndRevision();
            string = string2.substring(1);
        }
        if (string == null && blArray[0] && blArray2[0]) {
            string = "/";
            l4 = 0L;
        }
        return new SVNLocationSegment(l4, l4, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getHistoryAsMergeInfo(SVNURL sVNURL, SVNRevision sVNRevision, long l2, long l3, boolean[] blArray, SVNRepository sVNRepository) {
        long[] lArray = new long[1];
        Structure structure = this.getRevisionNumber(sVNRepository, SvnTarget.fromURL(sVNURL), sVNRevision, null);
        lArray[0] = structure.lng(SvnRepositoryAccess$RevisionsPair.revNumber);
        structure.release();
        boolean bl2 = false;
        try {
            Object object;
            List list;
            if (sVNRepository == null) {
                sVNRepository = this.createRepository(sVNURL, null, false);
                bl2 = true;
            }
            if (!SVNRevision.isValidRevisionNumber(l2)) {
                l2 = lArray[0];
            }
            if (!SVNRevision.isValidRevisionNumber(l3)) {
                l3 = 0L;
            }
            if (!(list = sVNRepository.getLocationSegments("", lArray[0], l2, l3)).isEmpty() && blArray != null && blArray.length > 0) {
                object = (SVNLocationSegment)list.get(0);
                blArray[0] = ((SVNLocationSegment)object).getStartRevision() == 0L;
            }
            object = SvnRepositoryAccess.getMergeInfoFromSegments(list);
            return object;
        }
        finally {
            if (bl2) {
                sVNRepository.closeSession();
            }
        }
    }

    public static Map getMergeInfoFromSegments(Collection collection) {
        LinkedList<SVNMergeRange> linkedList;
        TreeMap treeMap = new TreeMap();
        for (Object object : collection) {
            if (((SVNLocationSegment)object).getPath() == null) continue;
            String string = ((SVNLocationSegment)object).getPath();
            linkedList = (LinkedList<SVNMergeRange>)treeMap.get(string);
            if (linkedList == null) {
                linkedList = new LinkedList<SVNMergeRange>();
                treeMap.put(string, linkedList);
            }
            SVNMergeRange sVNMergeRange = new SVNMergeRange(Math.max(((SVNLocationSegment)object).getStartRevision() - 1L, 0L), ((SVNLocationSegment)object).getEndRevision(), true);
            linkedList.add(sVNMergeRange);
        }
        TreeMap treeMap2 = new TreeMap();
        for (String string : treeMap.keySet()) {
            linkedList = (Collection)treeMap.get(string);
            treeMap2.put(string, SVNMergeRangeList.fromCollection(linkedList));
        }
        return treeMap2;
    }

    public SVNLocationEntry getCopySource(SvnTarget svnTarget, SVNRevision sVNRevision) {
        Structure structure = this.createRepositoryFor(svnTarget, sVNRevision, sVNRevision, null);
        SVNRepository sVNRepository = (SVNRepository)structure.get(SvnRepositoryAccess$RepositoryInfo.repository);
        long l2 = structure.lng(SvnRepositoryAccess$RepositoryInfo.revision);
        structure.release();
        Object[] objectArray = new Object[3];
        try {
            sVNRepository.getLocationSegments("", l2, l2, -1L, new SvnRepositoryAccess$1(this, objectArray));
        }
        catch (SVNException sVNException) {
            if (sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND || sVNException.getErrorMessage().getErrorCode() == SVNErrorCode.RA_DAV_REQUEST_FAILED) {
                return new SVNLocationEntry(-1L, null);
            }
            throw sVNException;
        }
        if (objectArray[1] != null) {
            return new SVNLocationEntry((Long)objectArray[2], (String)objectArray[1]);
        }
        return null;
    }

    public Map getHistoryAsMergeInfo(SVNRepository sVNRepository, SvnTarget svnTarget, long l2, long l3) {
        Object object;
        long l4 = -1L;
        if (sVNRepository == null) {
            object = this.createRepositoryFor(svnTarget, SVNRevision.UNDEFINED, svnTarget.getResolvedPegRevision(), null);
            l4 = ((Structure)object).lng(SvnRepositoryAccess$RepositoryInfo.revision);
            sVNRepository = (SVNRepository)((Structure)object).get(SvnRepositoryAccess$RepositoryInfo.repository);
            ((Structure)object).release();
        } else if (svnTarget.getPegRevision() == SVNRevision.HEAD || svnTarget.getPegRevision() == SVNRevision.UNDEFINED) {
            l4 = sVNRepository.getLatestRevision();
        } else if (svnTarget.getPegRevision().getNumber() >= 0L) {
            l4 = svnTarget.getPegRevision().getNumber();
        } else if (svnTarget.getPegRevision().getDate() != null) {
            l4 = sVNRepository.getDatedRevision(svnTarget.getPegRevision().getDate());
        } else {
            if (svnTarget.isURL()) {
                object = SVNErrorMessage.create(SVNErrorCode.CLIENT_VERSIONED_PATH_REQUIRED);
                SVNErrorManager.error((SVNErrorMessage)object, SVNLogType.WC);
            }
            object = this.getRevisionNumber(sVNRepository, svnTarget, svnTarget.getPegRevision(), null);
            l4 = ((Structure)object).lng(SvnRepositoryAccess$RevisionsPair.revNumber);
            ((Structure)object).release();
        }
        if (l2 < 0L) {
            l2 = l4;
        }
        if (l3 < 0L) {
            l3 = 0L;
        }
        object = sVNRepository.getLocationSegments("", l4, l2, l3);
        return SVNMergeDriver.getMergeInfoFromSegments((Collection)object);
    }
}

