/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2;

import org.tmatesoft.svn.core.internal.wc2.SvnOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.old.SvnOldRepositoryAccess;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnOperation;

public abstract class SvnRemoteOperationRunner
extends SvnOperationRunner {
    private SvnRepositoryAccess repositoryAccess;
    private SvnWcGeneration detectedWcGeneration;

    @Override
    public void reset(SvnWcGeneration svnWcGeneration) {
        super.reset(svnWcGeneration);
        this.repositoryAccess = null;
        this.detectedWcGeneration = svnWcGeneration;
    }

    @Override
    public boolean isApplicable(SvnOperation svnOperation, SvnWcGeneration svnWcGeneration) {
        return svnOperation.hasRemoteTargets() || !this.isRevisionLocalToWc(svnOperation.getRevision());
    }

    protected SvnRepositoryAccess getRepositoryAccess() {
        if (this.repositoryAccess == null) {
            this.repositoryAccess = this.getDetectedWcGeneration() == SvnWcGeneration.V16 ? new SvnOldRepositoryAccess(this.getOperation()) : new SvnNgRepositoryAccess(this.getOperation(), this.getWcContext());
        }
        return this.repositoryAccess;
    }

    private SvnWcGeneration getDetectedWcGeneration() {
        return this.detectedWcGeneration;
    }

    protected boolean isRevisionLocalToWc(SVNRevision sVNRevision) {
        return sVNRevision == SVNRevision.BASE || sVNRevision == SVNRevision.WORKING || sVNRevision == SVNRevision.COMMITTED;
    }

    @Override
    public SvnWcGeneration getWcGeneration() {
        return SvnWcGeneration.NOT_DETECTED;
    }
}

